﻿using System;
using System.Diagnostics;
using System.Windows.Forms;

namespace AsReaderP3xU_Demo
{
    public class LongPressTracking
    {
        private System.Timers.Timer timer;
        private Control control;
        private int longPressDuration = 3000; // 长按的定义，这里设置为3秒

        public LongPressTracking(Control control)
        {
            this.control = control;
            timer = new System.Timers.Timer();
            timer.Interval = longPressDuration;
            timer.Elapsed += Timer_Tick;
            timer.AutoReset = false;

            control.MouseDown += Control_MouseDown;
            control.MouseUp += Control_MouseUp;
            control.MouseLeave += Control_MouseLeave;
            Debug.WriteLine("Long press init......");
        }

        private void Control_MouseDown(object sender, MouseEventArgs e)
        {
            Debug.WriteLine(DateTime.Now.ToString("G") + "Down");
            timer.Start();
        }

        private void Control_MouseLeave(object sender, EventArgs e)
        {
            timer.Stop();
        }

        private void Control_MouseUp(object sender, MouseEventArgs e)
        {
            Debug.WriteLine("Up");
            timer.Stop();
        }

        private void Timer_Tick(object sender, EventArgs e)
        {
            // 触发长按事件
            Debug.WriteLine(DateTime.Now.ToString("G") + " Triggered....");
            Debug.WriteLine("Timer ticked.");
            LongPress?.Invoke(control, e);
            timer.Stop();
        }

        // 定义长按事件
        public event EventHandler LongPress;
    }
}
