import 'dart:async';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:a3xd_plugin/a3xd_plugin.dart';
import 'package:a3xd_plugin_example/LocalCache.dart';
import 'event_bus_instance.dart';

class SettingWidget extends StatefulWidget {
  const SettingWidget({super.key});

  @override
  State<StatefulWidget> createState() => SettingState();
}

class SettingState extends State<SettingWidget> {
  final _a3xdPlugin = A3xdPlugin();
  static const iosCallPlatform = MethodChannel('a3xd_plugin');
  final cache = LocalCache();
  bool isBeep = false;
  bool isVibration = false;
  late BuildContext mContext;

  @override
  void initState() {
    super.initState();
    initPlatformState();
  }
  Future<void> initPlatformState() async {
    Future<dynamic> _handler(MethodCall methodCall) {
      print('setting methodCall.method:${methodCall.method}, methodCall.arguments:${methodCall.arguments}');
      if (_a3xdPlugin.ON_CONNECT == methodCall.method) {
        bool isConnected = methodCall.arguments['result'];
        print('SettingState onConnect:$isConnected');
        connected(isConnected);
      } else if (_a3xdPlugin.ON_SET_READER_SETTING_SUCCESS == methodCall.method) {
        print('SettingState onSetReaderSettingSuccess');
      } else if (_a3xdPlugin.ON_DEVICE_MANAGER_ERROR == methodCall.method) {
        String error = methodCall.arguments['result'];
        print('onDeviceManagerError:$error');
        onDeviceManagerError(error);
      }
      return Future.value('success');
    }
    iosCallPlatform.setMethodCallHandler(_handler);
    Future.delayed(const Duration(milliseconds: 500), () async {
        isBeep = await cache.getBeep();
        isVibration = await cache.getVibration();
        setState(() {});
    });
  }
  @override
  Widget build(BuildContext context) {
    mContext = context;
    var container1 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(20, 7, 0, 7),
      child: Row(
        children: <Widget>[
          const Expanded(
            child:Text(
              'Beep',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Switch(
              value: isBeep,
              onChanged: (bool value) {
                setState(() {
                  isBeep = value;
                  cache.setBeep(isBeep);
                  _a3xdPlugin.setReaderSettings(isBeep, isVibration, true, true);
                });
              },
            )
          ),
        ],
      ),
    );
    var container2 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(20, 7, 0, 7),
      child: Row(
        children: <Widget>[
          const Expanded(
            child:Text(
              'isVibration',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
              child:Switch(
                value: isVibration,
                onChanged: (bool value) {
                  setState(() {
                    isVibration = value;
                    cache.setVibration(isVibration);
                    _a3xdPlugin.setReaderSettings(isBeep, isVibration, true, true);
                  });
                },
              )
          ),
        ],
      ),
    );
    return Scaffold(
      appBar: AppBar(
        title: const Text('Setting'),
        backgroundColor: Colors.white,
        leading: IconButton(
          icon: Image.asset(
            'images/back.png',
            width: 25,
            height: 25,
            fit: BoxFit.cover,
          ),
          onPressed: () {
            Navigator.pop(context);
          },
        ),
      ),
      body: Container(
        color: Colors.white,
        child: Column(
          children: <Widget>[
            container1,
            container2,
          ],
        ),
      ),
    );
  }
  void connected(bool isConnected) {
    setState(() {
      if (!isConnected) {
        eventBus.fire(DisconnectEvent());
        Navigator.popUntil(context, ModalRoute.withName('/'));
      }
    });
  }
  void onDeviceManagerError(String error) {
    setState(() {
      showAlertDialog(
          mContext, '', error);
    });
  }
  void showAlertDialog(BuildContext context, String title, String message) {
    Widget okButton = ElevatedButton(
      child: const Text('OK'),
      onPressed: () {
        Navigator.of(context).pop();
      },
    );
    AlertDialog alert = AlertDialog(
      title: Text(title),
      content: Text(message),
      actions: [
        okButton,
      ],
    );
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return alert;
      },
    );
  }
}
