import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'a3xd_plugin_method_channel.dart';
import 'package:a3xd_plugin/a3xd_define.dart';
import 'package:flutter/foundation.dart';

abstract class A3xdPluginPlatform extends PlatformInterface {
  /// Constructs a A3xdPluginPlatform.
  A3xdPluginPlatform() : super(token: _token);

  static final Object _token = Object();

  static A3xdPluginPlatform _instance = MethodChannelA3xdPlugin();

  /// The default instance of [A3xdPluginPlatform] to use.
  ///
  /// Defaults to [MethodChannelA3xdPlugin].
  static A3xdPluginPlatform get instance => _instance;

  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [A3xdPluginPlatform] when
  /// they register themselves.
  static set instance(A3xdPluginPlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  Future<String?> getPlatformVersion() {
    throw UnimplementedError('getPlatformVersion() has not been implemented.');
  }

  Future<String?> getA3XDFlutterVersion() {
    throw UnimplementedError('getA3XDFlutterVersion() has not been implemented.');
  }

  Future<String?> getA3XDSDKVersion() {
      throw UnimplementedError('getA3XDSDKVersion() has not been implemented.');
  }

  Future<void> setLogLevel(A3XDLogLevel level) {
    throw UnimplementedError('setLogLevel() has not been implemented.');
  }

  Future<A3XDLogLevel?> getLogLevel() {
    throw UnimplementedError('getLogLevel() has not been implemented.');
  }

  Future<void> setLog(bool enable) {
    throw UnimplementedError('setLog() has not been implemented.');
  }

  Future<void> removeSDKLog() {
    throw UnimplementedError('removeSDKLog() has not been implemented.');
  }

  Future<bool?> isConnected() {
    throw UnimplementedError('isConnected() has not been implemented.');
  }

  Future<bool?> isPowerOn() {
    throw UnimplementedError('isPowerOn() has not been implemented.');
  }

  Future<bool?> isOpen() {
    throw UnimplementedError('isOpen() has not been implemented.');
  }

  Future<void> setPower(bool enable) {
    throw UnimplementedError('setPower() has not been implemented.');
  }

  Future<void> setPowerWithOption(bool power, bool beep, bool vib, bool led, bool aimer, bool powerOnBeep) {
    throw UnimplementedError('setPowerWithOption() has not been implemented.');
  }

  Future<void> setReaderSettings(bool beep, bool vib, bool led, bool aimer) {
    throw UnimplementedError('setReaderSettings() has not been implemented.');
  }

  Future<void> getBattery() {
    throw UnimplementedError('getBattery() has not been implemented.');
  }

  Future<void> getReaderInfo(int type) {
    throw UnimplementedError('getReaderInfo() has not been implemented.');
  }

  Future<bool?> isM30SDevice() {
    throw UnimplementedError('isM30SDevice() has not been implemented.');
  }

  Future<void> setMaxTagValue(int value) {
    throw UnimplementedError('setMaxTagValue() has not been implemented.');
  }

  Future<int?> getMaxTagValue() {
    throw UnimplementedError('getMaxTagValue() has not been implemented.');
  }

  Future<void> setMaxTimeValue(int value) {
    throw UnimplementedError('setMaxTimeValue() has not been implemented.');
  }

  Future<int?> getMaxTimeValue() {
    throw UnimplementedError('getMaxTimeValue() has not been implemented.');
  }

  Future<void> setRepeatCycleValue(int value) {
    throw UnimplementedError('setRepeatCycleValue() has not been implemented.');
  }

  Future<int?> getRepeatCycleValue() {
    throw UnimplementedError('getRepeatCycleValue() has not been implemented.');
  }

  Future<void> setRSSIEnable(bool enable) {
    throw UnimplementedError('setRSSIEnable() has not been implemented.');
  }

  Future<bool?> getRSSIEnable() {
    throw UnimplementedError('getRSSIEnable() has not been implemented.');
  }

  Future<void> startInventory(int maxTags, int maxTime, int repeatCycle) {
    throw UnimplementedError('startInventory() has not been implemented.');
  }

  Future<void> startInventoryRSSI(int maxTags, int maxTime,
      int repeatCycle) {
    throw UnimplementedError('startInventoryRSSI() has not been implemented.');
  }

  Future<void> startInventoryTagID(int maxTags, int maxTime,
      int repeatCycle)  {
    throw UnimplementedError('startInventoryTagID() has not been implemented.');
  }

  Future<void> startRFMDecode(int codeType, int maxTags, int maxTime,
      int repeatCycle) {
    throw UnimplementedError('startRFMDecode() has not been implemented.');
  }

  Future<void> stopDecode() {
    throw UnimplementedError('stopDecode() has not been implemented.');
  }

  Future<void> setRegion(int region) {
    throw UnimplementedError('setRegion() has not been implemented.');
  }

  Future<void> getRegion() {
    throw UnimplementedError('getRegion() has not been implemented.');
  }

  Future<void> setSmartHopping(bool isOn) {
    throw UnimplementedError('setSmartHopping() has not been implemented.');
  }

  Future<void> getFrequencyHoppingMode() {
    throw UnimplementedError('getFrequencyHoppingMode() has not been implemented.');
  }

  Future<void> setOptimumFrequencyHoppingTable() {
    throw UnimplementedError('setOptimumFrequencyHoppingTable() has not been implemented.');
  }

  Future<void> getFrequencyHoppingTable() {
    throw UnimplementedError('getFrequencyHoppingTable() has not been implemented.');
  }

  Future<void> setChannel(int num, int offset) {
    throw UnimplementedError('setChannel() has not been implemented.');
  }

  Future<void> getChannel() {
    throw UnimplementedError('getChannel() has not been implemented.');
  }

  Future<void> setSession(int session) {
    throw UnimplementedError('setSession() has not been implemented.');
  }

  Future<void> getSession() {
    throw UnimplementedError('getSession() has not been implemented.');
  }

  Future<void> setAntiCollisionMode(int mode, int start, int max, int min,
      int counter) {
    throw UnimplementedError('setAntiCollisionMode() has not been implemented.');
  }

  Future<void> getAntiCollisionMode() {
    throw UnimplementedError('getAntiCollisionMode() has not been implemented.');
  }

  Future<void> setFhLbtParam(int readTime, int idleTime, int senseTime,
      int rfLevel, int fhMode, int lbtMode, int cwMode) {
    throw UnimplementedError('setFhLbtParam() has not been implemented.');
  }

  Future<void> getFhLbtParam() {
    throw UnimplementedError('getFhLbtParam() has not been implemented.');
  }

  Future<void> setOutputPowerLevel(int level) {
    throw UnimplementedError('setOutputPowerLevel() has not been implemented.');
  }

  Future<void> getOutputPowerLevel() {
    throw UnimplementedError('getOutputPowerLevel() has not been implemented.');
  }

  Future<void> setModulation(String mode)  {
    throw UnimplementedError('setModulation() has not been implemented.');
  }

  Future<void> getModulation() {
    throw UnimplementedError('getModulation() has not been implemented.');
  }

  Future<void> setTriggerStopCondition(int maxTags, int maxTime,
      int repeatCycle) {
    throw UnimplementedError('setTriggerStopCondition() has not been implemented.');
  }

  Future<void> readTagMemory(int password, String targetEPC,
      A3XDMemoryBank memoryBank, A3XDReadMemoryType readType) {
    throw UnimplementedError('readTagMemory() has not been implemented.');
  }

  Future<void> readTagMemoryWithTimeout(int password, String targetEPC,
      A3XDMemoryBank memoryBank, A3XDReadMemoryType readType,
      int timeout) {
    throw UnimplementedError('readTagMemoryWithTimeout() has not been implemented.');
  }

  Future<void> readTagMemoryWithData(int password, String targetEPC,
      A3XDMemoryBank memoryBank, A3XDReadMemoryType readType, int startAddress,
      int dataLength, int timeout) {
    throw UnimplementedError('readTagMemoryWithData() has not been implemented.');
  }

  Future<void> writeTagMemory(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, Uint8List writeData) {
    throw UnimplementedError('writeTagMemory() has not been implemented.');
  }

  Future<void> writeTagMemoryWithTimeout(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, Uint8List writeData, int timeout) {
    throw UnimplementedError('writeTagMemoryWithTimeout() has not been implemented.');
  }

  Future<void> writeTagMemoryWithData(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, int startAddress, Uint8List writeData, int timeout) {
    throw UnimplementedError('writeTagMemoryWithData() has not been implemented.');
  }

  Future<void> killTag(int password, String targetEPC) {
    throw UnimplementedError('killTag() has not been implemented.');
  }

  Future<void> lockTagMemory(int password, String targetEPC, int lockData) {
    throw UnimplementedError('lockTagMemory() has not been implemented.');
  }

  Future<void> lockTagMemoryWithTimeout(int password, String targetEPC, int lockData, int timeout) {
    throw UnimplementedError('lockTagMemoryWithTimeout() has not been implemented.');
  }

  Future<void> updateRegistry() {
    throw UnimplementedError('updateRegistry() has not been implemented.');
  }

  Future<void> getContinuousMode() {
    throw UnimplementedError('getContinuousMode() has not been implemented.');
  }

  Future<void> setContinuousMode(bool isOn) {
    throw UnimplementedError('setContinuousMode() has not been implemented.');
  }

  Future<void> getAutoOffTime() {
    throw UnimplementedError('getAutoOffTime() has not been implemented.');
  }

  Future<void> setAutoOffTime(int time) {
    throw UnimplementedError('setAutoOffTime() has not been implemented.');
  }

  Future<void> getSessionFlag() {
    throw UnimplementedError('getSessionFlag() has not been implemented.');
  }

  Future<void> setSessionFlag(int sessionFlag) {
    throw UnimplementedError('setSessionFlag() has not been implemented.');
  }

  Future<void> getQValue() {
    throw UnimplementedError('getQValue() has not been implemented.');
  }

  Future<void> setQValue(int value) {
    throw UnimplementedError('setQValue() has not been implemented.');
  }

  Future<void> getHidMode() {
    throw UnimplementedError('getHidMode() has not been implemented.');
  }

  Future<void> setHidMode(bool hidMode) {
    throw UnimplementedError('setHidMode() has not been implemented.');
  }

  Future<void> getDutyRatio() {
    throw UnimplementedError('getDutyRatio() has not been implemented.');
  }

  Future<void> setDutyRatio(int dutyRatio) {
    throw UnimplementedError('setDutyRatio() has not been implemented.');
  }

  Future<void> getDutyRatioBaseTime() {
    throw UnimplementedError('getDutyRatioBaseTime() has not been implemented.');
  }

  Future<void> setDutyRatioBaseTime(int dutyRatioBaseTime) {
    throw UnimplementedError('setDutyRatioBaseTime() has not been implemented.');
  }
}

 