package com.example.a3xd_plugin;

import android.util.Log;

import androidx.annotation.NonNull;

import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodChannel.MethodCallHandler;
import io.flutter.plugin.common.MethodChannel.Result;

/** A3xdPlugin */
public class A3xdPlugin implements FlutterPlugin, MethodCallHandler {
  /// The MethodChannel that will the communication between Flutter and native Android
  ///
  /// This local reference serves to register the plugin with the Flutter Engine and unregister it
  /// when the Flutter Engine is detached from the Activity

  public static final String GET_PLATFORM_VERSION = "getPlatformVersion";
  public static final String GET_A3XD_FLUTTER_VERSION = "getA3XDFlutterVersion";
  public static final String GET_A3XD_SDK_VERSION = "getA3XDSDKVersion";
  public static final String SET_LOG_LEVEL = "setLogLevel";
  public static final String GET_LOG_LEVEL = "getLogLevel";
  public static final String SET_LOG = "setLog";
  public static final String REMOVE_SDK_LOG = "removeSDKLog";
  public static final String IS_CONNECTED = "isConnected";
  public static final String IS_POWERON = "isPowerOn";
  public static final String IS_OPEN = "isOpen";
  public static final String SET_POWER = "setPower";
  public static final String SET_POWER_WITH_OPTION = "setPowerWithOption";
  public static final String SET_READER_SETTINGS = "setReaderSettings";
  public static final String GET_BATTERY = "getBattery";
  public static final String GET_READER_INFO = "getReaderInfo";
  public static final String IS_M30S_DEVICE = "isM30SDevice";
  public static final String SET_MAX_TAG_VALUE = "setMaxTagValue";
  public static final String GET_MAX_TAG_VALUE = "getMaxTagValue";
  public static final String SET_MAX_TIME_VALUE = "setMaxTimeValue";
  public static final String GET_MAX_TIME_VALUE = "getMaxTimeValue";
  public static final String SET_REPEAT_CYCLE_VALUE = "setRepeatCycleValue";
  public static final String GET_REPEAT_CYCLE_VALUE = "getRepeatCycleValue";
  public static final String SET_RSSI_ENABLE = "setRSSIEnable";
  public static final String GET_RSSI_ENABLE = "getRSSIEnable";
  public static final String START_INVENTORY = "startInventory";
  public static final String START_INVENTORY_RSSI = "startInventoryRSSI";
  public static final String START_INVENTORY_TAGID = "startInventoryTagID";
  public static final String START_RFM_DECODE = "startRFMDecode";
  public static final String STOP_DECODE = "stopDecode";
  public static final String SET_REGION = "setRegion";
  public static final String GET_REGION = "getRegion";
  public static final String SET_SMART_HOPPING = "setSmartHopping";
  public static final String GET_FREQUENCY_HOPPING_MODE = "getFrequencyHoppingMode";
  public static final String SET_OPTIMUM_FREQUENCY_HOPPING_TABLE = "setOptimumFrequencyHoppingTable";
  public static final String GET_FREQUENCY_HOPPING_TABLE = "getFrequencyHoppingTable";
  public static final String SET_CHANNEL = "setChannel";
  public static final String GET_CHANNEL = "getChannel";
  public static final String SET_SESSION = "setSession";
  public static final String GET_SESSION = "getSession";
  public static final String SET_ANTI_COLLISION_MODE = "setAntiCollisionMode";
  public static final String GET_ANTI_COLLISION_MODE = "getAntiCollisionMode";
  public static final String SET_FH_LBT_PARAM = "setFhLbtParam";
  public static final String GET_FH_LBT_PARAM = "getFhLbtParam";
  public static final String SET_OUTPUT_POWER_LEVEL = "setOutputPowerLevel";
  public static final String GET_OUTPUT_POWER_LEVEL = "getOutputPowerLevel";
  public static final String SET_MODULATION = "setModulation";
  public static final String GET_MODULATION = "getModulation";
  public static final String SET_TRIGGER_STOP_CONDITION = "setTriggerStopCondition";
  public static final String READ_TAG_MEMORY = "readTagMemory";
  public static final String READ_TAG_MEMORY_WITH_TIMEOUT = "readTagMemoryWithTimeout";
  public static final String READ_TAG_MEMORY_WITH_DATA = "readTagMemoryWithData";
  public static final String WRITE_TAG_MEMORY = "writeTagMemory";
  public static final String WRITE_TAG_MEMORY_WITH_TIMEOUT = "writeTagMemoryWithTimeout";
  public static final String WRITE_TAG_MEMORY_WITH_DATA = "writeTagMemoryWithData";
  public static final String KILL_TAG = "killTag";
  public static final String LOCK_TAG_MEMORY = "lockTagMemory";
  public static final String LOCK_TAG_MEMORY_WITH_TIMEOUT = "lockTagMemoryWithTimeout";
  public static final String UPDATE_REGISTRY = "updateRegistry";
  public static final String GET_CONTINUOUS_MODE = "getContinuousMode";
  public static final String SET_CONTINUOUS_MODE = "setContinuousMode";
  public static final String GET_AUTO_OFF_TIME = "getAutoOffTime";
  public static final String SET_AUTO_OFF_TIME = "setAutoOffTime";
  public static final String GET_SESSION_FLAG = "getSessionFlag";
  public static final String SET_SESSION_FLAG = "setSessionFlag";
  public static final String GET_Q_VALUE = "getQValue";
  public static final String SET_Q_VALUE = "setQValue";
  public static final String GET_HID_MODE = "getHidMode";
  public static final String SET_HID_MODE = "setHidMode";
  public static final String GET_DUTY_RATIO = "getDutyRatio";
  public static final String SET_DUTY_RATIO = "setDutyRatio";
  public static final String GET_DUTY_RATIO_BASE_TIME = "getDutyRatioBaseTime";
  public static final String SET_DUTY_RATIO_BASE_TIME = "setDutyRatioBaseTime";
  private MethodChannel channel;
  private A3xdManager a3xdManager;

  @Override
  public void onAttachedToEngine(@NonNull FlutterPluginBinding flutterPluginBinding) {
    channel = new MethodChannel(flutterPluginBinding.getBinaryMessenger(), "a3xd_plugin");
    a3xdManager = A3xdManager.getInstance();
    a3xdManager.currentChannel = channel;
    a3xdManager.currentContext = flutterPluginBinding.getApplicationContext();
    a3xdManager.init();
    channel.setMethodCallHandler(this);
  }

  @Override
  public void onMethodCall(@NonNull MethodCall call, @NonNull Result result) {
    String method = call.method;
    if (method.equals(GET_PLATFORM_VERSION)) {
      result.success("Android " + android.os.Build.VERSION.RELEASE);
    } else if (method.equals(GET_A3XD_FLUTTER_VERSION)) {
      String sdkVersion = a3xdManager.getA3XDFlutterVersion();
      result.success(sdkVersion);
    } else if (method.equals(GET_A3XD_SDK_VERSION)) {
      String sdkVersion = a3xdManager.getA3XDSDKVersion();
      result.success(sdkVersion);
    } else if (method.equals(SET_LOG_LEVEL)) {
      int level = call.argument("level");
      a3xdManager.setLogLevel(level);
    } else if (method.equals(GET_LOG_LEVEL)) {
      int logLevel = a3xdManager.getLogLevel();
      result.success(logLevel);
    } else if (method.equals(SET_LOG)) {
      boolean enable = call.argument("enable");
      a3xdManager.setLog(enable);
    } else if (method.equals(REMOVE_SDK_LOG)) {
      a3xdManager.removeSDKLog();
    } else if (method.equals(IS_CONNECTED)) {
      boolean isConnected = a3xdManager.isConnected();
      if (isConnected){
        result.success("1");
      } else {
        result.success("0");
      }
    } else if (method.equals(IS_POWERON)) {
      boolean isPowerOn = a3xdManager.isPowerOn();
      if (isPowerOn){
        result.success("1");
      } else {
        result.success("0");
      }
    } else if (method.equals(IS_OPEN)) {
      boolean isOpen = a3xdManager.isOpen();
      if (isOpen){
        result.success("1");
      } else {
        result.success("0");
      }
    } else if (method.equals(SET_POWER)) {
      boolean enable = call.argument("enable");
      a3xdManager.setPower(enable);
    } else if (method.equals(SET_POWER_WITH_OPTION)) {
      boolean power = call.argument("power");
      boolean beep = call.argument("beep");
      boolean vib = call.argument("vib");
      boolean led = call.argument("led");
      boolean aimer = call.argument("aimer");
      boolean powerOnBeep = call.argument("powerOnBeep");
      a3xdManager.setPowerWithOption(power, beep, vib, led, aimer, powerOnBeep);
    } else if (method.equals(SET_READER_SETTINGS)) {
      boolean beep = call.argument("beep");
      boolean vib = call.argument("vib");
      boolean led = call.argument("led");
      boolean aimer = call.argument("aimer");
      a3xdManager.setReaderSettings(beep, vib, led, aimer);
    } else if (method.equals(GET_BATTERY)) {
      a3xdManager.getBattery();
    } else if (method.equals(GET_READER_INFO)) {
      int type = call.argument("type");
      a3xdManager.getReaderInfo(type);
    } else if (method.equals(IS_M30S_DEVICE)) {
      boolean status = a3xdManager.isM30SDevice();
      if (status){
        result.success("1");
      } else {
        result.success("0");
      }
    } else if (method.equals(SET_MAX_TAG_VALUE)) {
      int value = call.argument("value");
      a3xdManager.setMaxTagValue(value);
    } else if (method.equals(GET_MAX_TAG_VALUE)) {
      int status = a3xdManager.getMaxTagValue();
      result.success(status);
    } else if (method.equals(SET_MAX_TIME_VALUE)) {
      int value = call.argument("value");
      a3xdManager.setMaxTimeValue(value);
    } else if (method.equals(GET_MAX_TIME_VALUE)) {
      int status = a3xdManager.getMaxTimeValue();
      result.success(status);
    } else if (method.equals(SET_REPEAT_CYCLE_VALUE)) {
      int value = call.argument("value");
      a3xdManager.setRepeatCycleValue(value);
    } else if (method.equals(GET_REPEAT_CYCLE_VALUE)) {
      int status = a3xdManager.getRepeatCycleValue();
      result.success(status);
    } else if (method.equals(SET_RSSI_ENABLE)) {
      boolean value = call.argument("enable");
      a3xdManager.setRSSIEnable(value);
    } else if (method.equals(GET_RSSI_ENABLE)) {
      boolean enable = a3xdManager.getRSSIEnable();
      if (enable){
        result.success("1");
      } else {
        result.success("0");
      }
    } else if (method.equals(START_INVENTORY)) {
      int maxTags = call.argument("maxTags");
      int maxTime = call.argument("maxTime");
      int repeatCycle = call.argument("repeatCycle");
      a3xdManager.startInventory(maxTags, maxTime, repeatCycle);
    } else if (method.equals(START_INVENTORY_RSSI)) {
      int maxTags = call.argument("maxTags");
      int maxTime = call.argument("maxTime");
      int repeatCycle = call.argument("repeatCycle");
      a3xdManager.startInventoryRSSI(maxTags, maxTime, repeatCycle);
    } else if (method.equals(START_INVENTORY_TAGID)) {
      int maxTags = call.argument("maxTags");
      int maxTime = call.argument("maxTime");
      int repeatCycle = call.argument("repeatCycle");
      a3xdManager.startInventoryTagID(maxTags, maxTime, repeatCycle);
    } else if (method.equals(START_RFM_DECODE)) {
      int codeType = call.argument("codeType");
      int maxTags = call.argument("maxTags");
      int maxTime = call.argument("maxTime");
      int repeatCycle = call.argument("repeatCycle");
      a3xdManager.startRFMDecode(codeType, maxTags, maxTime, repeatCycle);
    } else if (method.equals(STOP_DECODE)) {
      a3xdManager.stopDecode();
    } else if (method.equals(SET_REGION)) {
      int region = call.argument("region");
      a3xdManager.setRegion(region);
    } else if (method.equals(GET_REGION)) {
      a3xdManager.getRegion();
    } else if (method.equals(SET_SMART_HOPPING)) {
      boolean isOn = call.argument("isOn");
      a3xdManager.setSmartHopping(isOn);
    } else if (method.equals(GET_FREQUENCY_HOPPING_MODE)) {
      a3xdManager.getFrequencyHoppingMode();
    } else if (method.equals(SET_OPTIMUM_FREQUENCY_HOPPING_TABLE)) {
      a3xdManager.setOptimumFrequencyHoppingTable();
    } else if (method.equals(GET_FREQUENCY_HOPPING_TABLE)) {
      a3xdManager.getFrequencyHoppingTable();
    } else if (method.equals(SET_CHANNEL)) {
      int num = call.argument("num");
      int offset = call.argument("offset");
      a3xdManager.setChannel(num, offset);
    } else if (method.equals(GET_CHANNEL)) {
      a3xdManager.getChannel();
    } else if (method.equals(SET_SESSION)) {
      int session = call.argument("session");
      a3xdManager.setSession(session);
    } else if (method.equals(GET_SESSION)) {
      a3xdManager.getSession();
    } else if (method.equals(SET_ANTI_COLLISION_MODE)) {
      int mode = call.argument("mode");
      int start = call.argument("start");
      int max = call.argument("max");
      int min = call.argument("min");
      int counter = call.argument("counter");
      a3xdManager.setAntiCollisionMode(mode, start, max, min, counter);
    } else if (method.equals(GET_ANTI_COLLISION_MODE)) {
      a3xdManager.getAntiCollisionMode();
    } else if (method.equals(SET_FH_LBT_PARAM)) {
      int readTime = call.argument("readTime");
      int idleTime = call.argument("idleTime");
      int senseTime = call.argument("senseTime");
      int rfLevel = call.argument("rfLevel");
      int fhMode = call.argument("fhMode");
      int lbtMode = call.argument("lbtMode");
      int cwMode = call.argument("cwMode");
      a3xdManager.setFhLbtParam(readTime, idleTime, senseTime, rfLevel, fhMode, lbtMode, cwMode);
    } else if (method.equals(GET_FH_LBT_PARAM)) {
      a3xdManager.getFhLbtParam();
    } else if (method.equals(SET_OUTPUT_POWER_LEVEL)) {
      int level = call.argument("level");
      a3xdManager.setOutputPowerLevel(level);
    } else if (method.equals(GET_OUTPUT_POWER_LEVEL)) {
      a3xdManager.getOutputPowerLevel();
    } else if (method.equals(SET_MODULATION)) {
      String mode = call.argument("mode");
      a3xdManager.setModulation(mode);
    } else if (method.equals(GET_MODULATION)) {
      a3xdManager.getModulation();
    } else if (method.equals(SET_TRIGGER_STOP_CONDITION)) {
      int maxTags = call.argument("maxTags");
      int maxTime = call.argument("maxTime");
      int repeatCycle = call.argument("repeatCycle");
      a3xdManager.setTriggerStopCondition(maxTags, maxTime, repeatCycle);
    } else if (method.equals(READ_TAG_MEMORY)) {
      int password = call.argument("password");
      String targetEPC = call.argument("targetEPC");
      int memoryBank = call.argument("memoryBank");
      int readType = call.argument("readType");
      a3xdManager.readTagMemory(password, targetEPC, memoryBank, readType);
    } else if (method.equals(READ_TAG_MEMORY_WITH_TIMEOUT)) {
      int password = call.argument("password");
      String targetEPC = call.argument("targetEPC");
      int memoryBank = call.argument("memoryBank");
      int readType = call.argument("readType");
      int timeout = call.argument("timeout");
      a3xdManager.readTagMemoryWithTimeout(password, targetEPC, memoryBank, readType, timeout);
    } else if (method.equals(READ_TAG_MEMORY_WITH_DATA)) {
      int password = call.argument("password");
      String targetEPC = call.argument("targetEPC");
      int memoryBank = call.argument("memoryBank");
      int readType = call.argument("readType");
      int startAddress = call.argument("startAddress");
      int dataLength = call.argument("dataLength");
      int timeout = call.argument("timeout");
      a3xdManager.readTagMemoryWithData(password, targetEPC, memoryBank, readType, startAddress, dataLength, timeout);
    } else if (method.equals(WRITE_TAG_MEMORY)) {
      int password = call.argument("password");
      String targetEPC = call.argument("targetEPC");
      int memoryBank = call.argument("memoryBank");
      int writeType = call.argument("writeType");
      byte[] writeData = call.argument("writeData");
      a3xdManager.writeTagMemory(password, targetEPC, memoryBank, writeType, writeData);
    } else if (method.equals(WRITE_TAG_MEMORY_WITH_TIMEOUT)) {
      int password = call.argument("password");
      String targetEPC = call.argument("targetEPC");
      int memoryBank = call.argument("memoryBank");
      int writeType = call.argument("writeType");
      byte[] writeData = call.argument("writeData");
      int timeout = call.argument("timeout");
      a3xdManager.writeTagMemoryWithTimeout(password, targetEPC, memoryBank, writeType, writeData, timeout);
    } else if (method.equals(WRITE_TAG_MEMORY_WITH_DATA)) {
      int password = call.argument("password");
      String targetEPC = call.argument("targetEPC");
      int memoryBank = call.argument("memoryBank");
      int writeType = call.argument("writeType");
      int startAddress = call.argument("startAddress");
      byte[] writeData = call.argument("writeData");
      int timeout = call.argument("timeout");
      a3xdManager.writeTagMemoryWithData(password, targetEPC, memoryBank, writeType, startAddress, writeData, timeout);
    } else if (method.equals(KILL_TAG)) {
      int password = call.argument("password");
      String targetEPC = call.argument("targetEPC");
      a3xdManager.killTag(password, targetEPC);
    } else if (method.equals(LOCK_TAG_MEMORY)) {
      int password = call.argument("password");
      String targetEPC = call.argument("targetEPC");
      int lockData = call.argument("lockData");
      a3xdManager.lockTagMemory(password, targetEPC, lockData);
    } else if (method.equals(LOCK_TAG_MEMORY_WITH_TIMEOUT)) {
      int password = call.argument("password");
      String targetEPC = call.argument("targetEPC");
      int lockData = call.argument("lockData");
      int timeout = call.argument("timeout");
      a3xdManager.lockTagMemoryWithTimeout(password, targetEPC, lockData, timeout);
    } else if (method.equals(UPDATE_REGISTRY)) {
      a3xdManager.updateRegistry();
    } else if (method.equals(SET_CONTINUOUS_MODE)) {
      boolean isOn = call.argument("isOn");
      a3xdManager.setContinuousMode(isOn);
    } else if (method.equals(GET_CONTINUOUS_MODE)) {
      a3xdManager.getContinuousMode();
    } else if (method.equals(SET_AUTO_OFF_TIME)) {
      int time = call.argument("time");
      a3xdManager.setAutoOffTime(time);
    } else if (method.equals(GET_AUTO_OFF_TIME)) {
      a3xdManager.getAutoOffTime();
    } else if (method.equals(SET_SESSION_FLAG)) {
      int sessionFlag = call.argument("sessionFlag");
      a3xdManager.setSessionFlag(sessionFlag);
    } else if (method.equals(GET_SESSION_FLAG)) {
      a3xdManager.getSessionFlag();
    } else if (method.equals(SET_Q_VALUE)) {
      int value = call.argument("value");
      a3xdManager.setQValue(value);
    } else if (method.equals(GET_Q_VALUE)) {
      a3xdManager.getQValue();
    } else if (method.equals(SET_HID_MODE)) {
      boolean hidMode = call.argument("hidMode");
      a3xdManager.setHidMode(hidMode);
    } else if (method.equals(GET_HID_MODE)) {
      a3xdManager.getHidMode();
    } else if (method.equals(SET_DUTY_RATIO)) {
      int dutyRatio = call.argument("dutyRatio");
      a3xdManager.setDutyRatio(dutyRatio);
    } else if (method.equals(GET_DUTY_RATIO)) {
      a3xdManager.getDutyRatio();
    } else if (method.equals(SET_DUTY_RATIO_BASE_TIME)) {
      int dutyRatioBaseTime = call.argument("dutyRatioBaseTime");
      a3xdManager.setDutyRatioBaseTime(dutyRatioBaseTime);
    } else if (method.equals(GET_DUTY_RATIO_BASE_TIME)) {
      a3xdManager.getDutyRatioBaseTime();
    } else {
      result.notImplemented();
    }
  }

  @Override
  public void onDetachedFromEngine(@NonNull FlutterPluginBinding binding) {
    channel.setMethodCallHandler(null);
  }
}
