/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.manager;

import androidx.annotation.IntRange;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import jp.co.asterisk.asreader.a3xd.sdk.PacketParser;
import jp.co.asterisk.asreader.a3xd.sdk.SharedPreferencesHelper;
import jp.co.asterisk.asreader.a3xd.sdk.common.Convert;
import jp.co.asterisk.asreader.a3xd.sdk.common.RFIDConst;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceCommandFactory;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDCommandFactory;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDCommandType;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.manager.USBManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.communication.CommunicationManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.communication.CommunicationManagerRFIDCallback;
import jp.co.asterisk.asreader.a3xd.sdk.utility.LogLevel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.ModulationMode;
import jp.co.asterisk.asreader.a3xd.sdk.utility.PacketModel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.SDKLog;

public class RFIDManager
implements CommunicationManagerRFIDCallback {
    private static RFIDManager instance;
    private final String TAG = RFIDManager.class.getSimpleName();
    private final String ERROR_MSG_FAILED_TO_SEND_PACKET = "Failed to send packet.";
    private RFIDManagerCallback callback;

    private RFIDManager() {
    }

    public static RFIDManager getInstance() {
        if (instance == null) {
            instance = new RFIDManager();
        }
        return instance;
    }

    public void initialize() {
        CommunicationManager.getInstance().setRFIDCallBack(this);
    }

    public void setCallback(RFIDManagerCallback callback) {
        this.callback = callback;
        PacketParser.getInstance().setRFIDManagerCallback(callback);
    }

    private void sendPacket(PacketModel packetModel) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "RFIDManager sendPacket");
        boolean result = CommunicationManager.getInstance().sendPacket(packetModel);
        if (!result) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
            this.callback.onRFIDManagerError("Failed to send packet.");
        }
    }

    private boolean checkIfValueIsWithinRange(long val, long range, String valName) {
        if (val >= 0L && val <= range) {
            return true;
        }
        this.callback.onRFIDManagerError(valName + " is wrong. (0 to " + range + ")");
        return false;
    }

    private boolean checkIfValueIsWithinRange(int val, int range, String valName) {
        if (val >= 0 && val <= range) {
            return true;
        }
        this.callback.onRFIDManagerError(valName + " is wrong. (0 to " + range + ")");
        return false;
    }

    private boolean checkMemoryParam(long password, String epc, int startAddress, int dataLength) {
        if (!this.checkIfValueIsWithinRange(password, 0xFFFFFFFFL, "password")) {
            return false;
        }
        if (epc == null || epc.length() <= 0) {
            return false;
        }
        if (!this.checkIfValueIsWithinRange(startAddress, 65535, "startAddress")) {
            return false;
        }
        return this.checkIfValueIsWithinRange(dataLength, 65535, "dataLength");
    }

    private byte[] toBytes(int val, int size) {
        byte[] bytes = new byte[size];
        for (int i = size - 1; i >= 0; --i) {
            bytes[i] = (byte)(val & 0xFF);
            val >>= 8;
        }
        return bytes;
    }

    private byte[] toBytes(long val, int size) {
        byte[] bytes = new byte[size];
        for (int i = size - 1; i >= 0; --i) {
            bytes[i] = (byte)(val & 0xFFL);
            val >>= 8;
        }
        return bytes;
    }

    private byte getMemoryBankByte(RFIDConst.MemoryBank memoryBank) {
        switch (memoryBank) {
            case RESERVED: {
                return 0;
            }
            case EPC: {
                return 1;
            }
            case TID: {
                return 2;
            }
            case USER: {
                return 3;
            }
        }
        return -1;
    }

    private PacketModel setPayloadHeaderParam(PacketModel packetModel, long password, byte[] targetEPC, RFIDConst.MemoryBank memoryBank) {
        byte[] passwordBytes = this.toBytes(password, 4);
        packetModel.addPayloadData(passwordBytes[0]);
        packetModel.addPayloadData(passwordBytes[1]);
        packetModel.addPayloadData(passwordBytes[2]);
        packetModel.addPayloadData(passwordBytes[3]);
        if (targetEPC != null) {
            byte[] epcLengthBytes = this.toBytes(targetEPC.length, 2);
            packetModel.addPayloadData(epcLengthBytes[0]);
            packetModel.addPayloadData(epcLengthBytes[1]);
            for (int i = 0; i < targetEPC.length; ++i) {
                packetModel.addPayloadData(targetEPC[i]);
            }
        }
        if (memoryBank != RFIDConst.MemoryBank.NONE) {
            packetModel.addPayloadData(this.getMemoryBankByte(memoryBank));
        }
        return packetModel;
    }

    private PacketModel setPayloadStartAddress(PacketModel packetModel, @IntRange(from=0L, to=255L) int startAddress) {
        byte[] startAddressBytes = this.toBytes(startAddress, 2);
        packetModel.addPayloadData(startAddressBytes[0]);
        packetModel.addPayloadData(startAddressBytes[1]);
        return packetModel;
    }

    private PacketModel setPayloadDataLength(PacketModel packetModel, @IntRange(from=0L, to=32767L) int dataLength) {
        byte[] dataLengthBytes = this.toBytes(dataLength, 2);
        packetModel.addPayloadData(dataLengthBytes[0]);
        packetModel.addPayloadData(dataLengthBytes[1]);
        return packetModel;
    }

    private PacketModel setPayloadTimeout(PacketModel packetModel, @IntRange(from=-1L, to=255L) int timeout) {
        byte[] timeoutBytes = this.toBytes(timeout, 2);
        packetModel.addPayloadData(timeoutBytes[0]);
        packetModel.addPayloadData(timeoutBytes[1]);
        return packetModel;
    }

    public void setMaxTagValue(@IntRange(from=0L, to=255L) int value) {
        SharedPreferencesHelper.getInstance().setMaxTag(value);
    }

    public int getMaxTagValue() {
        return SharedPreferencesHelper.getInstance().getMaxTag();
    }

    public void setMaxTimeValue(@IntRange(from=0L, to=255L) int value) {
        SharedPreferencesHelper.getInstance().setMaxTime(value);
    }

    public int getMaxTimeValue() {
        return SharedPreferencesHelper.getInstance().getMaxTime();
    }

    public void setRepeatCycleValue(@IntRange(from=0L, to=65535L) int value) {
        SharedPreferencesHelper.getInstance().setRepeatCycle(value);
    }

    public int getRepeatCycleValue() {
        return SharedPreferencesHelper.getInstance().getRepeatCycle();
    }

    public void setRSSIEnable(boolean enable) {
        SharedPreferencesHelper.getInstance().setRssi(enable);
    }

    public boolean getRSSIEnable() {
        return SharedPreferencesHelper.getInstance().getRssi();
    }

    public void setContinueMode(boolean value) {
        SharedPreferencesHelper.getInstance().setContinueMode(value);
    }

    public boolean getContinueMode() {
        return SharedPreferencesHelper.getInstance().getContinueMode();
    }

    public void startInventory(@IntRange(from=0L, to=255L) int maxTags, @IntRange(from=0L, to=255L) int maxTime, @IntRange(from=0L, to=65535L) int repeatCycle) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager startInventory");
        this.startInventory(maxTags, maxTime, repeatCycle, InventoryType.NORMAL);
    }

    public void startInventoryRSSI(@IntRange(from=0L, to=255L) int maxTags, @IntRange(from=0L, to=255L) int maxTime, @IntRange(from=0L, to=65535L) int repeatCycle) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager startInventoryRSSI");
        this.startInventory(maxTags, maxTime, repeatCycle, InventoryType.RSSI);
    }

    public void startInventoryTagID(@IntRange(from=0L, to=255L) int maxTags, @IntRange(from=0L, to=255L) int maxTime, @IntRange(from=0L, to=65535L) int repeatCycle) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager startInventoryTagID");
        this.startInventory(maxTags, maxTime, repeatCycle, InventoryType.TAG_ID);
    }

    private void startInventory(@IntRange(from=0L, to=255L) int maxTags, @IntRange(from=0L, to=255L) int maxTime, @IntRange(from=0L, to=65535L) int repeatCycle, InventoryType inventoryType) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager startInventory");
        if (!this.checkIfValueIsWithinRange(maxTags, 255, "maxTags")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(maxTime, 255, "maxTime")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(repeatCycle, 65535, "repeatCycle")) {
            return;
        }
        if (USBManager.getInstance().isM30SDevice()) {
            int len = 0;
            byte[] param = new byte[1024];
            param[len++] = -103;
            param[len++] = 0;
            param[len++] = (byte)((maxTime & 0xFF) >> 8 & 0xFF);
            param[len++] = (byte)(maxTime & 0xFF);
            param[len++] = (byte)((maxTags & 0xFF) >> 8 & 0xFF);
            param[len++] = (byte)(maxTags & 0xFF);
            param[len++] = inventoryType == InventoryType.TAG_ID ? 3 : 0;
            param[len++] = 0;
            param[len++] = inventoryType == InventoryType.RSSI ? 49 : 48;
            param[len++] = 48;
            param[len++] = 48;
            param[0] = (byte)(len - 2);
            byte[] data = new byte[len];
            System.arraycopy(param, 0, data, 0, len);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)97, (byte)102, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        byte[] repeatCycleBytes = this.toBytes(repeatCycle, 2);
        PacketModel packetModel = null;
        switch (inventoryType) {
            case NORMAL: {
                packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.START_DECODE);
                break;
            }
            case RSSI: {
                packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.START_DECODE_WITH_RSSI);
                break;
            }
            case TAG_ID: {
                packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.START_DECODE_WITH_TAG_ID);
            }
        }
        if (inventoryType == InventoryType.TAG_ID) {
            packetModel.addPayloadData((byte)-96);
            packetModel.addPayloadData((byte)0);
            packetModel.addPayloadData((byte)0);
        } else {
            packetModel.addPayloadData((byte)2);
        }
        packetModel.addPayloadData((byte)maxTags);
        packetModel.addPayloadData((byte)maxTime);
        packetModel.addPayloadData(repeatCycleBytes[0]);
        packetModel.addPayloadData(repeatCycleBytes[1]);
        this.sendPacket(packetModel);
    }

    public void startRFMDecode(@IntRange(from=0L, to=255L) int codeType, @IntRange(from=0L, to=255L) int maxTags, @IntRange(from=0L, to=255L) int maxTime, @IntRange(from=0L, to=65535L) int repeatCycle) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager startRFMDecode");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(codeType, 255, "codeType")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(maxTags, 255, "maxTags")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(maxTime, 255, "maxTime")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(repeatCycle, 65535, "repeatCycle")) {
            return;
        }
        byte[] repeatCycleBytes = this.toBytes(repeatCycle, 2);
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.START_RFM_DECODE);
        packetModel.addPayloadData((byte)codeType);
        packetModel.addPayloadData((byte)maxTags);
        packetModel.addPayloadData((byte)maxTime);
        packetModel.addPayloadData(repeatCycleBytes[0]);
        packetModel.addPayloadData(repeatCycleBytes[1]);
        this.sendPacket(packetModel);
    }

    public void stopDecode() {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)97, (byte)115, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager stopDecode");
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.STOP_DECODE);
        this.sendPacket(packetModel);
    }

    public void getRegion() {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)103, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager getRegion");
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.GET_REGION);
        this.sendPacket(packetModel);
    }

    public void setRegion(@IntRange(from=0L, to=255L) int region) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setRegion");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(region, 255, "region")) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_REGION);
        packetModel.addPayloadData((byte)region);
        this.sendPacket(packetModel);
    }

    public void getFrequencyHoppingMode() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager getFrequencyHoppingMode");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.GET_FREQUENCY_HOPPING_MODE);
        this.sendPacket(packetModel);
    }

    public void setSmartHopping(boolean isOn) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setSmartHopping: isOn=" + isOn);
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_SMART_HOPPING);
        packetModel.addPayloadData(isOn ? (byte)1 : 0);
        this.sendPacket(packetModel);
    }

    public void getFrequencyHoppingTable() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager getFrequencyHoppingTable");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.GET_FREQUENCY_HOPPING_TABLE);
        this.sendPacket(packetModel);
    }

    public void setOptimumFrequencyHoppingTable() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setOptimumFrequencyHoppingTable");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_OPTINUM_FREQUENCY_HOPPING_TABLE);
        this.sendPacket(packetModel);
    }

    public void getChannel() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager getChannel");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.GET_CHANNEL);
        this.sendPacket(packetModel);
    }

    public void setChannel(@IntRange(from=0L, to=255L) int num, @IntRange(from=0L, to=255L) int offset) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setCurrChannel: num=" + num + " offset=" + offset);
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(num, 255, "num")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(offset, 255, "offset")) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_CHANNEL);
        packetModel.addPayloadData((byte)num);
        packetModel.addPayloadData((byte)offset);
        this.sendPacket(packetModel);
    }

    public void getSession() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager getSession");
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)115, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.GET_SESSION);
        this.sendPacket(packetModel);
    }

    public void setSession(@IntRange(from=0L, to=4L) int session) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setSession");
        if (!this.checkIfValueIsWithinRange(session, 4, "session")) {
            return;
        }
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] data = this.toAsciiBytes("" + session);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)115, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_SESSION);
        packetModel.addPayloadData((byte)session);
        this.sendPacket(packetModel);
    }

    public void getAntiCollisionMode() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager getAntiCollisionMode");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.GET_ANTI_COLLISION_MODE);
        this.sendPacket(packetModel);
    }

    public void setAntiCollisionMode(@IntRange(from=0L, to=255L) int mode, @IntRange(from=0L, to=255L) int start, @IntRange(from=0L, to=255L) int max, @IntRange(from=0L, to=255L) int min, @IntRange(from=0L, to=255L) int counter) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setAntiCollisionMode");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(mode, 255, "mode")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(start, 255, "start")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(max, 255, "max")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(min, 255, "min")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(counter, 255, "counter")) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_ANTI_COLLISION_MODE);
        packetModel.addPayloadData((byte)mode);
        packetModel.addPayloadData((byte)start);
        packetModel.addPayloadData((byte)max);
        packetModel.addPayloadData((byte)min);
        packetModel.addPayloadData((byte)counter);
        this.sendPacket(packetModel);
    }

    public void getFhLbtParam() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager getFhLbtParam");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.GET_FH_LBT_PARAM);
        this.sendPacket(packetModel);
    }

    public void setFhLbtParam(@IntRange(from=0L, to=65535L) int readTime, @IntRange(from=0L, to=65535L) int idleTime, @IntRange(from=0L, to=65535L) int senseTime, @IntRange(from=0L, to=65535L) int rfLevel, @IntRange(from=0L, to=255L) int fhMode, @IntRange(from=0L, to=255L) int lbtMode, @IntRange(from=0L, to=255L) int cwMode) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setFhLbtParam: readTime=" + readTime + " idleTime=" + idleTime + " senseTime=" + senseTime + " rfLevel=" + rfLevel + " fhMode=" + fhMode + " lbtMode=" + lbtMode + " cwMode=" + cwMode);
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(readTime, 65535, "readTime")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(idleTime, 65535, "idleTime")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(senseTime, 65535, "senseTime")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(rfLevel, 65535, "rfLevel")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(fhMode, 255, "fhMode")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(lbtMode, 255, "lbtMode")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(cwMode, 255, "cwMode")) {
            return;
        }
        byte[] readTimeBytes = this.toBytes(readTime, 2);
        byte[] idleTimeBytes = this.toBytes(idleTime, 2);
        byte[] senseTimeBytes = this.toBytes(senseTime, 2);
        byte[] rfLevelBytes = this.toBytes(rfLevel, 2);
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_FH_LBT_PARAM);
        packetModel.addPayloadData(readTimeBytes[0]);
        packetModel.addPayloadData(readTimeBytes[1]);
        packetModel.addPayloadData(idleTimeBytes[0]);
        packetModel.addPayloadData(idleTimeBytes[1]);
        packetModel.addPayloadData(senseTimeBytes[0]);
        packetModel.addPayloadData(senseTimeBytes[1]);
        packetModel.addPayloadData(rfLevelBytes[0]);
        packetModel.addPayloadData(rfLevelBytes[1]);
        packetModel.addPayloadData((byte)fhMode);
        packetModel.addPayloadData((byte)lbtMode);
        packetModel.addPayloadData((byte)cwMode);
        this.sendPacket(packetModel);
    }

    public void getOutputPowerLevel() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager getOutputPowerLevel");
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)97, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)112, null);
            boolean resultt = USBManager.getInstance().sendData(sendData);
            if (!resultt) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.GET_OUTPUT_POWER_LEVEL);
        this.sendPacket(packetModel);
    }

    public void setOutputPowerLevel(@IntRange(from=0L, to=250L) int level) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setOutputPowerLevel");
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] data = this.toAsciiBytes("" + level);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)112, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        if (!this.checkIfValueIsWithinRange(level, 250, "level")) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_OUTPUT_POWER_LEVEL);
        packetModel.addPayloadData((byte)(level / 256));
        packetModel.addPayloadData((byte)(level % 256));
        this.sendPacket(packetModel);
    }

    public void getModulation() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager getModulation");
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)52, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.GET_MODULATION);
        this.sendPacket(packetModel);
    }

    public void setModulation(String mode) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setModulation");
        if (USBManager.getInstance().isM30SDevice()) {
            String value = "1";
            if (mode.equals("160KHz, M8, Tari=20us")) {
                value = "0";
            } else if (mode.equals("250KHz, M4, Tari=20us")) {
                value = "1";
            } else if (mode.equals("320KHz, M4, Tari=20us")) {
                value = "2";
            } else if (mode.equals("320KHz, M2, Tari=20us")) {
                value = "3";
            } else if (mode.equals("320KHz, M2, Tari=15us")) {
                value = "4";
            }
            byte[] data = this.toAsciiBytes("" + value);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)52, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        String[] splitStr = mode.trim().split(",");
        int blf = Integer.parseInt(splitStr[0].replaceAll("KHz", ""));
        byte rxMod = ModulationMode.getRxMod(splitStr[1]);
        byte dr = ModulationMode.getDR(splitStr[2]);
        byte[] blfBytes = this.toBytes(blf, 2);
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_MODULATION);
        packetModel.addPayloadData((byte)-1);
        packetModel.addPayloadData(blfBytes[0]);
        packetModel.addPayloadData(blfBytes[1]);
        packetModel.addPayloadData(rxMod);
        packetModel.addPayloadData(dr);
        this.sendPacket(packetModel);
    }

    public void setTriggerStopCondition(@IntRange(from=0L, to=255L) int maxTags, @IntRange(from=0L, to=255L) int maxTime, @IntRange(from=0L, to=65535L) int repeatCycle) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager setTriggerStopCondition");
        if (USBManager.getInstance().isM30SDevice()) {
            this.callback.onSetTriggerStopConditionSuccess();
            return;
        }
        if (!this.checkIfValueIsWithinRange(maxTags, 255, "maxTags")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(maxTime, 255, "maxTime")) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(repeatCycle, 65535, "repeatCycle")) {
            return;
        }
        SharedPreferencesHelper.getInstance().setMaxTag(maxTags);
        SharedPreferencesHelper.getInstance().setMaxTime(maxTime);
        SharedPreferencesHelper.getInstance().setRepeatCycle(repeatCycle);
        byte[] repeatCycleBytes = this.toBytes(repeatCycle, 2);
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.SET_TRIGGER_STOP_CONDITION);
        packetModel.addPayloadData((byte)maxTags);
        packetModel.addPayloadData((byte)maxTime);
        packetModel.addPayloadData(repeatCycleBytes[0]);
        packetModel.addPayloadData(repeatCycleBytes[1]);
        this.sendPacket(packetModel);
    }

    public void readTagMemory(long password, String targetEPC, RFIDConst.MemoryBank memoryBank, RFIDConst.ReadMemoryType readType) {
        this.readTagMemory(password, targetEPC, memoryBank, readType, 0, 0, 0);
    }

    public void readTagMemory(long password, String targetEPC, RFIDConst.MemoryBank memoryBank, RFIDConst.ReadMemoryType readType, int timeout) {
        this.readTagMemory(password, targetEPC, memoryBank, readType, 0, 0, timeout);
    }

    public void readTagMemory(long password, String targetEPC, RFIDConst.MemoryBank memoryBank, RFIDConst.ReadMemoryType readType, @IntRange(from=0L, to=255L) int startAddress, @IntRange(from=0L, to=32767L) int dataLength, int timeout) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager readTagMemory");
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] newEPC = Convert.toBytes(targetEPC);
            int epcLength = newEPC.length;
            int len = 0;
            byte[] param = new byte[1024];
            param[len++] = -103;
            param[len++] = 0;
            param[len++] = (byte)(epcLength * 8 >> 8 & 0xFF);
            param[len++] = (byte)(epcLength * 8 & 0xFF);
            param[len++] = 0;
            param[len++] = 32;
            param[len++] = 1;
            for (int i = 0; i < epcLength; ++i) {
                param[len++] = newEPC[i];
            }
            param[len++] = (byte)(dataLength >> 8 & 0xFF);
            param[len++] = (byte)(dataLength & 0xFF);
            param[len++] = (byte)(startAddress >> 8 & 0xFF);
            param[len++] = (byte)(startAddress & 0xFF);
            param[len++] = (byte)memoryBank.ordinal();
            param[len++] = (byte)(password >> 24 & 0xFFL);
            param[len++] = (byte)(password >> 16 & 0xFFL);
            param[len++] = (byte)(password >> 8 & 0xFFL);
            param[len++] = (byte)(password & 0xFFL);
            param[len++] = 48;
            param[len++] = 48;
            param[len++] = 48;
            param[0] = (byte)(len - 2);
            byte[] data = new byte[len];
            System.arraycopy(param, 0, data, 0, len);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)97, (byte)114, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        if (!this.checkMemoryParam(password, targetEPC, startAddress, dataLength)) {
            return;
        }
        PacketModel packetModel = null;
        if (timeout != 0) {
            packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.READ_TAG_MEMORY_TIMEOUT);
        } else {
            switch (readType) {
                case NORMAL: {
                    packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.READ_TAG_MEMORY);
                    break;
                }
                case LONG_DATA: {
                    packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.READ_TAG_MEMORY_BLOCK);
                }
            }
        }
        byte[] epcDataArray = Convert.toBytes(targetEPC);
        this.setPayloadHeaderParam(packetModel, password, epcDataArray, memoryBank);
        if (startAddress >= 0) {
            int address = startAddress;
            this.setPayloadStartAddress(packetModel, address);
        }
        this.setPayloadDataLength(packetModel, dataLength);
        if (timeout != 0) {
            this.setPayloadTimeout(packetModel, timeout);
        }
        this.sendPacket(packetModel);
    }

    public void writeTagMemory(long password, String targetEPC, RFIDConst.MemoryBank memoryBank, RFIDConst.WriteMemoryType writeType, byte[] writeData) {
        this.writeTagMemory(password, targetEPC, memoryBank, writeType, 0, writeData, 0);
    }

    public void writeTagMemory(long password, String targetEPC, RFIDConst.MemoryBank memoryBank, RFIDConst.WriteMemoryType writeType, byte[] writeData, @IntRange(from=0L, to=65535L) int timeout) {
        this.writeTagMemory(password, targetEPC, memoryBank, writeType, 0, writeData, timeout);
    }

    public void writeTagMemory(long password, String targetEPC, RFIDConst.MemoryBank memoryBank, RFIDConst.WriteMemoryType writeType, @IntRange(from=0L, to=255L) int startAddress, byte[] writeData, int timeout) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager writeToTagMemory");
        if (USBManager.getInstance().isM30SDevice()) {
            int i;
            byte[] newEPC = Convert.toBytes(targetEPC);
            int epcLength = newEPC.length;
            int writeDataLength = writeData.length;
            int dataLength = writeDataLength / 2;
            int len = 0;
            byte[] param = new byte[1024];
            param[len++] = -103;
            param[len++] = 0;
            param[len++] = (byte)(epcLength * 8 >> 8 & 0xFF);
            param[len++] = (byte)(epcLength * 8 & 0xFF);
            param[len++] = 0;
            param[len++] = 32;
            param[len++] = 1;
            for (i = 0; i < epcLength; ++i) {
                param[len++] = newEPC[i];
            }
            param[len++] = (byte)(dataLength >> 8 & 0xFF);
            param[len++] = (byte)(dataLength & 0xFF);
            param[len++] = (byte)(startAddress >> 8 & 0xFF);
            param[len++] = (byte)(startAddress & 0xFF);
            param[len++] = (byte)memoryBank.ordinal();
            param[len++] = (byte)(password >> 24 & 0xFFL);
            param[len++] = (byte)(password >> 16 & 0xFFL);
            param[len++] = (byte)(password >> 8 & 0xFFL);
            param[len++] = (byte)(password & 0xFFL);
            for (i = 0; i < writeDataLength; ++i) {
                param[len++] = writeData[i];
            }
            param[len++] = 0;
            param[0] = (byte)(len - 2);
            byte[] data = new byte[len];
            System.arraycopy(param, 0, data, 0, len);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)97, (byte)119, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        if (!this.checkMemoryParam(password, targetEPC, startAddress, writeData.length)) {
            return;
        }
        PacketModel packetModel = null;
        if (timeout != 0) {
            packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.WRITE_TAG_MEMORY_TIMEOUT);
        } else {
            switch (writeType) {
                case NORMAL: {
                    packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.WRITE_TAG_MEMORY);
                    break;
                }
                case BLOCK: {
                    packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.WRITE_TAG_MEMORY_BLOCK);
                }
            }
        }
        byte[] epcDataArray = Convert.toBytes(targetEPC);
        this.setPayloadHeaderParam(packetModel, password, epcDataArray, memoryBank);
        if (startAddress >= 0) {
            int address = startAddress;
            this.setPayloadStartAddress(packetModel, address);
        }
        int dataLength = writeData.length / 2;
        this.setPayloadDataLength(packetModel, dataLength);
        for (int i = 0; i < writeData.length; ++i) {
            packetModel.addPayloadData(writeData[i]);
        }
        if (timeout != 0) {
            this.setPayloadTimeout(packetModel, timeout);
        }
        this.sendPacket(packetModel);
    }

    public void blockEraseToTagMemory(long password, String targetEPC, RFIDConst.MemoryBank memoryBank, @IntRange(from=0L, to=255L) int startAddress, @IntRange(from=0L, to=32767L) int dataLength) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager blockEraseToTagMemory");
        if (!this.checkMemoryParam(password, targetEPC, startAddress, dataLength)) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.BLOCK_ERASE_TO_TAG_MEMORY_PARAM);
        byte[] epcDataArray = Convert.toBytes(targetEPC);
        this.setPayloadHeaderParam(packetModel, password, epcDataArray, memoryBank);
        if (startAddress >= 0) {
            int address = startAddress;
            this.setPayloadStartAddress(packetModel, address);
        }
        this.setPayloadDataLength(packetModel, dataLength);
        this.sendPacket(packetModel);
    }

    public void killTag(long password, String targetEPC) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager killTag");
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] newEPC = Convert.toBytes(targetEPC);
            int epcLength = newEPC.length;
            int len = 0;
            byte[] param = new byte[1024];
            param[len++] = -103;
            param[len++] = 0;
            param[len++] = (byte)(epcLength * 8 >> 8 & 0xFF);
            param[len++] = (byte)(epcLength * 8 & 0xFF);
            param[len++] = 0;
            param[len++] = 32;
            param[len++] = 1;
            for (int i = 0; i < epcLength; ++i) {
                param[len++] = newEPC[i];
            }
            param[len++] = (byte)(password >> 24 & 0xFFL);
            param[len++] = (byte)(password >> 16 & 0xFFL);
            param[len++] = (byte)(password >> 8 & 0xFFL);
            param[len++] = (byte)(password & 0xFFL);
            param[0] = (byte)(len - 2);
            byte[] data = new byte[len];
            System.arraycopy(param, 0, data, 0, len);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)97, (byte)107, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        if (!this.checkIfValueIsWithinRange(password, 0xFFFFFFFFL, "password")) {
            return;
        }
        if (targetEPC == null || targetEPC.length() <= 0) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.KILL_TAG_MEMORY);
        byte[] epcDataArray = Convert.toBytes(targetEPC);
        this.setPayloadHeaderParam(packetModel, password, epcDataArray, RFIDConst.MemoryBank.NONE);
        this.sendPacket(packetModel);
    }

    public void lockTagMemory(long password, String targetEPC, @IntRange(from=0L, to=1048575L) int lockData) {
        this.lockTagMemory(password, targetEPC, lockData, -1);
    }

    public void lockTagMemory(long password, String targetEPC, @IntRange(from=0L, to=1048575L) int lockData, @IntRange(from=-1L, to=255L) int timeout) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager lockTagMemory");
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] newEPC = Convert.toBytes(targetEPC);
            int epcLength = newEPC.length;
            int[] result = this.resolve(lockData);
            int targetMemory = 0;
            int seed = 0;
            if (result != null && result.length == 2) {
                targetMemory = result[0];
                seed = result[1];
            }
            if (seed == 1) {
                seed = 2;
            } else if (seed == 2) {
                seed = 1;
            }
            if (targetMemory == 0) {
                targetMemory = 5;
            } else if (targetMemory == 1) {
                targetMemory = 4;
            } else if (targetMemory == 2) {
                targetMemory = 3;
            } else if (targetMemory == 3) {
                targetMemory = 2;
            } else if (targetMemory == 4) {
                targetMemory = 1;
            }
            int len = 0;
            byte[] param = new byte[1024];
            param[len++] = -103;
            param[len++] = 0;
            param[len++] = (byte)(epcLength * 8 >> 8 & 0xFF);
            param[len++] = (byte)(epcLength * 8 & 0xFF);
            param[len++] = 0;
            param[len++] = 32;
            param[len++] = 1;
            for (int i = 0; i < epcLength; ++i) {
                param[len++] = newEPC[i];
            }
            param[len++] = (byte)(password >> 24 & 0xFFL);
            param[len++] = (byte)(password >> 16 & 0xFFL);
            param[len++] = (byte)(password >> 8 & 0xFFL);
            param[len++] = (byte)(password & 0xFFL);
            param[len++] = (byte)seed;
            param[len++] = (byte)targetMemory;
            param[0] = (byte)(len - 2);
            byte[] data = new byte[len];
            System.arraycopy(param, 0, data, 0, len);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)97, (byte)108, data);
            boolean resultt = USBManager.getInstance().sendData(sendData);
            if (!resultt) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
            return;
        }
        if (!this.checkIfValueIsWithinRange(password, 0xFFFFFFFFL, "password")) {
            return;
        }
        if (targetEPC == null || targetEPC.length() <= 0) {
            return;
        }
        if (!this.checkIfValueIsWithinRange(lockData, 1048575, "lockData")) {
            return;
        }
        PacketModel packetModel = null;
        packetModel = timeout == -1 ? RFIDCommandFactory.getInstance().create(RFIDCommandType.LOCK_TAG_MEMORY) : RFIDCommandFactory.getInstance().create(RFIDCommandType.LOCK_TAG_MEMORY_TIMEOUT);
        byte[] epcDataArray = Convert.toBytes(targetEPC);
        this.setPayloadHeaderParam(packetModel, password, epcDataArray, RFIDConst.MemoryBank.NONE);
        byte[] lockDataBytes = this.toBytes(lockData, 3);
        packetModel.addPayloadData(lockDataBytes[0]);
        packetModel.addPayloadData(lockDataBytes[1]);
        packetModel.addPayloadData(lockDataBytes[2]);
        this.setPayloadTimeout(packetModel, timeout);
        this.sendPacket(packetModel);
    }

    public void updateRegistry() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager updateRegistry");
        if (USBManager.getInstance().isM30SDevice()) {
            return;
        }
        PacketModel packetModel = RFIDCommandFactory.getInstance().create(RFIDCommandType.UPDATE_REGISTRY);
        packetModel.addPayloadData((byte)1);
        this.sendPacket(packetModel);
    }

    public void getContinuousMode() {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)99, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void setContinuousMode(boolean isOn) {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] data = new byte[]{48};
            if (isOn) {
                data[0] = 49;
            }
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)99, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void getAutoOffTime() {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)116, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void setAutoOffTime(@IntRange(from=0L, to=1800L) int time) {
        if (USBManager.getInstance().isM30SDevice()) {
            if (!this.checkIfValueIsWithinRange(time, 1800, "Set auto off time")) {
                return;
            }
            byte[] data = this.toAsciiBytes("" + time);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)116, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void getSessionFlag() {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)102, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void setSessionFlag(@IntRange(from=0L, to=2L) int sessionFlag) {
        if (USBManager.getInstance().isM30SDevice()) {
            if (!this.checkIfValueIsWithinRange(sessionFlag, 2, "Set session flag")) {
                return;
            }
            byte[] data = this.toAsciiBytes("" + sessionFlag);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)102, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void getQValue() {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)81, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void setQValue(@IntRange(from=0L, to=15L) int value) {
        if (USBManager.getInstance().isM30SDevice()) {
            if (!this.checkIfValueIsWithinRange(value, 15, "Set Q value")) {
                return;
            }
            byte[] data = this.toAsciiBytes("" + value);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)81, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void getHidMode() {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)6, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void setHidMode(boolean hidMode) {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] data = this.toAsciiBytes("" + (hidMode ? 1 : 0));
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)6, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void getDutyRatio() {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)4, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void setDutyRatio(@IntRange(from=0L, to=150L) int dutyRatio) {
        if (USBManager.getInstance().isM30SDevice()) {
            if (!this.checkIfValueIsWithinRange(dutyRatio, 150, "Set duty ratio")) {
                return;
            }
            byte[] data = this.toAsciiBytes("" + dutyRatio);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)4, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void getDutyRatioBaseTime() {
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)5, null);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    public void setDutyRatioBaseTime(@IntRange(from=0L, to=65000L) int dutyRatioBaseTime) {
        if (USBManager.getInstance().isM30SDevice()) {
            if (!this.checkIfValueIsWithinRange(dutyRatioBaseTime, 65000, "Set duty ratio base time")) {
                return;
            }
            byte[] data = this.toAsciiBytes("" + dutyRatioBaseTime);
            byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)119, (byte)5, data);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onRFIDManagerError("Failed to send packet.");
            }
        }
    }

    @Override
    public void onReceivedData(PacketModel packetModel) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "RFIDManager onReceivedData");
        ArrayList<Byte> payload = packetModel.getPayload();
        int[] data = new int[payload.size()];
        for (int i = 0; i < payload.size(); ++i) {
            data[i] = payload.get(i) & 0xFF;
        }
        String result = String.format("%02X", packetModel.getCommand());
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "Command : " + result);
        switch (packetModel.getCommand()) {
            case 59: {
                if (data[0] == 0 || data[0] == 31) {
                    return;
                }
                int pcLen = data[0] >> 3;
                int epcLen = pcLen * 2;
                int[] pcEpc = new int[2 + epcLen];
                int sensorSize = data.length - (2 + epcLen);
                if (sensorSize < 0) {
                    sensorSize = 0;
                }
                int[] sensor = new int[sensorSize];
                if (data.length >= 2) {
                    System.arraycopy(data, 0, pcEpc, 0, 2 + epcLen);
                    System.arraycopy(data, 2 + epcLen, sensor, 0, data.length - (2 + epcLen));
                }
                this.callback.onPcEpcSensorDataReceived(pcEpc, sensor);
                break;
            }
            case 34: {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "RCP_CMD_READ_C_UII");
                this.callback.onTagReceived(data);
                break;
            }
            case 35: {
                int dataLen = payload.size();
                int rssi_i = data[dataLen - 4] & 0xFF;
                int rssi_q = data[dataLen - 3] & 0xFF;
                int gain_i = data[dataLen - 2] & 0xFF;
                int gain_q = data[dataLen - 1] & 0xFF;
                double rfin_i = 20.0 * Math.log10(rssi_i) - (double)gain_i - 33.0 - 30.0;
                double rfin_q = 20.0 * Math.log10(rssi_q) - (double)gain_q - 33.0 - 30.0;
                rfin_i = Math.pow(10.0, rfin_i / 20.0);
                rfin_q = Math.pow(10.0, rfin_q / 20.0);
                int rssi = (int)(20.0 * Math.log10(Math.sqrt(Math.pow(rfin_i, 2.0) + Math.pow(rfin_q, 2.0))));
                int[] newDest = new int[dataLen - 4];
                System.arraycopy(data, 0, newDest, 0, dataLen - 4);
                this.callback.onTagWithRssiReceived(newDest, rssi);
                break;
            }
            case 37: {
                if (data.length == 1) break;
                int pcEpcLength = (data[0] >> 2 & 0xFE) + 2;
                int[] epc = new int[pcEpcLength];
                int[] tid = new int[data.length - pcEpcLength];
                System.arraycopy(data, 0, epc, 0, epc.length);
                System.arraycopy(data, epc.length, tid, 0, tid.length);
                this.callback.onTagWithTidReceived(epc, tid);
                break;
            }
            case 6: {
                this.callback.onRegionReceived(data[0]);
                break;
            }
            case 7: {
                this.callback.didReceiveRegion(data[0]);
                break;
            }
            case -28: {
                this.callback.didSetOptiFreqHPTable(data[0]);
                break;
            }
            case -27: {
                this.callback.onReceiveSmartMode(data[0]);
                break;
            }
            case -26: {
                this.callback.didSetSmartMode(data[0]);
                break;
            }
            case 18: {
                this.callback.onSetChannelSuccess();
                break;
            }
            case 17: {
                this.callback.onChannelReceived(data[0], data[1]);
                break;
            }
            case 47: {
                this.callback.onSetSessionSuccess();
                break;
            }
            case 46: {
                this.callback.onSessionReceived(data[0]);
                break;
            }
            case 52: {
                int counter = payload.size() == 5 ? data[4] : 0;
                this.callback.onReceiveAntimode(data[0], data[1], data[2], data[3], counter);
                break;
            }
            case 19: {
                int readTime = data[0] * 256 + data[1];
                int idleTime = data[2] * 256 + data[3];
                int senseTime = data[4] * 255 + data[5];
                int lbtl1 = -3;
                int lbtl2 = 28;
                int lbtLevel = lbtl1 << 8 | lbtl2;
                int fhMode = data[8];
                int lbtMode = data[9];
                int cwMode = 0;
                this.callback.onFhLbtReceived(readTime, idleTime, senseTime, lbtLevel, fhMode, lbtMode, cwMode);
                break;
            }
            case 21: {
                int powerLevel = data[0] * 256 + data[1];
                int tx_minpower = data[2] * 256 + data[3];
                int tx_maxpower = data[4] * 256 + data[5];
                this.callback.onTxPowerLevelReceived(powerLevel, tx_minpower, tx_maxpower);
                break;
            }
            case 51: {
                this.callback.didSetModulation(data[0]);
                break;
            }
            case 50: {
                short blf = (short)(data[0] << 8 | data[1]);
                byte rxmod = (byte)data[2];
                byte dr = (byte)data[3];
                Function<Short, String> getBlfStr = val -> {
                    switch (val) {
                        case 40: {
                            return "40KHz";
                        }
                        case 80: {
                            return "80KHz";
                        }
                        case 160: {
                            return "160KHz";
                        }
                        case 250: {
                            return "250KHz";
                        }
                        case 320: {
                            return "320KHz";
                        }
                        case 640: {
                            return "640KHz";
                        }
                    }
                    return "";
                };
                String sBlf = getBlfStr.apply(blf);
                Function<Byte, String> getRxModStr = val -> {
                    if (val == 0) {
                        return "FM0";
                    }
                    if (val == 1) {
                        return "M2";
                    }
                    if (val == 2) {
                        return "M4";
                    }
                    if (val == 3) {
                        return "M8";
                    }
                    return "";
                };
                String sRxMod = getRxModStr.apply(rxmod);
                String sDr = dr == 0 ? "DR=8" : "DR=64/3";
                String sModulationMode = sBlf + ", " + sRxMod + ", " + sDr;
                this.callback.onModulationReceived(sModulationMode);
                break;
            }
            case 41: {
                this.callback.onTagMemoryReceived(data);
                break;
            }
            case 42: {
                this.callback.onTagMemoryLongReceived(data);
                break;
            }
            case -46: {
                this.callback.didUpdateRegistry(data[0]);
                break;
            }
            case 20: {
                this.callback.onSetFhLbtParamSuccess();
                break;
            }
            case -126: {
                this.callback.onLockTagMemorySuccess();
                break;
            }
            case 70: {
                this.callback.onWriteToTagMemorySuccess();
                break;
            }
            case 101: {
                this.callback.onKillTagMemorySuccess();
                break;
            }
            case 48: {
                this.callback.onGetFrequencyHoppingTableSuccess(data);
                break;
            }
            case 22: {
                this.callback.onSetOutputPowerLevelSuccess();
                break;
            }
            case 53: {
                this.callback.onSetAntiCollisionModeSuccess();
                break;
            }
            case 16: {
                this.callback.onSetTriggerStopConditionSuccess();
                break;
            }
            case 54: {
                if (data[0] != 31) break;
                this.callback.onAutoInventoryFinished();
            }
        }
    }

    private byte[] toAsciiBytes(String str) {
        if (str == null) {
            return new byte[0];
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') continue;
            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u5305\u542b\u975eASCII\u5b57\u7b26: " + c);
        }
        return str.getBytes(StandardCharsets.US_ASCII);
    }

    private int[] resolve(int lock) {
        block7: for (int targetMemory = 0; targetMemory <= 4; ++targetMemory) {
            int seed;
            int seedShift;
            int mask3;
            switch (targetMemory) {
                case 0: {
                    mask3 = 786432;
                    seedShift = 8;
                    break;
                }
                case 1: {
                    mask3 = 196608;
                    seedShift = 6;
                    break;
                }
                case 2: {
                    mask3 = 49152;
                    seedShift = 4;
                    break;
                }
                case 3: {
                    mask3 = 12288;
                    seedShift = 2;
                    break;
                }
                case 4: {
                    mask3 = 3072;
                    seedShift = 0;
                    break;
                }
                default: {
                    continue block7;
                }
            }
            if ((lock & mask3) != mask3 || (seed = lock >> seedShift & 3) < 0 || seed > 3) continue;
            return new int[]{targetMemory, seed};
        }
        return null;
    }

    static enum InventoryType {
        NORMAL,
        RSSI,
        TAG_ID;

    }
}

