/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.manager;

import jp.co.asterisk.asreader.a3xd.sdk.common.AsDeviceConst;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceCommandType;
import jp.co.asterisk.asreader.a3xd.sdk.utility.PacketModel;

class DeviceCommandFactory {
    private static DeviceCommandFactory instance;

    private DeviceCommandFactory() {
    }

    public static DeviceCommandFactory getInstance() {
        if (instance == null) {
            instance = new DeviceCommandFactory();
        }
        return instance;
    }

    public PacketModel create(DeviceCommandType type) {
        switch (type) {
            case POWER: {
                return this.createPower();
            }
            case BATTERY: {
                return this.createBattery();
            }
            case READER_SETTING: {
                return this.createReaderSetting();
            }
            case READER_INFO: {
                return this.createReaderInfo();
            }
        }
        return null;
    }

    private PacketModel createPacketModel(byte type, byte command) {
        PacketModel packetModel = new PacketModel();
        packetModel.setCommand(type, command);
        return packetModel;
    }

    private PacketModel createPower() {
        return this.createPacketModel((byte)0, (byte)1);
    }

    private PacketModel createBattery() {
        return this.createPacketModel((byte)0, (byte)-35);
    }

    private PacketModel createReaderSetting() {
        return this.createPacketModel((byte)0, (byte)-85);
    }

    private PacketModel createReaderInfo() {
        return this.createPacketModel((byte)0, (byte)3);
    }

    public byte[] sendPacket(byte cmd, byte subCmd, byte[] data) {
        int dataLen = data == null ? 0 : data.length;
        byte[] buf = new byte[5 + dataLen];
        try {
            buf[0] = 126;
            buf[1] = cmd;
            buf[2] = subCmd;
            if (data != null && data.length > 0) {
                System.arraycopy(data, 0, buf, 3, data.length);
            }
            System.arraycopy(AsDeviceConst.PACKET_SUFFIX, 0, buf, 3 + dataLen, AsDeviceConst.PACKET_SUFFIX.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf;
    }
}

