/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.utility;

import android.content.Context;
import android.icu.text.SimpleDateFormat;
import android.icu.util.Calendar;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import jp.co.asterisk.asreader.a3xd.sdk.utility.LogLevel;

public class SDKLog {
    private static final String TAG = SDKLog.class.getSimpleName();
    private static final String LOGDIR = "AsReaderLog";
    private final Object lockObj = new Object();
    private static SDKLog instance;
    private File directory;
    private File logFile;
    private BufferedWriter logWriter;
    private boolean logEnable = false;
    private LogLevel logLevel = LogLevel.Information;

    private SDKLog() {
    }

    public void setLogEnable(boolean enable) {
        this.logEnable = enable;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    public static SDKLog getInstance() {
        if (instance == null) {
            instance = new SDKLog();
        }
        return instance;
    }

    public void initialize(Context context) {
        this.directory = new File(context.getExternalFilesDir(Environment.DIRECTORY_DOCUMENTS), LOGDIR);
        this.directory.mkdir();
        String fileName = this.getLogFileName();
        this.logFile = new File(this.directory, fileName);
        try {
            this.logFile.createNewFile();
            this.open();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.toString());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Log(String tagName, LogLevel level, String content) {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.logEnable) {
                try {
                    if (this.logWriter != null && this.logLevel.getCode() >= level.getCode()) {
                        Calendar cl = Calendar.getInstance();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss ");
                        String message = String.format("%s [%-5s] %s %s", sdf.format(cl.getTime()), level.getName(), tagName, content);
                        Log.d((String)tagName, (String)message);
                        this.logWriter.write(message);
                        this.logWriter.newLine();
                        this.logWriter.flush();
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)e.toString());
                    e.printStackTrace();
                }
            }
        }
    }

    public void open() {
        try {
            if (this.logWriter == null) {
                this.directory.mkdir();
                FileOutputStream fos = new FileOutputStream(this.logFile, true);
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                this.logWriter = new BufferedWriter(osw);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
                this.logWriter = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllLog() {
        Object object = this.lockObj;
        synchronized (object) {
            File[] files;
            if (this.logFile.exists() && (files = this.directory.listFiles()) != null) {
                for (File f : files) {
                    f.delete();
                }
            }
            this.directory.delete();
        }
    }

    public static String toStringFromByte(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            sb.append(String.format("%02X ", data[i]));
        }
        return sb.toString();
    }

    private String getLogFileName() {
        Calendar cl = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        return "SDK" + sdf.format(cl.getTime()) + ".log";
    }
}

