/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.utility;

import java.util.ArrayList;
import jp.co.asterisk.asreader.a3xd.sdk.utility.CRCCalculator;

public class PacketModel {
    private static final byte PREANBLE = -69;
    private static final byte ENDMARK = 126;
    private byte mPreamble = (byte)-69;
    private byte mType;
    private byte mCommand;
    private byte[] mLength;
    private ArrayList<Byte> mPayload;
    private byte mEndMark = (byte)126;
    private byte[] mCRC;

    public PacketModel() {
        this.mLength = new byte[2];
        this.mPayload = new ArrayList();
        this.mCRC = new byte[2];
    }

    public void setCommand(byte type, byte command) {
        this.mType = type;
        this.mCommand = command;
    }

    public void setCommand(byte type, byte command, byte[] payload) {
        this.mType = type;
        this.mCommand = command;
        int length = payload != null ? payload.length : 0;
        this.mLength[0] = (byte)(length >> 8 & 0xFF);
        this.mLength[1] = (byte)(length & 0xFF);
    }

    public byte[] getByte(byte[] retPacket) {
        return retPacket;
    }

    public byte[] toByteArray() {
        int size = 8;
        int n = this.mPayload != null ? this.mPayload.size() : 0;
        int count = 0;
        byte[] data = new byte[size += n];
        data[count++] = this.mPreamble;
        data[count++] = this.mType;
        data[count++] = this.mCommand;
        data[count++] = (byte)(this.mPayload.size() >> 8 & 0xFF);
        data[count++] = (byte)(this.mPayload.size() & 0xFF);
        if (this.mPayload != null) {
            for (int i = 0; i < this.mPayload.size(); ++i) {
                data[count++] = this.mPayload.get(i);
            }
        }
        data[count++] = this.mEndMark;
        data[count++] = this.mCRC[0];
        data[count] = this.mCRC[1];
        return data;
    }

    public void makeCRC() {
        int size = 5;
        int n = this.mPayload != null ? this.mPayload.size() : 0;
        int count = 0;
        byte[] data = new byte[size += n];
        data[count++] = this.mType;
        data[count++] = this.mCommand;
        data[count++] = (byte)(this.mPayload.size() >> 8 & 0xFF);
        data[count++] = (byte)(this.mPayload.size() & 0xFF);
        if (this.mPayload != null) {
            for (int i = 0; i < this.mPayload.size(); ++i) {
                data[count++] = this.mPayload.get(i);
            }
        }
        data[count] = this.mEndMark;
        int crc = CRCCalculator.Cal_CRC16(data);
        this.mCRC[0] = (byte)(crc >> 8 & 0xFF);
        this.mCRC[1] = (byte)(crc & 0xFF);
    }

    public void addPayloadData(byte data) {
        this.mPayload.add(data);
    }

    public ArrayList<Byte> getPayload() {
        return this.mPayload;
    }

    public void setPreamble(byte mPreamble) {
        this.mPreamble = mPreamble;
    }

    public void setType(byte mType) {
        this.mType = mType;
    }

    public byte getCommand() {
        return this.mCommand;
    }

    public void setCommand(byte mCommand) {
        this.mCommand = mCommand;
    }

    public void setLength(byte[] mLength) {
        this.mLength = mLength;
    }

    public void setEndMark(byte mEndMark) {
        this.mEndMark = mEndMark;
    }

    public void setCRC(byte[] mCRC) {
        this.mCRC = mCRC;
    }
}

