package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;

import java.util.ArrayList;

import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentSessionFlagBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class SessionFlagFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = SessionFlagFragment.class.getSimpleName();

    private FragmentSessionFlagBinding binding;

    private ArrayAdapter<String> adapter;
    private ArrayList<String> sessionFlagList;

    private int sessionFlag = 0;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_SessionFlagFragment_to_HomeFragment);

        binding = FragmentSessionFlagBinding.inflate(inflater, container, false);

        sessionFlagList = new ArrayList<>();
        sessionFlagList.add("A");
        sessionFlagList.add("B");
        sessionFlagList.add("AB");
        adapter = new ArrayAdapter<>(getContext(), R.layout.cell_setting_check, sessionFlagList);

        binding.listView.setAdapter(adapter);
        binding.listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        binding.listView.setItemChecked(getPreferencesHelper().getSessionFlag(), true);
        binding.listView.setOnItemClickListener((AdapterView<?> parent, View view, int position, long id) -> {
            sessionFlag = position;
            getPreferencesHelper().setSessionFlag(sessionFlag);
        });

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().getSessionFlag();

        setToolbar(true, getString(R.string.toolbar_title_session_flag), getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        AsReaderSDK.getInstance().getRFIDManager().setSessionFlag(getPreferencesHelper().getSessionFlag());
    }

    @Override
    public void  didSetSessionFlag(int status) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                if (status == 0) {
                    showToast(getString(R.string.success), Toast.LENGTH_LONG);
                }else {
                    showToast(getString(R.string.failed), Toast.LENGTH_LONG);
                }
            });
        }
    }

    @Override
    public void onReceiveSessionFlag(int ses) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                binding.listView.setItemChecked(ses, true);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
