package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentModulationModeBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.utility.ModulationMode;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import java.util.ArrayList;

public class ModulationModeFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = ModulationModeFragment.class.getSimpleName();
    private int MAX_MODULATION_MODE = 16;

    private FragmentModulationModeBinding binding;

    private ArrayList<String> modeList;
    private ArrayAdapter<String> adapter;

    private String selectMode;
    private int getMode;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_ModulationModeFragment_to_HomeFragment);

        binding = FragmentModulationModeBinding.inflate(inflater, container, false);
        if (AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
            MAX_MODULATION_MODE = 5;
        }
        modeList = new ArrayList<>();
        for (int i = 0; i < MAX_MODULATION_MODE; i++) {
            try {
                modeList.add(ModulationMode.getModulationMode(i));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        adapter = new ArrayAdapter(getContext(), R.layout.cell_setting_check, modeList);
        binding.listView.setAdapter(adapter);
        binding.listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        binding.listView.setOnItemClickListener((AdapterView<?> parent, View view, int position, long id) -> {
            try {
                selectMode = ModulationMode.getModulationMode(position);
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().getModulation();

        setToolbar(true, getString(R.string.toolbar_title_modulation_mode), getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }
    
    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        if (selectMode == null) {
            try {
                this.selectMode = ModulationMode.getModulationMode(getMode);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        AsReaderSDK.getInstance().getRFIDManager().setModulation(selectMode);
    }

    @Override
    public void didSetModulation(int state) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast(getString(R.string.success));
            });
        }
    }

    @Override
    public void onModulationReceived(String modulationMode) {
        // sModulationMode : BLF, RxMod, DR
        getMode = 0;
        for (int i = 0; i < modeList.size(); i++){
            if (modeList.get(i).contains(modulationMode)) {
                getMode = i;
                break;
            }
        }
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                binding.listView.setItemChecked(getMode, true);
                adapter.notifyDataSetChanged();
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
