package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentAutoOffTimeBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.util.EditTextInputFilter;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;



public class AutoOffTimeFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = AutoOffTimeFragment.class.getSimpleName();

    private FragmentAutoOffTimeBinding binding;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_AutoOffTimeFragment_to_HomeFragment);

        binding = FragmentAutoOffTimeBinding.inflate(inflater, container, false);

        binding.autoOffTimeEditText.setFilters(new EditTextInputFilter[]{new EditTextInputFilter("0","1800")});

        binding.autoOffTimeEditText.setOnFocusChangeListener(focusChangeListener);

        binding.getRoot().setFocusable(true);

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().getAutoOffTime();
        setToolbar(true, "Auto Off Time", getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        try {
            binding.getRoot().requestFocus();
            int time = Integer.parseInt(binding.autoOffTimeEditText.getText().toString());
            AsReaderSDK.getInstance().getRFIDManager().setAutoOffTime(time);
        } catch (NumberFormatException e) {
            e.printStackTrace();
            showToast(getString(R.string.error));
        }
    }

    private View.OnFocusChangeListener focusChangeListener = (View view, boolean hasFocus) -> {
        if (!hasFocus) {
           if (view == binding.autoOffTimeEditText) {
                if (binding.autoOffTimeEditText.getText().toString().equals("")) {
                    binding.autoOffTimeEditText.setText("0");
                }
            }
        }
    };

    @Override
    public void didSetAutoOffTime(int status) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                if (status == 0){
                    showToast(getString(R.string.success), Toast.LENGTH_LONG);
                } else {
                    showToast(getString(R.string.failed), Toast.LENGTH_LONG);
                }
            });
        }
    }

    @Override
    public void onReceiveAutoOffTime(int time) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                binding.autoOffTimeEditText.setText(String.valueOf(time));
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}