package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.RadioGroup;
import android.widget.Toast;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentAntiCollisionBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import java.util.ArrayList;

import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class AntiCollisionFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = AntiCollisionFragment.class.getSimpleName();
    private FragmentAntiCollisionBinding binding;

    private ArrayAdapter<String> adapter;
    private ArrayList<String> modeList;
    private Handler handler = new Handler();

    private int antimode = 0;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_AntiCollisionFragment_to_HomeFragment);

        binding = FragmentAntiCollisionBinding.inflate(inflater, container, false);

        modeList = new ArrayList<>();
        for (int i = 0; i < 4; i++) {
            modeList.add("Mode" + i);
        }
        adapter = new ArrayAdapter<>(getContext(), R.layout.cell_setting_check, modeList);

        binding.listView.setAdapter(adapter);
        binding.listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        binding.listView.setOnItemClickListener((AdapterView<?> parent, View view, int position, long id) -> {
            antimode = position;
        });

        binding.segmentRadioGroup.setOnCheckedChangeListener(onCheckedChanged);

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().getAntiCollisionMode();

        setToolbar(true, getString(R.string.toolbar_title_anticollision_mode), getString(R.string.button_name_done));
    }

    private RadioGroup.OnCheckedChangeListener onCheckedChanged = new RadioGroup.OnCheckedChangeListener() {
        @Override
        public void onCheckedChanged(RadioGroup group, int checkedId) {
            if (checkedId == R.id.fixed_que_radio_button) {
                antimode = 0;
                binding.maxMinSettingLayout.setVisibility(View.GONE);

            } else if (checkedId == R.id.dynamic_que_radio_button) {
                antimode = 1;
                binding.maxMinSettingLayout.setVisibility(View.VISIBLE);

            }
        }
    };

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        handler.removeCallbacksAndMessages(null);
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);

        try {
            int qstart = Integer.parseInt(binding.qstartEditText.getText().toString());
            int qmax = Integer.parseInt(binding.qmaxEditText.getText().toString());
            int qmin = Integer.parseInt(binding.qminEditText.getText().toString());
            int counter = Integer.parseInt(binding.counterEditText.getText().toString());

            if (counter > 255) {
                showToast("please Check Counter : 0 ~ 255");
                return;
            }

            AsReaderSDK.getInstance().getRFIDManager()
                    .setAntiCollisionMode(antimode, qstart, qmax, qmin, counter);

            showToast("Try to change Setting  ... ", Toast.LENGTH_LONG);

            handler.postDelayed(()-> {
                AsReaderSDK.getInstance().getRFIDManager().getAntiCollisionMode();
            }, 2000);

        } catch (NumberFormatException e) {
            e.printStackTrace();
            showToast(getString(R.string.error));
        }
    }

    @Override
    public void onSetAntiCollisionModeSuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast(getString(R.string.success), Toast.LENGTH_LONG);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }

    @Override
    public void onReceiveAntimode(int mode, int qStart, int qMax, int qMin, int counter) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                binding.listView.setItemChecked(mode, true);
                binding.qdataTextView.setText(
                        "Mode: " + mode + " QStart: " + qStart + " QMax: " + qMax + " QMin: " + qMin);
                binding.qstartEditText.setText(String.valueOf(qStart));
                binding.qmaxEditText.setText(String.valueOf(qMax));
                binding.qminEditText.setText(String.valueOf(qMin));
                binding.counterEditText.setText(String.valueOf(counter));

                if(mode == 0) {
                    binding.segmentRadioGroup.check(R.id.fixed_que_radio_button);
                }
                else if(mode == 1) {
                    binding.segmentRadioGroup.check(R.id.dynamic_que_radio_button);
                }
            });
        }
    }
}
