package jp.co.asterisk.asreader.a3xd.demoapp.fragment;

import android.os.Bundle;

import android.os.Handler;
import android.os.Looper;
import android.text.method.ScrollingMovementMethod;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentRfmSensorBinding;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.event.IOnAsDeviceRfidEvent;
import jp.co.asterisk.asreader.a3xd.demoapp.rfid.SensorTag;
import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

import static jp.co.asterisk.asreader.a3xd.demoapp.rfid.SensorTag.hexMoisture;
import static jp.co.asterisk.asreader.a3xd.demoapp.rfid.SensorTag.hexTemperature;

public class RfmSensorFragment extends BaseFragment implements RFIDManagerCallback {

    public static final String TAG = "RfmSensorFragment";

    private FragmentRfmSensorBinding binding;

    private byte hexRfmCT = 0x00;	// 0x02 = moisture , 0x03 = temperature

    private SensorTag sensorTag;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_RfmSensorFragment_to_HomeFragment);

        binding = FragmentRfmSensorBinding.inflate(inflater, container, false);

        sensorTag = new SensorTag();

        binding.temperatureTextView.setMovementMethod(ScrollingMovementMethod.getInstance());
        binding.moistureTextView.setMovementMethod(ScrollingMovementMethod.getInstance());

        binding.moistureButton.setOnClickListener(clickListener);
        binding.temperatureButton.setOnClickListener(clickListener);
        binding.stopButton.setOnClickListener(clickListener);
        binding.clearButton.setOnClickListener(clickListener);

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);

        setToolbar(true, getString(R.string.toolbar_title_rfm_sensor));
    }

    @Override
    public void onStop() {
        super.onStop();
        AsReaderSDK.getInstance().getRFIDManager().stopDecode();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    private View.OnClickListener clickListener = (View view) -> {
        if (view == binding.moistureButton) {
            hexRfmCT = hexMoisture;
            startReadRfm();

        } else if (view == binding.temperatureButton) {
            hexRfmCT = hexTemperature;
            startReadRfm();

        } else if (view == binding.stopButton) {
            AsReaderSDK.getInstance().getRFIDManager().stopDecode();

        } else if (view == binding.clearButton) {
            binding.temperatureTextView.setText("");
            binding.moistureTextView.setText("");
        }
    };

    private void startReadRfm(){
        binding.temperatureTextView.setText("");
        binding.moistureTextView.setText("");

        AsReaderSDK.getInstance().getRFIDManager().stopDecode();

        new Handler(Looper.myLooper()).postDelayed(() -> {
            int maxTag = AsReaderSDK.getInstance().getRFIDManager().getMaxTagValue();
            int maxTime = AsReaderSDK.getInstance().getRFIDManager().getMaxTimeValue();
            int repeatCycle = AsReaderSDK.getInstance().getRFIDManager().getRepeatCycleValue();

            AsReaderSDK.getInstance().getRFIDManager().startRFMDecode(hexRfmCT, maxTag, maxTime, repeatCycle);
        }, 100);
    }

    private void setSensorTagList(int[] pcEpc, int[] sensorData) {
        try {
            sensorTag.parseSensorData(pcEpc, sensorData);

            if (getActivity()!=null){
                getActivity().runOnUiThread(() -> {
                    if (hexRfmCT == hexTemperature){
                        binding.temperatureTextView.append("\n" + sensorTag.getSensorPcEpc() + "  [" + String.format("%.2f", sensorTag.getSensorTemp()) + "°C]");
                        binding.moistureTextView.append("\n" + sensorTag.getSensorPcEpc() + "  [" + String.format("%.2f", sensorTag.getSensorMoisture()) + "]");
                        scrollBottom(binding.temperatureTextView);
                    } else if (hexRfmCT == hexMoisture) {
                        binding.moistureTextView.append("\n" + sensorTag.getSensorPcEpc() + "  [" + String.format("%.2f", sensorTag.getSensorMoisture()) + "]");
                        scrollBottom(binding.moistureTextView);
                    }
                });
            }

        } catch (Exception e) {
            e.printStackTrace();
            Log.d(RfmSensorFragment.TAG, "Fail Parse Sensor Data");
        }
    }

    private void scrollBottom(TextView textView) {
        int lineTop =  textView.getLayout().getLineTop(textView.getLineCount());
        int scrollY = lineTop - textView.getHeight();
        if (scrollY > 0) {
            textView.scrollTo(0, scrollY);
        } else {
            textView.scrollTo(0, 0);
        }
    }

    @Override
    public void onPcEpcSensorDataReceived(int[] pcEpc, int[] sensorData) {
        setSensorTagList(pcEpc, sensorData);
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
