package jp.co.asterisk.asreader.a3xd.demoapp.fragment;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentRegionBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentRfmSensorBinding;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.event.IOnAsDeviceRfidEvent;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;

import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class RegionFragment extends BaseFragment implements RFIDManagerCallback, AlertDialogFragment.AlertDialogFragmentListener {

    private final String TAG = RegionFragment.class.getSimpleName();

    private FragmentRegionBinding binding;

    private ArrayAdapter<String> adapter;
    private ArrayList<String> regionList;

    private int nSelectedRegion = -1;

    private String strRegion = "None";

    private final int REGION_KOREA			=	0x11;
    private final int REGION_USA 			=	0x21;
    private final int REGION_USA2	 		=	0x22;
    private final int REGION_EUROPE			=	0x31;
    private final int REGION_JAPAN			=	0x41;
    private final int REGION_CHINA1			=	0x51;
    private final int REGION_CHINA2			=	0x52;
    private final int REGION_BRAZIL1        =   0x61;
    private final int REGION_BRAZIL2        =   0x62;
    private final int REGION_AU_HK			=	0x71;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_RegionFragment_to_HomeFragment);

        binding = FragmentRegionBinding.inflate(inflater, container, false);

        regionList = new ArrayList<>(Arrays.asList(
                "REGION_KOREA",
                "REGION_USA",
                "REGION_USA2",
                "REGION_EUROPE",
                "REGION_JAPAN",
                "REGION_CHINA1",
                "REGION_CHINA2",
                "REGION_BRAZIL1",
                "REGION_BRAZIL2",
                "REGION_AU_HK"
        ));
        adapter = new ArrayAdapter<>(getContext(), R.layout.cell_setting_check, regionList);

        binding.listView.setAdapter(adapter);
        binding.listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        binding.listView.setItemChecked(nSelectedRegion, true);
        binding.listView.setOnItemClickListener((AdapterView<?> parent, View view, int position, long id) -> {
            nSelectedRegion = position;
        });
        if (DeviceManager.getInstance().isM30SDevice()){
            binding.listView.setVisibility(View.GONE);
        }
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().getRegion();

        nSelectedRegion = -1;
        if (DeviceManager.getInstance().isM30SDevice()){
            setToolbar(true, getString(R.string.toolbar_title_region), "");
        } else {
            setToolbar(true, getString(R.string.toolbar_title_region), getString(R.string.button_name_done));
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        if (DeviceManager.getInstance().isM30SDevice()){
            return;
        }
        if(nSelectedRegion == -1) {
            showToast("Not selected Region");
            return;
        }

        Function<Integer, Integer> getRegionCode = (val) -> {
            switch(val) {
                case 0: return 0x11;
                case 1: return 0x21;
                case 2: return 0x22;
                case 3: return 0x31;
                case 4: return 0x41;
                case 5: return 0x51;
                case 6: return 0x52;
                case 7: return 0x61;
                case 8: return 0x62;
                case 9: return 0x71;
                default:
                    return 0;
            }
        };
        int region = getRegionCode.apply(nSelectedRegion);
        AsReaderSDK.getInstance().getRFIDManager().setRegion(region);
    }

    /*
     *   AlertDialogFragmentListener
     */
    @Override
    public void OnClickPositiveButton() {

    }

    @Override
    public void OnClickNegativeButton() {

    }

    /**
     *  RFIDManagerCallback
     */
    @Override
    public void didUpdateRegistry(int state) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                if(state != 0) {
                    showToast("Fail Update Registry");
                }
            });
        }
    }

    @Override
    public void didReceiveRegion(int state) {
        Log.i("Region", " Region   " +state);
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                if(state == 0) {
                    AsReaderSDK.getInstance().getRFIDManager().updateRegistry();
                    showToast(getString(R.string.success));

                    AsReaderSDK.getInstance().getRFIDManager().updateRegistry();

                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }

                    AsReaderSDK.getInstance().getRFIDManager().getRegion();

                    showAlertDialog(
                            "Confirm",
                            "Region is changed \nThe RFID Reader must be reset(detach -> reconnect)",
                            "OK",
                            this
                    );

                } else {
                    showToast("Fail Set Region");
                }
            });
        }
    }

    @Override
    public void onRegionReceived(int region) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                Function<Integer, String> getRegionStr = (val) -> {
                    switch (val) {
                        case REGION_KOREA:  return "KOREA";
                        case REGION_USA:    return "USA1";
                        case REGION_USA2:   return "USA2";
                        case REGION_EUROPE: return "EU";
                        case REGION_JAPAN:  return "JAPAN";
                        case REGION_CHINA1: return "CHINA1";
                        case REGION_CHINA2: return "CHINA2";
                        case REGION_BRAZIL1: return "BRAZIL1";
                        case REGION_BRAZIL2: return "BRAZIL2";
                        case REGION_AU_HK:  return "ASIA";
                        default:
                            return "Unknown";
                    }
                };
                strRegion = getRegionStr.apply(region);
                binding.regionTextView.setText("Region : " + strRegion);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
