package jp.co.asterisk.asreader.a3xd.demoapp.fragment;

import android.content.Context;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;
import androidx.fragment.app.Fragment;
import androidx.navigation.fragment.NavHostFragment;

import jp.co.asterisk.asreader.a3xd.demoapp.util.prefs.SharedPreferencesHelper;
import jp.co.asterisk.asreader.a3xd.demoapp.MainActivity;
import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;

public class BaseFragment extends Fragment {

    private int backToHomeActionResId;

    public void setBackToHomeActionResId(int backToHomeActionResId) {
        this.backToHomeActionResId = backToHomeActionResId;
    }

    public void onClickRightButton(View view) {
        InputMethodManager inputMethodManager =
                (InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
        inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    protected void setToolbar(boolean isSub, String title) {
        setToolbar(isSub, title, View.GONE);
    }

    protected void setToolbar(boolean isSub, String title, String rightButtonText) {
        setToolbar(isSub, title, View.VISIBLE);
        getMainActivity().setRightButtonText(rightButtonText);
    }

    private void setToolbar(boolean isSub, String title, int rightButtonVisibility) {
        if (isSub) {
            getMainActivity().showBackButton(true);
            getMainActivity().setVisibilityOtgLogoImage(View.GONE);
            getMainActivity().setTitleTextSize(getFloatValueFromDimenId(R.dimen.toolbar_title_normal_size));
        } else {
            getMainActivity().showBackButton(false);
            getMainActivity().setVisibilityOtgLogoImage(View.VISIBLE);
            getMainActivity().setTitleTextSize(getFloatValueFromDimenId(R.dimen.toolbar_title_small_size));
        }
        setTitleText(title);
        getMainActivity().setVisibilityRightButton(rightButtonVisibility);
    }

    protected SharedPreferencesHelper getPreferencesHelper() {
        return getMainActivity().getPreferencesHelper();
    }

    protected void showToast(String message) {
        getMainActivity().showToast(message, Toast.LENGTH_SHORT);
    }

    protected void showToast(String message, int duration) {
        getMainActivity().showToast(message, duration);
    }

    protected void setRightButtonEnabled(boolean enabled) {
        getMainActivity().setRightButtonEnabled(enabled);
        int color = enabled ? R.color.skyblue : R.color.silver;
        getMainActivity().setRightButtonTextColor(color);
    }

    protected void setTitleText(String text) {
        getMainActivity().setTitleText(text);
    }

    protected float getFloatValueFromDimenId(int id) {
        TypedValue outValue = new TypedValue();
        getResources().getValue(id, outValue, true);
        return outValue.getFloat();
    }

    protected void showAlertDialog(String title, String message, String positiveButtonText, Fragment fragment) {
        AlertDialogFragment dialogFragment =
                AlertDialogFragment.newInstance(title, message, positiveButtonText, fragment);

        dialogFragment.show(getParentFragmentManager(), "dialog");
    }

    protected void showAlertDialog(String title, String message, String positiveButtonText, String negativeButtonText, Fragment fragment) {
        AlertDialogFragment dialogFragment =
                AlertDialogFragment.newInstance(title, message, positiveButtonText, negativeButtonText, fragment);

        dialogFragment.show(getParentFragmentManager(), "dialog");
    }

    protected void navigate(Fragment fragment, int resId) {
        getMainActivity().navigate(fragment, resId);
    }

    protected void navigate(Fragment fragment, int resId, Bundle args) {
        getMainActivity().navigate(fragment, resId, args);
    }

    protected MainActivity getMainActivity() {
        return ((MainActivity)getActivity());
    }

    public void onConnect(boolean isConnect) {
        if (!isConnect) {
            if (backToHomeActionResId != 0) {
                navigate(this, backToHomeActionResId);
            }
        }
    }

    public void onUserLeaveHint() {
        if (backToHomeActionResId != 0) {
            navigate(this, backToHomeActionResId);
        }
    }
}
