//
//  AsReaderLfProtocol.h
//  AsReaderDockSDK
//
//  @brief  The AsReaderLfProtocol.h file defines a protocol used in the AsReaderDockSDK for handling LF RFID tags. The protocol provides an interface for devices that support LF RFID communication, allowing the SDK to notify a delegate when LF tags are detected or received.
//
//  Created by Mikiko on 11/7/24.
//  Copyright © 2024 SPS INC. All rights reserved.
//

#ifndef AsReaderLfProtocol_h
#define AsReaderLfProtocol_h
#endif /* AsReaderLfProtocol_h */


/**
 *  @brief      RcpLfDelegate
 *  @details    Delegate for Lf event callback.
 */

@protocol AsReaderLfDeviceDelegate <NSObject>

@required

@optional


/**
 *  @brief      Function that is called when a tag ID is received
 *  @param      lfTag : tag ID
 */
- (void)lfTagReceived:(NSData *)lfTag;
@end
