//
//  BarcodeDemoTableViewCell.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/9.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class BarcodeDemoTableViewCell: UITableViewCell {
    @IBOutlet private weak var codeTypeLabel: UILabel!
    @IBOutlet private weak var codeIdLabel: UILabel!
    @IBOutlet private weak var barcodeLabel: UILabel!
    @IBOutlet private weak var countLabel: UILabel!

    public func setCodeTypeValue(_ codeTypeValue: String) {
        self.codeTypeLabel.text = codeTypeValue
    }
    public func setCodeIdValue(_ codeIdValue: String) {
        self.codeIdLabel.text = codeIdValue
    }
    public func setBarcodeValue(_ barcodeValue: String) {
        self.barcodeLabel.text = barcodeValue
    }
    public func setCountValue(_ countValue: Int) {
        self.countLabel.text = String.init(format: "%d", countValue) 
    }
    override func awakeFromNib() {
        super.awakeFromNib()
    }
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
}
