//
//  WriteMemoryViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/13.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class WriteMemoryViewController: UIViewController {
    @IBOutlet private weak var selectionTagLabel: UILabel!
    @IBOutlet private weak var messageLabel: UILabel!
    @IBOutlet private weak var pickerView: UIPickerView!
    @IBOutlet private weak var bankTextField: UITextField!
    @IBOutlet private weak var offsetTextField: UITextField!
    @IBOutlet private weak var writeDataTextField: UITextField!
    @IBOutlet private weak var passwordTextField: UITextField!
    @IBOutlet private weak var powerGainTextField: UITextField!
    @IBOutlet private weak var operationTimeTextField: UITextField!
    @IBOutlet private weak var bankPickerTopView: UIView!
    @IBOutlet private weak var offsetPickerTopView: UIView!
    @IBOutlet private weak var powerGainPickerTopView: UIView!
    @IBOutlet private weak var rssiLabel: UILabel!
    @IBOutlet private weak var phaseLabel: UILabel!
    @IBOutlet private weak var reportRssiSwitch: UISwitch!
    @IBOutlet private var reportRssiCollection: [UILabel]!
    @IBOutlet private weak var maskBtn: UIButton!
    private enum PickerViewTag: Int {
        case pickerViewBank = 0
        case pickerViewOffset = 1
        case pickerViewPowerGain = 2
    }
    private let textFieldWriteData = 10
    private let textFieldWritePassword = 11
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var currentAlertController: UIAlertController?
    private var isActionResult = false
    private var maskType: MaskType?
    private var systemSetting: SystemSetting! = SystemSetting.shared()
    private var isEdite: Int = 0
    private var offsetValue: Int = 0
    private var powerGainPickerData: [String] = []
    var maskValue = ""
    private lazy var bankPickerData: [String] = {
        return dataBank
    }()
    private lazy var offsetPickerData: [String] = {
        var tmpArray: [String] = []
        for offset in wordData {
            tmpArray.append("\(offset) WORD")
        }
        return tmpArray
    }()
    private lazy var bitData: [String] = {
        return dataBit
    }()
    private lazy var wordData: [String] = {
        return dataWord
    }()
    override func viewDidLoad() {
        super.viewDidLoad()
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        if asReaderGUNManager.mReader == nil {
            return
        }
        initPowerGainPickerData()
        asReaderGUNManager.mReader?.continuousMode = false
        maskType = (asReaderGUNManager?.mReader?.maskTypeValue).map { MaskType(rawValue: MaskType.RawValue($0)) }
        if  !maskValue.isEmpty {
            asReaderGUNManager.initMask(maskValue, maskType: MaskType_Selection)
        }
        isActionResult = false
        if let powerGain =  asReaderGUNManager.mReader?.powerGain {
            let nPower = powerGain
            setPowerGain((Int(nPower / 10)))
        }
        if let operationTime = asReaderGUNManager.mReader?.operationTime {
            setOperationTime("\(operationTime)")
        }
        setBank(1)
        setOffset(2)
        if let isReportRSSI = asReaderGUNManager.mReader?.rssiMode {
            setReportRssiModeEnabled(isReportRSSI)
        }
        pickerView.reloadAllComponents()
        if  !maskValue.isEmpty {
            selectionTagLabel.text = maskValue
            maskBtn.isEnabled = false
        }
    }
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        if  !maskValue.isEmpty {
            asReaderGUNManager.exitMask()
        }
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    @IBAction func writeBtnTapped(_ sender: UIButton) {
        DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
            self.writeAction()
        }
    }
    @IBAction func blockWriteBtnTapped(_ sender: UIButton) {
        isActionResult = false
        messageLabel.text = "Block writing tag memory.\nPlease wait…"
        if let operationTimeText =  operationTimeTextField.text {
            asReaderGUNManager.mReader?.operationTime = Int32(operationTimeText) ?? 0
            systemSetting.setOperationTime(Int(operationTimeText) ?? 0)
        }
        
        guard let bankText = bankTextField.text,
            let row = bankPickerData.firstIndex(of: bankText) else {
                return
        }
        let bank: MemoryBank = MemoryBank(rawValue: MemoryBank.RawValue(row))
        asReaderGUNManager.mReader?.blockWrite(bank, offset: Int32(offsetValue), value: writeDataTextField.text)
        
    }
    @IBAction func clearBtnTapped(_ sender: UIButton) {
        selectionTagLabel.text = "Result"
        messageLabel.text = msgTagWait
        rssiLabel.text = "0.0 dB"
        phaseLabel.text = "0.0˚"
    }
    @IBAction func maskBtnTapped(_ sender: UIButton) {
        if maskType == MaskType_Selection {
            performSegue(withIdentifier: "SelectionMask", sender: self)
        } else {
            currentAlertController?.dismiss(animated: true, completion: nil)
            currentAlertController = UIAlertController(title: "",
                                                       message: "Please choosing the Selection Mask type in the RFID Option menu.",
                                                       preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
            currentAlertController?.addAction(okAction)
            guard let aleart = currentAlertController else {
                return
            }
            present(aleart, animated: true, completion: nil)
            return
        }
    }
    @IBAction func bankBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewBank.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        bankPickerTopView.isHidden = false
        if let text =  bankTextField.text {
            if !text.isEmpty {
                if let row = bankPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func offsetBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewOffset.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        offsetPickerTopView.isHidden = false
        if let text =  offsetTextField.text {
            if !text.isEmpty {
                if let row = offsetPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func writeDataBtnTapped(_ sender: UIButton) {
        isEdite = textFieldWriteData
        let alertController = UIAlertController(title: "Write Data:", message: "Please enter write data.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .alphabet
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            let text = alertController.textFields?.first?.text
            self.setWriteData(text)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func passwordBtnTapped(_ sender: UIButton) {
        isEdite = textFieldWritePassword
        let alertController = UIAlertController(title: "Password:", message: "Please enter password.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .alphabet
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            let value = alertController.textFields?.first?.text
            self.setPassword(value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func powerGainBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewPowerGain.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        powerGainPickerTopView.isHidden = false
        if let text = powerGainTextField.text {
            if !text.isEmpty {
                if let row = powerGainPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func operationTimeBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Operation Time:", message: "Please enter operation time.\n(ex: 30 ms)", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .alphabet
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var text = alertController.textFields?.first?.text
            guard let value = text else {
                return
            }
            if value.isEmpty {
                text = "0"
            }
            if let aText = text {
                self.setOperationTime(aText)
                self.asReaderGUNManager.mReader?.operationTime = Int32(aText) ?? 0
                self.systemSetting.setOperationTime(Int(aText) ?? 0)
            }
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func reportRssiSwitchTapped(_ sender: UISwitch) {
        asReaderGUNManager.mReader?.rssiMode = reportRssiSwitch.isOn
        systemSetting.setRssiMode(reportRssiSwitch.isOn)
        setReportRssiModeEnabled(reportRssiSwitch.isOn)
    }
    @IBAction func pickerCloseBtnTapped(_ sender: UIButton) {
        hidePickerView()
    }
    @IBAction func bankPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setBank(idx)
        hidePickerView()
    }
    @IBAction func offsetPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setOffset(idx)
        hidePickerView()
    }
    @IBAction func powerGainPickerOkBtnTapped(_ sender: UIButton) {
        var idx: Int32 = Int32(pickerView.selectedRow(inComponent: 0))
        if let min = asReaderGUNManager.mReader?.powerGainRange().min {
            idx += (min / 10)
        }
        setPowerGain(Int(idx))
        asReaderGUNManager.mReader?.powerGain = idx * 10
        systemSetting.setPowerGain(Int(idx * 10))
        hidePickerView()
    }
    @IBAction func prepare(forUnwind segue: UIStoryboardSegue) {
    }
}

// MARK: - UITextFieldDelegate
extension WriteMemoryViewController: UITextFieldDelegate {
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let text = textField.text ?? ""
        let length = text.count + string.count - range.length
        if isEdite == textFieldWritePassword {
            if length > maxPasswordLength {
                return false
            }
        } else if isEdite == textFieldWriteData {
            if length > maxWriteDataLength {
                return false
            }
        }
        if string.isEmpty {
            return true
        }
        if "0123456789ABCDEFabcdef" .contains(string) {
            let newString = (textField.text as NSString?)?.replacingCharacters(in: range, with: string)
            textField.text = newString?.uppercased()
            return false
        }
        return false
    }
}
// MARK: - UIPickerViewDelegate, UIPickerViewDataSource
extension WriteMemoryViewController: UIPickerViewDelegate, UIPickerViewDataSource {
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewBank {
                return bankPickerData.count
            } else if pickerViewTag == .pickerViewOffset {
                return bitData.count
            } else if pickerViewTag == .pickerViewPowerGain {
                return powerGainPickerData.count
            }
        }
        return 0
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewBank {
                return bankPickerData[row]
            } else if pickerViewTag == .pickerViewOffset {
                return offsetPickerData[row]
            } else if pickerViewTag == .pickerViewPowerGain {
                return powerGainPickerData[row]
            }
        }
        return "None"
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension WriteMemoryViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == true {
            DispatchQueue.main.async {
                self.viewDidAppear(true)
            }
        } else {
            DispatchQueue.main.async {
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        if status == true {
            let button: UIButton = UIButton.init()
            self.writeBtnTapped(button)
        }
        return false
    }
    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNUpdateDeviceState(_ error: ResultCode) {
        if error != ResultNoError {
            DispatchQueue.main.async {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                self.currentAlertController = UIAlertController(title: "Error",
                                                                message: "Failed to get response. Try again.",
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
                    self.navigationController?.popViewController(animated: true)
                })
                self.currentAlertController?.addAction(okAction)
                guard let aleart = self.currentAlertController else {
                    return
                }
                self.present(aleart, animated: true, completion: nil)
            }
        }
    }
    func asReaderGUNChangedActionState(_ action: CommandType, resultCode: Int) {
        if action == CommandStop {
            DispatchQueue.main.async {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                if !self.isActionResult {
                    self.messageLabel.text = msgTagWait
                }
            }
        }
    }
    func asReaderGUNAccessResult(_ error: ResultCode, actionState action: CommandType, epc: String?, data: String?, rssi: Float, phase: Float, frequency: Float) {
        isActionResult = true
        DispatchQueue.main.async {
            if error != ResultNoError {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                self.messageLabel.text = AsResultCode.msg(error)
                self.currentAlertController = UIAlertController(title: "Error",
                                                                message: AsResultCode.msg(error),
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                self.currentAlertController?.addAction(okAction)
                guard let aleart = self.currentAlertController else {
                    return
                }
                self.present(aleart, animated: true, completion: nil)
                return
            }
            self.messageLabel.text = "Success"
            self.selectionTagLabel.text = epc
            if !self.reportRssiSwitch.isOn {
                self.setReportRssiModeDefault()
            } else {
                self.rssiLabel.text = String(format: "%.1f dB", rssi)
                self.phaseLabel.text = String(format: "%.1f˚", phase)
            }
            self.currentAlertController?.dismiss(animated: true, completion: nil)
        }
    }
}
// MARK: - Custom
extension WriteMemoryViewController {
    func initPowerGainPickerData() {
        var tmpArray: [String] = []
        if let min = asReaderGUNManager.mReader?.powerGainRange().min, let max = asReaderGUNManager.mReader?.powerGainRange().max {
            var value = min
            while value <= max {
                tmpArray.append(String(format: "%i.0 dB", value / 10))
                value += 10
            }
        }
        powerGainPickerData = tmpArray
    }
    func hidePickerView() {
        bankPickerTopView.isHidden = true
        offsetPickerTopView.isHidden = true
        powerGainPickerTopView.isHidden = true
        pickerView.isHidden = true
    }
    func stopAction() {
        asReaderGUNManager.mReader?.stop()
    }
    func writeAction() {
        isActionResult = false
        currentAlertController?.dismiss(animated: true, completion: nil)
        if let text =  writeDataTextField.text {
            if Int(text.count) % 4 != 0 || Int(text.count) == 0 {
                currentAlertController = UIAlertController(title: "Error",
                                                           message: "Write Data must be entered in WORD unit.(1WORD = 16-bit)",
                                                           preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                currentAlertController?.addAction(okAction)
                guard let aleart = currentAlertController else {
                    return
                }
                present(aleart, animated: true, completion: nil)
                return
            }
            if text.count / 4 > 32 {
                currentAlertController = UIAlertController(title: "Error",
                                                           message: "Write Data cannot be exceed 32WORD.(1WORD = 16-bit)",
                                                           preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                currentAlertController?.addAction(okAction)
                guard let aleart = currentAlertController else {
                    return
                }
                present(aleart, animated: true, completion: nil)
                return
            }
        }
        messageLabel.text = "Writing tag memory.\nPlease wait…"
        if let operationTimeText = operationTimeTextField.text {
            asReaderGUNManager.mReader?.operationTime = Int32(operationTimeText) ?? 0
            systemSetting.setOperationTime(Int(operationTimeText) ?? 0)
        }
        let password = passwordTextField.text
        asReaderGUNManager.mReader?.accessPassword = password
        if let bankText = bankTextField.text {
            if let row = bankPickerData.firstIndex(of: bankText) {
                let bank: MemoryBank = MemoryBank(rawValue: MemoryBank.RawValue(row))
                asReaderGUNManager.mReader?.writeMemory(bank, offset: Int32(offsetValue), value: writeDataTextField.text)
            }
        }
      
        currentAlertController = UIAlertController(title: "Please wait...",
                                                   message: "Writing tag memory",
                                                   preferredStyle: .alert)
        let okAction = UIAlertAction(title: "Stop", style: .default, handler: { _ in
            self.stopAction()
        })
        currentAlertController?.addAction(okAction)
        guard let aleart = currentAlertController else {
            return
        }
        present(aleart, animated: true, completion: nil)
    }
}
// MARK: - Setters
extension  WriteMemoryViewController {
    func setBank(_ index: Int) {
        bankTextField.text = bankPickerData[index]
    }
    func setOffset(_ index: Int) {
        offsetTextField.text = offsetPickerData[index]
        offsetValue = index
    }
    func setWriteData(_ writeData: String?) {
        writeDataTextField.text = writeData
    }
    func setPassword(_ password: String?) {
        passwordTextField.text = password
    }
    func setPowerGain(_ power: Int) {
        let value = String(format: "%i.0 dB", power)
        if powerGainPickerData.contains(value) {
            let index: Int = powerGainPickerData.firstIndex(of: value) ?? 0
            if powerGainPickerData.count > index {
                powerGainTextField.text = powerGainPickerData[index]
            }
        }
    }
    func setOperationTime(_ operationTime: String?) {
        operationTimeTextField.text = operationTime
    }
    func setReportRssiModeEnabled(_ enabled: Bool) {
        for elem in reportRssiCollection {
            elem.isEnabled = enabled
        }
        if !enabled {
            setReportRssiModeDefault()
        }
        reportRssiSwitch.isOn = enabled
    }
    func setReportRssiModeDefault() {
        rssiLabel.text = String(format: "%.1f dB", 0.0)
        phaseLabel.text = String(format: "%.1f˚", 0.0)
    }
}
