//
//  SelectionMaskViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/10.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class SelectionMaskViewController: UIViewController {
    @IBOutlet private weak var tableView: UITableView!
    @IBOutlet private weak var selectFlagTextField: UITextField!
    @IBOutlet private weak var inventorySessionTextField: UITextField!
    @IBOutlet private weak var sessionFlagTextField: UITextField!
    @IBOutlet private weak var pickerView: UIPickerView!
    @IBOutlet private weak var saveBtn: UIButton!
    @IBOutlet private weak var cancelBtn: UIButton!
    @IBOutlet private weak var selectFlagPickerTopView: UIView!
    @IBOutlet private weak var inventorySessionPickerTopView: UIView!
    @IBOutlet private weak var sessionFlagPickerTopView: UIView!
    @IBOutlet private weak var addBarButtonItem: UIBarButtonItem!
    private enum PickerViewTag: Int {
        case pickerViewInventorySession = 0
        case pickerViewSessionFlag = 1
        case pickerViewSelectFlag = 2
    }
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var isEditCell = false
    private var systemSetting: SystemSetting = SystemSetting.shared()
    private var inventorySession: SessionType?
    private var sessionFlag: SessionFlag?
    private var maskData: [AsSelectMaskParam] = []
    private var selectFlag: SelectFlag?
    private lazy var selectFlagPickerData: [String] = {
        return dataSelectFlag
    }()
    private lazy var inventorySessionPickerData: [String] = {
        return dataInvenTorySession
    }()
    private lazy var sessionFlagPickerData: [String] = {
        return dataSessionFlag
    }()
    override func viewDidLoad() {
        super.viewDidLoad()
        enableActionWidgets(false)
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: loading)
        if asReaderGUNManager.mReader == nil {
            AsReaderGUNManager.dismissGlobalHUD()
            return
        }
        initLoadMask()
        AsReaderGUNManager.dismissGlobalHUD()
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
        isEditCell = false
    }
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == "SelectionMaskCell" {
            let editVC = segue.destination as? SelectionMaskEditViewController
            var indexPath: IndexPath?
            if let aSender = sender as? UITableViewCell {
                indexPath = tableView.indexPath(for: aSender)
            }
            if let index = indexPath?.row {
                editVC?.selectMaskParam = maskData[index]
            }
            isEditCell = true
        }
    }
    @IBAction func prepare(forUnwind segue: UIStoryboardSegue) {
        let sourceVC = segue.source as? SelectionMaskEditViewController
        if !isEditCell {
            if let aParam = sourceVC?.selectMaskParam {
                maskData.append(aParam)
            }
        }
        tableView.reloadData()
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    @IBAction func saveBtnTapped(_ sender: UIButton) {
        enableActionWidgets(false)
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Saving...")
        var param: AsSelectMaskParam?
        for index in MIN_SELECTION_MASK..<MAX_SELECTION_MASK {
            if index < maskData.count {
                param = maskData[Int(index)]
                asReaderGUNManager.mReader?.setSelectionMask(index, with: param)
            } else {
                asReaderGUNManager.mReader?.removeSelectionMask(index)
            }
        }
        if Int(maskData.count) > 0 {
            if let currentFlag = selectFlag {
                let selectFlag: SelectFlag = SelectFlag(UInt32(currentFlag.rawValue + 1))
                let selectIndex: Int32 = Int32(currentFlag.rawValue + 1)
                asReaderGUNManager.mReader?.useSelectionMask = selectFlag
                systemSetting.setUseSelectionMask(Int(selectIndex))
            }
        } else {
            asReaderGUNManager.mReader?.clearSelectionMask()
        }
        if let aInventorySession = inventorySession {
            asReaderGUNManager.mReader?.inventorySession = aInventorySession
            systemSetting.setInventorySession(Int(aInventorySession.rawValue))
        }
        if let aSessionFlag = sessionFlag {
            asReaderGUNManager.mReader?.sessionFlag = aSessionFlag
            systemSetting.setSessionFlag(Int(aSessionFlag.rawValue))
        }
        systemSetting.setEpcMaskData(maskData)
        enableActionWidgets(true)
        AsReaderGUNManager.dismissGlobalHUD()
        let alertController = UIAlertController(title: "Success",
                                                message: "Saved successfully",
                                                preferredStyle: .alert)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            self.navigationController?.popViewController(animated: true)
        })
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func selectFlagBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewSelectFlag.rawValue
        pickerView.reloadAllComponents()
        pickerView.selectRow(Int(selectFlag?.rawValue ?? 0), inComponent: 0, animated: false)
        pickerView.isHidden = false
        selectFlagPickerTopView.isHidden = false
    }
    @IBAction func inventorySessionBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewInventorySession.rawValue
        pickerView.reloadAllComponents()
        pickerView.selectRow(Int(inventorySession?.rawValue ?? 0), inComponent: 0, animated: false)
        pickerView.isHidden = false
        inventorySessionPickerTopView.isHidden = false
    }
    @IBAction func sessionFlagBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewSessionFlag.rawValue
        pickerView.reloadAllComponents()
        pickerView.selectRow(Int(sessionFlag?.rawValue ?? 0), inComponent: 0, animated: false)
        pickerView.isHidden = false
        sessionFlagPickerTopView.isHidden = false
    }
    @IBAction func selectFlagPickerOkBtnTapped(_ sender: UIButton) {
        setSelectFlag(SelectFlag(rawValue: SelectFlag.RawValue(pickerView.selectedRow(inComponent: 0))))
        hidePickerView()
    }
    @IBAction func inventorySessionPickerOkBtnTapped(_ sender: UIButton) {
        setInventorySession(SessionType(rawValue: SessionType.RawValue(pickerView.selectedRow(inComponent: 0))))
        hidePickerView()
    }
    @IBAction func sessionFlagPickerOkBtnTapped(_ sender: UIButton) {
        setSessionFlag(SessionFlag(rawValue: SessionFlag.RawValue(pickerView.selectedRow(inComponent: 0))))
        sessionFlag = SessionFlag(rawValue: SessionFlag.RawValue(pickerView.selectedRow(inComponent: 0)))
        hidePickerView()
    }
    @IBAction func pickerCloseBtnTapped(_ sender: UIButton) {
        hidePickerView()
    }
}
// MARK: - UITableViewDataSource, UITableViewDelegate
extension SelectionMaskViewController: UITableViewDataSource, UITableViewDelegate {
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return maskData.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "SelectionMaskCell",
                                                 for: indexPath) as? SelectionMaskTableViewCell
        let maskParam = maskData[indexPath.row]
        cell?.setTargetValue(dataTarget[Int((maskParam.target).rawValue)])
        cell?.setActionValue(AsMaskActionType.toString(maskParam.action, targetType: maskParam.target))
        cell?.setBankValue(dataBank[Int((maskParam.bank).rawValue)])
        cell?.setOffsetValue("\(maskParam.offset) bit")
        cell?.setLengthValue("\(maskParam.length) bit")
        cell?.setMaskValue(maskParam.mask)
        guard let aCell = cell else {
            return UITableViewCell()
        }
        return aCell
    }
    func tableView(_ tableView: UITableView, editingStyleForRowAt indexPath: IndexPath) -> UITableViewCell.EditingStyle {
        return .delete
    }
    func tableView(_ tableView: UITableView, commit editingStyle: UITableViewCell.EditingStyle, forRowAt indexPath: IndexPath) {
        maskData.remove(at: indexPath.row)
        tableView.reloadData()
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension SelectionMaskViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == true {
            DispatchQueue.main.async {
                self.viewDidAppear(true)
            }
        } else {
            DispatchQueue.main.async {
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        return false
    }
    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
}
extension SelectionMaskViewController {
    // MARK: - Custom
    func initLoadMask() {
        var param: AsSelectMaskParam?
        for index in MIN_SELECTION_MASK..<MAX_SELECTION_MASK {
            if let result = asReaderGUNManager.mReader?.usedSelectionMask(index) {
                if !result {
                    break
                }
            }
            param = asReaderGUNManager.mReader?.getSelectionMask(index)
            if let aParam = param {
                maskData.append(aParam)
            }
        }
        tableView.reloadData()
        if var selectFlagA: SelectFlag = asReaderGUNManager.mReader?.useSelectionMask {
            if selectFlagA == SelectFlag_NotUsed {
                selectFlagA = SelectFlag_SL
            }
            selectFlag = SelectFlag(selectFlagA.rawValue - 1)
        }

        setSelectFlag(selectFlag!)

        if let inventorySession = asReaderGUNManager.mReader?.inventorySession {
            setInventorySession(inventorySession)
        }
        if let sessionFlag = asReaderGUNManager.mReader?.sessionFlag {
            setSessionFlag(sessionFlag)
        }
        enableActionWidgets(true)
    }
    func hidePickerView() {
        pickerView.isHidden = true
        selectFlagPickerTopView.isHidden = true
        inventorySessionPickerTopView.isHidden = true
        sessionFlagPickerTopView.isHidden = true
    }
    func enableActionWidgets(_ enabled: Bool) {
        let count = Int(maskData.count)
        addBarButtonItem.isEnabled = enabled && count < MAX_SELECTION_MASK
        saveBtn.isEnabled = enabled
        cancelBtn.isEnabled = enabled
    }
}
// MARK: - Setters
extension SelectionMaskViewController {
    func setSelectFlag(_ selectFlag: SelectFlag) {
        let selectIndex: Int = Int(selectFlag.rawValue)
        selectFlagTextField.text = selectFlagPickerData[selectIndex]
        self.selectFlag = selectFlag
    }
    func setInventorySession(_ inventorySession: SessionType) {
        let selectIndex: Int = Int(inventorySession.rawValue)
        inventorySessionTextField.text = inventorySessionPickerData[selectIndex]
        self.inventorySession = inventorySession
    }
    func setSessionFlag(_ sessionFlag: SessionFlag) {
        let selectIndex: Int = Int(sessionFlag.rawValue)
        sessionFlagTextField.text = sessionFlagPickerData[selectIndex]
        self.sessionFlag = sessionFlag
    }
}
// MARK: - UIPickerViewDelegate, UIPickerViewDataSource
extension SelectionMaskViewController: UIPickerViewDelegate, UIPickerViewDataSource {
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewSelectFlag {
                return selectFlagPickerData.count
            } else if pickerViewTag == .pickerViewInventorySession {
                return inventorySessionPickerData.count
            } else if pickerViewTag == .pickerViewSessionFlag {
                return sessionFlagPickerData.count
            }
        }
        return 0
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewSelectFlag {
                return selectFlagPickerData[row]
            } else if pickerViewTag == .pickerViewInventorySession {
                return inventorySessionPickerData[row]
            } else if pickerViewTag == .pickerViewSessionFlag {
                return sessionFlagPickerData[row]
            }
        }
        return "None"
    }
}
