//
//  ReadMemoryViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/6.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class ReadMemoryViewController: UIViewController {
    @IBOutlet private weak var selectionTagLabel: UILabel!
    @IBOutlet private weak var messageLabel: UILabel!
    @IBOutlet private weak var address1Label: UILabel!
    @IBOutlet private weak var address2Label: UILabel!
    @IBOutlet private weak var address3Label: UILabel!
    @IBOutlet private weak var address4Label: UILabel!
    @IBOutlet private weak var address5Label: UILabel!
    @IBOutlet private weak var address6Label: UILabel!
    @IBOutlet private weak var address7Label: UILabel!
    @IBOutlet private weak var address8Label: UILabel!
    @IBOutlet private weak var value1Label: UILabel!
    @IBOutlet private weak var value2Label: UILabel!
    @IBOutlet private weak var value3Label: UILabel!
    @IBOutlet private weak var value4Label: UILabel!
    @IBOutlet private weak var value5Label: UILabel!
    @IBOutlet private weak var value6Label: UILabel!
    @IBOutlet private weak var value7Label: UILabel!
    @IBOutlet private weak var value8Label: UILabel!
    @IBOutlet private weak var bankTextField: UITextField!
    @IBOutlet private weak var offsetTextField: UITextField!
    @IBOutlet private weak var lengthTextField: UITextField!
    @IBOutlet private weak var passwordTextField: UITextField!
    @IBOutlet private weak var powerGainTextField: UITextField!
    @IBOutlet private weak var operationTimeTextField: UITextField!
    @IBOutlet private weak var readBtn: UIButton!
    @IBOutlet private weak var blockEraseBtn: UIButton!
    @IBOutlet private weak var clearBtn: UIButton!
    @IBOutlet private weak var maskBtn: UIButton!
    @IBOutlet private weak var pickerView: UIPickerView!
    @IBOutlet private weak var bankPickerTopView: UIView!
    @IBOutlet private weak var offsetPickerTopView: UIView!
    @IBOutlet private weak var lengthPickerTopView: UIView!
    @IBOutlet private weak var powerGainPickerTopView: UIView!
    @IBOutlet private weak var rssiLabel: UILabel!
    @IBOutlet private weak var phaseLabel: UILabel!
    @IBOutlet private weak var reportRssiSwitch: UISwitch!
    @IBOutlet private var reportRssiCollection: [UILabel]!
    private enum PickerViewTag: Int {
        case pickerViewBank = 0
        case pickerViewOffset = 1
        case pickerViewLength = 2
        case pickerViewPowerGain = 3
    }
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var currentAlertController: UIAlertController?
    private var isActionResult = false
    private var maskType: MaskType?
    private var systemSetting: SystemSetting! = SystemSetting.shared()
    var maskValue: String? = ""
    private var offsetValue: Int = 0
    private var lengthValue: Int = 0
    private var powerGainPickerData: [String] = []
    private lazy var bankPickerData: [String] = {
        return dataBank
    }()
    private lazy var offsetPickerData: [String] = {
        var tmpArray: [String] = []
        for offset in wordData {
            tmpArray.append("\(offset) WORD")
        }
        return tmpArray
    }()
    private lazy var lengthPickerData: [String] = {
        var tmpArray: [String] = []
        for offset in wordData {
            tmpArray.append("\(offset) WORD")
        }
        return tmpArray
    }()
    private lazy var bitData: [String] = {
        return dataBit
    }()
    private lazy var wordData: [String] = {
        return dataWord
    }()
    override func viewDidLoad() {
        super.viewDidLoad()
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        if asReaderGUNManager.mReader == nil {
            return
        }
        initPowerGainPickerData()
        let powerGain: Int32 = (asReaderGUNManager.mReader?.powerGain)!
        setPowerGain((Int(powerGain / 10)))

        asReaderGUNManager.mReader?.continuousMode = false
        maskType = (asReaderGUNManager?.mReader?.maskTypeValue).map { MaskType(rawValue: MaskType.RawValue($0)) }
        
        isActionResult = false
        let operationTime = asReaderGUNManager.mReader?.operationTime ?? 0
        setOperationTime("\(operationTime)")
        setBank(1)
        setOffset(2)
        setLength(2)
        let isReportRSSI: Bool = asReaderGUNManager.mReader?.rssiMode ?? false
        setReportRssiModeEnabled(isReportRSSI)

        pickerView.reloadAllComponents()
        
        guard let nowMaskValue = maskValue else {
            return
        }
        guard nowMaskValue.isEmpty else {
            asReaderGUNManager?.initMask(nowMaskValue, maskType: MaskType_Selection)
            selectionTagLabel.text = maskValue
            maskBtn.isEnabled = false
            return
        }
    }
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        guard let nowMaskValue = maskValue else {
            return
        }
        guard nowMaskValue.isEmpty else {
            asReaderGUNManager.exitMask()
            return
        }
    }
    // MARK: - Storyboard Segue
    @IBAction func prepare(forUnwind segue: UIStoryboardSegue) {
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    @IBAction func bankBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewBank.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        bankPickerTopView.isHidden = false
        if let text = bankTextField.text {
            if !text.isEmpty {
                if let row = bankPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func offsetBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewOffset.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        offsetPickerTopView.isHidden = false
        if let text = offsetTextField.text {
            if !text.isEmpty {
                if let row = offsetPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func lengthBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewLength.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        lengthPickerTopView.isHidden = false
        if let text = lengthTextField.text {
            if !text.isEmpty {
                if let row = lengthPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func passwordBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Password:", message: "Please enter password.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .alphabet
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            let text: String = alertController.textFields?.first?.text ?? ""
            self.setPassword(text)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func powerGainBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewPowerGain.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        powerGainPickerTopView.isHidden = false
        if let text = powerGainTextField.text {
            if !text.isEmpty {
                if let row = powerGainPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func operationTimeBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Operation Time:", message: "Please enter operation time.\n(ex: 30 ms)", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var value = alertController.textFields?.first?.text
            guard let text = value else {
                return
            }
            if text.isEmpty {
                value = "0"
            }
            if let aValue = value {
                self.setOperationTime(aValue)
                self.asReaderGUNManager.mReader?.operationTime = Int32(aValue) ?? 0
                self.systemSetting.setOperationTime(Int(aValue) ?? 0)
            }
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func reportRssiSwitchTapped(_ sender: UISwitch) {
        asReaderGUNManager.mReader?.rssiMode = reportRssiSwitch.isOn
        systemSetting.setRssiMode(reportRssiSwitch.isOn)
        setReportRssiModeEnabled(reportRssiSwitch.isOn)
    }
    @IBAction func readBtnTapped(_ sender: UIButton) {
        DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
            self.readAction()
        }
    }
    @IBAction func blockEraseBtnTapped(_ sender: UIButton) {
        isActionResult = false
        messageLabel.text = "Erasing tag memory.\nPlease wait…"
        if let operationTime = operationTimeTextField.text {
            asReaderGUNManager.mReader?.operationTime = Int32(operationTime) ?? 0
            systemSetting.setOperationTime(Int(operationTime) ?? 0)
        }
        if let text = bankTextField.text {
            if let row = bankPickerData.firstIndex(of: text) {
                let bank: MemoryBank = MemoryBank(rawValue: MemoryBank.RawValue(row))
                asReaderGUNManager.mReader?.blockErase(bank, offset: Int32(offsetValue), length: Int32(lengthValue))
            }
        }
        clearBtnTapped(sender)
    }
    @IBAction func clearBtnTapped(_ sender: UIButton) {
        selectionTagLabel.text = "Result"
        messageLabel.text = msgTagWait
        address1Label.text = "0 WORD"
        address2Label.text = "1 WORD"
        address3Label.text = "2 WORD"
        address4Label.text = "3 WORD"
        address5Label.text = "4 WORD"
        address6Label.text = "5 WORD"
        address7Label.text = "6 WORD"
        address8Label.text = "7 WORD"
        value1Label.text = "0000"
        value2Label.text = "0000"
        value3Label.text = "0000"
        value4Label.text = "0000"
        value5Label.text = "0000"
        value6Label.text = "0000"
        value7Label.text = "0000"
        value8Label.text = "0000"
        rssiLabel.text = "0.0 dB"
        phaseLabel.text = "0.0˚"
    }
    @IBAction func maskBtnTapped(_ sender: UIButton) {
        if maskType == MaskType_Selection {
            performSegue(withIdentifier: "SelectionMask", sender: self)
        } else {
            currentAlertController = UIAlertController(title: "",
                                                       message: "Please choosing the Selection Mask type in the RFID Option menu.",
                                                       preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
            currentAlertController?.addAction(okAction)
            guard let aleart = currentAlertController else {
                return
            }
            present(aleart, animated: true, completion: nil)
            return
        }
    }
    @IBAction func pickerCloseBtnTapped(_ sender: UIButton) {
        hidePickerView()
    }
    @IBAction func bankPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setBank(idx)
        hidePickerView()
    }
    @IBAction func offsetPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setOffset(idx)
        hidePickerView()
    }
    @IBAction func lengthPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setLength(idx)
        hidePickerView()
    }
    @IBAction func powerGainPickerOkBtnTapped(_ sender: UIButton) {
        var idx: Int32 = Int32(pickerView.selectedRow(inComponent: 0))
        let min = (asReaderGUNManager.mReader?.powerGainRange().min)!
        idx += (min / 10)
        setPowerGain(Int(idx))
        asReaderGUNManager.mReader?.powerGain = idx * 10
        systemSetting.setPowerGain(Int(idx * 10))
        hidePickerView()
    }
}
// MARK: - UIPickerViewDataSource, UIPickerViewDelegate
extension ReadMemoryViewController: UIPickerViewDataSource, UIPickerViewDelegate {
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewBank {
                return bankPickerData.count
            } else if pickerViewTag == .pickerViewOffset {
                return bitData.count
            } else if pickerViewTag == .pickerViewLength {
                return lengthPickerData.count
            } else if pickerViewTag == .pickerViewPowerGain {
                return powerGainPickerData.count
            }
        }
        return 0
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewBank {
                return bankPickerData[row]
            } else if pickerViewTag == .pickerViewOffset {
                return offsetPickerData[row]
            } else if pickerViewTag == .pickerViewLength {
                return lengthPickerData[row]
            } else if pickerViewTag == .pickerViewPowerGain {
                return powerGainPickerData[row]
            }
        }
        return "None"
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension ReadMemoryViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == true {
            DispatchQueue.main.async {
                self.viewDidAppear(true)
            }
        } else {
            DispatchQueue.main.async {
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        if status == true {
            DispatchQueue.main.async {
                self.readAction()
            }
        }
        return false
    }
    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNUpdateDeviceState(_ error: ResultCode) {
        if error != ResultNoError {
            DispatchQueue.main.async {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                self.currentAlertController = UIAlertController(title: "Error",
                                                                message: "Failed to get response. Try again.",
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
                    self.navigationController?.popViewController(animated: true)
                })
                self.currentAlertController?.addAction(okAction)
                guard let aleart = self.currentAlertController else {
                    return
                }
                self.present(aleart, animated: true, completion: nil)
            }
        }
    }
    func asReaderGUNReadTag(_ tag: String?, rssi: Float, phase: Float, frequency: Float) {
        if let aTag = tag {
            print("RMV - Read Tag: \(aTag)")
        }
    }
    func asReaderGUNChangedActionState(_ action: CommandType, resultCode: Int) {
        if action == CommandStop {
            DispatchQueue.main.async {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                if !self.isActionResult {
                    self.messageLabel.text = msgTagWait
                }
            }
        }
    }
    func asReaderGUNAccessResult(_ error: ResultCode, actionState action: CommandType, epc: String?, data: String?, rssi: Float, phase: Float, frequency: Float) {
        isActionResult = true
        DispatchQueue.main.async {
            if error != ResultNoError {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                self.messageLabel.text = AsResultCode.msg(error)
                self.currentAlertController = UIAlertController(title: "Error",
                                                                message: AsResultCode.msg(error),
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                self.currentAlertController?.addAction(okAction)
                guard let aleart = self.currentAlertController else {
                    return
                }
                self.present(aleart, animated: true, completion: nil)
                return
            }
            
            self.messageLabel.text = "Success"
            self.selectionTagLabel.text = epc
            self.address1Label.text = "\(Int(self.offsetValue)) WORD"
            self.address2Label.text = "\(Int(self.offsetValue + 1)) WORD"
            self.address3Label.text = "\(Int(self.offsetValue + 2)) WORD"
            self.address4Label.text = "\(Int(self.offsetValue + 3)) WORD"
            self.address5Label.text = "\(Int(self.offsetValue + 4)) WORD"
            self.address6Label.text = "\(Int(self.offsetValue + 5)) WORD"
            self.address7Label.text = "\(Int(self.offsetValue + 6)) WORD"
            self.address8Label.text = "\(Int(self.offsetValue + 7)) WORD"
            if let bitArr = data?.components(separatedBy: ",") {
                let bitArrCount = bitArr.count
                if bitArrCount >= 1 {
                    self.value1Label.text = bitArr[0]
                } else {
                    self.value1Label.text = "0000"
                }
                if bitArrCount >= 2 {
                    self.value2Label.text = bitArr[1]
                } else {
                    self.value2Label.text = "0000"
                }
                if bitArrCount >= 3 {
                    self.value3Label.text = bitArr[2]
                } else {
                    self.value3Label.text = "0000"
                }
                if bitArrCount >= 4 {
                    self.value4Label.text = bitArr[3]
                } else {
                    self.value4Label.text = "0000"
                }
                if bitArrCount >= 5 {
                    self.value5Label.text = bitArr[4]
                } else {
                    self.value5Label.text = "0000"
                }
                if bitArrCount >= 6 {
                    self.value6Label.text = bitArr[5]
                } else {
                    self.value6Label.text = "0000"
                }
                if bitArrCount >= 7 {
                    self.value7Label.text = bitArr[6]
                } else {
                    self.value7Label.text = "0000"
                }
                if bitArrCount >= 8 {
                    self.value8Label.text = bitArr[7]
                } else {
                    self.value8Label.text = "0000"
                }
            }
            if !self.reportRssiSwitch.isOn {
                self.setReportRssiModeDefault()
            } else {
                self.rssiLabel.text = String(format: "%.1f dB", rssi)
                self.phaseLabel.text = String(format: "%.1f˚", phase)
            }
            self.currentAlertController?.dismiss(animated: true, completion: nil)
        }
    }
}
// MARK: - UITextFieldDelegate
extension ReadMemoryViewController: UITextFieldDelegate {
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let text = textField.text ?? ""
        let length = text.count + string.count - range.length
        if length > maxPasswordLength {
            return false
        }
        if string.isEmpty {
            return true
        }
        if "0123456789ABCDEFabcdef" .contains(string) {
            let newString = (textField.text as NSString?)?.replacingCharacters(in: range, with: string)
            textField.text = newString?.uppercased()
        }
        return false
    }
}
// MARK: - Custom
extension ReadMemoryViewController {
    private func initPowerGainPickerData() {
        var tmpArray: [String] = []
        if let min = asReaderGUNManager.mReader?.powerGainRange().min,
            let max = asReaderGUNManager.mReader?.powerGainRange().max {
            var index = min
            while index <= max {
                tmpArray.append(String(format: "%i.0 dB", index / 10))
                index += 10
            }
        }
        powerGainPickerData = tmpArray
    }
    private func hidePickerView() {
        bankPickerTopView.isHidden = true
        offsetPickerTopView.isHidden = true
        lengthPickerTopView.isHidden = true
        powerGainPickerTopView.isHidden = true
        pickerView.isHidden = true
    }
    private func readAction() {
        isActionResult = false
        messageLabel.text = "Reading tag memory.\nPlease wait…"
        if let operationTime = operationTimeTextField.text {
            asReaderGUNManager.mReader?.operationTime = Int32(operationTime) ?? 0
            systemSetting.setOperationTime(Int(operationTime) ?? 0)
        }
        if let bankText = bankTextField.text {
            if let row = bankPickerData.firstIndex(of: bankText) {
                let bank: MemoryBank = MemoryBank(rawValue: MemoryBank.RawValue(row))
                asReaderGUNManager.mReader?.readMemory(bank, offset: Int32(offsetValue), length: Int32(lengthValue))
            }
        }
        let password = passwordTextField.text
        asReaderGUNManager.mReader?.accessPassword = password
        currentAlertController?.dismiss(animated: true, completion: nil)
        currentAlertController = UIAlertController(title: "Please wait...",
                                                   message: "Reading tag memory",
                                                   preferredStyle: .alert)
        let okAction = UIAlertAction(title: "Stop", style: .default, handler: { _ in
            self.stopAction()
        })
        currentAlertController?.addAction(okAction)
        guard let aleart = currentAlertController else {
            return
        }
        present(aleart, animated: true, completion: nil)
    }
    private func stopAction() {
        asReaderGUNManager.mReader?.stop()
    }
}
// MARK: - Setters
extension ReadMemoryViewController {
    private func setBank(_ index: Int) {
        bankTextField.text = bankPickerData[index]
    }
    private func setOffset(_ index: Int) {
        offsetTextField.text = offsetPickerData[index]
        offsetValue = index
    }
    private func setLength(_ index: Int) {
        lengthTextField.text = lengthPickerData[index]
        lengthValue = index
    }
    private func setPassword(_ password: String?) {
        passwordTextField.text = password
    }
    private func setPowerGain(_ power: Int) {
        let value = String(format: "%i.0 dB", power)
        let index = powerGainPickerData.firstIndex(of: value) ?? 0
        if powerGainPickerData.count > index {
            powerGainTextField.text = powerGainPickerData[index]
        }
    }
    private func setOperationTime(_ operationTime: String?) {
        operationTimeTextField.text = operationTime
    }
    private func setReportRssiModeEnabled(_ enabled: Bool) {
        for elem in reportRssiCollection {
            elem.isEnabled = enabled
        }
        if !enabled {
            setReportRssiModeDefault()
        }
        reportRssiSwitch.isOn = enabled
    }
    private func setReportRssiModeDefault() {
        rssiLabel.text = String(format: "%.1f dB", 0.0)
        phaseLabel.text = String(format: "%.1f˚", 0.0)
    }
}
