//
//  OptionsViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/6.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class OptionsViewController: UIViewController {
    @IBOutlet private weak var scrollView: UIScrollView!
    @IBOutlet private weak var setLBTButton: UIButton!
    @IBOutlet private weak var pickerView: UIPickerView!
    @IBOutlet private weak var tableView: UITableView!
    @IBOutlet private weak var buzzerTextField: UITextField!
    @IBOutlet private weak var vibratorTextField: UITextField!
    @IBOutlet private weak var inventoryTimeTextField: UITextField!
    @IBOutlet private weak var idleTimeTextField: UITextField!
    @IBOutlet private weak var autoOffTimeTextField: UITextField!
    @IBOutlet private weak var keyActionTextField: UITextField!
    @IBOutlet private weak var batteryIntervalTextField: UITextField!
    @IBOutlet private weak var maskTypeTextField: UITextField!
    @IBOutlet private weak var buzzerPickerTopView: UIView!
    @IBOutlet private weak var vibratorPickerTopView: UIView!
    @IBOutlet private weak var keyActionPickerTopView: UIView!
    @IBOutlet private weak var maskTypePickerTopView: UIView!
    @IBOutlet private weak var lbtChannelTableTopView: UIView!
    @IBOutlet private weak var shadowView: UIView!
    @IBOutlet private weak var algorithmTextField: UITextField!
    @IBOutlet private weak var algorithmPickerTopView: UIView!
    @IBOutlet private weak var qValueTextField: UITextField!
    @IBOutlet private weak var qValuePickerTopView: UIView!
    @IBOutlet private weak var minQValueTextField: UITextField!
    @IBOutlet private weak var maxQValueTextField: UITextField!
    @IBOutlet weak private var linkProfileTextField: UITextField!
    @IBOutlet private weak var sleepTimeTextField: UITextField!
    @IBOutlet private weak var thresHoldTextField: UITextField!
    @IBOutlet private weak var linkProfileTableTopView: UIView!
    private enum PickerViewTag: Int {
        case pickerViewBuzzer = 0
        case pickerViewKeyAction = 1
        case pickerViewMaskType = 2
        case pickerViewVibrator = 3
        case pickerViewQValue = 4
        case pickerViewAlgorithm = 5
        case pickerViewMaxQValue = 6
        case pickerViewMinQValue = 7
        case pickerViewLinkProfile = 8
    }
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var systemSetting: SystemSetting! = SystemSetting.shared()
    private var isJapan = false
    private var buzzerValue: BuzzerState?
    private var vibratorValue: VibratorState?
    private var inventoryTimeValue: Int32 = 0
    private var idleTimeValue: Int32 = 0
    private var autoOffTimeValue: Int32 = 0
    private var keyActionValue: Int = 0
    private var batteryIntervalValue = ""
    private var maskTypeValue: MaskType?
    private var qValue: Int32 = 0
    private var algorithmValue: AlgorithmType?
    private var maxQValue: Int32 = 0
    private var minQValue: Int32 = 0
    private var linkProfileValue: Int32 = 0
    private var sleepTimeValue: Int32 = 0
    private var lbtItemData: [LbtItem] = []
    private var thresHoldValue: Int32 = 0
    private lazy var algorithmPickerData: [String] = {
        return ["Fixed Q", "Dynamic Q"]
    }()
    private lazy var  buzzerPickerData: [String] = {
        return dataBuzzerPicker
    }()
    private lazy var  vibratoryPickerData: [String] = {
        return dataVibratoryPicker
    }()
    private lazy var  keyActionPickerData: [String] = {
        return ["Not Used", "Used"]
    }()
    private lazy var  maskTypePickerData: [String] = {
        return ["No Mask", "Selection Mask", "EPC Mask"]
    }()
    private lazy var  qValuePickerData: [String] = {
        return ["00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15"]
    }()
    private lazy var  linkProfilePickerData: [String] = {
        return ["0", "1", "2", "3"]
    }()
    override func viewDidLoad() {
        super.viewDidLoad()
        isJapan = false
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        scrollView.contentSize = CGSize(width: 0, height: 620)
        scrollView.showsVerticalScrollIndicator = false
        scrollView.isScrollEnabled = true
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: loading)
        if asReaderGUNManager.mReader == nil {
            AsReaderGUNManager.dismissGlobalHUD()
            return
        }
        vibratorValue = asReaderGUNManager.mReader?.vibrator
        buzzerValue = asReaderGUNManager.mReader?.buzzer
        if let inventoryTime = asReaderGUNManager.mReader?.inventoryTime {
            inventoryTimeValue = inventoryTime
        }
        if let idleTime = asReaderGUNManager.mReader?.idleTime {
            idleTimeValue = idleTime
        }
        if let autoOffTime =  asReaderGUNManager.mReader?.autoOffTime {
            autoOffTimeValue = autoOffTime
        }
        if let aQValue =  asReaderGUNManager.mReader?.qValue {
            qValue = aQValue
        }
        if let maxQ =  asReaderGUNManager.mReader?.maxQ {
            maxQValue = maxQ
        }
        if let minQ =  asReaderGUNManager.mReader?.minQ {
            minQValue = minQ
        }
        algorithmValue = asReaderGUNManager.mReader?.algorithm
        if let aLinkProfileValue = asReaderGUNManager.mReader?.linkProfileValue {
            linkProfileValue = aLinkProfileValue
        }
        maskTypeValue = (asReaderGUNManager.mReader?.maskTypeValue).map { MaskType(rawValue: MaskType.RawValue($0)) }
        sleepTimeValue = asReaderGUNManager.mReader?.sleepTime ?? 300
        thresHoldValue = asReaderGUNManager.mReader?.thresHoldValue ?? 50
        if let aIsJapan = asReaderGUNManager.mReader?.regionName().hasPrefix("Japan") {
                   isJapan = aIsJapan
               }
        if isJapan {
            setLBTButton.isHidden = false
            initLbtItemData()
        } else {
            setLBTButton.isHidden = true
        }
        initViewData()
        tableView.reloadData()
        navigationController?.view.addSubview(shadowView)
        AsReaderGUNManager.dismissGlobalHUD()
    }
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(true)
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    @IBAction func adminBtnAction(_ sender: UIBarButtonItem) {
        let alertController = UIAlertController(title: "Enter your Password", message: "", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.placeholder = "Current Password"
            textField.isSecureTextEntry = true
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            let value: String = alertController.textFields?.first?.text ?? ""
            if value == "111111" {
                let controller: UIViewController = self.storyboard!.instantiateViewController(withIdentifier: "RegionSettingViewController")
                self.navigationController?.pushViewController(controller, animated: true)
            } else {
                let alertVC = UIAlertController(title: "Please check your password and try again",
                                                message: "",
                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                alertVC.addAction(okAction)
                self.present(alertVC, animated: true, completion: nil)
            }
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func minQValueBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewMinQValue.rawValue
        pickerView.reloadAllComponents()
        qValuePickerTopView.isHidden = false
        showPickerView()
        guard let text = minQValueTextField.text else {
            return
        }
        guard !text.isEmpty else {
            return
        }
        if let row = qValuePickerData.firstIndex(of: text) {
            pickerView.selectRow(row, inComponent: 0, animated: false)
            return
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction private func maxQValueBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewMaxQValue.rawValue
        pickerView.reloadAllComponents()
        qValuePickerTopView.isHidden = false
        showPickerView()
        guard let text = maxQValueTextField.text else {
            return
        }
        guard !text.isEmpty else {
            return
        }
        if let row = qValuePickerData.firstIndex(of: text) {
            pickerView.selectRow(row, inComponent: 0, animated: false)
            return
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction private func qValueBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewQValue.rawValue
        pickerView.reloadAllComponents()
        qValuePickerTopView.isHidden = false
        showPickerView()
        guard let text = qValueTextField.text else {
            return
        }
        guard !text.isEmpty else {
            return
        }
        if let row = qValuePickerData.firstIndex(of: text) {
            pickerView.selectRow(row, inComponent: 0, animated: false)
            return
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction private func algorithmBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewAlgorithm.rawValue
        pickerView.reloadAllComponents()
        algorithmPickerTopView.isHidden = false
        showPickerView()
        guard let text = algorithmTextField.text else {
            return
        }
        guard !text.isEmpty else {
            return
        }
        if let row = algorithmPickerData.firstIndex(of: text) {
            pickerView.selectRow(row, inComponent: 0, animated: false)
            return
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction private func linkProfileBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewLinkProfile.rawValue
        pickerView.reloadAllComponents()
        linkProfileTableTopView.isHidden = false
        showPickerView()
        guard let text = linkProfileTextField.text else {
            return
        }
        guard !text.isEmpty else {
            return
        }
        if let row = linkProfilePickerData.firstIndex(of: text) {
            pickerView.selectRow(row, inComponent: 0, animated: false)
            return
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction private func fwdPWRTHRSHBtnTapped(_ sender: Any) {
        let isAvailableDefaultLinkProfile: Bool = asReaderGUNManager.mReader?.isAvailableDefaultLinkProfile ?? false
        if isAvailableDefaultLinkProfile {
            let alertController = UIAlertController(title: "Notice !!",
                                                    message: "This model does not support the [HST_RFTC_FWDPWRTHRSH] function.",
                                                    preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
            alertController.addAction(okAction)
            present(alertController, animated: true, completion: nil)
            return
        }
        let alertController = UIAlertController(title: "Please enter ThresholdValue", message: "Default : 50 (MIN = 50 / MAX = 70) ", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var value = alertController.textFields?.first?.text
            guard let text = value else {
                return
            }
            if text.isEmpty {
                value = "50"
                let alertVC = UIAlertController(title: "Please enter appropriate ThresholdValue",
                                                        message: "Thres Hold' should be greater than or equal 50  and less than or equal 70.",
                                                        preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                alertVC.addAction(okAction)
                self.present(alertVC, animated: true, completion: nil)
            }
            let checkVal = Int(value!)
            if checkVal! < 50 {
                value = "50"
                let alertVC = UIAlertController(title: "Please enter appropriate ThresholdValue",
                                                        message: "Thres Hold' should be greater than or equal 50.",
                                                        preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                alertVC.addAction(okAction)
                self.present(alertVC, animated: true, completion: nil)
            }
            if checkVal! > 70 {
                value = "70"
                let alertVC = UIAlertController(title: "Please enter appropriate ThresholdValue",
                                                message: "Thres Hold' should be less than or equal 70.",
                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                alertVC.addAction(okAction)
                self.present(alertVC, animated: true, completion: nil)
            }
            self.setThresHold(value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func buzzerBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewBuzzer.rawValue
        pickerView.reloadAllComponents()
        buzzerPickerTopView.isHidden = false
        showPickerView()
        guard let text = buzzerTextField.text else {
            return
        }
        guard !text.isEmpty else {
            return
        }
        if let row = buzzerPickerData.firstIndex(of: text) {
            pickerView.selectRow(row, inComponent: 0, animated: false)
            return
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction private func vibratorBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewVibrator.rawValue
        pickerView.reloadAllComponents()
        vibratorPickerTopView.isHidden = false
        showPickerView()
        guard let text = vibratorTextField.text else {
            return
        }
        guard !text.isEmpty else {
            return
        }
        if let row = vibratoryPickerData.firstIndex(of: text) {
            pickerView.selectRow(row, inComponent: 0, animated: false)
            return
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction private func inventoryTimeBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Inventory Time:", message: "Please enter inventory time.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var value = alertController.textFields?.first?.text
            guard let text = value else {
                return
            }
            if text.isEmpty {
                value = "0"
            }
            self.setInventoryTime(value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func idleTimeBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Idle Time:", message: "Please enter idle time.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var value = alertController.textFields?.first?.text
            guard let text = value else {
                return
            }
            if text.isEmpty {
                value = "0"
            }
            self.setIdleTime(value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func autoOffTimeBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Auto Off Time:", message: "Please enter auto off time.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var value = alertController.textFields?.first?.text
            guard let text = value else {
                return
            }
            if text.isEmpty {
                value = "0"
            }
            self.setAutoOffTime(value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func batteryIntervalBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Battery Interval:", message: "Please enter battery interval.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var value = alertController.textFields?.first?.text
            guard let text = value else {
                return
            }
            if text.isEmpty {
                value = "0"
            }
            self.setBatteryInterval(value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func maskTypeBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewMaskType.rawValue
        pickerView.reloadAllComponents()
        maskTypePickerTopView.isHidden = false
        showPickerView()
        guard let text = maskTypeTextField.text else {
            return
        }
        guard !text.isEmpty else {
            return
        }
        if let row = maskTypePickerData.firstIndex(of: text) {
            pickerView.selectRow(row, inComponent: 0, animated: false)
            return
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
        
    }
    @IBAction private func sleepTimeBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "sleep Time:", message: "Please enter sleep time.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var value = alertController.textFields?.first?.text
            guard let text = value else {
                return
            }
            if text.isEmpty {
                value = "0"
            }
            self.setSleepTime(value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func saveBtnTapped(_ sender: UIButton) {
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Saving...")
        if let aBuzzerValue =  buzzerValue {
            asReaderGUNManager.mReader?.buzzer = aBuzzerValue
            systemSetting.setBuzzer(Int(aBuzzerValue.rawValue))
        }
        if let aVibratorValue =  vibratorValue {
            asReaderGUNManager.mReader?.vibrator = aVibratorValue
            systemSetting.setVibrator(Int(aVibratorValue.rawValue))
        }
        if let aAlgorithmValue =  algorithmValue {
            asReaderGUNManager.mReader?.algorithm = aAlgorithmValue
            systemSetting.setAlgorithm(Int(aAlgorithmValue.rawValue))
        }
        if let maskTypeRawValue =  maskTypeValue?.rawValue {
            asReaderGUNManager.mReader?.maskTypeValue = Int32(maskTypeRawValue)
            systemSetting.setMaskTypeValue(Int(maskTypeRawValue))
        }
        systemSetting.setBatteryInterval(batteryIntervalValue)
        asReaderGUNManager.mReader?.inventoryTime = inventoryTimeValue
        asReaderGUNManager.mReader?.idleTime = idleTimeValue
        asReaderGUNManager.mReader?.autoOffTime = autoOffTimeValue
        asReaderGUNManager.mReader?.qValue = qValue
        asReaderGUNManager.mReader?.maxQ = maxQValue
        asReaderGUNManager.mReader?.minQ = minQValue
        asReaderGUNManager.mReader?.sleepTime = sleepTimeValue
        asReaderGUNManager.mReader?.thresHoldValue = thresHoldValue
        systemSetting.setInventoryTime(Int(inventoryTimeValue))
        systemSetting.setIdleTime(Int(idleTimeValue))
        systemSetting.setAutoOffTime(Int(autoOffTimeValue))
        systemSetting.setQValue(Int(qValue))
        systemSetting.setMaxQ(Int(maxQValue))
        systemSetting.setMinQ(Int(minQValue))
        systemSetting.setSleepTime(Int(sleepTimeValue))
        systemSetting.setThresHold(Int(thresHoldValue))
        AsReaderGUNManager.dismissGlobalHUD()
        let alertController = UIAlertController(title: "Success",
                                                message: "Saved successfully",
                                                preferredStyle: .alert)
        let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func defaultBtnTapped(_ sender: UIButton) {
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Saving...")
        let  res = asReaderGUNManager.mReader?.defaultParameter()
        if res != ResultNoError {
            let alertController = UIAlertController(title: "Fail",
                                                    message: "Set to default failed",
                                                    preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
            alertController.addAction(okAction)
            present(alertController, animated: true, completion: nil)
            return
        }
        if isJapan {
            for lbtItem in lbtItemData {
                lbtItem.mIsUsed = true
            }
            asReaderGUNManager.mReader?.setLBT(lbtItemData)
            systemSetting.setLbtItemData(lbtItemData)
        }
        buzzerValue = asReaderGUNManager.mReader?.buzzer
        vibratorValue = asReaderGUNManager.mReader?.vibrator
        
        if let inventoryTime =  asReaderGUNManager.mReader?.inventoryTime {
            inventoryTimeValue = inventoryTime
        }
        if let idleTime = asReaderGUNManager.mReader?.idleTime {
            idleTimeValue = idleTime
        }
        if let autoOffTime = asReaderGUNManager.mReader?.autoOffTime {
            autoOffTimeValue = autoOffTime
        }
        if let aQValue = asReaderGUNManager.mReader?.qValue {
            qValue = aQValue
        }
        if let maxQ = asReaderGUNManager.mReader?.maxQ {
            maxQValue = maxQ
        }
        if let minQ = asReaderGUNManager.mReader?.minQ {
            minQValue = minQ
        }
        if let sleepTime = asReaderGUNManager.mReader?.sleepTime {
            sleepTimeValue = sleepTime
        }
        algorithmValue = asReaderGUNManager.mReader?.algorithm
        if let aLinkProfileValue = asReaderGUNManager.mReader?.linkProfileValue {
            linkProfileValue = aLinkProfileValue
        }
        if let thresHoldValues = asReaderGUNManager.mReader?.thresHoldValue {
            thresHoldValue = thresHoldValues
        }
        maskTypeValue = (asReaderGUNManager?.mReader?.maskTypeValue).map { MaskType(rawValue: MaskType.RawValue($0)) }
        maskTypeValue = MaskType_NO_MASK
        asReaderGUNManager.mReader?.maskTypeValue = Int32(MaskType_NO_MASK.rawValue)
        if let aBuzzerRawValue = buzzerValue?.rawValue {
            systemSetting.setBuzzer(Int(aBuzzerRawValue))
        }
        if let aVibratorValue = vibratorValue?.rawValue {
            systemSetting.setVibrator(Int(aVibratorValue))
        }
        systemSetting.setInventoryTime(Int(inventoryTimeValue))
        systemSetting.setIdleTime(Int(idleTimeValue))
        systemSetting.setAutoOffTime(Int(autoOffTimeValue))
        systemSetting.setQValue(Int(qValue))
        if let aAlgorithmRawValue = algorithmValue?.rawValue {
            systemSetting.setAlgorithm(Int(aAlgorithmRawValue))
        }
        systemSetting.setMaxQ(Int(maxQValue))
        systemSetting.setMinQ(Int(minQValue))
        systemSetting.setSleepTime(Int(sleepTimeValue))
        if let maskTypeRawValue = maskTypeValue?.rawValue {
            systemSetting.setMaskTypeValue(Int(maskTypeRawValue))
        }
        systemSetting.setLinkProfileValue(Int(linkProfileValue))
        if let sessionFlagRawValue = asReaderGUNManager.mReader?.sessionFlag.rawValue {
            systemSetting?.setSessionFlag(Int(sessionFlagRawValue))
        }
        if let inventorySessionRawValue = asReaderGUNManager.mReader?.inventorySession.rawValue {
            systemSetting?.setInventorySession(Int(inventorySessionRawValue))
        }
        if let operationTime = asReaderGUNManager.mReader?.operationTime {
            systemSetting?.setOperationTime(Int(operationTime))
        }
        systemSetting?.setPowerGain(300)
        systemSetting?.setThresHold(50)
        systemSetting.setBatteryInterval("10000")
        initViewData()
        AsReaderGUNManager.dismissGlobalHUD()
        let alertController = UIAlertController(title: "Success",
                                                message: "Set to default successfully",
                                                preferredStyle: .alert)
        let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func pickerCloseBtnTapped(_ sender: UIButton) {
        hidePickerView()
    }
    @IBAction private func qValuePickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewMaxQValue {
                setMaxQ(idx)
            } else if pickerViewTag == .pickerViewMinQValue {
                setMinQ(idx)
            } else if pickerViewTag == .pickerViewQValue {
                setQ(idx)
            }
        }
        
        hidePickerView()
    }
    @IBAction private func algorithmPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setAlgorithm(idx)
        hidePickerView()
    }
    @IBAction private func linkProfilePickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewLinkProfile {
                setLinkProfile(idx)
                asReaderGUNManager.mReader?.linkProfileValue = linkProfileValue
                systemSetting.setLinkProfileValue(Int(linkProfileValue))
            }
        }
        hidePickerView()
    }
    @IBAction private func buzzerPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setBuzzer(idx)
        hidePickerView()
    }
    @IBAction private func vibratorPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setVibrator(idx)
        hidePickerView()
    }
    @IBAction private func keyActionPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setKeyAction(idx)
        hidePickerView()
    }
    @IBAction private func maskTypePickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setMaskType(idx)
        hidePickerView()
    }
    @IBAction private func lbtChannelBtnTapped(_ sender: UIButton) {
        tableView.reloadData()
        lbtChannelTableTopView.isHidden = false
        tableView.isHidden = false
        shadowView.isHidden = false
    }
    @IBAction private func tableCloseBtnTapped(_ sender: UIButton) {
        hideTableView()
    }
    @IBAction private func lbtChannelTableOkBtnTapped(_ sender: UIButton) {
        hideTableView()
        asReaderGUNManager.mReader?.setLBT(lbtItemData)
        systemSetting.setLbtItemData(lbtItemData)
    }
}
// MARK: - UITextFieldDelegate
extension OptionsViewController: UITextFieldDelegate {
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let text = textField.text ?? ""
        let length = text.count + string.count - range.length
        return length <= 9
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension OptionsViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == false {
            DispatchQueue.main.async {
                self.hideTableView()
                self.hidePickerView()
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        return false
    }
    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNUpdateDeviceState(_ error: ResultCode) {
        if error != ResultNoError {
            DispatchQueue.main.async {
                let alertController = UIAlertController(title: "Error",
                                                        message: "Failed to get response. Try again.",
                                                        preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
                    self.navigationController?.popViewController(animated: true)
                })
                alertController.addAction(okAction)
                self.present(alertController, animated: true, completion: nil)
            }
        }
    }
}
// MARK: - UITableViewDelegate, UITableViewDataSource
extension OptionsViewController: UITableViewDelegate, UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return lbtItemData.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell: UITableViewCell? = tableView.dequeueReusableCell(withIdentifier: "LbtCell", for: indexPath)
        let lbtItem = lbtItemData[indexPath.row]
        if lbtItem.mIsUsed {
            cell?.accessoryType = .checkmark
        } else {
            cell?.accessoryType = .none
        }
        cell?.textLabel?.text = lbtItem.frequency
        guard let aCell = cell else {
            return UITableViewCell()
        }
        return aCell
    }
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cell: UITableViewCell? = tableView.cellForRow(at: indexPath)
        let lbtItem = lbtItemData[indexPath.row]
        if cell?.accessoryType == .checkmark {
            cell?.accessoryType = .none
            lbtItem.mIsUsed = false
        } else {
            cell?.accessoryType = .checkmark
            lbtItem.mIsUsed = true
        }
    }
    func tableView(_ tableView: UITableView, didDeselectRowAt indexPath: IndexPath) {
        let cell: UITableViewCell? = tableView.cellForRow(at: indexPath)
        let lbtItem = lbtItemData[indexPath.row]
        if cell?.accessoryType == .checkmark {
            cell?.accessoryType = .none
            lbtItem.mIsUsed = false
        } else {
            cell?.accessoryType = .checkmark
            lbtItem.mIsUsed = true
        }
    }
}
// MARK: - UIPickerViewDelegate,UIPickerViewDataSource
extension OptionsViewController: UIPickerViewDelegate, UIPickerViewDataSource {
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewBuzzer {
                return buzzerPickerData.count
            } else if pickerViewTag == .pickerViewKeyAction {
                return keyActionPickerData.count
            } else if pickerViewTag == .pickerViewMaskType {
                return maskTypePickerData.count
            } else if pickerViewTag == .pickerViewVibrator {
                return vibratoryPickerData.count
            } else if pickerViewTag == .pickerViewQValue {
                return qValuePickerData.count
            } else if pickerViewTag == .pickerViewAlgorithm {
                return algorithmPickerData.count
            } else if pickerViewTag == .pickerViewMinQValue {
                return qValuePickerData.count
            } else if pickerViewTag == .pickerViewMaxQValue {
                return qValuePickerData.count
            } else if pickerViewTag == .pickerViewLinkProfile {
                return linkProfilePickerData.count
            }
        }
        return 0
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewBuzzer {
                return buzzerPickerData[row]
            } else if pickerViewTag == .pickerViewKeyAction {
                return keyActionPickerData[row]
            } else if pickerViewTag == .pickerViewMaskType {
                return maskTypePickerData[row]
            } else if pickerViewTag == .pickerViewVibrator {
                return vibratoryPickerData[row]
            } else if pickerViewTag == .pickerViewQValue {
                return qValuePickerData[row]
            } else if pickerViewTag == .pickerViewAlgorithm {
                return algorithmPickerData[row]
            } else if pickerViewTag == .pickerViewMinQValue {
                return qValuePickerData[row]
            } else if pickerViewTag == .pickerViewMaxQValue {
                return qValuePickerData[row]
            } else if pickerViewTag == .pickerViewLinkProfile {
                return linkProfilePickerData[row]
            }
        }
        return "None"
    }
}
// MARK: - Custom
extension OptionsViewController {
    private func initLbtItemData() {
        if let getLbtItemData = systemSetting.getLbtItemData() {
            lbtItemData = getLbtItemData
        }
    }
    private func showPickerView() {
        pickerView.isHidden = false
        shadowView.isHidden = false
    }
    private func hidePickerView() {
        linkProfileTableTopView.isHidden = true
        algorithmPickerTopView.isHidden = true
        qValuePickerTopView.isHidden = true
        vibratorPickerTopView.isHidden = true
        buzzerPickerTopView.isHidden = true
        keyActionPickerTopView.isHidden = true
        maskTypePickerTopView.isHidden = true
        pickerView.isHidden = true
        shadowView.isHidden = true
    }
    private func hideTableView() {
        lbtChannelTableTopView.isHidden = true
        tableView.isHidden = true
        shadowView.isHidden = true
    }
    private func initViewData() {
        setMaxQ(Int(maxQValue))
        setMinQ(Int(minQValue))
        if let maskTypeRawValue = maskTypeValue?.rawValue {
            setMaskType(Int(maskTypeRawValue))
        }
        setLinkProfile(Int(linkProfileValue))
        linkProfileTextField.text = "\(linkProfileValue)"
        if let algorithmRawValue = algorithmValue?.rawValue {
            setAlgorithm(Int(algorithmRawValue))
        }
        setQ(Int(qValue))
        if let buzzerRawValue =  buzzerValue?.rawValue {
            setBuzzer(Int(buzzerRawValue))
        }
        if let vibratorRawValue =  vibratorValue?.rawValue {
            setVibrator(Int(vibratorRawValue))
        }
        setInventoryTime("\(inventoryTimeValue)")
        setIdleTime("\(idleTimeValue)")
        setAutoOffTime("\(autoOffTimeValue)")
        setSleepTime("\(sleepTimeValue)")
        setThresHold("\(thresHoldValue)")
        let batteryInterval = systemSetting.getBatteryInterval()
        setBatteryInterval(batteryInterval)
    }
}
// MARK: - Setters
extension OptionsViewController {
    private func setBuzzer(_ index: Int) {
        buzzerTextField.text = buzzerPickerData[index]
        buzzerValue = BuzzerState(rawValue: BuzzerState.RawValue(index))
    }
    private func setVibrator(_ index: Int) {
        vibratorTextField.text = vibratoryPickerData[index]
        vibratorValue = VibratorState(rawValue: VibratorState.RawValue(index))
    }
    private func setMinQ(_ index: Int) {
        var index = index
        if index > maxQValue {
            index = Int(maxQValue)
        }
        minQValueTextField.text = qValuePickerData[index]
        minQValue = Int32(index)
    }
    private func setMaxQ(_ index: Int) {
        var index = index
        if index < minQValue {
            index = Int(minQValue)
        }
        maxQValueTextField.text = qValuePickerData[index]
        maxQValue = Int32(index)
    }
    private func setLinkProfile(_ index: Int) {
        linkProfileTextField.text = linkProfilePickerData[index]
        linkProfileValue = Int32(index)
    }
    private func setQ(_ index: Int) {
        qValueTextField.text = qValuePickerData[index]
        qValue = Int32(index)
    }
    private func setAlgorithm(_ index: Int) {
        algorithmTextField.text = algorithmPickerData[index]
        algorithmValue = AlgorithmType(rawValue: AlgorithmType.RawValue(index))
    }
    private func setInventoryTime(_ inventoryTime: String?) {
        inventoryTimeTextField.text = inventoryTime
        if let aInventoryTime = inventoryTime {
            inventoryTimeValue = Int32(aInventoryTime) ?? 400
        }
    }
    private func setIdleTime(_ idleTime: String?) {
        idleTimeTextField.text = idleTime
        if let aIdleTime = idleTime {
            idleTimeValue = Int32(aIdleTime) ?? 0
        }
    }
    private func setAutoOffTime(_ autoOffTime: String?) {
        autoOffTimeTextField.text = autoOffTime
        if let aAutoOffTime = autoOffTime {
            autoOffTimeValue = Int32(aAutoOffTime) ?? 1800
        }
    }
    private func setKeyAction(_ index: Int) {
        keyActionTextField.text = keyActionPickerData[index]
        keyActionValue = index
    }
    private func setBatteryInterval(_ batteryInterval: String?) {
        batteryIntervalTextField.text = batteryInterval
        if let aBatteryInterval = batteryInterval {
            batteryIntervalValue = aBatteryInterval
        }
    }
    private func setSleepTime(_ sleepTime: String?) {
        sleepTimeTextField.text = sleepTime
        if let aSleepTime = sleepTime {
            sleepTimeValue = Int32(aSleepTime) ?? 300
        }
    }
    private func setMaskType(_ index: Int) {
        maskTypeTextField.text = maskTypePickerData[index]
        maskTypeValue = MaskType(rawValue: MaskType.RawValue(index))
    }
    private func setThresHold(_ thresHold: String?) {
        thresHoldTextField.text = thresHold
        thresHoldValue = Int32(thresHold!)!
    }
}
