//
//  MainViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/2.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit
import AsReaderGunSDK
import AsRingAccessorySDK
import CoreBluetooth


final class MainViewController: UIViewController {
    @IBOutlet private weak var asRingPlusVersion: UILabel!
    @IBOutlet private var buttonCollection: [MainButton]!
    @IBOutlet private weak var batteryImage: UIImageView!
    @IBOutlet private weak var vibratorTextField: UITextField!
    @IBOutlet private weak var buzzerTextField: UITextField!
    @IBOutlet private weak var buzzerButton: UIButton!
    @IBOutlet private weak var vibratorButton: UIButton!
    @IBOutlet private weak var logoImage: UIImageView!
    @IBOutlet private weak var labelDemoVer: UILabel!
    @IBOutlet private weak var labelFirmwareVer: UILabel!
    @IBOutlet private weak var labelAddress: UILabel!
    @IBOutlet private weak var regionLabel: UILabel!
    @IBOutlet private weak var snLabel: UILabel!
    @IBOutlet private weak var ufVersion: UILabel!
    @IBOutlet private weak var mainScrollView: UIScrollView!
    @IBOutlet private weak var sdkVersion: UILabel!
    @IBOutlet private weak var ledTestButton: UIButton!
    private var batteryCheckTimer: Timer!
    private var logoDebugTap: UITapGestureRecognizer?
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var systemSetting: SystemSetting! = SystemSetting.shared()
    private var backView: UIView! = UIView()
    private var updateUrl = ""
    private enum BatteryStatus: Int {
        case batteryNone, batteryQuarter, batteryHalf, batteryThirdQuarter, batteryFull, batteryNoData
    }
    private enum ConnectionStatus: Int {
        case connectionOff, connectionOn
    }
    override func viewDidLoad() {
        super.viewDidLoad()
        let appDelegate: AppDelegate = UIApplication.shared.delegate as! AppDelegate
        labelDemoVer.text = appDelegate.getAppVersion()
        sdkVersion.text = asReaderGUNManager.mAsReaderGUN.getVersion()
        regionLabel.text = ""
        snLabel.text = ""
        ufVersion.text = ""
        mainScrollView.contentSize = CGSize(width: 0, height: view.frame.size.height)
        mainScrollView.showsVerticalScrollIndicator = false
        logoDebugTap = nil
        buzzerTextField.text = "\(systemSetting.getBuzzerTime())"
        vibratorTextField.text = "\(systemSetting.getVibratorTime())"
        buzzerTextField.delegate = self
        vibratorTextField.delegate = self
        backView.backgroundColor = UIColor.gray
        backView.alpha = 0.5
        backView.frame = CGRect(x: 0, y: 0, width: view.frame.size.width, height: view.frame.size.height)
        mainScrollView.setContentOffset(CGPoint(x: 0, y: 0), animated: true)
        let tapGestureRecognizer = UITapGestureRecognizer.init(target: self, action: #selector(keyboardHide))
        tapGestureRecognizer.cancelsTouchesInView = false
        backView.addGestureRecognizer(tapGestureRecognizer)
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        changeBatteryImage(BatteryStatus.batteryNoData.rawValue)
        connectMethod()
        if  view.frame.size.height < 590 {
            mainScrollView.contentSize = CGSize(width: 0, height: 590)
        }
    }
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
        startMonitoringBattery(isStart: false)

    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    // MARK: - IBActions
    @IBAction private func onClickVibratorButton(_ sender: UIButton) {
        guard let vibratorStr =  vibratorTextField.text,
            let vibratorIndex = Int(vibratorStr) else {
                return
        }
        if vibratorIndex > 0 && vibratorIndex < 5000 {
            systemSetting.setVibratorTime(vibratorIndex)
            let resultCode = asReaderGUNManager.mReader?.startVibrator(withVibratorTime: Int32(vibratorIndex))
            if resultCode == ResultOperationFailed {
                print("Vibrator Start ERROR!")
            }
        } else {
            let alertController = UIAlertController(title: "Vibrator Value", message: "Please enter the value (1~4999)", preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .cancel, handler: nil)
            alertController.addAction(okAction)
            present(alertController, animated: true, completion: nil)
        }
    }
    @IBAction private func onClickBuzzerButton(_ sender: UIButton) {
        guard let buzzerStr: String =  buzzerTextField.text,
            let buzzerIndex: Int = Int(buzzerStr) else {
                return
        }
        if buzzerIndex > 0 && buzzerIndex < 5000 {
            systemSetting.setBuzzerTime(buzzerIndex)
            let resultCode = asReaderGUNManager.mReader?.startBuzzer(withBuzzerTime: Int32(buzzerIndex))
                if resultCode == ResultOperationFailed {
                    print("Buzzer Start ERROR!")
                }
        } else {
            let alertController = UIAlertController(title: "Buzzer Value", message: "Please enter the value (1~4999)", preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .cancel, handler: nil)
            alertController.addAction(okAction)
            present(alertController, animated: true, completion: nil)
        }
    }
    @IBAction private func btnModeLedTestAction(_ sender: Any) {
        let alertController = UIAlertController(title: "MODE LED TEST", message: "\n\n\n\n\n\n", preferredStyle: .alert)
        let okAction = UIAlertAction(title: ok, style: .cancel, handler: nil)
        alertController.addAction(okAction)
        let labelLeft = UILabel.init(frame: CGRect(x: 5, y: 50, width: 200, height: 50))
        let labelRight = UILabel.init(frame: CGRect(x: 5, y: 100, width: 200, height: 50))
        labelLeft.text = " LEFT LED (ON/OFF)"
        labelRight.text = " RIGHT LED (ON/OFF)"
        let switchLeft = UISwitch.init(frame: CGRect(x: 200, y: 60, width: 0, height: 0))
        switchLeft.tag = 1
        switchLeft.addTarget(self, action: #selector(changeModeLedTestAction), for: UIControl.Event.touchUpInside)
        let switchRight = UISwitch.init(frame: CGRect(x: 200, y: 110, width: 0, height: 0))
        switchRight.tag = 2
        switchRight.addTarget(self, action: #selector(changeModeLedTestAction), for: UIControl.Event.touchUpInside)
        if let isOn = asReaderGUNManager.mReader?.modeLeftLedOn {
            switchLeft.setOn(isOn, animated: false)
        }
        if let isOn = asReaderGUNManager.mReader?.modeRightLedOn {
            switchRight.setOn(isOn, animated: false)
        }
        alertController.view.addSubview(labelLeft)
        alertController.view.addSubview(labelRight)
        alertController.view.addSubview(switchLeft)
        alertController.view.addSubview(switchRight)
        present(alertController, animated: true, completion: nil)

    }
    @IBAction private func prepare(forUnwind segue: UIStoryboardSegue) {
    }
    @objc private func changeModeLedTestAction(_ sender: UISwitch) {
        let tagId: Int = sender.tag
        let sw: UISwitch = sender
        switch (tagId) {
        case 1:
            if (sw.isOn) {
                asReaderGUNManager.mReader?.modeLeftLedOn = true
            } else {
                asReaderGUNManager.mReader?.modeLeftLedOn = false
            }
            break;
        case 2:
            if (sw.isOn) {
                asReaderGUNManager.mReader?.modeRightLedOn = true
            } else {
                asReaderGUNManager.mReader?.modeRightLedOn = false
            }
            break;
        default:
            break;
        }
    }
}
// MARK: - Custom
extension MainViewController {
    @objc private func keyboardHide() {
        mainScrollView.isScrollEnabled = true
        backView.removeFromSuperview()
        vibratorTextField.resignFirstResponder()
        buzzerTextField.resignFirstResponder()
        if let  buzzerStr: String =  buzzerTextField.text {
            if buzzerStr.isEmpty {
                buzzerTextField.text = "1"
            } else {
                if let buzzerIndex: Int = Int(buzzerStr) {
                    if buzzerIndex == 0 {
                        buzzerTextField.text = "1"
                    }
                    if buzzerIndex >= 5000 {
                        buzzerTextField.text = "4999"
                        let alertController = UIAlertController(title: "Buzzer Value",
                                                                message: "Please enter the value (1~4999)",
                                                                preferredStyle: .alert)
                        let actionCancel = UIAlertAction(title: ok, style: .cancel, handler: nil)
                        alertController.addAction(actionCancel)
                        navigationController?.present(alertController, animated: false)
                    }
                    SystemSetting.shared()?.setBuzzerTime(buzzerIndex)
                }
            }
        }
        if let  vibratorStr: String =  vibratorTextField.text {
            if vibratorStr.isEmpty {
                vibratorTextField.text = "1"
            } else {
                if let vibratorIndex: Int = Int(vibratorStr) {
                    if vibratorIndex == 0 {
                        vibratorTextField.text = "1"
                    }
                    if vibratorIndex >= 5000 {
                        vibratorTextField.text = "4999"
                        let alertController = UIAlertController(title: "Vibrator Value",
                                                                message: "Please enter the value (1~4999)",
                                                                preferredStyle: .alert)
                        let actionCancel = UIAlertAction(title: ok, style: .cancel, handler: nil)
                        alertController.addAction(actionCancel)
                        navigationController?.present(alertController, animated: false)
                    }
                    SystemSetting.shared()?.setVibratorTime(vibratorIndex)
                }
            }
        }
        
        if mainScrollView.contentSize.height - mainScrollView.bounds.size.height > 0 {
            mainScrollView.setContentOffset(CGPoint(x: 0, y: mainScrollView.contentSize.height - mainScrollView.bounds.size.height), animated: false)
        } else {
            mainScrollView.setContentOffset(CGPoint(x: 0, y: 0), animated: true)
        }
    }
    private func enableAllButtons() {
        for btn in buttonCollection {
            btn.enableButton()
        }
        startMonitoringBattery(isStart: true)
        changeLogoImage(ConnectionStatus.connectionOn.rawValue)
        buzzerButton.setTitleColor(UIColor.black, for: .normal)
        vibratorButton.setTitleColor(UIColor.black, for: .normal)
        buzzerTextField.text = "\(systemSetting.getBuzzerTime())"
        vibratorTextField.text = "\(systemSetting.getVibratorTime())"
        buzzerTextField.isEnabled = true
        vibratorTextField.isEnabled = true
        buzzerButton.isEnabled = true
        vibratorButton.isEnabled = true
        ledTestButton.isEnabled = true
    }
    private func disableAllUIs() {
        startMonitoringBattery(isStart: false)
        keyboardHide()
        mainScrollView.setContentOffset(CGPoint(x: 0, y: 0), animated: false)
        asRingPlusVersion.text = ""
        labelFirmwareVer.text = ""
        labelAddress.text = ""
        regionLabel.text = ""
        snLabel.text = ""
        ufVersion.text = ""
        buzzerButton.setTitleColor(UIColor.gray, for: .normal)
        vibratorButton.setTitleColor(UIColor.gray, for: .normal)
        buzzerTextField.text = "\(systemSetting.getBuzzerTime())"
        vibratorTextField.text = "\(systemSetting.getVibratorTime())"
        buzzerTextField.isEnabled = false
        vibratorTextField.isEnabled = false
        buzzerButton.isEnabled = false
        vibratorButton.isEnabled = false
        ledTestButton.isEnabled = false
        for btn in buttonCollection {
            btn.disableButton()
        }
        changeBatteryImage(BatteryStatus.batteryNoData.rawValue)
        changeLogoImage(ConnectionStatus.connectionOff.rawValue)
    }
    private func disableBarcodeButtons() {
        buttonCollection[6].disableButton()
        buttonCollection[7].disableButton()
    }
    private func disableRFIDButtons() {
        buttonCollection[0].disableButton()
        buttonCollection[1].disableButton()
        buttonCollection[2].disableButton()
        buttonCollection[3].disableButton()
        buttonCollection[4].disableButton()
        buttonCollection[5].disableButton()
        buttonCollection[8].disableButton()
    }
    private func changeBatteryImage(_ batteryStatus: Int) {
        if let status = BatteryStatus(rawValue: batteryStatus) {
            if status == .batteryNone {
                batteryImage.image = UIImage(named: "battery0")
            } else if status == .batteryQuarter {
                batteryImage.image = UIImage(named: "battery1")
            } else if status == .batteryHalf {
                batteryImage.image = UIImage(named: "battery2")
            } else if status == .batteryThirdQuarter {
                batteryImage.image = UIImage(named: "battery3")
            } else if status == .batteryFull {
                batteryImage.image = UIImage(named: "battery4")
            } else if status == .batteryNoData {
                batteryImage.image = UIImage(named: "battery")
            }
        }
    }
    private func changeLogoImage(_ connectionStatus: Int) {
        if let status = ConnectionStatus(rawValue: connectionStatus) {
            if status == .connectionOff {
                logoImage.image = UIImage(named: "asreader_logo_off")
                if let aLogoDebugTap = logoDebugTap {
                    logoImage.isUserInteractionEnabled = false
                    logoImage.removeGestureRecognizer(aLogoDebugTap)
                    logoDebugTap = nil
                }
            } else if status == .connectionOn {
                logoImage.image = UIImage(named: "asreader_logo_on")
                if logoDebugTap != nil {
                    logoDebugTap = nil
                }
                logoDebugTap = UITapGestureRecognizer(target: self, action: #selector(logoDebugTapDetected(_:)))
                logoDebugTap?.numberOfTapsRequired = 5
                logoImage.isUserInteractionEnabled = true
                if let aLogoDebugTap = logoDebugTap {
                    logoImage.addGestureRecognizer(aLogoDebugTap)
                }
            }
        }
    }
    @objc private func logoDebugTapDetected(_ sender: UITapGestureRecognizer?) {
        if sender?.state == .ended {
            let alertController = UIAlertController(title: "Please select the operationg mode.",
                                                    message:"",
                                                    preferredStyle: .actionSheet)
            let okAction = UIAlertAction(title: "Normal Mode", style: .destructive) { _ in
                self.asReaderGUNManager.mReader?.setDebugMode(false)
            }
            alertController.addAction(okAction)
            let cancelAction = UIAlertAction(title: "Debug Mode", style: .cancel) { _ in
                self.asReaderGUNManager.mReader?.setDebugMode(true)
            }
            alertController.addAction(cancelAction)
            self.present(alertController, animated: true, completion: nil)
        }
    }
    private func connectMethod() {
        if asReaderGUNManager.mReader != nil {
            asRingPlusVersion.text = AsRingDeviceSDK.shared().getAsRingFirmwareRevision()
            print("Loading shows")
            AsReaderGUNManager.showGlobalProgressHUD(withTitle: loading)
            labelFirmwareVer.text = asReaderGUNManager.mReader?.firmwareVersion()
            if let battery = asReaderGUNManager.mReader?.batteryStatus() {
                changeBatteryImage(Int(battery))
            }
            enableAllButtons()
            let isBarcodeModule: Bool = asReaderGUNManager.mReader?.isBarcodeModule() ?? false
            if !isBarcodeModule {
                disableBarcodeButtons()
            }
            let isRFIDModule: Bool = asReaderGUNManager.mReader?.isRFIDModule() ?? false
            if !isRFIDModule {
                disableRFIDButtons()
            }
            regionLabel.text = asReaderGUNManager.mReader?.regionName()
            snLabel.text = asReaderGUNManager.mReader?.serialNumber
            ufVersion.text = asReaderGUNManager.mReader?.rFModuleVersion()
            print("Loading hide")
            asReaderGUNManager.asReaderGUNSetting()
            labelAddress.text = asReaderGUNManager.mAsReaderGUN.address()
            asReaderGUNManager.mReader?.setScanMode(RFIDScanMode)
            AsReaderGUNManager.dismissGlobalHUD()
        } else {
            disableAllUIs()
        }
    }
    private func startMonitoringBattery(isStart: Bool) {
        updateBattery()
        guard let intervalString: String = systemSetting.getBatteryInterval() else { return }
        let interval: Float = Float.init (intervalString)!
        let periodicTime: Float =  interval / 1000.0
        if batteryCheckTimer != nil{
            batteryCheckTimer.invalidate()
            batteryCheckTimer = nil
        }
        if isStart == true {
            batteryCheckTimer = Timer.scheduledTimer(timeInterval: TimeInterval(periodicTime), target: self, selector: #selector(updateBattery), userInfo: nil, repeats: true)
        }
    }
    @objc private func updateBattery() {
        if asReaderGUNManager.mReader != nil {
            if let battery = asReaderGUNManager.mReader?.batteryStatus() {
                changeBatteryImage(Int(battery))
            }
        } else {
            changeBatteryImage(0)
        }
    }
}
// MARK: - UITextFieldDelegate
extension MainViewController: UITextFieldDelegate {
    func textFieldDidBeginEditing(_ textField: UITextField) {
        mainScrollView.isScrollEnabled = false
        view.addSubview(backView)
        mainScrollView.setContentOffset(CGPoint(x: 0, y: 300), animated: true)
    }
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange,
                   replacementString string: String) -> Bool {
        if string == "\n" {
            keyboardHide()
        } else {
            if let text = textField.text {
                if Int(text+string) ?? 0 <= 0 {
                    textField.text = "1"
                }
            }
        }
        return true
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension MainViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        DispatchQueue.main.async {
            if isConnected == true {
                self.connectMethod()
                self.enableAllButtons()
                let isBarcodeModule: Bool = (self.asReaderGUNManager.mReader?.isBarcodeModule())!
                if !isBarcodeModule {
                    self.disableBarcodeButtons()
                } else {
                    AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Barcode Setting...")
                    CATransaction.commit()
                    self.asReaderGUNManager.barcodeSetting()
                    AsReaderGUNManager.dismissGlobalHUD()
                    CATransaction.commit()
                }
                let isRFIDModule: Bool = (self.asReaderGUNManager.mReader?.isRFIDModule())!
                if !isRFIDModule {
                    self.disableRFIDButtons()
                } else {
                    AsReaderGUNManager.showGlobalProgressHUD(withTitle: "RFID Setting...")
                    CATransaction.commit()
                    self.asReaderGUNManager.rfidSetting()
                    AsReaderGUNManager.dismissGlobalHUD()
                    CATransaction.commit()
                }
            } else {
                self.disableAllUIs()
                AsReaderGUNManager.dismissGlobalHUD()
            }
        }
    }

    func asReaderGUNAccessResult(_ error: ResultCode, actionState action: CommandType, epc: String?, data: String?, rssi: Float, phase: Float, frequency: Float) {
        if error != ResultNoError {
            DispatchQueue.main.async {
                let alertController = UIAlertController(title: "Error", message: AsResultCode.msg(error), preferredStyle: .alert)
                let cancelAction = UIAlertAction(title: ok, style: .cancel, handler: nil)
                alertController.addAction(cancelAction)
                self.present(alertController, animated: true, completion: nil)
            }
        }
    }

    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        return false
    }

    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
        return false
    }

    func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
        return false
    }
}
