//
//  InventoryViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/3.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit
final class InventoryViewController: UIViewController {
    @IBOutlet private var tableView: UITableView!
    @IBOutlet private weak var pickerView: UIPickerView!
    @IBOutlet private weak var inventoryBtn: UIButton!
    @IBOutlet private weak var csvOutputBtn: UIBarButtonItem!
    @IBOutlet private weak var speedLabel: UILabel!
    @IBOutlet private weak var tagCountLabel: UILabel!
    @IBOutlet private weak var totalTagCountLabel: UILabel!
    @IBOutlet private weak var displayPcSwitch: UISwitch!
    @IBOutlet private weak var continuousModeSwitch: UISwitch!
    @IBOutlet private weak var reportRssiSwitch: UISwitch!
    @IBOutlet private weak var powerGainPickerTopView: UIView!
    @IBOutlet private weak var powerGainTextField: UITextField!
    @IBOutlet private weak var scrollView: UIScrollView!
    @IBOutlet private weak var scrollViewHeight: NSLayoutConstraint!
    @IBOutlet private weak var operationTimeTextField: UITextField!
    @IBOutlet private weak var optionButton: UIButton!
    @IBOutlet private weak var inventorySessionTextField: UITextField!
    @IBOutlet private weak var sessionFlagTextField: UITextField!
    @IBOutlet private var toDisableElems: [UIControl]!
    @IBOutlet private weak var reportTidSwitch: UISwitch!
    @IBOutlet private weak var tidLabel: UILabel!
    private enum PickerViewTag: Int {
        case pickerViewInventorySession = 0
        case pickerViewPowerGain = 1
        case pickerViewSessionFlag = 2
    }
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var systemSetting: SystemSetting! = SystemSetting.shared()
    private var databaseManeger: DatabaseManeger?
    private var mTotalTagCount: Int = 0
    private var mTotalTagCounts: Int = 0
    private var currentTagCount: Int = 0
    private var mLastTime: Double = 0
    private var mTagSpeed: Double = 0.0
    private var isReloadNeeded: Bool = false
    private var isCanScan: Bool = false
    private var isJapan: Bool = false
    private var maskType: MaskType?
    private var sessionFlag: SessionFlag?
    private var inventorySession: SessionType?
    private var aryTags: [AsTagItem] = []
    private var powerGainPickerData: [String] = []
    private var sessionFlagPickerData: [String] = []
    private var inventorySessionPickerData: [String] = []
    private var mapTags: [String: AsTagItem] = [:]
    private var sqlDic: [String: String] = [:]
    private var exportType: Int = 0
    private var isfinishedInitial: Bool = false
    override func viewDidLoad() {
        super.viewDidLoad()
        sessionFlagPickerData =  dataSessionFlag
        inventorySessionPickerData =  dataInvenTorySession
        isReloadNeeded = true
        databaseManeger?.insertOperation.maxConcurrentOperationCount = 1
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: loading)
        databaseManeger = DatabaseManeger.sharedDatabaseManeger
        databaseManeger?.getDatebaseQueue()?.inDatabase({database in
            if let arr = self.databaseManeger?.getAllAsTagItemsfmdb(database) as? [AsTagItem] {
                self.aryTags = arr
            }
        })
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
        if let inventorySes = asReaderGUNManager.mReader?.inventorySession {
            self.setInventorySession(inventorySes)
        }
        if let sessionFlag = asReaderGUNManager.mReader?.sessionFlag {
            self.setSessionFlag(sessionFlag)
        }
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        isfinishedInitial = false
        for item in aryTags {
            mapTags.updateValue(item, forKey: item.tag)
        }
        mTotalTagCount = 0
        mTotalTagCounts = 0
        for item in aryTags {
            mTotalTagCounts += Int(item.count)
        }
        mTagSpeed = 0.0
        isJapan = asReaderGUNManager.mReader?.regionName().hasPrefix("Japan") ?? false
        currentTagCount = 0
        speedLabel.text = "0 tps"
        reportRssiSwitch.isOn = false
        isCanScan = true
        if !isReloadNeeded {
            isfinishedInitial = true
            return
        }
        isReloadNeeded = true
        maskType = (asReaderGUNManager?.mReader?.maskTypeValue).map { MaskType(rawValue: MaskType.RawValue($0)) }
        asReaderGUNManager.mReader?.storedMode = false
        asReaderGUNManager.mReader?.reportMode = false
        initPowerGainPickerData()
        if let powerGain =  asReaderGUNManager.mReader?.powerGain {
            let nPower = powerGain
            self.setPowerGain((Int(nPower / 10)))
        }
         mLastTime = 0
        if let continuousMode = systemSetting?.getContinuousMode() {
           asReaderGUNManager.mReader?.continuousMode = continuousMode
            continuousModeSwitch.isOn = continuousMode
        }
        if let rssiMode = systemSetting?.getRssiMode() {
            asReaderGUNManager.mReader?.rssiMode = rssiMode
            reportRssiSwitch.isOn = rssiMode
        }
        displayPcSwitch.isOn = systemSetting.getDisPlayPC()
        if let operationTime = asReaderGUNManager.mReader?.operationTime {
            self.setOperationTime("\(operationTime)")
        }
        if let inventory = asReaderGUNManager.mReader?.inventorySession {
            self.setInventorySession(inventory)
        }
        if let sessionFlag = asReaderGUNManager.mReader?.sessionFlag {
            self.setSessionFlag(sessionFlag)
        }
        let length: Int = systemSetting.getTidLength()
        let strTid: String = String.init(format: "Report TID (len : %d word)", length)
        tidLabel.text = strTid
        reportTidSwitch.setOn(systemSetting.getTidOn(), animated: true)
        pickerView.reloadAllComponents()
        updateUI()
        isfinishedInitial = true
        AsReaderGUNManager.dismissGlobalHUD()
    }
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        if (asReaderGUNManager.mReader != nil) {
            asReaderGUNManager.mReader?.stopSync()
            enableControlByActionState()
        }
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        isReloadNeeded = true
        if segue.identifier == "ReadMemory" {
            let destinationController = segue.destination as? ReadMemoryViewController
            let indexPath = sender as? IndexPath
            if let index = indexPath?.row {
                destinationController?.maskValue = aryTags[index].tag
            }
        } else if segue.identifier == "WriteMemory" {
            let destinationController = segue.destination as? WriteMemoryViewController
            let indexPath = sender as? IndexPath
            if let index = indexPath?.row {
                destinationController?.maskValue = aryTags[index].tag
            }
        } else if segue.identifier == "LockMemory" {
            let destinationController = segue.destination as? TagAccessViewController
            let indexPath = sender as? IndexPath
            if let index = indexPath?.row {
                destinationController?.maskValue = aryTags[index].tag
            }
        } else  if segue.identifier == "inventoryExport" {
            let exportVC = segue.destination as? ExportTableViewController
            if exportType == 1 {
                exportVC?.exportType = "csvInven"
            } else {
                exportVC?.exportType = "excelInven"
            }
        }
    }
    @IBAction func prepare(forUnwind segue: UIStoryboardSegue) {
    }
    @IBAction private func powerGainBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewPowerGain.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        powerGainPickerTopView.isHidden = false
        guard let text = powerGainTextField.text else {
            return
        }
        guard text.isEmpty else {
            if let row = powerGainPickerData.firstIndex(of: text) {
                pickerView.selectRow(row, inComponent: 0, animated: false)
                return
            }
            pickerView.selectRow(0, inComponent: 0, animated: false)
            return
        }
    }
    @IBAction private func displayPcSwitchTapped(_ sender: UISwitch) {
        systemSetting.setDisPlayPC(displayPcSwitch.isOn)
        tableView.reloadData()
    }
    @IBAction private func continuousModeSwitchTapped(_ sender: UISwitch) {
        asReaderGUNManager.mReader?.continuousMode = continuousModeSwitch.isOn
        systemSetting.setContinuousMode(continuousModeSwitch.isOn)
    }
    @IBAction private func reportRssiSwitchTapped(_ sender: UISwitch) {
        asReaderGUNManager.mReader?.rssiMode = reportRssiSwitch.isOn
        systemSetting.setRssiMode(reportRssiSwitch.isOn)
        self.tableView.reloadData()
    }
    @IBAction private func inventoryBtnTapped(_ sender: UIButton) {
        if asReaderGUNManager.mReader?.getAction() == CommandStop {
            if reportTidSwitch.isOn
            {
                asReaderGUNManager.mReader?.inventory(withTidOffset: 0, length: Int32(systemSetting.getTidLength()), inventorySession: inventorySession!, sessionFlag: sessionFlag!)
            } else {
                asReaderGUNManager.mReader?.inventory()
            }
        } else {
            asReaderGUNManager.mReader?.stop()
        }
    }
    @IBAction private func clearBtnTapped(_ sender: UIButton) {
        aryTags.removeAll()
        mapTags.removeAll()
        tagCountLabel.text = "\(aryTags.count)"
        totalTagCountLabel.text = "\(aryTags.count)"
        speedLabel.text = "0 tps"
        mTagSpeed = 0.0
        mLastTime = 0
        mTotalTagCount = 0
        currentTagCount = 0
        mTotalTagCounts = 0
        databaseManeger?.insertOperation.cancelAllOperations()
        databaseManeger?.getDatebaseQueue()?.inTransaction({dataBase, rollback in
            if let result = self.databaseManeger?.deleteAll(asTagItemsFmdb: dataBase) {
                if !result {
                    let isRollback = rollback
                    isRollback.pointee = true
                }
            }
        })
        tableView.reloadData()
    }
    @IBAction private func maskBtnTapped(_ sender: UIButton) {
        if maskType == MaskType_NO_MASK {
            let alertController = UIAlertController(title: "",
                                                    message: "Please set the mask type in RFID Options menu before using mask.",
                                                    preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
            alertController.addAction(okAction)
            present(alertController, animated: true, completion: nil)
            return
        } else if maskType == MaskType_Selection {
            nowViewWillDisappear()
            performSegue(withIdentifier: "SelectionMask", sender: self)
        } else if maskType == MaskType_EPC {
            nowViewWillDisappear()
            performSegue(withIdentifier: "EpcMask", sender: self)
        }
        isReloadNeeded = false
    }
    @IBAction private func rfmSensorBtnTap(_ sender: UIButton) {
        title = "RFM Sensor (Beta)"
        asReaderGUNManager.mReader?.readRFMSensorTag()
    }
    @IBAction private func pickerCloseBtnTapped(_ sender: UIButton) {
        hidePickerView()
    }
    @IBAction private func powerGainPickerOkBtnTapped(_ sender: UIButton) {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewPowerGain {
                var idx: Int32 = Int32(pickerView.selectedRow(inComponent: 0))
                if let min = asReaderGUNManager.mReader?.powerGainRange().min {
                    idx += (min / 10)
                }
                self.setPowerGain(Int(idx))
                asReaderGUNManager.mReader?.powerGain = idx * 10
                systemSetting.setPowerGain(Int(idx * 10))
            } else if pickerViewTag == .pickerViewInventorySession {
                self.setInventorySession(SessionType(rawValue: SessionType.RawValue(pickerView.selectedRow(inComponent: 0))))
                if let inventory = inventorySession {
                    asReaderGUNManager.mReader?.inventorySession = inventory
                    systemSetting.setInventorySession(Int(inventory.rawValue))
                }
            } else if pickerViewTag == .pickerViewSessionFlag {
                self.setSessionFlag(SessionFlag(rawValue: SessionFlag.RawValue(pickerView.selectedRow(inComponent: 0))))
                if let aSessionFlag = sessionFlag {
                    asReaderGUNManager.mReader?.sessionFlag = aSessionFlag
                    systemSetting.setSessionFlag(Int(aSessionFlag.rawValue))
                }
            }
        }
        hidePickerView()
    }
    @IBAction private func operationTimeBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Operation Time:", message: "Please enter operation time.\n(ex: 30 ms)", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var value = alertController.textFields?.first?.text
            guard let text = value else {
                return
            }
            if text.isEmpty {
                value = "0"
            }
            if let aValue = value {
                self.setOperationTime(aValue)
                self.asReaderGUNManager.mReader?.operationTime = Int32(aValue) ?? 0
                self.systemSetting.setOperationTime(Int(aValue) ?? 0)
            }
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func csvOutputBtnTapped(_ sender: UIBarButtonItem) {
        let alertController = UIAlertController(title: nil, message: nil, preferredStyle: .actionSheet)
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let csvAction = UIAlertAction(title: "CSV Export", style: .default, handler: { _ in
            self.csvExport()
        })
        let excelAction = UIAlertAction(title: "Excel Export", style: .default, handler: { _ in
            self.excelExport()
        })
        let excelListAction = UIAlertAction(title: "Excel List", style: .default, handler: { _ in
            self.replaceDB()
            self.inventoryBtn .setTitle("Inventory", for: .normal)
            self.mLastTime = 0
            self.currentTagCount = self.mTotalTagCount
            for value in self.toDisableElems {
                value.isEnabled = true
            }
            self.csvOutputBtn.isEnabled = true
            self.tableView.isUserInteractionEnabled = true
            self.exportType = 2
            self.performSegue(withIdentifier: "inventoryExport", sender: nil)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(csvAction)
        alertController.addAction(excelAction)
        alertController.addAction(excelListAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction private func backBtnTapped(_ sender: UIButton) {
        nowViewWillDisappear()
        navigationController?.popViewController(animated: true)
    }
    @IBAction private func onClickOptionButton(_ sender: UIButton) {
        if self.scrollView.isHidden == true {
            self.scrollView.isHidden = false
        } else {
            self.scrollView.isHidden = true
        }
    }
    @IBAction private func onClickInventorySessionButton(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewInventorySession.rawValue
        pickerView.reloadAllComponents()
        if let inventoryRaw =  inventorySession?.rawValue {
            pickerView.selectRow(Int(inventoryRaw), inComponent: 0, animated: false)
        }
        pickerView.isHidden = false
        powerGainPickerTopView.isHidden = false
    }
    @IBAction private func onClickSessionFlagButton(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewSessionFlag.rawValue
        pickerView.reloadAllComponents()
        if let sessionValue = sessionFlag?.rawValue {
            pickerView.selectRow(Int(sessionValue), inComponent: 0, animated: false)
        }
        pickerView.isHidden = false
        powerGainPickerTopView.isHidden = false
    }
    @IBAction private func displayTidSwitchTapped(_ sender: Any) {
        systemSetting?.setTidOn(reportTidSwitch.isOn)
        if(reportTidSwitch.isOn)
        {
            let alert = UIAlertController(title: "TID Length:",
                                          message: "Please enter TID length(word).\n(ex:1 word = 2byte )",
                                          preferredStyle: .alert)
            alert.addTextField { (textField: UITextField!) in
                textField.keyboardType = .numberPad
            }
            alert.addAction(UIAlertAction(title: ok, style: .default, handler: { _ in
                var len: Int = 1
                let value: String = (alert.textFields?.first?.text)!
                let newValue: Int = Int(value) ?? 0
                if newValue < 1 {
                    len = 1
                } else {
                    len = newValue
                }
                self.systemSetting?.setTidLength(len)
                let strTid: String = String.init(format: "Report TID (len : %d word)", len)
                self.tidLabel.text = strTid
            }))
            alert.addAction(UIAlertAction(title: cancel, style: .cancel, handler: { _ in
            }))
            present(alert, animated: true)
            
        }
    }
}
// MARK: - UITableViewDelegate, UITableViewDataSource
extension InventoryViewController: UITableViewDelegate, UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return aryTags.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "InventoryCell", for: indexPath) as? InventoryTableViewCell
        var item: AsTagItem?
        item = aryTags[indexPath.row]
        if item != nil {
            if displayPcSwitch.isOn {
                if let tagStr = item?.tag {
                    let tagLabelStr = String(format: "%@ ", RainTagHelper.getPCStringData(tagStr))
                    cell?.setTagValue(tagLabelStr)
                    
                    let epcLabelStr = String(format: "%@ ", RainTagHelper.getEPCStringData(tagStr))
                    cell?.setEPCValue(epcLabelStr)
                } else {
                    return UITableViewCell()
                }
            } else {
                if let tagStr = item?.tag {
                    let tagLabelStr = String(format: "%@", RainTagHelper.getEPCStringData(tagStr))
                    cell?.setTagValue(tagLabelStr)
                    cell?.setEPCValue("")
                } else {
                    return UITableViewCell()
                }
            }
            if let aCount = item?.count {
                cell?.setCountValue("\(aCount)")
            }
            if let tid = item?.tid {
                cell?.setTidValue("\(tid)")
            }
            if reportRssiSwitch.isOn {
                if let arssi = item?.rssi, let aPhase = item?.phase, let aFrequency = item?.frequency {
                    cell?.setRssiValue(String(format: "%.1f dB", arssi))
                    cell?.setPhaseValue(String(format: "%.0f˚", aPhase))
                    cell?.setFrequencyValue(String(format: "%.2fMHz ", aFrequency))
                } else {
                    cell?.setRssiValue("")
                    cell?.setPhaseValue("")
                    cell?.setFrequencyValue("")
                }
            } else {
                cell?.setRssiValue("")
                cell?.setPhaseValue("")
                cell?.setFrequencyValue("")
            }
        }
        
        guard let aCell = cell else {
            return UITableViewCell()
        }
        return aCell
    }
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if asReaderGUNManager?.mReader?.getAction() != CommandStop {
            return
        }
        let alert = UIAlertController(title: "Additional Actions",
                                      message: "You can choose one of the following actions for this Tag",
                                      preferredStyle: .alert)
        alert.addAction(UIAlertAction(title: "Read Memory", style: .default, handler: { _ in
            self.nowViewWillDisappear()
            self.performSegue(withIdentifier: "ReadMemory", sender: indexPath)
        }))
        alert.addAction(UIAlertAction(title: "Write Memory", style: .default, handler: { _ in
            self.nowViewWillDisappear()
            self.performSegue(withIdentifier: "WriteMemory", sender: indexPath)
        }))
        alert.addAction(UIAlertAction(title: "Lock Memory", style: .default, handler: { _ in
            self.nowViewWillDisappear()
            self.performSegue(withIdentifier: "LockMemory", sender: indexPath)
        }))
        alert.addAction(UIAlertAction(title: cancel, style: .cancel, handler: { _ in
        }))
        present(alert, animated: true)
    }
}
// MARK: - UIPickerViewDelegate, UIPickerViewDataSource
extension InventoryViewController: UIPickerViewDataSource, UIPickerViewDelegate {
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewPowerGain {
                return powerGainPickerData.count
            } else if pickerViewTag == .pickerViewInventorySession {
                return inventorySessionPickerData.count
            } else if pickerViewTag == .pickerViewSessionFlag {
                return sessionFlagPickerData.count
            }
        }
        return 0
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewPowerGain {
                return powerGainPickerData[row]
            } else if pickerViewTag == .pickerViewInventorySession {
                return inventorySessionPickerData[row]
            } else if pickerViewTag == .pickerViewSessionFlag {
                return sessionFlagPickerData[row]
            }
        }
        
        return "None"
    }
}
// MARK: - UITextFieldDelegate
extension InventoryViewController: UITextFieldDelegate {
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let text = textField.text ?? ""
        let length = text.count + string.count - range.length
        return length <= 9
    }
}
// MARK: - Custom
extension InventoryViewController {
    private func updateUI() {
        tagCountLabel.text = "\(aryTags.count)"
        totalTagCountLabel.text = "\(mTotalTagCounts)"
        speedLabel.text = String(format: "%0.2f tps", mTagSpeed)
        tableView.reloadData()
    }
    private func initPowerGainPickerData() {
        var tmpArray: [String] = []
        if let min = asReaderGUNManager.mReader?.powerGainRange().min,
            let max = asReaderGUNManager.mReader?.powerGainRange().max {
            var index: Int = Int(min)
            while index <= max {
                tmpArray.append(String(format: "%i.0 dB", index / 10))
                index += 10
            }
        }
        powerGainPickerData = tmpArray
    }
    private func hidePickerView() {
        powerGainPickerTopView.isHidden = true
        pickerView.isHidden = true
    }
    @objc private func changStatus() {
        isCanScan = true
    }
    private func enableControlByActionState() {
        if asReaderGUNManager.mReader?.getAction() == CommandStop {
            replaceDB()
            inventoryBtn.setTitle("Inventory", for: .normal)
            mLastTime = 0
            currentTagCount = mTotalTagCount
            for value in toDisableElems {
                value.isEnabled = true
            }
            csvOutputBtn.isEnabled = true;
            tableView.isUserInteractionEnabled = true;
        }
    }
    private func nowViewWillDisappear() {
        replaceDB()
        if let operationCount = databaseManeger?.insertOperation.operationCount {
            if operationCount > 0 {
                AsReaderGUNManager.dismissGlobalHUD()
                AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Data Insert...")
                CATransaction.commit()
                print("wait")
                while true {
                    Thread.sleep(forTimeInterval: 0.5)
                    if databaseManeger?.insertOperation.operationCount == 0 {
                        print("wait")
                        break
                    }
                }
                AsReaderGUNManager.dismissGlobalHUD()
                CATransaction.commit()
            } else {
                return
            }
        } else {
            return
        }
    }
    private func replaceDB() {
        databaseManeger?.insertOperation.addOperation({
            self.databaseManeger?.getDatebaseQueue()?.inTransaction({ database, rollback in
                for item in self.aryTags {
                    let tagString: String = item.tag
                    let countString: String = String.init(format: "%d", item.count)
                    let rssiString: String = String.init(format: "%f", item.rssi)
                    let phaseString: String = String.init(format: "%f", item.phase)
                    let frequencyString: String = String.init(format: "%f", item.frequency)
                    let dateTimeString: String = item.dateTime
                    let tidString: String = item.tid
                    let sql: String = "REPLACE INTO AsTagItem(tag, count, rssi, phase, frequency, datetime, tid) VALUES ('\(tagString)','\(countString)','\(rssiString)','\(phaseString)','\(frequencyString)','\(dateTimeString)','\(tidString)')"
                    if let result = self.databaseManeger?.updataOrAddSql(sql, fmdb: database) {
                        if !result {
                            let isRollback = rollback
                            isRollback.pointee = true
                        }
                    }
                }
            })
        })
    }
    private func csvExport() {
        DispatchQueue.main.async {
            var rfidCount: Int = 0
            for index in 0..<self.aryTags.count {
                let item: AsTagItem = self.aryTags[index]
                if !item.tag.isEmpty {
                    rfidCount += 1
                }
            }
            let timeString: String = self.currentData()
            let fileName: String = String.init(format: "rfid_%@.csv", timeString)
            if rfidCount != 0 {
                if CSVData.isFileExist(fileName) {
                    CSVData.deleteFile(forFileName: fileName)
                }
                CSVData.createCSV(withFileName: fileName)
                CSVData.exportRfidCSV(fileName, withArray: self.aryTags, isEpc: self.displayPcSwitch.isOn, isRSSI: self.reportRssiSwitch.isOn, isTid: self.reportTidSwitch.isOn)
            } else {
                return
            }
        }
    }
    
    private func excelExport() {
        DispatchQueue.main.async {
            if (self.aryTags.count != 0) {
                let timeString: String = self.currentData()
                let fileName: String = String.init(format: "rfid_%@.xlsx", timeString)

                let array: NSMutableArray = NSMutableArray.init()
                for item in self.aryTags {
                    let fruits = ["tag":item.tag, "dateTime":item.dateTime, "count":String.init(format: "%d", item.count), "rssi":String.init(format: "%.2f", item.rssi) , "tid":item.tid] as [String : Any]
                    array.add(fruits)
                }
                let arr: Array = Array(array)
                ExcelData.createExcel(withFileName: fileName, export: rfidExportType)
                ExcelData.exportRfidExcel(fileName, with: arr, export: rfidExportType, isEpc: self.displayPcSwitch.isOn, isRssi: self.reportRssiSwitch.isOn, isTid: self.reportTidSwitch.isOn)
            }
        }
    }
    
    private func currentData() -> String {
        let today: Date = Date.init()
        let df: DateFormatter = DateFormatter.init()
        df.dateFormat = "yyyyMMddHHmmss"
        let str: String = df.string(from: today)
        return str;
    }
}

// MARK: - AsReaderGUNManagerDelegate
extension InventoryViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == false {
            DispatchQueue.main.async {
                self.nowViewWillDisappear()
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNReadTag(_ tag: String?, rssi: Float, phase: Float, frequency: Float) {
        if reportTidSwitch.isOn
        {
            return
        }
        let rssiBlock: Float = rssi
        let phaseBlock: Float = phase
        let frequencyBlock: Float = frequency
        let queue = DispatchQueue(label: "queue")
        queue.async {
            let time = CFAbsoluteTimeGetCurrent()
            var interval: Double = 0.0
            self.mTotalTagCount += 1
            self.mTotalTagCounts += 1
            if self.mLastTime == 0 {
                self.mTagSpeed = 0.0
                self.mLastTime = time
            } else {
                interval = Double(time - self.mLastTime)
                if interval != 0 {
                    self.mTagSpeed = Double(self.mTotalTagCount - self.currentTagCount) / interval
                }
            }
            var item: AsTagItem?
            let lockQueue = DispatchQueue(label: "self")
            lockQueue.sync {
                DispatchQueue.main.async {
                    let newData: String = RainTagHelper.convertUniqueStringDataTag(tag!)
                    item = self.mapTags[newData]
                    if let aItem = item {
                        item?.count = aItem.count + 1
                        item?.updateRssi(rssiBlock, withPhase: phaseBlock, frequency: frequencyBlock)
                    } else {
                        item = AsTagItem.item(with: tag, rssi: rssiBlock, phase: phaseBlock, frequency: frequencyBlock, tid:"") as? AsTagItem
                        if let aItem = item {
                            self.aryTags.append(aItem)
                            self.mapTags.updateValue(aItem, forKey: newData)
                        }
                    }
                    self.tagCountLabel.text = "\(self.aryTags.count)"
                    self.totalTagCountLabel.text = "\(self.mTotalTagCounts)"
                    self.speedLabel.text = String(format: "%0.2f tps", self.mTagSpeed)
                    self.tableView.reloadData()
                }
            }
        }
    }
    func asReaderGUNReadTag(withTid error: ResultCode, actionState action: CommandType, epc: String!, tid data: String!, rssi: Float, phase: Float, frequency: Float) {
        if (error != ResultNoError) {
            return
        }
        let rssiBlock: Float = rssi
        let phaseBlock: Float = phase
        let frequencyBlock: Float = frequency
        let queue = DispatchQueue(label: "queue")
        queue.async {
            let time = CFAbsoluteTimeGetCurrent()
            var interval: Double = 0.0
            self.mTotalTagCount += 1
            self.mTotalTagCounts += 1
            if self.mLastTime == 0 {
                self.mTagSpeed = 0.0
                self.mLastTime = time
            } else {
                interval = Double(time - self.mLastTime)
                if interval != 0 {
                    self.mTagSpeed = Double(self.mTotalTagCount - self.currentTagCount) / interval
                }
            }
            var item: AsTagItem?
            let lockQueue = DispatchQueue(label: "self")
            lockQueue.sync {
                if let aTag = epc {
                    item = self.mapTags[aTag]
                }
                if let aItem = item {
                    item?.count = aItem.count + 1
                    item?.updateRssi(rssiBlock, withPhase: phaseBlock, frequency: frequencyBlock)
                } else {
                    item = AsTagItem.item(with: epc, rssi: rssiBlock, phase: phaseBlock, frequency: frequencyBlock, tid: data) as? AsTagItem
                    if let aItem = item {
                        self.aryTags.append(aItem)
                        self.mapTags.updateValue(aItem, forKey: epc ?? "")
                    }
                }
                DispatchQueue.main.async {
                    self.tagCountLabel.text = "\(self.aryTags.count)"
                    self.totalTagCountLabel.text = "\(self.mTotalTagCounts)"
                    self.speedLabel.text = String(format: "%0.2f tps", self.mTagSpeed)
                    self.tableView.reloadData()
                }
            }
        }
    }
    func asReaderGUNReadTagWithRFM(_ error: ResultCode, action: CommandType, epc: String!, rssi: Float, phase: Float, frequency: Float, tid: String!, tempCode: String!, calibration: String!, sensorCode: String!) {
        let tempV: String = RFMHelper.calculationTemp(tempCode, calibration: calibration)
        let sensorCodeV: String = RFMHelper.calculationSensorCode(sensorCode, tid: tid)
        let tidString: String = String(format: "Temp Val :%@ °C - Scode(Moisture)  :%@\n tid:%@ tc:%@ cal:%@ sc:%@", tempV,sensorCodeV,tid ?? "",tempCode ?? "",calibration ?? "",sensorCode ?? "")
        let rssiBlock: Float = rssi
        let phaseBlock: Float = phase
        let frequencyBlock: Float = frequency
        let queue = DispatchQueue(label: "queue")
        queue.async {
            let time = CFAbsoluteTimeGetCurrent()
            var interval: Double = 0.0
            self.mTotalTagCount += 1
            self.mTotalTagCounts += 1
            if self.mLastTime == 0 {
                self.mTagSpeed = 0.0
                self.mLastTime = time
            } else {
                interval = Double(time - self.mLastTime)
                if interval != 0 {
                    self.mTagSpeed = Double(self.mTotalTagCount - self.currentTagCount) / interval
                }
            }
            var item: AsTagItem?
            let lockQueue = DispatchQueue(label: "self")
            lockQueue.sync {
                DispatchQueue.main.async {
                    if let aTag = epc {
                        item = self.mapTags[aTag]
                    }
                    if let aItem = item {
                        item?.count = aItem.count + 1
                        item?.updateRssi(rssiBlock, withPhase: phaseBlock, frequency: frequencyBlock, data:tidString)
                    } else {
                        item = AsTagItem.item(with: epc, rssi: rssiBlock, phase: phaseBlock, frequency: frequencyBlock, tid: tidString) as? AsTagItem
                        if let aItem = item {
                            self.aryTags.append(aItem)
                            self.mapTags.updateValue(aItem, forKey: epc ?? "")
                        }
                    }
                    self.tagCountLabel.text = "\(self.aryTags.count)"
                    self.totalTagCountLabel.text = "\(self.mTotalTagCounts)"
                    self.speedLabel.text = String(format: "%0.2f tps", self.mTagSpeed)
                    self.tableView.reloadData()
                }
            }
        }
    }
    func asReaderGUNChangedActionState(_ action: CommandType, resultCode: Int) {
        if action == CommandStop {
            for value in toDisableElems {
                value.isEnabled = false
            }
            reportTidSwitch.isEnabled = true
            replaceDB()
            Thread.sleep(forTimeInterval: 0.3)
            title = "Inventory"
            inventoryBtn.setTitle("Inventory", for: .normal)
            mLastTime = 0
            currentTagCount = mTotalTagCount
            for value in toDisableElems {
                value.isEnabled = true
            }
            csvOutputBtn.isEnabled = true
            tableView.isUserInteractionEnabled = true
            if resultCode == Int(ResultNoError.rawValue) {
                isCanScan = true
                NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(changStatus), object: nil)
            } else {
                isCanScan = false
                NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(changStatus), object: nil)
                perform(#selector(changStatus), with: nil, afterDelay: 1.0)
            }
        } else {
            if action == CommandInventory {
                for value in toDisableElems {
                    value.isEnabled = true
                }
                reportTidSwitch.isEnabled = false
            }
            if resultCode == Int(ResultNoError.rawValue) {
                inventoryBtn.setTitle("Stop", for: .normal)
                for value in toDisableElems {
                    value.isEnabled = false
                }
                csvOutputBtn.isEnabled = true
                tableView.isUserInteractionEnabled = false
            }
        }
    }
    func asReaderGUNUpdateDeviceState(_ error: ResultCode) {
        let err: String = String.init(format: "%04x", error as! CVarArg)
        print("ErrorCode ==== " + err)
    }
    func asReaderGUNOnResetReader() {
        DispatchQueue.main.async {
            let alertController = UIAlertController(title: "", message: "Device must be rebooted due to packet loss.", preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .cancel, handler: nil)
            alertController.addAction(okAction)
            self.present(alertController, animated: true, completion: nil)
        }
    }
    func asReaderGUNOnModuleOverHeated() {
        DispatchQueue.main.async {
            let alertController = UIAlertController(title: "", message: "The RFID module is overheating. Please pause reading until it cools off.", preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .cancel, handler: nil)
            alertController.addAction(okAction)
            self.present(alertController, animated: true, completion: nil)
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        if isfinishedInitial == false {
            return false
        }
        if asReaderGUNManager.mReader?.getScanMode() == RFIDScanMode {
            if status {
                if isCanScan {
                    if reportTidSwitch.isOn
                    {
                       asReaderGUNManager.mReader?.inventory(withTidOffset: 0, length: Int32(systemSetting.getTidLength()), inventorySession: inventorySession!, sessionFlag: sessionFlag!)
                    } else {
                        asReaderGUNManager.mReader?.inventory()
                    }
                }
            } else {
                asReaderGUNManager.mReader?.stop()
            }
            return false
        } else {
            return true
        }
    }
    
    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
}

// MARK: - Setters
extension InventoryViewController {
    private func setInventorySession(_ inventorySession: SessionType) {
        let index: Int = Int(inventorySession.rawValue)
        inventorySessionTextField.text = inventorySessionPickerData[index]
        self.inventorySession = inventorySession
    }
    private func setPowerGain(_ power: Int) {
        let value = String(format: "%li.0 dB", power)
        if powerGainPickerData.contains(value) {
            if let index = powerGainPickerData.firstIndex(of: value) {
                if powerGainPickerData.count > index {
                    powerGainTextField.text = powerGainPickerData[index]
                }
            }
        }
    }
    private func setSessionFlag(_ sessionFlag: SessionFlag) {
        let index: Int = Int(sessionFlag.rawValue)
        sessionFlagTextField.text = sessionFlagPickerData[index]
        self.sessionFlag = sessionFlag
    }
    private func setOperationTime(_ operationTime: String?) {
        operationTimeTextField.text = operationTime
    }
}
