//
//  EpcMaskViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/9.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class EpcMaskViewController: UIViewController {
    @IBOutlet private weak var tableView: UITableView!
    @IBOutlet private weak var saveBtn: UIButton!
    @IBOutlet private weak var cancelBtn: UIButton!
    @IBOutlet private weak var addBarButtonItem: UIBarButtonItem!
    @IBOutlet private weak var matchModeSwitch: UISwitch!
    private var isEditCell = false
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var systemSetting: SystemSetting! = SystemSetting.shared()
    private lazy var maskData: [AsSelectMaskEPCParam] = {
        return []
    }()
    override func viewDidLoad() {
        super.viewDidLoad()
        enableActionWidgets(false)
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: loading)
        if asReaderGUNManager.mReader == nil {
            AsReaderGUNManager.dismissGlobalHUD()
            return
        }
        initLoadMask()
        let matchMode: Bool = asReaderGUNManager.mReader?.epcMaskMatchMode ?? false
        matchModeSwitch.isOn = matchMode
        AsReaderGUNManager.dismissGlobalHUD()
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
        isEditCell = false
    }
    override  func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
    }
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == "EpcMaskCell" {
            let epcVC  = segue.destination as? EpcMaskEditViewController
            var indexPath: IndexPath?
            if let aSender = sender as? UITableViewCell {
                indexPath = tableView.indexPath(for: aSender)
            }
            let index = indexPath?.row ?? 0
            epcVC?.selectMaskParam = maskData[index]
            isEditCell = true
        }
    }
    @IBAction func prepare(forUnwind segue: UIStoryboardSegue) {
        let sourceViewController  = segue.source as? EpcMaskEditViewController
        if !isEditCell {
            if let aParam = sourceViewController?.selectMaskParam {
                maskData.append(aParam)
            }
        }
        tableView.reloadData()
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    @IBAction func saveBtnTapped(_ sender: UIButton) {
        enableActionWidgets(false)
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Saving...")
        asReaderGUNManager.mReader?.clearEpcMask()
        for mask in maskData {
            asReaderGUNManager.mReader?.addEpcMask(mask)
        }
        if matchModeSwitch.isOn {
            asReaderGUNManager.mReader?.epcMaskMatchMode = true
            systemSetting.setEpcMaskMatchMode(true)
        } else {
            asReaderGUNManager.mReader?.epcMaskMatchMode = false
            systemSetting.setEpcMaskMatchMode(false)
        }
        systemSetting.setSelectionEpcMaskData(maskData)
        enableActionWidgets(true)
        AsReaderGUNManager.dismissGlobalHUD()
        let alertController = UIAlertController(title: "Success",
                                                message: "Saved successfully",
                                                preferredStyle: .alert)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            self.navigationController?.popViewController(animated: true)
        })
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
}
// MARK: - UITableViewDelegate, UITableViewDataSource
extension EpcMaskViewController: UITableViewDataSource, UITableViewDelegate {
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return maskData.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "EpcMaskCell", for: indexPath) as? EpcMaskTableViewCell
        let maskParam = maskData[indexPath.row]
        cell?.setOffsetValue("\(maskParam.offset) bit")
        cell?.setLengthValue("\(maskParam.length) bit")
        cell?.setMaskValue(maskParam.mask)
        guard let aCell = cell else {
            return UITableViewCell()
        }
        return aCell
    }
    func tableView(_ tableView: UITableView, editingStyleForRowAt indexPath: IndexPath) -> UITableViewCell.EditingStyle {
        return .delete
    }
    func tableView(_ tableView: UITableView, commit editingStyle: UITableViewCell.EditingStyle, forRowAt indexPath: IndexPath) {
        maskData.remove(at: indexPath.row)
        tableView.reloadData()
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension EpcMaskViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == true {
            DispatchQueue.main.async {
                self.viewDidAppear(true)
            }
        } else {
            DispatchQueue.main.async {
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        return false
    }
    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
}

// MARK: - Custom
extension EpcMaskViewController {
    func initLoadMask() {
        var param: AsSelectMaskEPCParam?
        if let count = asReaderGUNManager.mReader?.epcMaskCount() {
            for index in 0..<count {
                param = asReaderGUNManager.mReader?.getEpcMask(Int32(index))
                if let aParam = param {
                    maskData.append(aParam)
                }
            }
            tableView.reloadData()
            enableActionWidgets(true)
        }
    }
    func enableActionWidgets(_ enabled: Bool) {
        let count = Int(maskData.count)
        addBarButtonItem.isEnabled = enabled && count < MAX_SELECTION_MASK
        saveBtn.isEnabled = enabled
        cancelBtn.isEnabled = enabled
    }
}
