//
//  BarcodeOptionViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/12.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class BarcodeOptionViewController: UIViewController {
    @IBOutlet private weak var tableView: UITableView!
    @IBOutlet weak var customPrefixSuffixSwitch: UISwitch!
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var systemSetting: SystemSetting! = SystemSetting.shared()
    private var barcodeParamData: [AsParamValue] = []
    override func viewDidLoad() {
        super.viewDidLoad()
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: loading)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
        if asReaderGUNManager.mReader != nil {
            guard let isRFIDModule = asReaderGUNManager.mReader?.isRFIDModule() else { return}
            if !isRFIDModule {
                let rightItem = UIBarButtonItem(title: "Setting",
                                                style: .done,
                                                target: self,
                                                action: #selector(setting))
                navigationItem.rightBarButtonItem = rightItem
            }
        }
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.mReader?.setScanMode(BarcodeScanMode)
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(true)
        asReaderGUNManager.mReader?.setPropBarcodeMode(true)
        let paramData: [ParamName] = [Codabar, Code39, Code32Pharmaceutical, I2of5,
                                      NEC2of5, Code93, R2of5,
                                      A2of5, X2of5, Code11, Code128,
                                      GS1128, Telepen, UPCA, UPCACouponCode,
                                      CouponGS1DataBarOutput, UPCE0, UPCE1, EAN8,
                                      EAN13, MSI, RSS14, RSSLimit,
                                      RSSExp, TriopticCode, CodablockA, CodablockF,
                                      PDF417, MacroPDF417, MicroPDF, ComCode, GS1Emulation, TLC39, QRCode, Matrix, MaxiCode, AztecCode, HanXinCode, PostalCodes, ChinaPost, KoreaPost]
        var arrParam: [AsParamValue] = []
        for paramName in paramData {
            let paramNameNum: NSNumber = NSNumber.init(value: Int64(paramName.rawValue))
            let asParamValue: AsParamValue = (asReaderGUNManager.mReader?.getBarcodeParam(paramNameNum))!
                arrParam.append(asParamValue)
        }
        if let barcodePar =  systemSetting.getBarcodeParamData() {
            if barcodePar.isEmpty {
                barcodeParamData = barcodePar
            } else {
                barcodeParamData = arrParam
            }
        } else {
            barcodeParamData = arrParam
        }
        tableView.reloadData()
        
        if(systemSetting.getCustomPrefixSuffix()){
            customPrefixSuffixSwitch.setOn(true, animated: true)
            asReaderGUNManager.mReader?.setBarcodeMode(true, isKeyAction: true, isCustomPreSuffixOn: customPrefixSuffixSwitch.isOn, type:Temporary)

        }else{
            customPrefixSuffixSwitch.setOn(false, animated: false)
            asReaderGUNManager.mReader?.setBarcodeMode(true, isKeyAction: true, isCustomPreSuffixOn: customPrefixSuffixSwitch.isOn, type:Temporary)
        }
        AsReaderGUNManager.dismissGlobalHUD()
    }
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        if (asReaderGUNManager.mReader != nil) {
            asReaderGUNManager.mReader?.setScanMode(RFIDScanMode)
            asReaderGUNManager.mReader?.setBarcodeMode(false, isKeyAction: false, isCustomPreSuffixOn:systemSetting.getCustomPrefixSuffix(), type:Temporary)
        }
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    @IBAction private func defaultAllSymBtnTapped(_ sender: UIButton) {
        for paramValue in barcodeParamData {
            switch paramValue.paramName {
            case UPCA, UPCE0, EAN8, EAN13, Code128, Code39, Code93, I2of5, Codabar, PDF417, MacroPDF417, MaxiCode, QRCode, AztecCode, NEC2of5, GS1128, RSS14, ComCode:
                paramValue.setEnabled(true)
            case UPCE1, Code11, MSI, X2of5, MicroPDF, Matrix, R2of5, A2of5, Telepen, RSSLimit, RSSExp, TriopticCode, CodablockA, CodablockF, TLC39, ChinaPost, KoreaPost, HanXinCode:
                paramValue.setEnabled(false)
            default:
                break
            }
        }
        tableView.reloadData()
    }
    @IBAction private func disableAllSymBtnTapped(_ sender: UIButton) {
        for paramValue in barcodeParamData {
            paramValue.setEnabled(false)
        }
        tableView.reloadData()
    }
    @IBAction private func enableAllSymBtnTapped(_ sender: UIButton) {
        for paramValue in barcodeParamData {
            paramValue.setEnabled(true)
        }
        tableView.reloadData()
    }
    @IBAction private func saveSymBtnTapped(_ sender: UIButton) {
        var resultCode = ResultNoError
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Saving...")
        for  paramName: AsParamValue in barcodeParamData {
            resultCode = asReaderGUNManager.mReader?.setBarcodeParam(paramName, type:Permanent) ?? ResultNoError
            if resultCode != ResultNoError {
                AsReaderGUNManager.dismissGlobalHUD()
                return
            }
        }
        AsReaderGUNManager.dismissGlobalHUD()
        if resultCode == ResultNoError {
            let alertController = UIAlertController(title: "Success",
                                                    message: "Saved successfully",
                                                    preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
            alertController.addAction(okAction)
            present(alertController, animated: true, completion: nil)
        } else {
            let alertController = UIAlertController(title: "Error",
                                                    message: "Failed to save",
                                                    preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
            alertController.addAction(okAction)
            present(alertController, animated: true, completion: nil)
        }
        systemSetting.setBarcodeParamData(barcodeParamData)
    }
    
    @IBAction private func defaultPrefixSuffixSwitchAction(_ sender: UISwitch) {
        //OFF : Default preffix  ON : User Preffix
        systemSetting?.setCustomPrefixSuffix(customPrefixSuffixSwitch.isOn)
        asReaderGUNManager.mReader?.setBarcodeMode(true, isKeyAction: true, isCustomPreSuffixOn: customPrefixSuffixSwitch.isOn, type:Temporary)
        var title: String = ""
        var message: String = ""
        if (customPrefixSuffixSwitch.isOn) {
            title = "Enable"
            message = "Set prefix/suffix following the barcode setting manual."
        } else {
            title = "Disable"
            message = "Custom prefix/suffix setting is unnecessary."
        }
        let alertController = UIAlertController(title: title,
                                                message: message,
                                                preferredStyle: .alert)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
        })
        alertController.addAction(okAction)
        self.present(alertController, animated: true, completion: nil)
    }
}
// MARK: - Custom
extension BarcodeOptionViewController {
    @objc private func setting() {
        let barcodeViewController = storyboard?.instantiateViewController(withIdentifier: "BarcodeOptionVC") as? BarcodeOptionVC
        if let aController = barcodeViewController {
            navigationController?.pushViewController(aController, animated: true)
        }
    }
    @objc private func asReaderGUNDisconnected(_ notification: Notification?) {
        DispatchQueue.main.async {
            self.asReaderGUNManager?.mReader = nil
            AsReaderGUNManager.dismissGlobalHUD()
            self.navigationController?.popToRootViewController(animated: true)
        }
    }
}
// MARK: - UITableViewDelegate, UITableViewDataSource
extension BarcodeOptionViewController: UITableViewDelegate, UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return barcodeParamData.count
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = (tableView.dequeueReusableCell(withIdentifier: "BarcodeCell", for: indexPath)) as UITableViewCell
        let paramValue = barcodeParamData[indexPath.row]
        cell.textLabel?.text = AsParamName.getName(paramValue.paramName)
        if paramValue.value != 0 {
            cell.accessoryType = .checkmark
        } else {
            cell.accessoryType = .none
        }
        return cell
    }
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cell: UITableViewCell! = tableView.cellForRow(at: indexPath)
        let paramValue = barcodeParamData[indexPath.row]
        if cell.accessoryType == .checkmark {
            cell.accessoryType = .none
            paramValue.value = 0
        } else {
            cell.accessoryType = .checkmark
            paramValue.value = 1
        }
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension BarcodeOptionViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == false {
            DispatchQueue.main.async {
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        return false
    }
    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
        let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
        let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
        if  rfidModule && barcodeModule {
            return true
        } else {
            return false
        }
    }
    func asReaderGUNUpdateDeviceState(_ error: ResultCode) {
        if error != ResultNoError {
            DispatchQueue.main.async {
                let alertController = UIAlertController(title: "Error",
                                                        message: "Failed to get response. Try again.",
                                                        preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
                    self.navigationController?.popViewController(animated: true)
                })
                alertController.addAction(okAction)
                self.present(alertController, animated: true, completion: nil)
            }
        }
    }
}
