//
//  RainTagHelper.swift
//  AsReaderGUN
//
//  Created by Songxueqian on 2022/3/2.
//  Copyright © 2022 Asterisk. All rights reserved.
//

import UIKit
import Foundation

final class RainTagHelper: NSObject {
    class func getPC(_ rawData: Data) -> String {
        let bytePtr = [UInt8](rawData)
        var pc: String = ""
        if ((bytePtr[0] & 0x02) != 0)
        {
            if ((bytePtr[2] & 0x01) == 0x01)
            {
                pc = String(format: "PC:%02X%02X%02X%02X%02X%02X", bytePtr[0],bytePtr[1],bytePtr[2],bytePtr[3],bytePtr[4],bytePtr[5])
            }
            else
            {
                pc = String(format: "PC:%02X%02X%02X%02X", bytePtr[0],bytePtr[1],bytePtr[2],bytePtr[3])
            }
        }
        else{
            pc = String(format: "PC:%02X%02X", bytePtr[0],bytePtr[1])
        }
        return pc;
    }
    class func getEPC(_ rawData: Data) -> String {
        let bytePtr = [UInt8](rawData)
        var startEPC: Int = 0
        var epc: String = ""
        if ((bytePtr[0] & 0x02) != 0)
        {
            if ((bytePtr[2] & 0x01) == 0x01)
            {
                startEPC = 6
            }
            else
            {
                startEPC = 4
            }
        }
        else{
            startEPC = 2
        }
        let buffer = (rawData as NSData).bytes.bindMemory(to: UInt8.self, capacity: rawData.count)
        var strScanRead: String = ""
        for i in 0..<rawData.count {
            strScanRead += String(format: "%02x", buffer.advanced(by: i).pointee)
        }
        let calibBinaryCode1: String = String(strScanRead.suffix(strScanRead.count - startEPC * 2))
        epc = calibBinaryCode1.uppercased()
        var returnVal: String = ""
        if ((bytePtr[0] & 0x01) == 0x01) {
            returnVal = String(format: "UII : %@", epc)
        } else {
            returnVal = String(format: "EPC : %@", epc)
        }
        return returnVal
    }
    class func getPCEPCWithoutXpc(_ rawData: Data) -> String {
        let bytePtr = [UInt8](rawData)
        var startEPC: Int = 0
        var pc: String = ""
        var epc: String = ""
        pc = String(format: "PC:%02X%02X", bytePtr[0],bytePtr[1])
        if ((bytePtr[0] & 0x02) != 0)
        {
            if ((bytePtr[2] & 0x01) == 0x01) {
                startEPC = 6
            } else {
                startEPC = 4
            }
        } else {
            startEPC = 2;
        }
        let buffer = (rawData as NSData).bytes.bindMemory(to: UInt8.self, capacity: rawData.count)
        var strScanRead: String = ""
        for i in 0..<rawData.count {
            strScanRead += String(format: "%02x", buffer.advanced(by: i).pointee)
        }
        let calibBinaryCode1: String = String(strScanRead.suffix(strScanRead.count - startEPC * 2))
        epc = calibBinaryCode1.uppercased()
        return String(format: "%@%@", pc,epc);
    }
    class func checkSameTag1(_ compare1: Data, compare2: Data) -> Bool {
        let com1: String = getPCEPCWithoutXpc(compare1)
        let com2: String = getPCEPCWithoutXpc(compare2)
        if (com1 == com2) {
            return true
        } else {
            return false
        }
    }
    class func dataFromHexString(_ string: String) -> Data {
        let bytes = RainTagHelper.stringToBytes(from: string)
        return Data.init(bytes: bytes, count: string.count / 2)
    }
    class func getPCStringData(_ rawData: String) -> String {
        let data: Data = dataFromHexString(rawData)
        return getPC(data)
    }
    class func getEPCStringData(_ rawData: String) -> String {
        let data: Data = dataFromHexString(rawData)
        return getEPC(data)
    }
    class func checkSameStringDataTag1(_ compare1: String, compare2: String) -> Bool {
        let data1: Data = dataFromHexString(compare1)
        let data2: Data = dataFromHexString(compare2)
        return checkSameTag1(data1, compare2: data2)
    }
    class func convertUniqueStringDataTag(_ rawData: String) -> String {
        let data: Data = dataFromHexString(rawData)
        let bytePtr = [UInt8](data)
        let pc: String = String(format: "PC:%02X%02X", bytePtr[0], bytePtr[1])
        let epc: String = getEPC(data)
        return String(format: "%@%@", pc,epc)
    }
    class func stringToBytes(from hexStr: String) -> [UInt8] {
            assert(hexStr.count % 2 == 0, "输入字符串格式不对，8位代表一个字符")
            var bytes = [UInt8]()
            var sum = 0
            // 整形的 utf8 编码范围
            let intRange = 48...57
            // 小写 a~f 的 utf8 的编码范围
            let lowercaseRange = 97...102
            // 大写 A~F 的 utf8 的编码范围
            let uppercasedRange = 65...70
            for (index, c) in hexStr.utf8CString.enumerated() {
                var intC = Int(c.byteSwapped)
                if intC == 0 {
                    break
                } else if intRange.contains(intC) {
                    intC -= 48
                } else if lowercaseRange.contains(intC) {
                    intC -= 87
                } else if uppercasedRange.contains(intC) {
                    intC -= 55
                } else {
                    assertionFailure("输入字符串格式不对，每个字符都需要在0~9，a~f，A~F内")
                }
                sum = sum * 16 + intC
                // 每两个十六进制字母代表8位，即一个字节
                if index % 2 != 0 {
                    bytes.append(UInt8(sum))
                    sum = 0
                }
            }
            return bytes
        }
}
