//
//  SystemSetting.m
//  AsReaderLR
//
//  Created by mac on 2017/8/7.
//  Copyright © 2017年 asterisk. All rights reserved.
//
#import "SystemSetting.h"
#import "AppDelegate.h"
#import <AsReaderGunSDK/AsReaderGunSDK.h>

#define ISNOTFIRSTUSED          @"IsNotFirtUsed"
#define BUZZER                  @"Buzzer"
#define VIBRATOR                @"Vibrator"
#define BUZZERTIME              @"BuzzerTime"
#define VIBRATORTIME            @"VibratorTime"
#define INVENTORYTIME           @"InventoryTime"
#define IDLETIME                @"IdleTime"
#define AUTOOFFTIME             @"AutoOffTime"
#define QVALUE                  @"QValue"
#define ALGORITHM               @"Algorithm"
#define MAXQ                    @"MaxQ"
#define MINQ                    @"MinQ"
#define SLEEPTIME               @"SleepTime"
#define MASKTYPEVALUE           @"MaskTypeValue"
#define LINKPROFILEVALUE        @"LinkProfileValue"
#define DeFAULTLINKPROFILEVALUE @"DefaultLinkProfileValue"
#define OPERATIONTIME           @"OperationTime"
#define POWERGAIN               @"PowerGain"
#define INVENTORYSESSION        @"InventorySession"
#define SESSIONFLAG             @"SessionFlag"
#define USESELECTIONMASK        @"UseSelectionMask"
#define CONTINUOUSMODE          @"ContinuousMode"
#define RSSIMODE                @"RssiMode"
#define PROPBARCODEMODE         @"PropBarcodeMode"
#define EPCMASKMATCHMODE        @"EpcMaskMatchMode"
#define DISPLAYPC               @"Displaypc"
#define LBTITEMDATA             @"LbtItemData"
#define RFIDDATA                @"RfidData"
#define BARCODEDATA             @"BarcodeData"
#define MAPTAGS                 @"MapTags"
#define EPCMASKDATA             @"EpcMaskData"
#define SELECTIONEPCMASKDATA    @"SelectionEpcMaskData"
#define BARCODEPARAMDATA        @"barcodeParamData"
#define BARCODERESCANTIME       @"BarcodeRescanTime"
#define THRESHOLD               @"ThresHoldValue"
#define TIDLEN                  @"TidLength"
#define TIDON                   @"TidOn"

#define CUSTOMPREFIXSUFFIX            @"CustomPrefixSuffix"
#define BARCODESAVETYPE               @"BarcodeSaveType"

@implementation SystemSetting{
    AppDelegate    * m_appdelegate;
    NSUserDefaults * m_userDefaults;
 
}

static SystemSetting * systemSetting;

+ (SystemSetting *)sharedSystemSetting{
    if (!systemSetting) {
        systemSetting = [[SystemSetting alloc] init];
    }
    return systemSetting;
}

- (instancetype)init
{
    self = [super init];
    if (self) {
        m_appdelegate = (AppDelegate *)[[UIApplication sharedApplication] delegate];
        m_userDefaults = [NSUserDefaults standardUserDefaults];
    }
    return self;
}

- (void)asReaderGUNSetting{
    m_appdelegate.mReader.buzzer = [self getBuzzer];
    m_appdelegate.mReader.vibrator = [self getVibrator];
    m_appdelegate.mReader.sleepTime = [self getSleepTime];
}

- (void)RFIDSetting{
    if (m_appdelegate.mReader) {
        //Wait for RFID Bootting time
        //#issue 5-2
        [NSThread sleepForTimeInterval:1.5];
        m_appdelegate.mReader.inventoryTime = [self getInventoryTime];
        m_appdelegate.mReader.idleTime = [self getIdleTime];
        m_appdelegate.mReader.autoOffTime = [self getAutoOffTime];
        m_appdelegate.mReader.qValue = [self getQValue];
        m_appdelegate.mReader.algorithm = [self getAlgorithm];
        m_appdelegate.mReader.maxQ = [self getMaxQ];
        m_appdelegate.mReader.minQ = [self getMinQ];
        m_appdelegate.mReader.linkProfileValue = [self getLinkProfileValue];
        m_appdelegate.mReader.defaultLinkProfileValue = [self getDefaultLinkProfileValue];
        m_appdelegate.mReader.operationTime = [self getOperationTime];
        m_appdelegate.mReader.powerGain = [self getPowerGain];
        m_appdelegate.mReader.inventorySession = [self getInventorySession];
        m_appdelegate.mReader.sessionFlag = [self getSessionFlag];
        m_appdelegate.mReader.continuousMode = [self getContinuousMode];
        m_appdelegate.mReader.rssiMode = [self getRssiMode];
        m_appdelegate.mReader.thresHoldValue = [self getThresHoldValue];
        BOOL isJapan = [[m_appdelegate.mReader regionName] hasPrefix:@"Japan"];
        
        if (isJapan) {
            NSArray *  _lbtItemData = [self getLbtItemData];
            if (_lbtItemData == nil) {
                NSMutableArray *lbtItems = [[NSMutableArray alloc] initWithArray: m_appdelegate.mReader.getLBT];
                LbtItem *lbtI = [[LbtItem alloc] init];
          
                for (LbtItem *lbtItem in lbtItems) {
                    NSLog(@" LBT :  mSlot %d   mIsUsed %d  %@",lbtItem.mSlot,lbtItem.mIsUsed,lbtItem.frequency);
                    lbtItem.frequency = [m_appdelegate.mReader getLBTFrequency:lbtItem.mSlot];
                    if ([lbtItem.frequency isEqualToString:@"0 HZ"]) {
                        lbtI = lbtItem;
                    }
                }
                
                [lbtItems removeObject:lbtI];
                _lbtItemData = lbtItems;
                [self setLbtItemData:_lbtItemData];
            }
            [m_appdelegate.mReader setLBT:[self getLbtItemData]];
        }
        
        
        m_appdelegate.mReader.maskTypeValue = [self getMaskTypeValue];
        switch ([self getMaskTypeValue]) {
            case MaskType_NO_MASK:{
                
            }
                break;
            case MaskType_Selection:{
                AsSelectMaskParam *param;
                NSArray * selectionArray = [self getEpcMaskData];
                for (int i=MIN_SELECTION_MASK; i < MAX_SELECTION_MASK; i++) {
                    if (i < selectionArray.count) {
                        param = [selectionArray objectAtIndex:i];
                        [m_appdelegate.mReader setSelectionMask:i withParam:param];
                    } else {
                        [m_appdelegate.mReader removeSelectionMask:i];
                    }
                }
                if ([selectionArray count] > 0) {
                    [m_appdelegate.mReader setUseSelectionMask:[self getUseSelectionMask]];
                }else {
                    [m_appdelegate.mReader clearSelectionMask];
                }
            }
                break;
            case MaskType_EPC:{
                [m_appdelegate.mReader clearEpcMask];
                for (AsSelectMaskEPCParam *mask in [self getSelectionEpcMaskData]) {
                    [m_appdelegate.mReader addEpcMask:mask];
                }
                if ([self getEpcMaskMatchMode]) {
                    [m_appdelegate.mReader setEpcMaskMatchMode:YES];
                } else {
                    [m_appdelegate.mReader setEpcMaskMatchMode:NO];
                }
            }
                break;
            default:
                break;
        }
    }
}
    
- (void)barcodeSetting{
    //Temporary
    if([self getBarcodeSettingSaveTypeIsTemporary]){
        if (m_appdelegate.mReader) {
            [m_appdelegate.mReader setPropBarcodeMode:YES];
            ResultCode res = ResultNoError;
            for (AsParamValue *paramName in [self getBarcodeParamData]) {
                res = [m_appdelegate.mReader setBarcodeParam:paramName type:Temporary];
                if (res != ResultNoError) {
                    return;
                }
            }
            [m_appdelegate.mReader setPropBarcodeMode:NO];
        }
    }
}


-(void)setBarcodeSettingSaveType:(BOOL)isTemporaryOn{
    [m_userDefaults setBool:isTemporaryOn forKey:BARCODESAVETYPE];
    [m_userDefaults synchronize];
}

- (BOOL)getBarcodeSettingSaveTypeIsTemporary{
    return [m_userDefaults boolForKey:BARCODESAVETYPE];
}



- (void)setCustomPrefixSuffix:(BOOL)isPreSuffixOn{
    
    [m_userDefaults setBool:isPreSuffixOn forKey:CUSTOMPREFIXSUFFIX];
    
    [m_userDefaults synchronize];
}

- (BOOL)getCustomPrefixSuffix{
    return [m_userDefaults boolForKey:CUSTOMPREFIXSUFFIX];
}

- (void)setNotFirstUsed:(BOOL)isFirst{
    [m_userDefaults setBool:isFirst forKey:ISNOTFIRSTUSED];
    [m_userDefaults synchronize];
}
- (BOOL)getNotFirstUsed{
    return [m_userDefaults boolForKey:ISNOTFIRSTUSED];
}


- (void)setBuzzer:(int)buzzrtType{
    [m_userDefaults setInteger:buzzrtType forKey:BUZZER];
    [m_userDefaults synchronize];
}
- (void)setVibrator:(int)vibratorType{
    [m_userDefaults setInteger:vibratorType forKey:VIBRATOR];
    [m_userDefaults synchronize];
}
- (void)setInventoryTime:(int)inventoryTime{
    [m_userDefaults setInteger:inventoryTime forKey:INVENTORYTIME];
    [m_userDefaults synchronize];
}
- (void)setIdleTime:(int)idleTime{
    [m_userDefaults setInteger:idleTime forKey:IDLETIME];
    [m_userDefaults synchronize];
}
- (void)setAutoOffTime:(int)autoOffTime{
    [m_userDefaults setInteger:autoOffTime forKey:AUTOOFFTIME];
    [m_userDefaults synchronize];
}
- (void)setQValue:(int)qValue{
    [m_userDefaults setInteger:qValue forKey:QVALUE];
    [m_userDefaults synchronize];
}
- (void)setAlgorithm:(int)algorithm{
    [m_userDefaults setInteger:algorithm forKey:ALGORITHM];
    [m_userDefaults synchronize];
}
- (void)setMaxQ:(int)maxQValue{
    [m_userDefaults setInteger:maxQValue forKey:MAXQ];
    [m_userDefaults synchronize];
}
- (void)setMinQ:(int)minQValue{
    [m_userDefaults setInteger:minQValue forKey:MINQ];
    [m_userDefaults synchronize];
}
- (void)setSleepTime:(int)sleepTimeValue{
    [m_userDefaults setInteger:sleepTimeValue forKey:SLEEPTIME];
    [m_userDefaults synchronize];
}
- (void)setMaskTypeValue:(int)maskTypeValue{
    [m_userDefaults setInteger:maskTypeValue forKey:MASKTYPEVALUE];
    [m_userDefaults synchronize];
}
- (void)setLinkProfileValue:(int)linkProfileValue{
    [m_userDefaults setInteger:linkProfileValue forKey:LINKPROFILEVALUE];
    [m_userDefaults synchronize];
}
- (void)setDefaultLinkProfileValue:(int)defaultLinkProfileValue{
    [m_userDefaults setInteger:defaultLinkProfileValue forKey:DeFAULTLINKPROFILEVALUE];
    [m_userDefaults synchronize];
}
- (void)setOperationTime:(int)operationTime{
    [m_userDefaults setInteger:operationTime forKey:OPERATIONTIME];
    [m_userDefaults synchronize];
}
- (void)setPowerGain:(int)powerGain{
    [m_userDefaults setInteger:powerGain forKey:POWERGAIN];
    [m_userDefaults synchronize];
}
- (void)setInventorySession:(int)inventorySession{
    [m_userDefaults setInteger:inventorySession forKey:INVENTORYSESSION];
    [m_userDefaults synchronize];
}
- (void)setSessionFlag:(int)sessionFlag{
    [m_userDefaults setInteger:sessionFlag forKey:SESSIONFLAG];
    [m_userDefaults synchronize];
}
- (void)setUseSelectionMask:(int)useSelectionMask{
    [m_userDefaults setInteger:useSelectionMask forKey:USESELECTIONMASK];
    [m_userDefaults synchronize];
}

- (void)setContinuousMode:(BOOL)isContinuousMode{
    [m_userDefaults setInteger:isContinuousMode forKey:CONTINUOUSMODE];
    [m_userDefaults synchronize];
}
- (void)setRssiMode:(BOOL)isRssiMode{
    [m_userDefaults setInteger:isRssiMode forKey:RSSIMODE];
    [m_userDefaults synchronize];
}
- (void)setPropBarcodeMode:(BOOL)isPropBarcodeMode{
    [m_userDefaults setInteger:isPropBarcodeMode forKey:PROPBARCODEMODE];
    [m_userDefaults synchronize];
}
- (void)setEpcMaskMatchMode:(BOOL)isEpcMaskMatchMode{
    [m_userDefaults setInteger:isEpcMaskMatchMode forKey:EPCMASKMATCHMODE];
    [m_userDefaults synchronize];
}
- (void)setDisPlayPC:(BOOL)isDisplaypc{
    [m_userDefaults setBool:isDisplaypc forKey:DISPLAYPC];
    [m_userDefaults synchronize];
}

- (void)setLbtItemData:(NSArray *)lbtItemData{
    NSData *lbtData = [NSKeyedArchiver archivedDataWithRootObject:lbtItemData];
    [m_userDefaults setObject:lbtData forKey:LBTITEMDATA];
    lbtData = nil;
    [m_userDefaults synchronize];
}
- (void)setRfidData:(NSArray *)rfidData{
    NSData *data = [NSKeyedArchiver archivedDataWithRootObject:rfidData];
    [m_userDefaults setObject:data forKey:RFIDDATA];
     data = nil;
    [m_userDefaults synchronize];
}
- (void)setBarcodeData:(NSArray *)barcodeData{
    NSData *data = [NSKeyedArchiver archivedDataWithRootObject:barcodeData];
    [m_userDefaults setObject:data forKey:BARCODEDATA];
    data = nil;
    [m_userDefaults synchronize];
}
- (void)setMapTags:(NSDictionary *)mapTags{
    NSData *data = [NSKeyedArchiver archivedDataWithRootObject:mapTags];
    [m_userDefaults setObject:data forKey:MAPTAGS];
     data = nil;
    [m_userDefaults synchronize];
}
- (void)setEpcMaskData:(NSArray *)epcMaskData{
    NSData *epcData = [NSKeyedArchiver archivedDataWithRootObject:epcMaskData];
    [m_userDefaults setObject:epcData forKey:EPCMASKDATA];
    epcData = nil;
    [m_userDefaults synchronize];
}
- (void)setSelectionEpcMaskData:(NSArray *)selectionEpcMaskData{
    NSData *selectionEpcData = [NSKeyedArchiver archivedDataWithRootObject:selectionEpcMaskData];
    [m_userDefaults setObject:selectionEpcData forKey:SELECTIONEPCMASKDATA];
    selectionEpcData = nil;
    [m_userDefaults synchronize];
}

-(void)clearAllMaskData
{
    [m_userDefaults setObject:nil forKey:EPCMASKDATA];
    [m_userDefaults setObject:nil forKey:SELECTIONEPCMASKDATA];
}

- (void)setBarcodeParamData:(NSArray *)barcodeParamData{
    NSData *barcodeData = [NSKeyedArchiver archivedDataWithRootObject:barcodeParamData];
    [m_userDefaults setObject:barcodeData forKey:BARCODEPARAMDATA];
    barcodeData = nil;
    [m_userDefaults synchronize];
}
 
- (void)setThresHoldValue:(int)thresHoldValue{
    [m_userDefaults setInteger:thresHoldValue forKey:THRESHOLD];
    [m_userDefaults synchronize];
}

- (void)setTidLength:(int)length
{
    [m_userDefaults setInteger:length forKey:TIDLEN];
    [m_userDefaults synchronize];
}

- (void)setTidOn:(BOOL)isOn{
    [m_userDefaults setInteger:isOn forKey:TIDON];
    [m_userDefaults synchronize];
}

- (BOOL)getTidOn{
    return [m_userDefaults boolForKey:TIDON];
}


- (int)getTidLength{
    return (int)[m_userDefaults integerForKey:TIDLEN];
}


- (int)getBuzzer{
    return (int)[m_userDefaults integerForKey:BUZZER];
}
- (int)getVibrator{
    return (int)[m_userDefaults integerForKey:VIBRATOR];
}
- (int)getInventoryTime{
    return (int)[m_userDefaults integerForKey:INVENTORYTIME];
}
- (int)getIdleTime{
    return (int)[m_userDefaults integerForKey:IDLETIME];
}
- (int)getAutoOffTime{
    return (int)[m_userDefaults integerForKey:AUTOOFFTIME];
}
- (int)getQValue{
    return (int)[m_userDefaults integerForKey:QVALUE];
}
- (int)getAlgorithm{
    return (int)[m_userDefaults integerForKey:ALGORITHM];
}
- (int)getMaxQ{
    return (int)[m_userDefaults integerForKey:MAXQ];
}
- (int)getMinQ{
    return (int)[m_userDefaults integerForKey:MINQ];
}
- (int)getSleepTime{
    return (int)[m_userDefaults integerForKey:SLEEPTIME];
}
- (int)getMaskTypeValue{
    return (int)[m_userDefaults integerForKey:MASKTYPEVALUE];
}
- (int)getLinkProfileValue{
    return (int)[m_userDefaults integerForKey:LINKPROFILEVALUE];
}
- (int)getDefaultLinkProfileValue{
    return (int)[m_userDefaults integerForKey:DeFAULTLINKPROFILEVALUE];
}
- (int)getOperationTime{
    return (int)[m_userDefaults integerForKey:OPERATIONTIME];
}
- (int)getPowerGain{
    return (int)[m_userDefaults integerForKey:POWERGAIN];
}
- (int)getInventorySession{
    return (int)[m_userDefaults integerForKey:INVENTORYSESSION];
}
- (int)getSessionFlag{
    return (int)[m_userDefaults integerForKey:SESSIONFLAG];
}
- (int)getUseSelectionMask{
    return (int)[m_userDefaults integerForKey:USESELECTIONMASK];
}

- (BOOL)getContinuousMode{
    return [m_userDefaults boolForKey:CONTINUOUSMODE];
}
- (BOOL)getRssiMode{
    return [m_userDefaults boolForKey:RSSIMODE];
}
- (BOOL)getPropBarcodeMode{
    return [m_userDefaults boolForKey:PROPBARCODEMODE];
}
- (BOOL)getEpcMaskMatchMode{
    return [m_userDefaults boolForKey:EPCMASKMATCHMODE];
}
- (BOOL)getDisPlayPC{
    return [m_userDefaults boolForKey:DISPLAYPC];
}


- (NSArray *)getLbtItemData{
    NSData *tokenObject = [m_userDefaults objectForKey:LBTITEMDATA];
    NSArray * array = [NSKeyedUnarchiver unarchiveObjectWithData:tokenObject];
    return array;
}
- (NSArray *)getRfidData{
    NSData *data = [m_userDefaults objectForKey:RFIDDATA];
    NSArray * array = [NSKeyedUnarchiver unarchiveObjectWithData:data];
    return array;
}
- (NSArray *)getBarcodeData{
    NSData *data = [m_userDefaults objectForKey:BARCODEDATA];
    NSArray * array = [NSKeyedUnarchiver unarchiveObjectWithData:data];
    return array;
}
- (NSDictionary *)getMapTags{
    NSData *data = [m_userDefaults objectForKey:MAPTAGS];
    NSDictionary * dic = [NSKeyedUnarchiver unarchiveObjectWithData:data];
    return dic;
}
- (NSArray *)getEpcMaskData{
    NSData *tokenObject = [m_userDefaults objectForKey:EPCMASKDATA];
    NSArray * array = [NSKeyedUnarchiver unarchiveObjectWithData:tokenObject];
    return array;
}
- (NSArray *)getSelectionEpcMaskData{
    NSData *tokenObject = [m_userDefaults objectForKey:SELECTIONEPCMASKDATA];
    NSArray * array = [NSKeyedUnarchiver unarchiveObjectWithData:tokenObject];
    return array;
}
- (NSArray *)getBarcodeParamData{
    NSData *tokenObject = [m_userDefaults objectForKey:BARCODEPARAMDATA];
    NSArray * array = [NSKeyedUnarchiver unarchiveObjectWithData:tokenObject];
    return array;
}

- (void)setBuzzerTime:(int)buzzerTime{
    [m_userDefaults setInteger:buzzerTime forKey:BUZZERTIME];
    [m_userDefaults synchronize];
}
- (int)getBuzzerTime{
    return (int)[m_userDefaults integerForKey:BUZZERTIME];
}

- (void)setVibratorTime:(int)vibratorTime{
    [m_userDefaults setInteger:vibratorTime forKey:VIBRATORTIME];
    [m_userDefaults synchronize];
}
- (int)getVibratorTime{
    return (int)[m_userDefaults integerForKey:VIBRATORTIME];
}
- (void)setBarcodeReScanTime:(int)barcodeReScanTime{
    [m_userDefaults setInteger:barcodeReScanTime forKey:BARCODERESCANTIME];
    [m_userDefaults synchronize];
}
- (int)getBarcodeReScanTime{
    return (int)[m_userDefaults integerForKey:BARCODERESCANTIME];
}

- (int)getThresHoldValue{
    return (int)[m_userDefaults integerForKey:THRESHOLD];
}

- (void)setMaskDataUpdate
{
    switch ([self getMaskTypeValue]) {
        case MaskType_NO_MASK:{
            [m_appdelegate.mReader clearSelectionMask];
        }
            break;
        case MaskType_Selection:{
            AsSelectMaskParam *param;
            NSArray * selectionArray = [self getEpcMaskData];
            for (int i=MIN_SELECTION_MASK; i < MAX_SELECTION_MASK; i++) {
                if (i < selectionArray.count) {
                    param = [selectionArray objectAtIndex:i];
                    [m_appdelegate.mReader setSelectionMask:i withParam:param];
                } else {
                    [m_appdelegate.mReader removeSelectionMask:i];
                }
            }
            if ([selectionArray count] > 0) {
                [m_appdelegate.mReader setUseSelectionMask:[self getUseSelectionMask]];
            }else {
                [m_appdelegate.mReader clearSelectionMask];
            }
        }
            break;
        case MaskType_EPC:{
            [m_appdelegate.mReader clearSelectionMask];
            [m_appdelegate.mReader clearEpcMask];
            if([self getSelectionEpcMaskData].count == 0)
                return;
            
            
            
            for (AsSelectMaskEPCParam *mask in [self getSelectionEpcMaskData]) {
                [m_appdelegate.mReader addEpcMask:mask];
            }
            if ([self getEpcMaskMatchMode]) {
                [m_appdelegate.mReader setEpcMaskMatchMode:YES];
            } else {
                [m_appdelegate.mReader setEpcMaskMatchMode:NO];
            }
        }
            break;
        default:
            break;
    }
}
@end
