//
//  RainTagHelper.m
//  AsReaderScan
//
//  Created by Robin on 2021/10/18.
//

#import "RainTagHelper.h"

@implementation RainTagHelper

+ (NSString *)getPC:(NSData*)rawData{
    unsigned char *bytePtr = (unsigned char *)[rawData bytes];
    int startEPC = 0;
    NSString *pc = @"";
    NSString *epc = @"";
    if (bytePtr[0] & 0x02)
    {
        if ((bytePtr[2] & 0x01) == 0x01)
        {
            pc = [NSString stringWithFormat:@"PC:%02X%02X%02X%02X%02X%02X ",bytePtr[0],bytePtr[1],bytePtr[2],bytePtr[3],bytePtr[4],bytePtr[5]];
            
            startEPC = 6;
        }
        else
        {
            pc = [NSString stringWithFormat:@"PC:%02X%02X%02X%02X",bytePtr[0],bytePtr[1],bytePtr[2],bytePtr[3]];
            startEPC = 4;
        }
    }
    else{
        pc = [NSString stringWithFormat:@"PC:%02X%02X",bytePtr[0],bytePtr[1]];
        startEPC = 2;
    }
    
    NSMutableString *strScanRead = [NSMutableString new];
    for(int i = 0; i < rawData.length; i++) {
        [strScanRead appendFormat:@"%02x", *bytePtr++ & 0xFF ];
    }
    
    epc = [[strScanRead substringFromIndex:startEPC*2]uppercaseString];
    return pc;
}


+ (NSString *)getEPC:(NSData*)rawData{
    unsigned char *bytePtr = (unsigned char *)[rawData bytes];
    int startEPC = 0;
    NSString *pc = @"";
    NSString *epc = @"";
    if (bytePtr[0] & 0x02)
    {
        if ((bytePtr[2] & 0x01) == 0x01)
        {
            pc = [NSString stringWithFormat:@"PC:%02X%02X%02X%02X%02X%02X ",bytePtr[0],bytePtr[1],bytePtr[2],bytePtr[3],bytePtr[4],bytePtr[5]];
            
            startEPC = 6;
        }
        else
        {
            pc = [NSString stringWithFormat:@"PC:%02X%02X%02X%02X",bytePtr[0],bytePtr[1],bytePtr[2],bytePtr[3]];
            startEPC = 4;
        }
    }
    else{
        pc = [NSString stringWithFormat:@"PC:%02X%02X",bytePtr[0],bytePtr[1]];
        startEPC = 2;
    }
    NSMutableString *strScanRead = [NSMutableString new];
    for(int i = 0; i < rawData.length; i++) {
        [strScanRead appendFormat:@"%02x", bytePtr[i] & 0xFF ];
    }
    epc = [[strScanRead substringFromIndex:startEPC*2]uppercaseString];
    
    NSString *returnVal = @"";
    if ((bytePtr[0] & 0x01) == 0x01){
        if(epc.length>4){
            NSRange range = NSMakeRange(epc.length - 4, 4);
            NSString *lastData = [epc substringWithRange:range];
            returnVal = [NSString stringWithFormat:@"%@ : (%@) %@",@"UII",lastData,epc];
        }else{
            returnVal = [NSString stringWithFormat:@"%@ : %@",@"UII",epc];
        }
        
    }
    else{
        
        if(epc.length>4){
            NSRange range = NSMakeRange(epc.length - 4, 4);
            NSString *lastData = [epc substringWithRange:range];
            returnVal = [NSString stringWithFormat:@"%@ : (%@) %@",@"EPC",lastData,epc];
        }else{
            returnVal = [NSString stringWithFormat:@"%@ : %@",@"EPC",epc];
        }
        
    }
    return returnVal;
}


+ (NSString *)getPCEPCWithoutXpc:(NSData*)rawData{
    unsigned char *bytePtr = (unsigned char *)[rawData bytes];
    int startEPC = 0;
    NSString *pc = @"";
    NSString *epc = @"";
    pc = [NSString stringWithFormat:@"PC:%02X%02X",bytePtr[0],bytePtr[1]];
    if (bytePtr[0] & 0x02)
    {
        if ((bytePtr[2] & 0x01) == 0x01)
            startEPC = 6;
        else
            startEPC = 4;
    }
    else
        startEPC = 2;
    
    NSMutableString *strScanRead = [NSMutableString new];
    for(int i = 0; i < rawData.length; i++) {
        [strScanRead appendFormat:@"%02x", *bytePtr++ & 0xFF ];
    }
    epc = [[strScanRead substringFromIndex:startEPC*2]uppercaseString];
    return [NSString stringWithFormat:@"%@%@",pc,epc];
}

+ (BOOL) checkSameTag1:(NSData*)compare1 Tag2:(NSData*)compare2{
    NSString *com1 = [self getPCEPCWithoutXpc:compare1];
    NSString *com2 = [self getPCEPCWithoutXpc:compare2];
    
    if([com1 isEqualToString:com2])
        return YES;
    return NO;
    
}

+ (NSData *)dataFromHexString:(NSString *) string {
    if([string length] % 2 == 1){
        string = [@"0"stringByAppendingString:string];
    }

    const char *chars = [string UTF8String];
    int i = 0, len = (int)[string length];

    NSMutableData *data = [NSMutableData dataWithCapacity:len / 2];
    char byteChars[3] = {'\0','\0','\0'};
    unsigned long wholeByte;

    while (i < len) {
        byteChars[0] = chars[i++];
        byteChars[1] = chars[i++];
        wholeByte = strtoul(byteChars, NULL, 16);
        [data appendBytes:&wholeByte length:1];
    }
    return data;
}


+ (NSString *)getPCStringData:(NSString*)rawData{
    NSData *data = [self dataFromHexString:rawData];
    return [self getPC:data];
}

+ (NSString *)getEPCStringData:(NSString*)rawData{
    
    NSData *data = [self dataFromHexString:rawData];
    return [self getEPC:data];
}

+ (BOOL) checkSameStringDataTag1:(NSString*)compare1 Tag2:(NSString*)compare2{
    NSData *data1 = [self dataFromHexString:compare1];
    NSData *data2 = [self dataFromHexString:compare2];
    return [self checkSameTag1:data1 Tag2:data2];
}


+ (NSString *)convertUniqueStringDataTag:(NSString*)rawData{
    NSData *data = [self dataFromHexString:rawData];
    unsigned char *bytePtr = (unsigned char *)[data bytes];
    NSString *pc = [NSString stringWithFormat:@"PC:%02X%02X",bytePtr[0],bytePtr[1]];
    NSString *epc = [self getEPC:data];
    return [NSString stringWithFormat:@"%@%@",pc,epc];
}




@end
