//
//  RFMHelper.m
//  AsReaderLR
//
//  Created by Robin on 2020/11/06.
//  Copyright © 2020 asterisk. All rights reserved.
//

#import "RFMHelper.h"

@implementation RFMHelper

+ (NSString *)convertCelsiusToFahrenheit:(NSString *)celsiusString {
    float celsius = [celsiusString floatValue];
    float fahrenheit = celsius * 9 / 5 + 32;
    return [NSString stringWithFormat:@"%.1f", fahrenheit];
}

+ (NSString *)calculationTemp:(NSString *)sensCode calibration:(NSString*)calibration{
   
    if((sensCode == nil)||(calibration == nil))
        return @"";
    
    calibration = [calibration uppercaseString];
    
    NSString *calibBinaryData = [RFMHelper convertHexToBinary:calibration];
    NSLog(@" Sen Code1 : %@ %d ",calibBinaryData,(int)calibBinaryData.length);
    
    if(calibBinaryData.length < 47)
        return @"";
    
    NSString *calibBinaryCode1 = [calibBinaryData substringWithRange:NSMakeRange(0, 12)];
    NSString *calibBinaryTemp1 = [calibBinaryData substringWithRange:NSMakeRange(12, 11)];
    NSString *calibBinaryCode2 = [calibBinaryData substringWithRange:NSMakeRange(23, 12)];
    NSString *calibBinaryTemp2 = [calibBinaryData substringWithRange:NSMakeRange(35, 11)];
    
    //binary to decimal
    NSNumber * calibDecCode1 = [RFMHelper convertBinaryStringToDecimalNumber:calibBinaryCode1];
    NSNumber * calibDecCode2 = [RFMHelper convertBinaryStringToDecimalNumber:calibBinaryCode2];
    NSNumber * calibDecTemp1 = [RFMHelper convertBinaryStringToDecimalNumber:calibBinaryTemp1];
    NSNumber * calibDecTemp2 = [RFMHelper convertBinaryStringToDecimalNumber:calibBinaryTemp2];
    
    int calibCode1 =  [calibDecCode1 intValue];
    int calibCode2 =  [calibDecCode2 intValue];
    int calibTemp1 =  [calibDecTemp1 intValue];
    int calibTemp2 =  [calibDecTemp2 intValue];
    
    int code       =  [self convertHexStringToInt:sensCode];
    
   
    float temperatureVal = 0.1* ( (calibTemp2-calibTemp1)/(calibCode2-calibCode1)*(code-calibCode1)+calibTemp1-800);
    
    return [NSString stringWithFormat:@"%.1f",temperatureVal];
}

+ (NSString *)calculationSensorCode:(NSString*)sensCode tid:(NSString*)tid{
    if(sensCode == nil)
        return @"";
    
    sensCode =  [sensCode substringWithRange:NSMakeRange(0,4)];
    int code       =  [self convertHexStringToInt:sensCode];
    
    return [NSString stringWithFormat:@"%d",code];
}

+ (NSString*)convertHexToBinary:(NSString*)hexString
{
    NSMutableString *returnString = [NSMutableString string];
    for(int i = 0; i < [hexString length]; i++)
    {
        char c = [[hexString lowercaseString] characterAtIndex:i];
        
        switch(c) {
            case '0': [returnString appendString:@"0000"]; break;
            case '1': [returnString appendString:@"0001"]; break;
            case '2': [returnString appendString:@"0010"]; break;
            case '3': [returnString appendString:@"0011"]; break;
            case '4': [returnString appendString:@"0100"]; break;
            case '5': [returnString appendString:@"0101"]; break;
            case '6': [returnString appendString:@"0110"]; break;
            case '7': [returnString appendString:@"0111"]; break;
            case '8': [returnString appendString:@"1000"]; break;
            case '9': [returnString appendString:@"1001"]; break;
            case 'a': [returnString appendString:@"1010"]; break;
            case 'b': [returnString appendString:@"1011"]; break;
            case 'c': [returnString appendString:@"1100"]; break;
            case 'd': [returnString appendString:@"1101"]; break;
            case 'e': [returnString appendString:@"1110"]; break;
            case 'f': [returnString appendString:@"1111"]; break;
            default : break;
        }
    }
    
    return returnString;
}


+ (NSNumber *)convertBinaryStringToDecimalNumber:(NSString *)binaryString {
    NSUInteger totalValue = 0;
    for (int i = 0; i < binaryString.length; i++) {
        totalValue += (int)([binaryString characterAtIndex:(binaryString.length - 1 - i)] - 48) * pow(2, i);
    }
    return @(totalValue);
}

+ (int)convertHexStringToInt:(NSString*)hexString{
    unsigned int outVal;
    NSScanner* scanner = [NSScanner scannerWithString:hexString];
    [scanner scanHexInt:&outVal];
    return outVal;
}

@end
