#import "MainButton.h"

@interface MainButton()
{
    BOOL didInitImageView;
    BOOL didInitTextLabel;
    BOOL isDisabled;
}
@property (nonatomic, strong) UIColor *originBackgroundColor;
@property (nonatomic, strong) UILabel *textLabel;

@end

@implementation MainButton

- (void)awakeFromNib
{
    [super awakeFromNib];
//    self.layer.borderWidth = 0.5;
}

- (void)layoutSubviews
{

//    [self initImageView];
    [self initTextLabel];
}

- (void)initImageView
{
    if (!didInitImageView) {
        CGSize buttonSize = self.bounds.size;

        CGFloat imageWidth = buttonSize.width * 0.5;
        CGFloat imageHeight = imageWidth;
        
        UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(buttonSize.width / 2 - imageWidth / 2, buttonSize.height * 0.15, imageWidth, imageHeight)];
        [imageView setImage:self.image];
        
        [self addSubview:imageView];
        didInitImageView = true;
    }
}

- (void)initTextLabel
{
    if (!didInitTextLabel) {
        [self addSubview:self.textLabel];
        didInitTextLabel = true;
    }
}
- (UILabel *)textLabel
{
    if (_textLabel == nil) {
        CGSize buttonSize = self.bounds.size;
        CGSize textLabelSize = CGSizeMake(buttonSize.width, buttonSize.height);
         NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
        paragraphStyle.lineHeightMultiple =0.80;
        NSDictionary *attributes = @{NSParagraphStyleAttributeName: paragraphStyle, NSFontAttributeName:[UIFont systemFontOfSize:24.0]};
        
//        CGRect r = [self.text boundingRectWithSize:textLabelSize
//                                           options:NSStringDrawingUsesLineFragmentOrigin
//                                        attributes:attributes
//                                           context:nil];
        NSAttributedString *attributedText = [[NSAttributedString alloc] initWithString:self.text attributes:attributes];
//
//        CGFloat pointX = (buttonSize.width - textLabelSize.width) / 2;
//        CGFloat pointY = buttonSize.height * 0.65;

//        if ((buttonSize.height - pointY - r.size.height) > r.size.height * 0.9) {
//            pointY = pointY + r.size.height / 2;
//        }
        _textLabel = [[UILabel alloc] initWithFrame:CGRectMake(10, 0, buttonSize.width, 50)];
        _textLabel.numberOfLines = 0;
        _textLabel.attributedText = attributedText;
        [_textLabel setFont:[UIFont fontWithName:@"Helvetica-Bold" size:24]];
        [_textLabel setTextAlignment:NSTextAlignmentLeft];

    }
    return _textLabel;
}

- (void)disableButton
{
    if (!isDisabled) {
        isDisabled = true;
        self.enabled = NO;
        self.textLabel.textColor = [UIColor grayColor];
//        self.originBackgroundColor = self.backgroundColor;
//        [self setBackgroundColor:[UIColor grayColor]];
    }
}

- (void)enableButton
{
    if (isDisabled) {
        isDisabled = false;
        self.enabled = YES;
        self.textLabel.textColor = [UIColor blackColor];
//        [self setBackgroundColor:self.originBackgroundColor];
    }
}

@end
