//
//  CSVData.m
//  AsReaderLR
//
//  Created by mac on 2017/8/7.
//  Copyright © 2017年 asterisk. All rights reserved.
//

#import "CSVData.h"
#import "AsTagItem.h"
#import "AsBarcodeItem.h"
@implementation CSVData
+ (NSString *)filePath:(NSString *)fileName export:(ExportType)type{
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *path = [paths objectAtIndex:0];
    NSString *filePath = @"";
    switch (type) {
        case barcodeExportType:
        {
            filePath = [path stringByAppendingPathComponent:@"Barcode"];
        }
            break;
        case rfidExportType:
        {
            filePath = [path stringByAppendingPathComponent:@"RFID"];
        }
            break;
        default:
            break;
    }
    
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if (![fileManager fileExistsAtPath:filePath]) {
        [fileManager createDirectoryAtPath:filePath withIntermediateDirectories:YES attributes:nil error:nil];
    }
    filePath = [filePath stringByAppendingPathComponent:fileName];
    return filePath;
}

//+ (BOOL) isFileExist:(NSString *)fileName {
//    
//    NSFileManager *fileManager = [NSFileManager defaultManager];
//    BOOL result = [fileManager fileExistsAtPath:[self filePath:fileName]];
//    return result;
//}
//
//+ (void) deleteFileForFileName:(NSString *)fileName {
//    
//    NSFileManager *fileManager = [NSFileManager defaultManager];
//    [fileManager removeItemAtPath:[self filePath:fileName] error:nil];
//}

+ (void) createCSVWithFileName:(NSString *)fileName export:(ExportType)type{
    
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if (![fileManager createFileAtPath:[self filePath:fileName export:type]  contents:nil attributes:nil]) {
    }
};

+ (void) exportRfidCSV:(NSString *)fileName withArray:(NSMutableArray *)array export:(ExportType)type isEpc:(BOOL)isEpc isRssi:(BOOL)isRssiOn isTid:(BOOL)isTidOn{
    NSOutputStream *output = [[NSOutputStream alloc] initToFileAtPath:[self filePath:fileName export:type] append:YES];
    [output open];
    
    if (![output hasSpaceAvailable]) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
        [alert setMessage:@"Export Error"];
        [alert show];
        return;
    } else {
        
        NSString *strRssi = @"";
        if(isRssiOn)
            strRssi = @",rssi";
        
        NSString *strTid = @"";
        if(isTidOn)
            strTid = @",tid";
        
        NSString *header;
        if (isEpc) {
                header = [NSString stringWithFormat:@"%@%@%@\n",@"pcepc hex,time,count",strRssi,strTid] ;
        }else{
                header = [NSString stringWithFormat:@"%@%@%@\n",@"epc hex,time,count",strRssi,strTid] ;
        }
        
        
        const uint8_t *headerString = (const uint8_t *)[header cStringUsingEncoding:NSUTF8StringEncoding];
        NSInteger headerLength = [header lengthOfBytesUsingEncoding:NSUTF8StringEncoding];
        NSInteger result = [output write:headerString maxLength:headerLength];
        if (result <= 0) {
            UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
            [alert setMessage:@"Export Error"];
            [alert show];
            return;
        }
        
        for (AsTagItem *item in array) {
            NSString *temp;
            NSString *pcEpc = @"";
            if (isEpc)
                pcEpc = item.tag;
            else
                pcEpc =  [item.tag substringFromIndex:TAG_PC_LENGTH];
            
            
            if(isRssiOn)
                temp = [NSString stringWithFormat:@"%@,%@,%d,%.2f",pcEpc,item.dateTime,item.count,item.rssi];
            else
                temp = [NSString stringWithFormat:@"%@,%@,%d",pcEpc,item.dateTime,item.count];
            
            NSString *row = @"";
            if(isTidOn)
                row = [NSString stringWithFormat:@"%@,%@\n",temp,item.tid];
            else
                row =  [NSString stringWithFormat:@"%@\n",temp];
                
            const uint8_t *rowString = (const uint8_t *)[row cStringUsingEncoding:NSUTF8StringEncoding];
            NSInteger rowLength = [row lengthOfBytesUsingEncoding:NSUTF8StringEncoding];
            result = [output write:rowString maxLength:rowLength];
            if (result <= 0) {
                UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
                [alert setMessage:@"RFID File Export Error"];
                [alert show];
                return;
            }
        }
        
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
        [alert setMessage:@"RFID File Export Success !!"];
        [alert show];
        
        [output close];
    }
}


+ (void) exportRFMRfidCSV:(NSString *)fileName withArray:(NSMutableArray *)array export:(ExportType)type{

    NSOutputStream *output = [[NSOutputStream alloc] initToFileAtPath:[self filePath:fileName export:type] append:YES];
    [output open];
    
    if (![output hasSpaceAvailable]) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
        [alert setMessage:@"Export Error"];
        [alert show];
        return;
    } else {
        
        NSString *header = @"PCEPC(hex),time,count,C,F,Moisture\n";
        
        const uint8_t *headerString = (const uint8_t *)[header cStringUsingEncoding:NSUTF8StringEncoding];
        NSInteger headerLength = [header lengthOfBytesUsingEncoding:NSUTF8StringEncoding];
        NSInteger result = [output write:headerString maxLength:headerLength];
        if (result <= 0) {
            UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
            [alert setMessage:@"Export Error"];
            [alert show];
            return;
        }
        
        for (AsTagItem *item in array) {
            NSString *pcEpc = item.tag;
            //PCEPC , Time , Count , Temp(C) , Temo(F), Moisture
            NSString *row = [NSString
                             stringWithFormat:@"%@,%@,%d,%@,%@,%@\n",pcEpc,item.dateTime,item.count,item.celsius,item.fahrenheit,item.moisture];
        
                
            const uint8_t *rowString = (const uint8_t *)[row cStringUsingEncoding:NSUTF8StringEncoding];
            NSInteger rowLength = [row lengthOfBytesUsingEncoding:NSUTF8StringEncoding];
            result = [output write:rowString maxLength:rowLength];
            if (result <= 0) {
                UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
                [alert setMessage:@"RFID File Export Error"];
                [alert show];
                return;
            }
        }
        
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
        [alert setMessage:@"RFID File Export Success !!"];
        [alert show];
        
        [output close];
    }
}


+ (void) exportBarCodeCSV:(NSString *)fileName withArray:(NSMutableArray *)array export:(ExportType)type {
    NSOutputStream *output = [[NSOutputStream alloc] initToFileAtPath:[self filePath:fileName export:type] append:YES];
    [output open];
    
    if (![output hasSpaceAvailable]) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
        [alert setMessage:@"Export Error"];
        [alert show];
        return;
    } else {
        NSString *header;
        
        header = @"barcode,time\n";
        
        const uint8_t *headerString = (const uint8_t *)[header cStringUsingEncoding:NSUTF8StringEncoding];
        NSInteger headerLength = [header lengthOfBytesUsingEncoding:NSUTF8StringEncoding];
        NSInteger result = [output write:headerString maxLength:headerLength];
        if (result <= 0) {
            UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
            [alert setMessage:@"Export Error"];
            [alert show];
            return;
        }
        
        for (AsBarcodeItem *item in array) {
            //NSLog(@" barcode Data : %@",item.barcode);
            
            NSString *row = [NSString stringWithFormat:@"%@,%@\n", item.barcode, item.dateTime];
            const uint8_t *rowString = (const uint8_t *)[row cStringUsingEncoding:NSUTF8StringEncoding];
            NSInteger rowLength = [row lengthOfBytesUsingEncoding:NSUTF8StringEncoding];
            result = [output write:rowString maxLength:rowLength];
            if (result <= 0) {
                UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
                [alert setMessage:@"Barcode File Export Error"];
                [alert show];
                return;
            }
            
        }
        
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:nil message:@"" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
        [alert setMessage:@"Barcode File Export Success"];
        [alert show];
        
        [output close];
    }
}

@end
