#import "AsTagItem.h"
#import <AsReaderGunSDK/AsReaderGunSDK.h>

@implementation AsTagItem

@synthesize tag;
@synthesize tid;
@synthesize count;
- (void)encodeWithCoder:(NSCoder *)aCoder
{
    [aCoder encodeObject:self.tag forKey:@"tag"];
    [aCoder encodeObject:self.tid forKey:@"tid"];
    [aCoder encodeInt:self.count forKey:@"count"];
    [aCoder encodeFloat:self.rssi forKey:@"rssi"];
    [aCoder encodeFloat:self.phase forKey:@"phase"];
    [aCoder encodeFloat:self.frequency forKey:@"frequency"];
    [aCoder encodeObject:self.dateTime forKey:@"dateTime"];
    [aCoder encodeObject:self.celsius forKey:@"temp1"];
    [aCoder encodeObject:self.fahrenheit forKey:@"temp2"];
    [aCoder encodeObject:self.moisture forKey:@"moisture"];
}
- (nullable instancetype)initWithCoder:(NSCoder *)aDecoder
{
    if (self = [super init]) {
        self.tag = [aDecoder decodeObjectForKey:@"tag"];
        self.tid = [aDecoder decodeObjectForKey:@"tid"];
        self.count = [aDecoder decodeIntForKey:@"count"];
        self.rssi = [aDecoder decodeFloatForKey:@"rssi"];
        self.phase = [aDecoder decodeFloatForKey:@"phase"];
        self.frequency = [aDecoder decodeFloatForKey:@"frequency"];
        self.dateTime = [aDecoder decodeObjectForKey:@"dateTime"];
        self.celsius = [aDecoder decodeObjectForKey:@"temp1"];
        self.fahrenheit = [aDecoder decodeObjectForKey:@"temp2"];
        self.moisture = [aDecoder decodeObjectForKey:@"moisture"];
      
    }
    return self;
}
- (id)copyWithZone:(NSZone *)zone{
    AsTagItem *asTagItem=[[[self class] allocWithZone:zone] init];
    asTagItem.tag=self.tag;
    asTagItem.tid=self.tid;
    asTagItem.count=self.count;
    asTagItem.rssi  =self.rssi;
    asTagItem.phase  =self.phase;
    asTagItem.frequency  =self.frequency;
    asTagItem.dateTime  =self.dateTime;
    asTagItem.celsius  =self.celsius;
    asTagItem.fahrenheit  =self.fahrenheit;
    asTagItem.moisture  =self.moisture;
    return asTagItem;
}
+ (id)itemWith:(NSString *)tag rssi:(float)rssi phase:(float)phase frequency:(float)frequency tid:(NSString*)tid{
    AsTagItem *item = [[AsTagItem alloc] init];
    [item setTag:tag];
    [item setTid:tid];
    [item setRssi:rssi];
    [item setPhase:phase];
    [item setFrequency:frequency];
    [item setCount:1];
    [item setCelsius:@""];
    [item setFahrenheit:@""];
    [item setMoisture:@""];
    
    NSDate *timeDate = [NSDate date];
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateStyle:NSDateFormatterMediumStyle];
    [formatter setTimeStyle:NSDateFormatterShortStyle];
    [formatter setDateFormat:@"YYYY/MM/dd HH:mm:ss"];
    NSString *dateTime = [formatter stringFromDate:timeDate];
    [item setDateTime:dateTime];
    return item;
}


+ (id)itemWithRFM:(NSString *)tag temp1:(NSString *)temp1 temp2:(NSString *)temp2 moisture:(NSString *)moisture{
    
    AsTagItem *item = [[AsTagItem alloc] init];
    [item setTag:tag];
    [item setCount:1];
    [item setCelsius:temp1];
    [item setFahrenheit:temp2];
    [item setMoisture:moisture];
    [item setTid:@""];
    [item setRssi:0.0];
    
    NSDate *timeDate = [NSDate date];
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateStyle:NSDateFormatterMediumStyle];
    [formatter setTimeStyle:NSDateFormatterShortStyle];
    [formatter setDateFormat:@"YYYY/MM/dd HH:mm:ss"];
    NSString *dateTime = [formatter stringFromDate:timeDate];
    [item setDateTime:dateTime];
    return item;
}

- (void)updateRFMTemp1:(NSString *)temp1 temp2:(NSString *)temp2 moisture:(NSString *)moisture {
    NSDate *timeDate = [NSDate date];
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateStyle:NSDateFormatterMediumStyle];
    [formatter setTimeStyle:NSDateFormatterShortStyle];
    [formatter setDateFormat:@"YYYY/MM/dd HH:mm:ss"];
    NSString *dateTime = [formatter stringFromDate:timeDate];
    [self setDateTime:dateTime];
    [self setCelsius:temp1];
    [self setFahrenheit:temp2];
    [self setMoisture:moisture];
}

- (void)updateRssi:(float)rssi withPhase:(float)phase frequency:(float)frequency {
    NSDate *timeDate = [NSDate date];
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateStyle:NSDateFormatterMediumStyle];
    [formatter setTimeStyle:NSDateFormatterShortStyle];
    [formatter setDateFormat:@"YYYY/MM/dd HH:mm:ss"];
    NSString *dateTime = [formatter stringFromDate:timeDate];
    [self setDateTime:dateTime];
    [self setRssi:rssi];
    [self setPhase:phase];
    [self setFrequency:frequency];
    [self setCelsius:@""];
    [self setFahrenheit:@""];
    [self setMoisture:@""];
}
- (void)updateRssi:(float)rssi withPhase:(float)phase frequency:(float)frequency data:(NSString*)data{
    NSDate *timeDate = [NSDate date];
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateStyle:NSDateFormatterMediumStyle];
    [formatter setTimeStyle:NSDateFormatterShortStyle];
    [formatter setDateFormat:@"YYYY/MM/dd HH:mm:ss"];
    NSString *dateTime = [formatter stringFromDate:timeDate];
    [self setDateTime:dateTime];
    [self setRssi:rssi];
    [self setPhase:phase];
    [self setFrequency:frequency];
    [self setTid:data];
    [self setCelsius:@""];
    [self setFahrenheit:@""];
    [self setMoisture:@""];
}
@end
