#import "AsBarcodeItem.h"

@implementation AsBarcodeItem
- (void)encodeWithCoder:(NSCoder *)aCoder
{
    [aCoder encodeInt:self.barcodeType forKey:@"barcodeType"];
    [aCoder encodeObject:self.codeId forKey:@"codeId"];
    [aCoder encodeObject:self.barcode forKey:@"barcode"];
    [aCoder encodeObject:self.dateTime forKey:@"dateTime"];
    [aCoder encodeObject:self.count forKey:@"count"];
}
- (nullable instancetype)initWithCoder:(NSCoder *)aDecoder
{
    if (self = [super init]) {
        self.barcodeType = [aDecoder decodeIntForKey:@"barcodeType"];
        self.codeId = [aDecoder decodeObjectForKey:@"codeId"];
        self.barcode = [aDecoder decodeObjectForKey:@"barcode"];
        self.dateTime = [aDecoder decodeObjectForKey:@"dateTime"];
        self.count = [aDecoder decodeObjectForKey:@"count"];
    }
    return self;
}
- (id)copyWithZone:(NSZone *)zone{
    AsBarcodeItem *asBarItem=[[[self class] allocWithZone:zone] init];
    asBarItem.barcodeType=self.barcodeType;
    asBarItem.codeId=self.codeId;
    asBarItem.barcode  =self.barcode;
    asBarItem.dateTime  =self.dateTime;
    asBarItem.count  =self.count;
    return asBarItem;
}
@end
