#import <UIKit/UIKit.h>
#import <AsReaderGunSDK/AsReaderGunSDK.h>
#import "MBProgressHUD.h"
#import <AsRingAccessorySDK/AsRingDeviceSDK.h>

#define PRINT_LOG       0

#define kBluetoothAlertView         0
#define kDeviceAlertView            1
#define VersionAlertView            2
#define VersionForceAlertView       3

#define DATA_TARGET             @[@"S0", @"S1", @"S2", @"S3", @"SL"]
#define DATA_ACTION             @[@"AB", @"AN", @"NB", @"MN", @"BA", @"BN", @"NA", @"NM"]
#define DATA_BANK               @[@"Reserved", @"EPC", @"TID", @"User"]
#define DATA_BIT                @[@"0", @"16", @"32", @"48", @"64", @"80", @"96", @"112", @"128", @"144", @"160", @"176", @"192", @"208", @"224", @"240"]
#define DATA_WORD               @[@"0", @"1", @"2", @"3", @"4", @"5", @"6", @"7", @"8", @"9", @"10", @"11", @"12", @"13", @"14", @"15"]
#define DATA_SELECT_FLAG        @[@"SL", @"~SL", @"All"]
#define DATA_INVENTORY_SESSION  @[@"S0", @"S1", @"S2", @"S3"]
#define DATA_SESSION_FLAG       @[@"A Only", @"B Only", @"A or B"]

#define MAX_PASSWORD_LENGTH         8
#define MAX_WRITE_DATA_WORD         32
#define MAX_WRITE_DATA_LENGTH       MAX_WRITE_DATA_WORD * 4

@interface AppDelegate : UIResponder <UIApplicationDelegate> {
    
}
- (void)initMask:(NSString *)maskValue maskType:(MaskType)maskType;
- (void)exitMask;
- (NSString *)getAppVersion;
+ (MBProgressHUD *)showGlobalProgressHUDWithTitle:(NSString *)title;
+ (void)dismissGlobalHUD;

@property (strong, nonatomic) UIWindow *window;
@property (strong, nonatomic) AsReaderGUN *mAsReaderGUN;
@property (strong, nonatomic) AsReader *mReader; 
@property (strong, nonatomic) MBProgressHUD *HUD;
@property (strong, nonatomic) NSMutableArray *barcodeData;
@property (strong, nonatomic) NSMutableArray *rfidData;
@property (strong, nonatomic) NSMutableDictionary *mapTags;
@property (strong, nonatomic) NSOperationQueue * insertOperation;
@end

