import 'asreader_m24d_plugin_platform_interface.dart';
import 'asreader_m24d_plugin_define.dart';
import 'package:asreader_m24d_plugin/SymbologyInfoModel.dart';
import 'package:asreader_m24d_plugin/OCRInfoModel.dart';

class AsreaderM24dPlugin {
  String ONCONNECT = "onConnect";
  String ONBATTERYSTATERECEIVED = "onBatteryStateReceived";
  String ONTRIGGEREVENTRECEIVED = "onTriggerEventReceived";
  String ONREADERINFORECEIVED = "onReaderInfoReceived";
  String ONSETREADERSETTINGSUCCESS = "onSetReaderSettingSuccess";
  String ONREADERSETTINGRECEIVED = "onReaderSettingReceived";
  String ONSLEEPSETTINGRECEIVED = "onSleepSettingReceived";
  String ONSETCHARGECONTROLSUCCESS = "onSetChargeControlSuccess";
  String ONHIDMODERECEIVED = "onHIDModeReceived";
  String ONDEVICEMANAGERERROR = "onDeviceManagerError";
  String ONRECEIVEDBARCODEDECODEDATA = "onReceivedBarcodeDecodeData";
  String ONRECEIVEDBARCODEDECODEDATABYTE = "onReceivedBarcodeDecodeDataByte";
  String ONRECEIVEDRESPONSE = "onReceivedResponse";
  String ONBARCODEMANAGERSTANDBYREADY = "onBarcodeManagerStandByReady";
  String ONBARCODEMANAGERERROR = "onBarcodeManagerError";

  Future<String?> getPlatformVersion() {
    return AsreaderM24dPluginPlatform.instance.getPlatformVersion();
  }

  Future<String?> getSDKVersion() {
    return AsreaderM24dPluginPlatform.instance.getSDKVersion();
  }

  Future<void> setConnectionType(ConnectionType connectionType) {
    return AsreaderM24dPluginPlatform.instance.setConnectionType(
      connectionType,
    );
  }

  Future<void> setLogLevel(LogLevel logLevel) {
    return AsreaderM24dPluginPlatform.instance.setLogLevel(logLevel);
  }

  Future<LogLevel?> getLogLevel() {
    return AsreaderM24dPluginPlatform.instance.getLogLevel();
  }

  Future<void> setLog(bool enable) {
    return AsreaderM24dPluginPlatform.instance.setLog(enable);
  }

  Future<void> removeSDKLog() {
    return AsreaderM24dPluginPlatform.instance.removeSDKLog();
  }

  Future<void> enableAutoLaunchApp(bool enable, String aliasName) {
    return AsreaderM24dPluginPlatform.instance.enableAutoLaunchApp(
      enable,
      aliasName,
    );
  }

  Future<BarcodeSettings?> getCharacterStatus() {
    return AsreaderM24dPluginPlatform.instance.getCharacterStatus();
  }

  Future<void> setDecodeMode(BarcodeSettings mode) {
    return AsreaderM24dPluginPlatform.instance.setDecodeMode(mode);
  }

  Future<BarcodeSettings?> getDecodeMode() {
    return AsreaderM24dPluginPlatform.instance.getDecodeMode();
  }

  Future<void> setEncodeMode(QREncodeMode qrEncodeMode) {
    return AsreaderM24dPluginPlatform.instance.setEncodeMode(qrEncodeMode);
  }

  Future<QREncodeMode?> getEncodeMode() {
    return AsreaderM24dPluginPlatform.instance.getEncodeMode();
  }

  Future<void> startDecode() {
    return AsreaderM24dPluginPlatform.instance.startDecode();
  }

  Future<void> startDecodeWithCountTime(int count, int time) {
    return AsreaderM24dPluginPlatform.instance.startDecodeWithCountTime(
      count,
      time,
    );
  }

  Future<void> stopDecode() {
    return AsreaderM24dPluginPlatform.instance.stopDecode();
  }

  Future<void> factoryDefault() {
    return AsreaderM24dPluginPlatform.instance.factoryDefault();
  }

  Future<void> getStopCondition() {
    return AsreaderM24dPluginPlatform.instance.getStopCondition();
  }

  Future<void> setBarcodeSettings(MemoryType memoryType, BarcodeSettings settingsType) {
    return AsreaderM24dPluginPlatform.instance.setBarcodeSettings(
      memoryType,
      settingsType,
    );
  }

  Future<void> getBarcodeSettings(BarcodeSettings settingsType) {
    return AsreaderM24dPluginPlatform.instance.getBarcodeSettings(settingsType);
  }

  Future<void> setSymbologyAllEnable(MemoryType memoryType, bool isEnable) {
    return AsreaderM24dPluginPlatform.instance.setSymbologyAllEnable(memoryType, isEnable);
  }

  Future<void> setSymbologySettings(MemoryType memoryType, Symbology symbology, bool isEnable) {
    return AsreaderM24dPluginPlatform.instance.setSymbologySettings(memoryType, symbology, isEnable);
  }

  Future<void> setSymbologyListSettings(MemoryType memoryType, List<SymbologyInfoModel> symbologyInfoList) {
    return AsreaderM24dPluginPlatform.instance.setSymbologyListSettings(memoryType, symbologyInfoList);
  }

  Future<void> setOCRSettings(MemoryType memoryType, OCR ocr, bool isEnable) {
    return AsreaderM24dPluginPlatform.instance.setOCRSettings(memoryType, ocr, isEnable);
  }

  Future<void> setOCRListSettings(MemoryType memoryType, List<OCRInfoModel> ocrInfoList) {
    return AsreaderM24dPluginPlatform.instance.setOCRListSettings(memoryType, ocrInfoList);
  }

  Future<void> getSymbologySettings(Symbology symbology) {
    return AsreaderM24dPluginPlatform.instance.getSymbologySettings(symbology);
  }

  Future<void> getSymbologySettingsList(List<Symbology> symbologyList) {
    return AsreaderM24dPluginPlatform.instance.getSymbologySettingsList(symbologyList);
  }

  Future<void> getOCRSettings(OCR ocr) {
    return AsreaderM24dPluginPlatform.instance.getOCRSettings(ocr);
  }

  Future<void> getOCRSettingsList(List<OCR> ocrList) {
    return AsreaderM24dPluginPlatform.instance.getOCRSettingsList(ocrList);
  }

  Future<SystemBeepSoundType?> getSystemBeep() {
    return AsreaderM24dPluginPlatform.instance.getSystemBeep();
  }

  Future<void> setNotisEditing(MemoryType memoryType, bool isEnabled) {
    return AsreaderM24dPluginPlatform.instance.setNotisEditing(memoryType, isEnabled);
  }

  Future<void> getNotisEditing() {
    return AsreaderM24dPluginPlatform.instance.getNotisEditing();
  }

  Future<void> setPresentationMode(MemoryType memoryType, BarcodeSettings settingsType) {
    return AsreaderM24dPluginPlatform.instance.setPresentationMode(memoryType, settingsType);
  }

  Future<void> getPresentationMode() {
    return AsreaderM24dPluginPlatform.instance.getPresentationMode();
  }

  Future<bool?> isConnected() {
    return AsreaderM24dPluginPlatform.instance.isConnected();
  }

  Future<void> setTriggerMode(TriggerMode mode) {
    return AsreaderM24dPluginPlatform.instance.setTriggerMode(mode);
  }

  Future<TriggerMode?> getTriggerMode() {
    return AsreaderM24dPluginPlatform.instance.getTriggerMode();
  }

  Future<bool?> getBackgroundRead() {
    return AsreaderM24dPluginPlatform.instance.getBackgroundRead();
  }

  Future<bool?> isOpen() {
    return AsreaderM24dPluginPlatform.instance.isOpen();
  }

  Future<void> open() {
    return AsreaderM24dPluginPlatform.instance.open();
  }

  Future<void> close() {
    return AsreaderM24dPluginPlatform.instance.close();
  }

  Future<void> setReaderSettings(bool beep, bool vib, bool aimer, bool led, bool powerOnBeep) {
    return AsreaderM24dPluginPlatform.instance.setReaderSettings(beep, vib, aimer, led, powerOnBeep);
  }

  Future<void> getReaderSettings() {
    return AsreaderM24dPluginPlatform.instance.getReaderSettings();
  }

  Future<void> getReaderInfo() {
    return AsreaderM24dPluginPlatform.instance.getReaderInfo();
  }

  Future<void> setSleepTime(int sleepTime) {
    return AsreaderM24dPluginPlatform.instance.setSleepTime(sleepTime);
  }

  Future<void> getSleepTime() {
    return AsreaderM24dPluginPlatform.instance.getSleepTime();
  }

  Future<void> setSleepBeep(bool isSleepBeepOn) {
    return AsreaderM24dPluginPlatform.instance.setSleepBeep(isSleepBeepOn);
  }

  Future<void> getSleepBeep() {
    return AsreaderM24dPluginPlatform.instance.getSleepBeep();
  }

  Future<void> setSleepTimeAndBeep(int sleepTime, bool isSleepBeepOn) {
    return AsreaderM24dPluginPlatform.instance.setSleepTimeAndBeep(sleepTime, isSleepBeepOn);
  }

  Future<void> getSleepTimeAndBeep() {
    return AsreaderM24dPluginPlatform.instance.getSleepTimeAndBeep();
  }

  Future<void> setHIDMode(HIDType hidMode) {
    return AsreaderM24dPluginPlatform.instance.setHIDMode(hidMode);
  }

  Future<void> getHIDMode() {
    return AsreaderM24dPluginPlatform.instance.getHIDMode();
  }
}
