/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.devicemanager;

import jp.co.asterisk.asreader.a24d.communicationmanager.packet.AsReaderPacketConst;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.PacketModel;
import jp.co.asterisk.asreader.devicemanager.DeviceConst;

class DeviceCommandFactory {
    private static DeviceCommandFactory instance;

    private DeviceCommandFactory() {
    }

    public static DeviceCommandFactory getInstance() {
        if (instance == null) {
            instance = new DeviceCommandFactory();
        }
        return instance;
    }

    public PacketModel create(DeviceConst.DeviceCommandType type) {
        switch (type) {
            case SET_READER_SETTING: {
                return this.createSetReaderSetting();
            }
            case GET_READER_SETTING: {
                return this.createGetReaderSetting();
            }
            case READER_INFO: {
                return this.createReaderInfo();
            }
            case SET_CHARGING_CONTROL: {
                return this.createSetChargeControl();
            }
            case GET_SLEEP_TIME: {
                return this.createGetSleepSetting(true, false);
            }
            case SET_SLEEP_TIME: {
                return this.createSetSleepSetting(true, false);
            }
            case GET_SLEEP_BEEP: {
                return this.createGetSleepSetting(false, true);
            }
            case SET_SLEEP_BEEP: {
                return this.createSetSleepSetting(false, true);
            }
            case GET_SLEEP_TIME_AND_BEEP: {
                return this.createGetSleepSetting(true, true);
            }
            case SET_SLEEP_TIME_AND_BEEP: {
                return this.createSetSleepSetting(true, true);
            }
            case SET_HID_MODE: 
            case GET_HID_MODE: {
                return this.createHIDMode();
            }
        }
        return null;
    }

    private PacketModel createPacketModel(byte type, byte command, byte[] payload) {
        PacketModel packetModel = new PacketModel();
        packetModel.setCommand(type, command, payload);
        return packetModel;
    }

    private PacketModel createSetReaderSetting() {
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_SET_DEVICE_SETTINGS.getByte(), null);
    }

    private PacketModel createGetReaderSetting() {
        byte[] payload = new byte[]{0};
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_GET_DEVICE_SETTINGS.getByte(), payload);
    }

    private PacketModel createReaderInfo() {
        byte[] payload = new byte[]{-78};
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_GET_READER_INFO.getByte(), payload);
    }

    private PacketModel createSetChargeControl() {
        byte[] payload = new byte[1];
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_SET_CHARGE_CONTROL.getByte(), payload);
    }

    private PacketModel createHIDMode() {
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE_COMBO_BARCODE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_HID_MODE.getByte(), new byte[]{0, 0});
    }

    private PacketModel createSetSleepSetting(boolean sleepTime, boolean sleepBeep) {
        byte count;
        byte start;
        byte change = -128;
        byte reserve = 0;
        if (sleepTime && sleepBeep) {
            start = 0;
            count = 2;
        } else {
            start = sleepTime ? (byte)0 : 1;
            count = 1;
        }
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_SET_MODULE_SLEEP_SETTING.getByte(), new byte[]{start, count, change, reserve});
    }

    private PacketModel createGetSleepSetting(boolean sleepTime, boolean sleepBeep) {
        byte count;
        byte start;
        if (sleepTime && sleepBeep) {
            start = 0;
            count = 2;
        } else {
            start = sleepTime ? (byte)0 : 1;
            count = 1;
        }
        return this.createPacketModel(AsReaderPacketConst.AsReaderPacket.MESSAGE.getByte(), AsReaderPacketConst.AsReaderPacket.CMD_GET_MODULE_SLEEP_SETTING.getByte(), new byte[]{start, count});
    }
}

