/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.utility;

import android.content.Context;
import android.content.SharedPreferences;
import jp.co.asterisk.asreader.a24d.utility.SDKLog;

public class SDKSharedData {
    private static final String TAG = "[A24D_SDK] " + SDKLog.class.getSimpleName();
    private static SDKSharedData mInstance;
    private SharedPreferences mSharedPreference;
    private String mDataKey;

    private SDKSharedData() {
    }

    public static SDKSharedData getInstance() {
        if (mInstance == null) {
            mInstance = new SDKSharedData();
        }
        return mInstance;
    }

    public void initialize(String key, Context context) {
        this.mDataKey = key;
        this.mSharedPreference = context.getSharedPreferences(this.mDataKey, 0);
    }

    public void putString(String key, String data) {
        this.mSharedPreference.edit().putString(key, data).apply();
    }

    public void putInt(String key, int data) {
        this.mSharedPreference.edit().putInt(key, data).apply();
    }

    public void putFloat(String key, float data) {
        this.mSharedPreference.edit().putFloat(key, data).apply();
    }

    public void putLong(String key, long data) {
        this.mSharedPreference.edit().putLong(key, data).apply();
    }

    public void putBoolean(String key, boolean data) {
        this.mSharedPreference.edit().putBoolean(key, data).apply();
    }

    public String getString(String key, String defaultValue) {
        return this.mSharedPreference.getString(key, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return this.mSharedPreference.getInt(key, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        return this.mSharedPreference.getFloat(key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return this.mSharedPreference.getLong(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.mSharedPreference.getBoolean(key, defaultValue);
    }
}

