/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.utility;

public class AsReaderError {
    private static final byte BYTE_NOT_SUPPORTED = 1;
    private static final byte BYTE_WITHOUT_AUTHORITY = 2;
    private static final byte BYTE_MEMORY_OVERRUN = 3;
    private static final byte BYTE_MEMORY_LOCKED = 4;
    private static final byte BYTE_CRYPTO_SUITE_ERROR = 5;
    private static final byte BYTE_COMMAND_NOT_ENCAPSULATED = 6;
    private static final byte BYTE_RESPONSE_BUFFER_OVERFLOW = 7;
    private static final byte BYTE_SECURITY_TIMEOUT = 8;
    private static final byte BYTE_SSI_BEEP_GETTING_FAIL = 9;
    private static final byte BYTE_INSUFFICIENT_POWER = 11;
    private static final byte BYTE_NON_SPECIFIC_ERROR = 15;
    private static final byte BYTE_FAILED_TO_SEND_PACKET = -2;
    private static final byte BYTE_ALREADY_POWER_ON = -1;

    public static ErrorCode getError(byte buf) {
        ErrorCode[] findArray;
        for (ErrorCode code : findArray = ErrorCode.values()) {
            if (code.getByte() != buf) continue;
            return code;
        }
        return ErrorCode.NON_SPECIFIC_ERROR;
    }

    public static enum ErrorCode {
        NOT_SUPPORTED{

            @Override
            public String getMessage() {
                return "Not supported[" + String.format("%02X", (byte)1) + "]";
            }

            @Override
            public byte getByte() {
                return 1;
            }
        }
        ,
        WITHOUT_AUTHORITY{

            @Override
            public String getMessage() {
                return "Without authority[" + String.format("%02X", (byte)1) + "]";
            }

            @Override
            public byte getByte() {
                return 2;
            }
        }
        ,
        MEMORY_OVERRUN{

            @Override
            public String getMessage() {
                return "Memory overrun[" + String.format("%02X", (byte)3) + "]";
            }

            @Override
            public byte getByte() {
                return 3;
            }
        }
        ,
        MEMORY_LOCKED{

            @Override
            public String getMessage() {
                return "Memory locked[" + String.format("%02X", (byte)4) + "]";
            }

            @Override
            public byte getByte() {
                return 4;
            }
        }
        ,
        CRYPTO_SUITE_ERROR{

            @Override
            public String getMessage() {
                return "Crypto suite error[" + String.format("%02X", (byte)5) + "]";
            }

            @Override
            public byte getByte() {
                return 5;
            }
        }
        ,
        COMMAND_NOT_ENCAPSULATED{

            @Override
            public String getMessage() {
                return "Command not encapsulated[" + String.format("%02X", (byte)6) + "]";
            }

            @Override
            public byte getByte() {
                return 6;
            }
        }
        ,
        RESPONSE_BUFFER_OVERFLOW{

            @Override
            public String getMessage() {
                return "Response buffer overflow[" + String.format("%02X", (byte)7) + "]";
            }

            @Override
            public byte getByte() {
                return 7;
            }
        }
        ,
        SECURITY_TIMEOUT{

            @Override
            public String getMessage() {
                return "Security timeout[" + String.format("%02X", (byte)8) + "]";
            }

            @Override
            public byte getByte() {
                return 8;
            }
        }
        ,
        INSUFFICIENT_POWER{

            @Override
            public String getMessage() {
                return "Insufficient power[" + String.format("%02X", (byte)11) + "]";
            }

            @Override
            public byte getByte() {
                return 11;
            }
        }
        ,
        NON_SPECIFIC_ERROR{

            @Override
            public String getMessage() {
                return "Non specific error[" + String.format("%02X", (byte)15) + "]";
            }

            @Override
            public byte getByte() {
                return 15;
            }
        }
        ,
        ALREADY_POWER_ON{

            @Override
            public String getMessage() {
                return "Power is already on[" + String.format("%02X", (byte)-1) + "]";
            }

            @Override
            public byte getByte() {
                return -1;
            }
        }
        ,
        FAILED_TO_SEND_PACKET{

            @Override
            public String getMessage() {
                return "Failed to send packet[" + String.format("%02X", (byte)-2) + "]";
            }

            @Override
            public byte getByte() {
                return -2;
            }
        };


        public abstract String getMessage();

        public abstract byte getByte();
    }
}

