/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.barcodemanager;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import jp.co.asterisk.asreader.a24d.utility.LogLevel;
import jp.co.asterisk.asreader.a24d.utility.SDKLog;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeConst;

public class StringEncoder {
    private static final String TAG = "\u3010AsReaderSDK\u3011" + StringEncoder.class.getSimpleName();
    private static StringEncoder instance;
    private String[] encodeTypeArray = new String[]{"UTF-8", "UTF-16", "UTF-32", "Shift_JIS", "EUC_KR"};

    private StringEncoder() {
    }

    public static StringEncoder getInstance() {
        if (instance == null) {
            instance = new StringEncoder();
        }
        return instance;
    }

    public String getEncodeTypeString(StringEncodeType type) {
        int index = type.ordinal();
        return this.encodeTypeArray[index];
    }

    public String encodeByteData(byte[] data, String encode) {
        try {
            String str = new String(data, encode);
            return str;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public StringEncodeType checkIncludeCharacter(byte[] data) {
        StringEncodeType type = StringEncodeType.UNKNOWN;
        for (int i = 0; i < data.length; ++i) {
            String encodeType;
            int n;
            byte[] buf = new byte[]{data[i]};
            String[] stringArray = this.encodeTypeArray;
            int n2 = stringArray.length;
            for (n = 0; n < n2 && (type = this.checkEncodeType(buf, encodeType = stringArray[n])) == StringEncodeType.UNKNOWN; ++n) {
            }
            if (type == StringEncodeType.UNKNOWN) {
                int n3;
                if (i >= data.length - 1) {
                    return type;
                }
                byte[] bufTwoByte = new byte[]{data[i], data[i + 1]};
                String[] stringArray2 = this.encodeTypeArray;
                n = stringArray2.length;
                for (n3 = 0; n3 < n; ++n3) {
                    String encodeType2 = stringArray2[n3];
                    type = this.checkEncodeType(bufTwoByte, encodeType2);
                    if (type == StringEncodeType.UNKNOWN) continue;
                    return type;
                }
                if (type != StringEncodeType.UNKNOWN) continue;
                if (i >= data.length - 2) {
                    return type;
                }
                byte[] bufThreeByte = new byte[]{data[i], data[i + 1], data[i + 2]};
                String[] stringArray3 = this.encodeTypeArray;
                n3 = stringArray3.length;
                for (int j = 0; j < n3; ++j) {
                    String encodeType3 = stringArray3[j];
                    type = this.checkEncodeType(bufThreeByte, encodeType3);
                    if (type == StringEncodeType.UNKNOWN) continue;
                    return type;
                }
                continue;
            }
            if (type == StringEncodeType.UTF_8 || type == StringEncodeType.UTF_16 || type == StringEncodeType.UTF_32) continue;
            return type;
        }
        return type;
    }

    private StringEncodeType checkEncodeType(byte[] data, String encode) {
        try {
            byte[] tmp = new String(data, encode).getBytes(encode);
            if (Arrays.equals(tmp, data)) {
                if (encode.equals("UTF-8")) {
                    return StringEncodeType.UTF_8;
                }
                if (encode.equals("UTF-16")) {
                    return StringEncodeType.UTF_16;
                }
                if (encode.equals("UTF-32")) {
                    return StringEncodeType.UTF_32;
                }
                if (encode.equals("Shift_JIS")) {
                    return StringEncodeType.SHIFT_JIS;
                }
                if (encode.equals("EUC_KR")) {
                    return StringEncodeType.EUC_KR;
                }
                return StringEncodeType.UNKNOWN;
            }
        }
        catch (UnsupportedEncodingException ex) {
            SDKLog.getInstance().Log(TAG, LogLevel.Error, "checkEncodeType UnsupportedEncodingException" + ex.getMessage());
            return StringEncodeType.UNKNOWN;
        }
        return StringEncodeType.UNKNOWN;
    }

    public static enum StringEncodeType {
        UTF_8,
        UTF_16,
        UTF_32,
        SHIFT_JIS,
        EUC_KR,
        AUTO,
        UNKNOWN;


        public static StringEncodeType getEncodeMode(BarcodeConst.QREncodeMode mode) {
            switch (mode) {
                case UTF_8: {
                    return UTF_8;
                }
                case UTF_16: {
                    return UTF_16;
                }
                case UTF_32: {
                    return UTF_32;
                }
                case SHIFT_JIS: {
                    return SHIFT_JIS;
                }
                case EUC_KR: {
                    return EUC_KR;
                }
                case AUTO: {
                    return AUTO;
                }
            }
            return UNKNOWN;
        }
    }
}

