/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.barcodemanager;

import android.content.Context;
import android.util.Log;
import androidx.annotation.IntRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.co.asterisk.asreader.a24d.communicationmanager.CommunicationBarcodeCallback;
import jp.co.asterisk.asreader.a24d.communicationmanager.CommunicationManager;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.PacketModel;
import jp.co.asterisk.asreader.a24d.utility.LogLevel;
import jp.co.asterisk.asreader.a24d.utility.SDKLog;
import jp.co.asterisk.asreader.a24d.utility.SDKSharedData;
import jp.co.asterisk.asreader.barcodemanager.BarcodeCommandFactory;
import jp.co.asterisk.asreader.barcodemanager.BarcodeCommandType;
import jp.co.asterisk.asreader.barcodemanager.BarcodeManagerCallback;
import jp.co.asterisk.asreader.barcodemanager.StringEncoder;
import jp.co.asterisk.asreader.barcodemanager.SymbologyInfoModel;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeConst;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeManagerError;
import jp.co.asterisk.asreader.barcodemanager.define.BarcodeResult;
import jp.co.asterisk.asreader.barcodemanager.define.OCR;
import jp.co.asterisk.asreader.barcodemanager.define.SSICommandModel;
import jp.co.asterisk.asreader.barcodemanager.define.SecurityLevels;
import jp.co.asterisk.asreader.barcodemanager.define.Symbology;
import jp.co.asterisk.asreader.barcodemanager.model.OCRInfoModel;
import jp.co.asterisk.asreader.barcodemanager.model.SecurityInfoModel;
import jp.co.asterisk.asreader.barcodemanager.parse.BarcodePacketParser;
import jp.co.asterisk.asreader.barcodemanager.parse.BarcodePacketParserCallback;

public class BarcodeManager
implements CommunicationBarcodeCallback,
BarcodePacketParserCallback {
    private static final String TAG = "\u3010AsReaderSDK\u3011" + BarcodeManager.class.getSimpleName();
    private static final String TAG_TEST = "\u3010AsReaderSDKBarcodeManagerTEST\u3011" + BarcodeManager.class.getSimpleName();
    private static final String TAG_SYMBOLDATA_TEST = "\u3010AsReaderSDKBarcodeManagerSymbolTEST\u3011" + BarcodeManager.class.getSimpleName();
    private static final String KEY_DECODE_MODE = "key_DecodeMode";
    private static final String KEY_ENCODE_MODE = "key_EncodeMode";
    private static BarcodeManager instance;
    private BarcodeManagerCallback mCallback;
    private BarcodeResult.Result mScanDataFormatType = BarcodeResult.Result.UNKNOWN;
    private BarcodeConst.BarcodeSettings mCharacterType = BarcodeConst.BarcodeSettings.CHARACTER_NONE;
    private PacketModel mSSIPacket = null;
    private BarcodeConst.BarcodeCommandAction mSSICommandAction = BarcodeConst.BarcodeCommandAction.UNSET;
    private boolean isSendCharacterAction = false;
    private InitializeProgress mInitProcess = InitializeProgress.UNTREATED;
    private OCRPrerequisite mOCRPrerequisite = OCRPrerequisite.FINISH;
    private BarcodeResult ocrSetResult;
    private static final String KEY_SAVE_SYSTEM_BEEP = "keySaveSystemBeep";

    private BarcodeManager() {
        BarcodePacketParser.getInstance().setCallback(this);
    }

    public static BarcodeManager getInstance() {
        if (instance == null) {
            instance = new BarcodeManager();
        }
        return instance;
    }

    public BarcodeConst.BarcodeSettings getCharacterStatus() {
        return this.mCharacterType;
    }

    public void setCallback(BarcodeManagerCallback callback) {
        this.mCallback = callback;
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "Barcode manager callback set");
    }

    public void setDecodeMode(BarcodeConst.BarcodeSettings mode) {
        SDKSharedData.getInstance().putString(KEY_DECODE_MODE, mode.toString());
    }

    public BarcodeConst.BarcodeSettings getDecodeMode() {
        try {
            String string = SDKSharedData.getInstance().getString(KEY_DECODE_MODE, BarcodeConst.BarcodeSettings.DECODE_MODE_SINGLE.toString());
            return BarcodeConst.BarcodeSettings.valueOf(string);
        }
        catch (Exception ex) {
            return BarcodeConst.BarcodeSettings.DECODE_MODE_SINGLE;
        }
    }

    public void setEncodeMode(BarcodeConst.QREncodeMode mode) {
        int value = mode.ordinal();
        SDKSharedData.getInstance().putInt(KEY_ENCODE_MODE, value);
    }

    public BarcodeConst.QREncodeMode getEncodeMode() {
        int value = SDKSharedData.getInstance().getInt(KEY_ENCODE_MODE, 0);
        BarcodeConst.QREncodeMode[] modeArray = BarcodeConst.QREncodeMode.values();
        return modeArray[value];
    }

    public void initialize(Context context) {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "initialize");
        CommunicationManager.getInstance().setCommunicationBarcodeCallback((CommunicationBarcodeCallback)this);
    }

    public void startDecode() {
        BarcodeConst.BarcodeSettings mode = this.getDecodeMode();
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "startDecode : Mode = " + (Object)((Object)mode));
        switch (mode) {
            case DECODE_MODE_SINGLE: {
                this.startDecode(1, 0);
                break;
            }
            case DECODE_MODE_CONTINUOUS: {
                this.startDecode(255, 0);
            }
        }
    }

    public void startDecode(@IntRange(from=0L, to=255L) int count, @IntRange(from=0L, to=255L) int time) {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "startDecode");
        if (count < 0 || count > 255 || time < 0 || time > 255) {
            return;
        }
        PacketModel packetModel = BarcodeCommandFactory.getInstance().create(BarcodeCommandType.START_DECODE);
        packetModel.setPayload(new byte[]{2, (byte)count, (byte)time, 0, 0});
        this.sendPacket(packetModel);
    }

    public void stopDecode() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "stopDecode");
        PacketModel packetModel = BarcodeCommandFactory.getInstance().create(BarcodeCommandType.STOP_DECODE);
        this.sendPacket(packetModel);
    }

    public void factoryDefault() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "factoryDefault");
        PacketModel packetModel = BarcodeCommandFactory.getInstance().create(BarcodeCommandType.FACTORY_DEFAULT);
        this.sendPacket(packetModel);
    }

    public void getStopCondition() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "DeviceManager getStopCondition");
        PacketModel packetModel = BarcodeCommandFactory.getInstance().create(BarcodeCommandType.GET_STOP_CONDITION);
        this.sendPacket(packetModel);
    }

    public void setBarcodeSettings(BarcodeConst.MemoryType memoryType, BarcodeConst.BarcodeSettings settingsType) {
        this.mCharacterType = settingsType;
        switch (settingsType) {
            case CHARACTER_CODE_ID_SYMBOL: 
            case CHARACTER_CODE_ID_AIM: 
            case CHARACTER_NONE: {
                this.isSendCharacterAction = true;
                break;
            }
        }
        Log.d((String)TAG_TEST, (String)("isSendCharacterAction : " + (this.isSendCharacterAction ? "True" : "False")));
        this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.SETTINGS_CHARACTER_STATUS;
        byte[] bytes = BarcodeCommandFactory.getInstance().create(settingsType);
        byte[] sendBytes = new byte[bytes.length];
        int count = 0;
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte buf;
            sendBytes[count] = buf = byArray[i];
            ++count;
        }
        PacketModel packetModel = BarcodeCommandFactory.getInstance().createSetSSIParam(memoryType.getCommand(), this.getSaveSystemBeepValue().getCommand(), sendBytes);
        this.sendSSIPacket(packetModel);
    }

    public void setPresentationMode(BarcodeConst.MemoryType memoryType, BarcodeConst.BarcodeSettings settingsType) {
        if (settingsType == BarcodeConst.BarcodeSettings.TRIGGER_PRESENTATION || settingsType == BarcodeConst.BarcodeSettings.TRIGGER_STANDARD) {
            this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.SETTINGS_PRESENTATION_MODE;
            byte[] bytes = BarcodeCommandFactory.getInstance().create(settingsType);
            PacketModel packetModel = BarcodeCommandFactory.getInstance().createSetSSIParam(memoryType.getCommand(), this.getSaveSystemBeepValue().getCommand(), bytes);
            this.sendSSIPacket(packetModel);
        }
    }

    public void getPresentationMode() {
        this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.GET_INFO_PRESENTATION_MODE;
        byte[] bytes = BarcodeCommandFactory.getInstance().create(BarcodeConst.BarcodeSettings.PRESENTATION_GET);
        PacketModel packetModel = BarcodeCommandFactory.getInstance().createGetSSIParam(bytes);
        this.sendSSIPacket(packetModel);
    }

    public void getBarcodeSettings(BarcodeConst.BarcodeSettings settingsType) {
        this.isSendCharacterAction = true;
        switch (settingsType) {
            case CHARACTER_CODE_ID_SYMBOL: 
            case CHARACTER_CODE_ID_AIM: 
            case CHARACTER_NONE: {
                break;
            }
            default: {
                this.isSendCharacterAction = false;
            }
        }
        this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.GET_INFO_CHARACTER_STATUS;
        byte[] bytes = BarcodeCommandFactory.getInstance().create(settingsType);
        PacketModel packetModel = BarcodeCommandFactory.getInstance().createGetSSIParam(bytes);
        this.sendSSIPacket(packetModel);
    }

    public void setSymbologyAllEnable(BarcodeConst.MemoryType memoryType, boolean isEnable) {
        ArrayList<SymbologyInfoModel> sendList = new ArrayList<SymbologyInfoModel>();
        for (Symbology symbol : Symbology.values()) {
            SymbologyInfoModel model = new SymbologyInfoModel(symbol, isEnable);
            Log.d((String)TAG_TEST, (String)("Symbol = " + (Object)((Object)model.symbology) + "  Enable = " + (model.isEnableStatus ? "TRUE" : "FALSE")));
            sendList.add(model);
        }
        this.setSymbologySettings(memoryType, sendList);
    }

    public void setSymbologySettings(BarcodeConst.MemoryType memoryType, Symbology symbology, boolean isEnable) {
        SymbologyInfoModel model = new SymbologyInfoModel(symbology, isEnable);
        ArrayList<SymbologyInfoModel> infoModelArrayList = new ArrayList<SymbologyInfoModel>();
        infoModelArrayList.add(model);
        this.setSymbologySettings(memoryType, infoModelArrayList);
    }

    public void setSymbologySettings(BarcodeConst.MemoryType memoryType, ArrayList<SymbologyInfoModel> symbologyInfoList) {
        ArrayList<SymbologyInfoModel> array = new ArrayList<SymbologyInfoModel>();
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (SymbologyInfoModel symbolInfo : symbologyInfoList) {
            array.add(symbolInfo);
            for (byte buf : symbolInfo.symbology.getHexCommand()) {
                byteArray.add(buf);
            }
            byte byteEnableStatus = symbolInfo.isEnableStatus ? (byte)1 : 0;
            byteArray.add(byteEnableStatus);
            Log.d((String)TAG_SYMBOLDATA_TEST, (String)("Symbol : " + (Object)((Object)symbolInfo.symbology)));
            Log.d((String)TAG_SYMBOLDATA_TEST, (String)("[Symbol Byte] : " + this.convertStringFromByteArray(symbolInfo.symbology.getHexCommand()) + "  [Enable status] : " + String.format("%02X", byteEnableStatus)));
        }
        BarcodePacketParser.getInstance().setSymbologyInfoArray(array);
        if (byteArray.size() > 0) {
            byte[] bytes = new byte[byteArray.size()];
            for (int i = 0; i < byteArray.size(); ++i) {
                bytes[i] = (Byte)byteArray.get(i);
            }
            Log.d((String)TAG_TEST, (String)("Send Data = " + this.convertStringFromByteArray(bytes)));
            this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.SETTINGS_SYMBOLOGIES;
            PacketModel packetModel = BarcodeCommandFactory.getInstance().createSetSSIParam(memoryType.getCommand(), this.getSaveSystemBeepValue().getCommand(), bytes);
            Log.d((String)TAG_TEST, (String)("Send Data = " + this.convertStringFromByteArray(packetModel.toByteArray())));
            this.sendSSIPacket(packetModel);
        }
    }

    public void setOCRSettings(BarcodeConst.MemoryType memoryType, OCR ocr, boolean isEnable) {
        OCRInfoModel model = new OCRInfoModel(ocr, isEnable);
        ArrayList<OCRInfoModel> infoModelArrayList = new ArrayList<OCRInfoModel>();
        infoModelArrayList.add(model);
        this.setOCRSettings(memoryType, infoModelArrayList);
    }

    public void setOCRSettings(BarcodeConst.MemoryType memoryType, ArrayList<OCRInfoModel> ocrInfoList) {
        ArrayList<OCRInfoModel> array = new ArrayList<OCRInfoModel>();
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (OCRInfoModel ocrInfo : ocrInfoList) {
            array.add(ocrInfo);
            for (byte buf : ocrInfo.ocr.getHexCommand()) {
                byteArray.add(buf);
            }
            byte byteEnableStatus = ocrInfo.isEnableStatus ? (byte)1 : 0;
            byteArray.add(byteEnableStatus);
            Log.d((String)TAG_SYMBOLDATA_TEST, (String)("Symbol : " + (Object)((Object)ocrInfo.ocr)));
            Log.d((String)TAG_SYMBOLDATA_TEST, (String)("[Symbol Byte] : " + this.convertStringFromByteArray(ocrInfo.ocr.getHexCommand()) + "  [Enable status] : " + String.format("%02X", byteEnableStatus)));
        }
        BarcodePacketParser.getInstance().setOCRInfoArray(array);
        if (byteArray.size() > 0) {
            byte[] bytes = new byte[byteArray.size()];
            for (int i = 0; i < byteArray.size(); ++i) {
                bytes[i] = (Byte)byteArray.get(i);
            }
            Log.d((String)TAG_TEST, (String)("Send Data = " + this.convertStringFromByteArray(bytes)));
            this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.SETTING_OCR;
            PacketModel packetModel = BarcodeCommandFactory.getInstance().createSetSSIParam(memoryType.getCommand(), this.getSaveSystemBeepValue().getCommand(), bytes);
            Log.d((String)TAG_TEST, (String)("Send Data = " + this.convertStringFromByteArray(packetModel.toByteArray())));
            this.sendSSIPacket(packetModel);
        }
    }

    public void getSymbologySettings(Symbology symbology) {
        ArrayList<Symbology> symbolArrayList = new ArrayList<Symbology>();
        symbolArrayList.add(symbology);
        this.getSymbologySettings(symbolArrayList);
    }

    public void getSymbologySettings(ArrayList<Symbology> symbologyList) {
        ArrayList<SymbologyInfoModel> array = new ArrayList<SymbologyInfoModel>();
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (Symbology symbol : symbologyList) {
            Log.d((String)TAG_TEST, (String)("\u3010Request\u3011getSymbologySettings : " + (Object)((Object)symbol)));
            SymbologyInfoModel model = new SymbologyInfoModel(symbol, true);
            array.add(model);
            for (byte commandByte : symbol.getHexCommand()) {
                byteArray.add(commandByte);
            }
        }
        BarcodePacketParser.getInstance().setSymbologyInfoArray(array);
        if (byteArray.size() > 0) {
            byte[] bytes = new byte[byteArray.size()];
            for (int i = 0; i < byteArray.size(); ++i) {
                bytes[i] = (Byte)byteArray.get(i);
            }
            this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.GET_INFO_SYMBOLOGIES_ENABLE_STATUS;
            PacketModel packetModel = BarcodeCommandFactory.getInstance().createGetSSIParam(bytes);
            this.sendSSIPacket(packetModel);
        }
    }

    public void getOCRSettings(OCR ocr) {
        ArrayList<OCR> ocrArrayList = new ArrayList<OCR>();
        ocrArrayList.add(ocr);
        this.getOCRSettings(ocrArrayList);
    }

    public void getOCRSettings(ArrayList<OCR> ocrList) {
        ArrayList<OCRInfoModel> array = new ArrayList<OCRInfoModel>();
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (OCR symbol : ocrList) {
            Log.d((String)TAG_TEST, (String)("\u3010Request\u3011getOCRSettings : " + (Object)((Object)symbol)));
            OCRInfoModel model = new OCRInfoModel(symbol, true);
            array.add(model);
            for (byte commandByte : symbol.getHexCommand()) {
                byteArray.add(commandByte);
            }
        }
        BarcodePacketParser.getInstance().setOCRInfoArray(array);
        if (byteArray.size() > 0) {
            byte[] bytes = new byte[byteArray.size()];
            for (int i = 0; i < byteArray.size(); ++i) {
                bytes[i] = (Byte)byteArray.get(i);
            }
            this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.GET_INFO_OCR_ENABLE_STATUS;
            PacketModel packetModel = BarcodeCommandFactory.getInstance().createGetSSIParam(bytes);
            this.sendSSIPacket(packetModel);
        }
    }

    public void setSecurityLevelSettings(BarcodeConst.MemoryType memoryType, SecurityLevels.SecurityLevelType securityLevelType, SecurityLevels.SecurityLevel securityLevel) {
        SecurityInfoModel model = new SecurityInfoModel(securityLevelType, securityLevel);
        ArrayList<SecurityInfoModel> infoModelArrayList = new ArrayList<SecurityInfoModel>();
        infoModelArrayList.add(model);
        this.setSecurityLevelSettings(memoryType, infoModelArrayList);
    }

    public void setSecurityLevelSettings(BarcodeConst.MemoryType memoryType, ArrayList<SecurityInfoModel> securityInfoList) {
        ArrayList<SecurityInfoModel> array = new ArrayList<SecurityInfoModel>();
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (SecurityInfoModel securityInfo : securityInfoList) {
            array.add(securityInfo);
            for (byte buf : securityInfo.securityLevelType.getHexCommand()) {
                byteArray.add(buf);
            }
            byte byteSecurityStatus = (byte)securityInfo.securityLevel.getNum();
            byteArray.add(byteSecurityStatus);
        }
        BarcodePacketParser.getInstance().setSecurityInfoArray(array);
        if (byteArray.size() > 0) {
            byte[] bytes = new byte[byteArray.size()];
            for (int i = 0; i < byteArray.size(); ++i) {
                bytes[i] = (Byte)byteArray.get(i);
            }
            Log.d((String)TAG_TEST, (String)("Send Data = " + this.convertStringFromByteArray(bytes)));
            this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.SETTING_SECURITY_LEVEL;
            PacketModel packetModel = BarcodeCommandFactory.getInstance().createSetSSIParam(memoryType.getCommand(), this.getSaveSystemBeepValue().getCommand(), bytes);
            Log.d((String)TAG_TEST, (String)("Send Data = " + this.convertStringFromByteArray(packetModel.toByteArray())));
            this.sendSSIPacket(packetModel);
        }
    }

    public void getSecurityLevelSettings(ArrayList<SecurityLevels.SecurityLevelType> securityLevelTypeList) {
        ArrayList<SecurityInfoModel> array = new ArrayList<SecurityInfoModel>();
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (SecurityLevels.SecurityLevelType symbol : securityLevelTypeList) {
            Log.d((String)TAG_TEST, (String)("\u3010Request\u3011getSecurityLevelSettings : " + (Object)((Object)symbol)));
            SecurityInfoModel model = new SecurityInfoModel(symbol, SecurityLevels.SecurityLevel.LEVEL_1);
            array.add(model);
            for (byte commandByte : symbol.getHexCommand()) {
                byteArray.add(commandByte);
            }
        }
        BarcodePacketParser.getInstance().setSecurityInfoArray(array);
        if (byteArray.size() > 0) {
            byte[] bytes = new byte[byteArray.size()];
            for (int i = 0; i < byteArray.size(); ++i) {
                bytes[i] = (Byte)byteArray.get(i);
            }
            this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.GET_INFO_SECURITY_LEVEL_ENABLE_STATUS;
            PacketModel packetModel = BarcodeCommandFactory.getInstance().createGetSSIParam(bytes);
            this.sendSSIPacket(packetModel);
        }
    }

    public void getFormatStatus() {
        this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.GET_INFO_SCAN_DATA_TRANSMISSION_FORMAT;
        byte[] bytes = BarcodeCommandFactory.getInstance().create(BarcodeConst.BarcodeSettings.PREFIX_STATUS);
        PacketModel packetModel = BarcodeCommandFactory.getInstance().createGetSSIParam(bytes);
        this.sendSSIPacket(packetModel);
    }

    public BarcodeConst.SystemBeepSoundType getSystemBeep() {
        switch (this.getSaveSystemBeepValue()) {
            case SHORT_HIGH: {
                return BarcodeConst.SystemBeepSoundType.TYPE1;
            }
            case SHORT_LOW: {
                return BarcodeConst.SystemBeepSoundType.TYPE2;
            }
            case LONG_HIGH: {
                return BarcodeConst.SystemBeepSoundType.TYPE3;
            }
            case LONG_LOW: {
                return BarcodeConst.SystemBeepSoundType.TYPE4;
            }
            case FAST_WARBLE: {
                return BarcodeConst.SystemBeepSoundType.TYPE5;
            }
            case SLOW_WARBLE: {
                return BarcodeConst.SystemBeepSoundType.TYPE6;
            }
            case HIGH_CLICK: {
                return BarcodeConst.SystemBeepSoundType.TYPE7;
            }
            case LOW_CLICK: {
                return BarcodeConst.SystemBeepSoundType.TYPE8;
            }
        }
        return BarcodeConst.SystemBeepSoundType.NONE;
    }

    public void setSystemBeep(BarcodeConst.SystemBeepSoundType type) {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "BarcodeManager setSystemBeep");
        this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.SETTINGS_SYSTEM_BEEP;
        SSICommandModel.SystemBeep beepType = SSICommandModel.SystemBeep.getSystemBeepValue(type);
        this.saveSystemBeepValue(beepType);
    }

    public void setNotisEditing(BarcodeConst.MemoryType memoryType, boolean isEnabled) {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "BarcodeManager setNotisEditing");
        this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.SETTINGS_NOTIS_EDITING;
        byte enableByte = isEnabled ? SSICommandModel.SSIParameter.RESPONSE_ENABLE.getCommand() : SSICommandModel.SSIParameter.RESPONSE_DISABLE.getCommand();
        byte[] bytes = new byte[]{SSICommandModel.SSICommand.NOTIS_EDITING.getCommand(), enableByte};
        PacketModel packetModel = BarcodeCommandFactory.getInstance().createSetSSIParam(memoryType.getCommand(), this.getSaveSystemBeepValue().getCommand(), bytes);
        this.sendSSIPacket(packetModel);
    }

    public void getNotisEditing() {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "BarcodeManager getNotisEditing");
        this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.GET_INFO_NOTIS_EDITING;
        byte[] bytes = BarcodeCommandFactory.getInstance().create(BarcodeConst.BarcodeSettings.NOTIS_EDITING);
        PacketModel packetModel = BarcodeCommandFactory.getInstance().createGetSSIParam(bytes);
        this.sendSSIPacket(packetModel);
    }

    public void zebraBarcodeUpdate() {
        PacketModel packetModel = BarcodeCommandFactory.getInstance().createUpdateCmd(null);
        this.sendSSIPacket(packetModel);
    }

    private void startInitializeProcess() {
        switch (this.mInitProcess) {
            case UNTREATED: {
                this.checkCodeIdEnable();
                this.mInitProcess = InitializeProgress.GET_STATUS_CODE_ID;
                break;
            }
            case GET_STATUS_CODE_ID: {
                this.getFormatStatus();
                this.mInitProcess = InitializeProgress.GET_CHARACTER_STATUS;
                break;
            }
            case GET_CHARACTER_STATUS: {
                this.mInitProcess = InitializeProgress.GET_STATUS_FORMAT;
                this.getBarcodeSettings(BarcodeConst.BarcodeSettings.CHARACTER_GET);
                break;
            }
            case GET_STATUS_FORMAT: {
                this.mInitProcess = InitializeProgress.FINISH;
                break;
            }
        }
        if (this.mInitProcess == InitializeProgress.FINISH && this.mCallback != null) {
            this.mCallback.onBarcodeManagerStandByReady();
        }
    }

    private void startOCRPrerequisite() {
        byte[] data = null;
        switch (this.mOCRPrerequisite) {
            case RSM_GET_PACKETSIZE: {
                data = new byte[]{10, -128, 4, 0, 0, 6, 32, 0, -1, -1, -3, 78};
                this.sendBypassCmd(data);
                this.mOCRPrerequisite = OCRPrerequisite.ATTRIBUTE_STORE;
                break;
            }
            case ATTRIBUTE_STORE: {
                data = new byte[]{27, -128, 4, 0, 0, 23, 6, 0, 2, 35, 65, 7, 66, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, -119};
                this.sendBypassCmd(data);
                this.mOCRPrerequisite = OCRPrerequisite.ATTRIBUTE_GET;
                break;
            }
            case ATTRIBUTE_GET: {
                data = new byte[]{10, -128, 4, 0, 0, 6, 2, 0, 2, 35, -1, 69};
                this.sendBypassCmd(data);
                this.mOCRPrerequisite = OCRPrerequisite.FINISH;
                break;
            }
        }
        if (this.mOCRPrerequisite == OCRPrerequisite.FINISH && this.mCallback != null) {
            this.mCallback.onReceivedResponse(BarcodeConst.BarcodeCommandAction.SETTING_OCR, this.ocrSetResult);
        }
    }

    private void checkCodeIdEnable() {
        SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "checkCodeIdEnable");
        this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.GET_INFO_CODE_ID_ENABLE;
        byte[] param = new byte[]{SSICommandModel.SSICommand.CHARACTER.getCommand()};
        PacketModel packetModel = BarcodeCommandFactory.getInstance().createGetSSIParam(param);
        this.sendSSIPacket(packetModel);
    }

    private void sendSSIPacket(PacketModel packetModel) {
        SDKLog.getInstance().Log(TAG, LogLevel.Debug, "sendSSIPacket");
        this.mSSIPacket = packetModel;
        if (!CommunicationManager.getInstance().sendPacket(packetModel)) {
            SDKLog.getInstance().Log(TAG, LogLevel.Error, "Failed to send packet.");
        }
    }

    private void sendPacket(PacketModel packetModel) {
        SDKLog.getInstance().Log(TAG, LogLevel.Debug, "sendPacket");
        if (!CommunicationManager.getInstance().sendPacket(packetModel)) {
            SDKLog.getInstance().Log(TAG, LogLevel.Error, "Failed to send packet.");
            if (this.mCallback != null) {
                this.mCallback.onBarcodeManagerError(BarcodeManagerError.COMMAND_ERROR_COMMAND_SEND_FAILED);
            }
        }
    }

    private void sendBypassCmd(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (byte byteBuf : data) {
            buf.append(String.format("%02X ", byteBuf));
        }
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "BYPASS TX : " + buf.toString());
        PacketModel packetModel = BarcodeCommandFactory.getInstance().createBypassCmd(data);
        this.sendPacket(packetModel);
    }

    private String convertBarcodeData(byte[] data) {
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "parseBarcodeData Mode = " + (Object)((Object)this.getEncodeMode()));
        StringEncoder encoder = StringEncoder.getInstance();
        StringEncoder.StringEncodeType type = StringEncoder.StringEncodeType.getEncodeMode(this.getEncodeMode());
        if (type == StringEncoder.StringEncodeType.AUTO) {
            type = encoder.checkIncludeCharacter(data);
        }
        if (type != StringEncoder.StringEncodeType.UNKNOWN) {
            return encoder.encodeByteData(data, encoder.getEncodeTypeString(type));
        }
        return null;
    }

    private String convertStringFromByteArray(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (byte byteBuf : bytes) {
            buf.append(String.format("%02X ", byteBuf));
        }
        return buf.toString();
    }

    private String convertStringFromByteArray(Byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Byte byteBuf : bytes) {
            buf.append(String.format("%02X ", byteBuf));
        }
        return buf.toString();
    }

    public void onReceivedData(PacketModel packetModel, boolean isSSI) {
        String commandStr = String.format("%02X", packetModel.getCommand());
        SDKLog.getInstance().Log(TAG, LogLevel.Information, "onReceivedData : " + commandStr);
        if (isSSI) {
            SDKLog.getInstance().Log(TAG, LogLevel.Information, "!!!!!!!! SSI Parse !!!!!!!!\n" + (Object)((Object)this.mSSICommandAction));
            BarcodePacketParser.getInstance().parseSSIPacket(packetModel, this.mSSIPacket, this.mSSICommandAction);
        } else {
            SDKLog.getInstance().Log(TAG, LogLevel.Information, "!!!!!!!! Normal Parse !!!!!!!!");
            BarcodePacketParser.getInstance().parsePacket(packetModel);
        }
    }

    public void onExecuteTriggerAutoMode(boolean executeMode) {
        if (executeMode) {
            this.startDecode();
        } else {
            this.stopDecode();
        }
    }

    public void onConnectedStatus(boolean status) {
        if (status) {
            this.startInitializeProcess();
        } else {
            this.mScanDataFormatType = BarcodeResult.Result.UNKNOWN;
            this.mInitProcess = InitializeProgress.UNTREATED;
            this.mSSIPacket = null;
            this.mCharacterType = BarcodeConst.BarcodeSettings.CHARACTER_NONE;
            this.mSSICommandAction = BarcodeConst.BarcodeCommandAction.UNSET;
            this.isSendCharacterAction = false;
        }
    }

    @Override
    public void onParsedBarcodeDecodeData(byte[] decodeData) {
        if (this.mCallback != null) {
            this.mCallback.onReceivedBarcodeDecodeData(decodeData);
            String receiveDataStr = this.convertBarcodeData(decodeData);
            if (receiveDataStr == null) {
                return;
            }
            HashMap<String, String> retParameter = new HashMap<String, String>();
            Map<String, String> trimStrMap = this.trimPrefixAndSuffix(receiveDataStr);
            if (trimStrMap != null) {
                Set<String> keys = trimStrMap.keySet();
                for (String key : keys) {
                    if (!key.contentEquals("Key_ParameterBarcodeString")) {
                        retParameter.put(key, trimStrMap.get(key));
                        continue;
                    }
                    if (trimStrMap.get(key) == null) continue;
                    receiveDataStr = trimStrMap.get(key);
                }
            }
            String barcodeStr = "";
            switch (this.mCharacterType) {
                case CHARACTER_CODE_ID_SYMBOL: {
                    String symbolStr;
                    assert (receiveDataStr != null);
                    String result = receiveDataStr.substring(0, 1);
                    if (result.equals("P")) {
                        symbolStr = receiveDataStr.substring(0, 3);
                        barcodeStr = receiveDataStr.substring(3);
                    } else {
                        symbolStr = receiveDataStr.substring(0, 1);
                        barcodeStr = receiveDataStr.substring(1);
                    }
                    retParameter.put("Key_ParameterSymbol", symbolStr);
                    break;
                }
                case CHARACTER_CODE_ID_AIM: {
                    assert (receiveDataStr != null);
                    String aimStr = receiveDataStr.substring(0, 3);
                    barcodeStr = receiveDataStr.substring(3);
                    retParameter.put("Key_ParameterAIM", aimStr);
                    break;
                }
                case CHARACTER_NONE: {
                    barcodeStr = receiveDataStr;
                    break;
                }
            }
            this.mCallback.onReceivedBarcodeDecodeData(barcodeStr, retParameter);
        }
    }

    private Map<String, String> trimPrefixAndSuffix(String payload) {
        boolean isPrefix = false;
        boolean isSuffix1 = false;
        boolean isSuffix2 = false;
        SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Payload = " + payload);
        switch (this.mScanDataFormatType) {
            case FORMAT_DATA_ONLY: {
                break;
            }
            case FORMAT_PREFIX_DATA: {
                isPrefix = true;
                break;
            }
            case FORMAT_DATA_SUFFIX_TYPE1: {
                isSuffix1 = true;
                break;
            }
            case FORMAT_DATA_SUFFIX_TYPE2: {
                isSuffix2 = true;
                break;
            }
            case FORMAT_DATA_SUFFIX_TYPE3: {
                isSuffix1 = true;
                isSuffix2 = true;
                break;
            }
            case FORMAT_PREFIX_DATA_SUFFIX_TYPE1: {
                isPrefix = true;
                isSuffix1 = true;
                break;
            }
            case FORMAT_PREFIX_DATA_SUFFIX_TYPE2: {
                isPrefix = true;
                isSuffix2 = true;
                break;
            }
            case FORMAT_PREFIX_DATA_SUFFIX_TYPE3: {
                isPrefix = true;
                isSuffix1 = true;
                isSuffix2 = true;
            }
        }
        SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Prefix = " + (isPrefix ? "True" : "False") + " Suffix1 = " + (isSuffix1 ? "True" : "False") + " Suffix2 = " + (isSuffix2 ? "True" : "False"));
        if (!(isPrefix || isSuffix1 || isSuffix2)) {
            return null;
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        int barcodeStartIndex = 0;
        int barcodeEndIndex = payload.length();
        if (isPrefix) {
            parameter.put("Key_ParameterPrefix", payload.substring(0, 1));
            barcodeStartIndex = 1;
        }
        if (isSuffix1 && !isSuffix2) {
            int len = payload.length() - 1;
            parameter.put("Key_ParameterSuffix1", payload.substring(len));
            barcodeEndIndex = payload.length() - 1;
        } else if (!isSuffix1 && isSuffix2) {
            int len = payload.length() - 1;
            parameter.put("Key_ParameterSuffix2", payload.substring(len));
            barcodeEndIndex = payload.length() - 1;
        } else if (isSuffix1 && isSuffix2) {
            parameter.put("Key_ParameterSuffix1", payload.substring(payload.length() - 2, payload.length() - 2));
            parameter.put("Key_ParameterSuffix2", payload.substring(payload.length() - 1, payload.length() - 1));
            barcodeEndIndex = payload.length() - 2;
        }
        SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Prefix = " + (String)parameter.get("Key_ParameterPrefix"));
        SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Suffix1 = " + (String)parameter.get("Key_ParameterSuffix1"));
        SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "Suffix2 = " + (String)parameter.get("Key_ParameterSuffix2"));
        parameter.put("Key_ParameterBarcodeString", payload.substring(barcodeStartIndex, barcodeEndIndex));
        return parameter;
    }

    @Override
    public void onParsedBarcodeError(BarcodeManagerError error) {
        if (error == BarcodeManagerError.COMMAND_ERROR_START_DECODE_FAILED) {
            this.stopDecode();
        }
        if (this.mCallback != null) {
            this.mCallback.onBarcodeManagerError(error);
        }
    }

    @Override
    public void onParsedBarcodeResponse(BarcodeConst.BarcodeCommandAction action, BarcodeResult result) {
        switch (action) {
            case SETTINGS_CHARACTER_STATUS: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "onParsedBarcodeResponse : " + (Object)((Object)BarcodeConst.BarcodeCommandAction.SETTINGS_CHARACTER_STATUS) + " isSend = " + (this.isSendCharacterAction ? "True" : "False"));
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "mCodeID(Character)Type : " + (Object)((Object)this.mCharacterType));
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "result : " + (Object)((Object)result.getResult()));
                switch (this.mCharacterType) {
                    case CHARACTER_NONE: {
                        result.setResult(BarcodeResult.Result.CHARACTER_NONE);
                        break;
                    }
                    case CHARACTER_CODE_ID_SYMBOL: {
                        result.setResult(BarcodeResult.Result.CHARACTER_SYMBOL);
                        break;
                    }
                    case CHARACTER_CODE_ID_AIM: {
                        result.setResult(BarcodeResult.Result.CHARACTER_AIM);
                        break;
                    }
                }
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "mCharacterType = " + (Object)((Object)this.mCharacterType));
                if (!this.isSendCharacterAction) break;
                this.isSendCharacterAction = false;
                break;
            }
            case SETTINGS_SYMBOLOGIES: {
                SDKLog.getInstance().Log(TAG_SYMBOLDATA_TEST, LogLevel.Information, "SETTINGS_SYMBOLOGIES : " + (Object)((Object)BarcodeConst.BarcodeCommandAction.SETTINGS_SYMBOLOGIES));
                SDKLog.getInstance().Log(TAG_SYMBOLDATA_TEST, LogLevel.Information, "Status : " + (Object)((Object)result.getStatus()) + " Result : " + (Object)((Object)result.getResult()));
                break;
            }
            case SETTING_OCR: {
                this.ocrSetResult = result;
                this.mOCRPrerequisite = OCRPrerequisite.RSM_GET_PACKETSIZE;
                SDKLog.getInstance().Log(TAG, LogLevel.Information, "SETTING OCR, state : " + this.mOCRPrerequisite.toString());
                this.startOCRPrerequisite();
                return;
            }
            case GET_INFO_CHARACTER_STATUS: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "onParsedBarcodeResponse : " + (Object)((Object)BarcodeConst.BarcodeCommandAction.GET_INFO_CHARACTER_STATUS) + " isSend = " + (this.isSendCharacterAction ? "True" : "False"));
                switch (result.getResult()) {
                    case CHARACTER_NONE: {
                        this.mCharacterType = BarcodeConst.BarcodeSettings.CHARACTER_NONE;
                        break;
                    }
                    case CHARACTER_SYMBOL: {
                        this.mCharacterType = BarcodeConst.BarcodeSettings.CHARACTER_CODE_ID_SYMBOL;
                        break;
                    }
                    case CHARACTER_AIM: {
                        this.mCharacterType = BarcodeConst.BarcodeSettings.CHARACTER_CODE_ID_AIM;
                        break;
                    }
                }
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "mCharacterType = " + (Object)((Object)this.mCharacterType));
                if (this.isSendCharacterAction) {
                    this.isSendCharacterAction = false;
                }
                if (this.mInitProcess == InitializeProgress.FINISH) break;
                this.startInitializeProcess();
                return;
            }
            case GET_INFO_SYMBOLOGIES_ENABLE_STATUS: 
            case GET_INFO_OCR_ENABLE_STATUS: {
                break;
            }
            case GET_INFO_SCAN_DATA_TRANSMISSION_FORMAT: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "onParsedBarcodeResponse : " + (Object)((Object)BarcodeConst.BarcodeCommandAction.GET_INFO_SCAN_DATA_TRANSMISSION_FORMAT));
                this.mScanDataFormatType = result.getResult();
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "ScanDataFormatType = " + (Object)((Object)this.mScanDataFormatType));
                if (this.mInitProcess == InitializeProgress.FINISH) break;
                this.startInitializeProcess();
                return;
            }
            case GET_INFO_STOP_CONDITION: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "GET_INFO_STOP_CONDITION");
                break;
            }
            case GET_INFO_CODE_ID_ENABLE: {
                if (this.mInitProcess == InitializeProgress.FINISH) break;
                this.startInitializeProcess();
                return;
            }
            case GET_INFO_NOTIS_EDITING: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "GET_INFO_NOTIS_EDITING");
                break;
            }
            case SETTINGS_NOTIS_EDITING: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "SETTING_NOTIS_EDITING");
                break;
            }
            case GET_INFO_PRESENTATION_MODE: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "GET_INFO_PRESENTATION_MODE");
                break;
            }
            case SETTINGS_PRESENTATION_MODE: {
                SDKLog.getInstance().Log(TAG_TEST, LogLevel.Information, "SETTINGS_PRESENTATION_MODE");
            }
        }
        if (this.mCallback != null) {
            this.mCallback.onReceivedResponse(action, result);
        }
    }

    @Override
    public void onBypass(BarcodeConst.BarcodeCommandAction action, byte[] data) {
        switch (action) {
            case SETTING_OCR: {
                StringBuilder buf = new StringBuilder();
                for (byte byteBuf : data) {
                    buf.append(String.format("%02X ", byteBuf));
                }
                SDKLog.getInstance().Log(TAG, LogLevel.Information, "SETTING OCR PARSE : " + buf.toString());
                this.startOCRPrerequisite();
            }
        }
    }

    private void saveSystemBeepValue(SSICommandModel.SystemBeep beepType) {
        SDKSharedData.getInstance().putString(KEY_SAVE_SYSTEM_BEEP, beepType.toString());
    }

    private SSICommandModel.SystemBeep getSaveSystemBeepValue() {
        String value = SDKSharedData.getInstance().getString(KEY_SAVE_SYSTEM_BEEP, SSICommandModel.SystemBeep.SHORT_LOW.toString());
        try {
            return SSICommandModel.SystemBeep.valueOf(value);
        }
        catch (Exception ex) {
            return SSICommandModel.SystemBeep.SHORT_LOW;
        }
    }

    static enum OCRPrerequisite {
        RSM_GET_PACKETSIZE,
        ATTRIBUTE_STORE,
        ATTRIBUTE_GET,
        FINISH;

    }

    static enum InitializeProgress {
        UNTREATED,
        GET_STATUS_CODE_ID,
        GET_STATUS_FORMAT,
        GET_CHARACTER_STATUS,
        FINISH;

    }
}

