/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.communicationmanager.packet;

import java.util.ArrayList;
import java.util.List;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.AsReaderPacketConst;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.CRCCalculator;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.CheckPacketState;
import jp.co.asterisk.asreader.a24d.communicationmanager.packet.PacketModel;

public class PacketParser {
    private static PacketParser instance;
    private long checkedTime = System.currentTimeMillis();
    private CheckPacketState packetState = CheckPacketState.START;
    private List<Byte> checkedPacketArray = new ArrayList<Byte>();
    private List<Byte> packetArray = new ArrayList<Byte>();
    private int packetLength = 0;
    private int payloadLength = 0;
    private int payloadCount = 0;

    private PacketParser() {
    }

    public static PacketParser getInstance() {
        if (instance == null) {
            instance = new PacketParser();
        }
        return instance;
    }

    public PacketModel parse(byte[] data) {
        if (this.checkPacket(data)) {
            PacketModel packetModel = this.createPacketModel();
            this.packetArray.clear();
            return packetModel;
        }
        return null;
    }

    private boolean checkTimeout(byte[] data) {
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.checkedTime;
        this.checkedTime = currentTime;
        if ((double)elapsedTime < 30.0) {
            return false;
        }
        return !((double)elapsedTime < 100.0) || data.length >= 20;
    }

    private PacketModel createPacketModel() {
        PacketModel packetModel = new PacketModel();
        packetModel.setPreamble(this.packetArray.get(0));
        packetModel.setType(this.packetArray.get(1));
        packetModel.setCommand(this.packetArray.get(2));
        byte[] length = new byte[]{this.packetArray.get(3), this.packetArray.get(4)};
        packetModel.setLength(length);
        for (int i = 0; i < this.payloadLength; ++i) {
            packetModel.addPayload(this.packetArray.get(i + 5));
        }
        int endMarkPosition = 4 + this.payloadLength + 1;
        packetModel.setEndMark(this.packetArray.get(endMarkPosition));
        byte[] crc = new byte[]{this.packetArray.get(endMarkPosition + 1), this.packetArray.get(endMarkPosition + 2)};
        packetModel.setCRC(crc);
        return packetModel;
    }

    private boolean checkPacket(byte[] data) {
        boolean isFirst = false;
        if (this.checkTimeout(data)) {
            if (data.length > 1) {
                isFirst = data[0] == AsReaderPacketConst.AsReaderPacket.PREAMBLE.getByte() && data[1] == 1 | data[1] == 2;
            } else {
                boolean bl = isFirst = data[0] == AsReaderPacketConst.AsReaderPacket.PREAMBLE.getByte();
            }
        }
        if (isFirst) {
            this.packetState = CheckPacketState.START;
        }
        block11: for (int i = 0; i < data.length; ++i) {
            switch (this.packetState) {
                case START: {
                    this.payloadLength = 0;
                    this.payloadCount = 0;
                    this.packetArray.clear();
                    if (data[i] != AsReaderPacketConst.AsReaderPacket.PREAMBLE.getByte()) continue block11;
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.MSG_TYPE;
                    continue block11;
                }
                case MSG_TYPE: {
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.MSG_CODE;
                    continue block11;
                }
                case MSG_CODE: {
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.LEN_H;
                    continue block11;
                }
                case LEN_H: {
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.LEN_L;
                    continue block11;
                }
                case LEN_L: {
                    this.packetArray.add(data[i]);
                    this.payloadLength = this.packetArray.get(4) & 0xFF;
                    this.packetState = this.payloadLength == 0 ? CheckPacketState.PAYLOAD_E : CheckPacketState.PAYLOAD;
                    continue block11;
                }
                case PAYLOAD: {
                    this.packetArray.add(data[i]);
                    ++this.payloadCount;
                    if (this.payloadCount != this.payloadLength) continue block11;
                    this.packetState = CheckPacketState.PAYLOAD_E;
                    continue block11;
                }
                case PAYLOAD_E: {
                    if (AsReaderPacketConst.AsReaderPacket.END_MARK.getByte() == data[i]) {
                        this.packetArray.add(data[i]);
                        this.packetState = CheckPacketState.CRC_H;
                        continue block11;
                    }
                    this.packetState = CheckPacketState.START;
                    continue block11;
                }
                case CRC_H: {
                    this.packetArray.add(data[i]);
                    this.packetState = CheckPacketState.CRC_L;
                    continue block11;
                }
                case CRC_L: {
                    this.packetArray.add(data[i]);
                    int[] checkData = new int[this.packetArray.size()];
                    int baIndex = 0;
                    for (Byte b : this.packetArray.toArray(new Byte[0])) {
                        checkData[baIndex++] = b & 0xFF;
                    }
                    this.packetState = CheckPacketState.START;
                    return CRCCalculator.Chk_CRC(checkData);
                }
            }
        }
        return false;
    }

    private void checkPacket(byte data, boolean isFirst) {
        if (isFirst) {
            this.packetState = CheckPacketState.START;
        }
        switch (this.packetState) {
            case START: {
                this.packetLength = 0;
                this.payloadLength = 0;
                this.checkedPacketArray.clear();
                if (data != AsReaderPacketConst.AsReaderPacket.PREAMBLE.getByte()) break;
                this.checkedPacketArray.add(data);
                this.packetState = CheckPacketState.MSG_TYPE;
                break;
            }
            case MSG_TYPE: {
                this.checkedPacketArray.add(data);
                this.packetState = CheckPacketState.MSG_CODE;
                break;
            }
            case MSG_CODE: {
                this.checkedPacketArray.add(data);
                this.packetState = CheckPacketState.LEN_H;
                break;
            }
            case LEN_H: {
                this.checkedPacketArray.add(data);
                this.packetState = CheckPacketState.LEN_L;
                break;
            }
            case LEN_L: {
                this.checkedPacketArray.add(data);
                this.packetLength = this.checkedPacketArray.get(4) & 0xFF;
                this.packetState = this.packetLength == 0 ? CheckPacketState.PAYLOAD_E : CheckPacketState.PAYLOAD;
                break;
            }
            case PAYLOAD: {
                this.checkedPacketArray.add(data);
                ++this.payloadLength;
                if (this.payloadLength != this.packetLength) break;
                this.packetState = CheckPacketState.PAYLOAD_E;
                break;
            }
            case PAYLOAD_E: {
                if (AsReaderPacketConst.AsReaderPacket.END_MARK.getByte() == data) {
                    this.checkedPacketArray.add(data);
                    this.packetState = CheckPacketState.CRC_H;
                    break;
                }
                this.checkedPacketArray.clear();
                this.packetState = CheckPacketState.START;
                break;
            }
            case CRC_H: {
                this.checkedPacketArray.add(data);
                this.packetState = CheckPacketState.CRC_L;
                break;
            }
            case CRC_L: {
                this.checkedPacketArray.add(data);
                int[] completeData = new int[this.checkedPacketArray.size()];
                int baIndex = 0;
                for (Byte b : this.checkedPacketArray.toArray(new Byte[0])) {
                    completeData[baIndex++] = b & 0xFF;
                }
                if (!CRCCalculator.Chk_CRC(completeData)) {
                    this.checkedPacketArray.clear();
                    this.packetState = CheckPacketState.START;
                    return;
                }
                this.packetState = CheckPacketState.START;
                this.checkedPacketArray.clear();
            }
        }
    }
}

