/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.communicationmanager.connection.ble;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import androidx.annotation.NonNull;
import java.util.UUID;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ConnectionCallback;
import jp.co.asterisk.asreader.a24d.utility.LogLevel;
import jp.co.asterisk.asreader.a24d.utility.SDKLog;
import no.nordicsemi.android.ble.BleManager;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.DataSentCallback;
import no.nordicsemi.android.ble.data.Data;
import no.nordicsemi.android.ble.observer.ConnectionObserver;

public class NordicBLE
extends BleManager {
    private final String TAG = NordicBLE.class.getSimpleName();
    private static NordicBLE instance;
    private ConnectionCallback callback;
    private final UUID SERVICE_UUID = UUID.fromString("BA821000-3B5B-4654-85FE-E998B123ADEA");
    private final UUID TX_CHAR_UUID = UUID.fromString("BA821001-3B5B-4654-85FE-E998B123ADEA");
    private final UUID RX_CHAR_UUID = UUID.fromString("BA821002-3B5B-4654-85FE-E998B123ADEA");
    private BluetoothGattCharacteristic tx_Characteristic;
    private BluetoothGattCharacteristic rx_Characteristic;
    private final ConnectionObserver mConnectionObserver = new ConnectionObserver(){

        public void onDeviceConnecting(@NonNull BluetoothDevice device) {
            SDKLog.getInstance().Log(NordicBLE.this.TAG, LogLevel.Information, "onDeviceConnecting");
        }

        public void onDeviceConnected(@NonNull BluetoothDevice device) {
            SDKLog.getInstance().Log(NordicBLE.this.TAG, LogLevel.Information, "onDeviceConnected");
        }

        public void onDeviceFailedToConnect(@NonNull BluetoothDevice device, int reason) {
            SDKLog.getInstance().Log(NordicBLE.this.TAG, LogLevel.Information, "onDeviceFailedToConnectreason : " + reason);
            NordicBLE.this.close();
        }

        public void onDeviceReady(@NonNull BluetoothDevice device) {
            if (NordicBLE.this.callback != null) {
                NordicBLE.this.callback.onReceivedBleConnection(true);
            }
            SDKLog.getInstance().Log(NordicBLE.this.TAG, LogLevel.Information, "onDeviceReady ");
        }

        public void onDeviceDisconnecting(@NonNull BluetoothDevice device) {
            SDKLog.getInstance().Log(NordicBLE.this.TAG, LogLevel.Information, "onDeviceDisconnecting ");
        }

        public void onDeviceDisconnected(@NonNull BluetoothDevice device, int reason) {
            if (NordicBLE.this.callback != null) {
                NordicBLE.this.callback.onReceivedBleConnection(false);
            }
            SDKLog.getInstance().Log(NordicBLE.this.TAG, LogLevel.Information, "onDeviceDisconnected reason : " + reason);
        }
    };
    private final DataReceivedCallback dataReceivedCallback = new DataReceivedCallback(){

        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data rxData) {
            byte[] datas = rxData.getValue();
            if (datas.length > 0) {
                StringBuilder data = new StringBuilder(datas.length);
                for (byte byteChar : datas) {
                    data.append(String.format("%02X ", byteChar));
                }
                SDKLog.getInstance().Log(NordicBLE.this.TAG, LogLevel.Information, "RX: " + data.toString());
                if (NordicBLE.this.callback != null) {
                    NordicBLE.this.callback.onReceivedData(datas);
                }
            }
        }
    };
    private final DataSentCallback dataSentCallback = new DataSentCallback(){

        public void onDataSent(@NonNull BluetoothDevice device, @NonNull Data data) {
            SDKLog.getInstance().Log(NordicBLE.this.TAG, LogLevel.Information, " onDataSent : " + data.toString());
        }
    };

    private NordicBLE(@NonNull Context context) {
        super(context);
        this.setConnectionObserver(this.mConnectionObserver);
    }

    public static NordicBLE getInstance(Context context) {
        if (instance == null) {
            instance = new NordicBLE(context);
        }
        return instance;
    }

    public void setCallback(ConnectionCallback callback) {
        this.callback = callback;
    }

    public boolean isOpen() {
        return this.isConnected();
    }

    public void open(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            return;
        }
        if (!this.isConnected()) {
            this.close();
            this.connect(bluetoothDevice).retry(3, 100).useAutoConnect(false).enqueue();
        }
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "BLE Connect ");
    }

    public void close() {
        this.disableNotifications(this.rx_Characteristic).enqueue();
        this.disconnect().enqueue();
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "BLE Disconnect ");
    }

    public boolean sendData(byte[] buffer) {
        if (this.tx_Characteristic == null || this.dataSentCallback == null) {
            return false;
        }
        this.sendDividedData(buffer);
        return true;
    }

    private void sendDividedData(byte[] data) {
        int packetLength = 100;
        int currentPacket = 0;
        byte[] sendingData = new byte[packetLength];
        while (currentPacket < data.length) {
            if (currentPacket + packetLength >= data.length) {
                sendingData = new byte[data.length - currentPacket];
                System.arraycopy(data, currentPacket, sendingData, 0, data.length - currentPacket);
                currentPacket = data.length;
            } else {
                System.arraycopy(data, currentPacket, sendingData, 0, packetLength);
                currentPacket += packetLength;
            }
            this.writeCharacteristic(this.tx_Characteristic, sendingData).with(this.dataSentCallback).enqueue();
        }
    }

    @NonNull
    protected BleManager.BleManagerGattCallback getGattCallback() {
        return new nordicLibraryGattCallback();
    }

    private class nordicLibraryGattCallback
    extends BleManager.BleManagerGattCallback {
        private nordicLibraryGattCallback() {
        }

        public boolean isRequiredServiceSupported(@NonNull BluetoothGatt gatt) {
            BluetoothGattService service = gatt.getService(NordicBLE.this.SERVICE_UUID);
            if (service != null) {
                NordicBLE.this.tx_Characteristic = service.getCharacteristic(NordicBLE.this.TX_CHAR_UUID);
                NordicBLE.this.rx_Characteristic = service.getCharacteristic(NordicBLE.this.RX_CHAR_UUID);
            }
            boolean writeRequest = false;
            if (NordicBLE.this.tx_Characteristic != null) {
                int properties = NordicBLE.this.tx_Characteristic.getProperties();
                writeRequest = (properties & 8) != 0;
            }
            boolean notify = false;
            if (NordicBLE.this.rx_Characteristic != null) {
                int properties = NordicBLE.this.rx_Characteristic.getProperties();
                notify = (properties & 0x10) != 0;
            }
            return NordicBLE.this.tx_Characteristic != null && NordicBLE.this.rx_Characteristic != null && notify && writeRequest;
        }

        protected void initialize() {
            NordicBLE.this.setNotificationCallback(NordicBLE.this.rx_Characteristic).with(NordicBLE.this.dataReceivedCallback);
            NordicBLE.this.readCharacteristic(NordicBLE.this.rx_Characteristic).with(NordicBLE.this.dataReceivedCallback);
            NordicBLE.this.readCharacteristic(NordicBLE.this.tx_Characteristic).with(NordicBLE.this.dataReceivedCallback);
            NordicBLE.this.enableNotifications(NordicBLE.this.rx_Characteristic).enqueue();
        }

        protected void onDeviceDisconnected() {
            NordicBLE.this.tx_Characteristic = null;
            NordicBLE.this.rx_Characteristic = null;
        }
    }
}

