/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a24d.communicationmanager.connection.ble;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ConnectionCallback;
import jp.co.asterisk.asreader.a24d.communicationmanager.connection.ble.NordicBLE;

public class BLEManager {
    private NordicBLE bleManager;
    private static BLEManager instance;

    private BLEManager() {
    }

    public static BLEManager getInstance() {
        if (instance == null) {
            instance = new BLEManager();
        }
        return instance;
    }

    public void initialize(Context context) {
        this.bleManager = NordicBLE.getInstance(context);
    }

    public void setCallback(ConnectionCallback callback) {
        if (this.bleManager == null) {
            return;
        }
        this.bleManager.setCallback(callback);
    }

    public boolean isOpen() {
        if (this.bleManager == null) {
            return false;
        }
        return this.bleManager.isOpen();
    }

    public void open(BluetoothDevice bluetoothDevice) {
        if (this.bleManager == null) {
            return;
        }
        this.bleManager.open(bluetoothDevice);
    }

    public void close() {
        if (this.bleManager == null) {
            return;
        }
        this.bleManager.close();
    }

    public boolean sendData(byte[] buffer) {
        if (this.bleManager == null) {
            return false;
        }
        return this.bleManager.sendData(buffer);
    }
}

