//
//  AsReaderBleMgr.h
//  AsReaderBLESDK
//
//  Created by Mikiko on 11/7/24.
//  Copyright © 2024 SPS INC. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreBluetooth/CoreBluetooth.h>
#import "AsReaderBLEProtocols.h"
//#import "AsReaderDockSDK/AsReaderProtocol.h"

/**
 *  @brief      This class is designed to manage BLE connections for a specific SDK or BLE-enabled device. The class provides various methods for scanning, connecting, and transferring data via BLE.
 */
@interface AsReaderBleMgr : NSObject
@property (nonatomic, weak) id<AsReaderBLEProtocols> delegate;
@property (nonatomic, weak) id rcpReceiverDelegate;
// @property (nonatomic, assign) SEL dispatchRcpFrmReader;
// @property (nonatomic, assign) SEL plugChangedStatus;
@property (nonatomic, strong, readonly) CBPeripheral *pripheral;

+ (instancetype) sharedInstance;
//-(NSArray *) getPreripheralList;

/**
 *  @brief      [ONLY SDK USE] Response of all
 *  @details    TThis function starts a device search.
 */
- (BOOL) scanBLE;

/**
 *  @brief      [ONLY SDK USE] Response of all
 *  @details    This function will stop searching for devices.
 */
- (void) stopSacnBLE;

/**
 *  @brief      [ONLY SDK USE] Response of all
 *  @details    This function checks the connection status.
 *  @return     YES : Connected  NO: Disconnected
 */
- (BOOL) isOpened;

/**
 *  @brief      [ONLY SDK USE] Response of all
 *  @details    Disconnect the device.
 */
- (void) close;

/**
 *  @brief      [ONLY SDK USE] Response of all
 *  @details    This function transfers data.
 *  @return     YES : Success  NO: Fail
 */
- (BOOL) send:(NSData*)data;

/**
 *  @brief      [ONLY SDK USE] Response of all
 *  @details    This function transfers data.
 *  @return     YES : Success  NO: Fail
 */
- (BOOL) sendPower:(NSData*)data;

/**
 *  @brief      [ONLY SDK USE] Response of all
 *  @details    This function attempts to connect the device.
 */
- (void) connectBLE:(id)peripheral;
@end


