﻿using System;
using AsReaderBLESDK.IOS;
using CoreBluetooth;
using Foundation;

namespace AsReaderSDK4MAUIDemo.Platforms.iOS
{
    public class AsReaderDockManagerDelegate
	{
        public delegate void PluggedDelegate(bool plug);
        public PluggedDelegate Plugged;

        public delegate void ReaderConnectedDelegate(int status);
        public ReaderConnectedDelegate ReaderConnected;

        public delegate void BatteryReceivedDelegate(int battery);
        public BatteryReceivedDelegate BatteryReceived;

        public delegate void ErrorReceivedDelegate(NSData errorCode);
        public ErrorReceivedDelegate ErrorReceived;

        public delegate void ResponsePowerOnOffDelegate(bool isOn, bool isHWModeChange);
        public ResponsePowerOnOffDelegate ResponsePowerOnOff;

        public delegate void PushedTriggerButtonDelegate();
        public PushedTriggerButtonDelegate PushedTriggerButton;

        public delegate void ReleasedTriggerButtonDelegate();
        public ReleasedTriggerButtonDelegate ReleasedTriggerButton;

        public delegate void CheckTriggerStatusDelegate(string strStatus);
        public CheckTriggerStatusDelegate CheckTriggerStatus;

        public delegate void ReceivedScanDataDelegate(NSData readData);
        public ReceivedScanDataDelegate ReceivedScanData;

        public delegate void PcEpcRssiReceivedDelegate(NSData pcEpc, int rssi);
        public PcEpcRssiReceivedDelegate PcEpcRssiReceived;

        public delegate void ScanningBleDeiveDelegate(CBPeripheral device);
        public ScanningBleDeiveDelegate ScanningBleDeive;

        public delegate void ScanBleStatusDelegate(BleStatusCodes status);
        public ScanBleStatusDelegate ScanBleStatus;

        public delegate void RegionReceivedDelegate(int region);
        public RegionReceivedDelegate RegionReceived;

        public delegate void RfidModuleVersionReceivedDelegate();
        public RfidModuleVersionReceivedDelegate RfidModuleVersionReceived;

        static AsReaderDockManagerDelegate uniqueInstance;

        static readonly object locker = new object();

        public static AsReaderDockManagerDelegate sharedInstance()
        {
            if (uniqueInstance == null)
            {
                lock (locker)
                {
                    if (uniqueInstance == null)
                    {
                        uniqueInstance = new AsReaderDockManagerDelegate();
                    }
                }
            }
            return uniqueInstance;
        }
        public AsReaderDockManagerDelegate()
        {
          
		}
	}
}

