import 'dart:ffi';
import 'dart:typed_data';

import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'asreader_sdk4_method_channel.dart';

abstract class AsreaderSdk4Platform extends PlatformInterface {
  /// Constructs a AsreaderSdk4Platform.
  AsreaderSdk4Platform() : super(token: _token);

  static final Object _token = Object();

  static AsreaderSdk4Platform _instance = MethodChannelAsreaderSdk4();

  /// The default instance of [AsreaderSdk4Platform] to use.
  ///
  /// Defaults to [MethodChannelAsreaderSdk4].
  static AsreaderSdk4Platform get instance => _instance;

  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [AsreaderSdk4Platform] when
  /// they register themselves.
  static set instance(AsreaderSdk4Platform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  Future<String?> getPlatformVersion() {
    throw UnimplementedError('platformVersion() has not been implemented.');
  }

  Future<bool> getPluggedStatus() {
    throw UnimplementedError('getPluggedStatus() has not been implemented.');
  }

  Future<String?> getSDKVersion() {
    throw UnimplementedError('getSDKVersion() has not been implemented.');
  }

  Future<String?> getFlutterSDKVersion() {
    throw UnimplementedError('getFlutterSDKVersion() has not been implemented.');
  }

  Future<void> showPrintNSLog(bool isShow) {
    throw UnimplementedError('showPrintNSLog() has not been implemented.');
  }

  Future<int> setReaderPower(bool isOn, bool beep, bool vibration, bool led,
      bool illumination, bool connectedBeep, int mode) {
    throw UnimplementedError('setReaderPower() has not been implemented.');
  }

  Future<bool> getReaderInfo(int infoType) {
    throw UnimplementedError('setReaderPower() has not been implemented.');
  }

  Future<int> getCurrentBattery() {
    throw UnimplementedError('getCurrentBattery() has not been implemented.');
  }

  Future<bool> setBeep(bool isBeep, bool vibration, bool batteryGaugeLed,
      bool barcodeAimer) async {
    throw UnimplementedError('setBeep() has not been implemented.');
  }

  Future<bool> setBeepIncludePowerOnBeep(bool isBeep, bool vibration,
      bool batteryGaugeLed, bool barcodeAimer, bool barcodePowerOnBeep) async {
    throw UnimplementedError(
        'setBeepIncludePowerOnBeep() has not been implemented.');
  }

  Future<void> setTagCount(int mtnu, int mtime, int repeatCycle) {
    throw UnimplementedError('setTagCount() has not been implemented.');
  }

  Future<bool> setChargingControl(bool isOn) {
    throw UnimplementedError('setChargingControl() has not been implemented.');
  }
  Future<void> setDelayDisconnectOnBackground(double time) {
    throw UnimplementedError(
        'setDelayDisconnectOnBackground() has not been implemented.');
  }
  Future<double> getDelayDisconnectOnBackground() {
    throw UnimplementedError(
        'getDelayDisconnectOnBackground() has not been implemented.');
  }

  Future<bool> isOpened() {
    throw UnimplementedError('isOpened() has not been implemented.');
  }

  Future<bool> setStopTagNum(int maxTags, int maxTime, int repeatCycle) {
    throw UnimplementedError('setStopTagNum() has not been implemented.');
  }

  Future<bool> getStopCondition() {
    throw UnimplementedError('getStopCondition() has not been implemented.');
  }

  Future<bool> setTriggerMode(bool isDefault) {
    throw UnimplementedError('setTriggerMode() has not been implemented.');
  }

  Future<bool> reset() {
    throw UnimplementedError('reset() has not been implemented.');
  }

  Future<bool> getAutoLaunch() {
    throw UnimplementedError('getAutoLaunch() has not been implemented.');
  }

  Future<bool> setAutoLaunch(bool enable, String bundleId) {
    throw UnimplementedError('setAutoLaunch() has not been implemented.');
  }

  Future<bool> setSleepBeep(bool isOn) {
    throw UnimplementedError('setSleepBeep() has not been implemented.');
  }

  Future<bool> setSleepTime(int time) {
    throw UnimplementedError('setSleepTime() has not been implemented.');
  }

  Future<bool> getSleepTime() {
    throw UnimplementedError('setSleepTime() has not been implemented.');
  }

  Future<bool> startBleScan() {
    throw UnimplementedError('startBleScan() has not been implemented.');
  }

  Future<void> stopBleScan() {
    throw UnimplementedError('stopBleScan() has not been implemented.');
  }

  Future<void> disConnectBLE() {
    throw UnimplementedError('disConnectBLE() has not been implemented.');
  }
  Future<bool> connectBLE(String deviceName){
    throw UnimplementedError('connectBLE() has not been implemented.');
  }
  Future<int> getSleepTimeForBLEDevice() {
    throw UnimplementedError(
        'getSleepTimeForBLEDevice() has not been implemented.');
  }

  Future<int> setSleepTimeForBLEDeviceType(int min, int type) {
    throw UnimplementedError(
        'setSleepTimeForBLEDeviceType() has not been implemented.');
  }

  Future<bool> startBarcodeScan(int numberOfTags, int readUntilInSec) {
    throw UnimplementedError('startBarcodeScan() has not been implemented.');
  }

  Future<bool> stopBarcodeScan() {
    throw UnimplementedError('stopBarcodeScan() has not been implemented.');
  }

  Future<bool> doFactoryReset() {
    throw UnimplementedError('doFactoryReset() has not been implemented.');
  }
  Future<bool> sendBarcodeSettingData(Uint8List sendData) {
    throw UnimplementedError('sendBarcodeSettingData() has not been implemented.');
  }
  Future<bool> sendBarcodeHoneywellSettingWithData(Uint8List sendData) {
    throw UnimplementedError('sendBarcodeHoneywellSettingWithData() has not been implemented.');
  }
  Future<bool> setCustomPrefix(String prefix) {
    throw UnimplementedError('setCustomPrefix() has not been implemented.');
  }

  Future<bool> setDisableCustomPrefix() {
    throw UnimplementedError(
        'setDisableCustomPrefix() has not been implemented.');
  }

  Future<bool> setCustomSuffix(String suffix) {
    throw UnimplementedError('setCustomSuffix() has not been implemented.');
  }

  Future<bool> setDisableCustomSuffix() {
    throw UnimplementedError(
        'setDisableCustomSuffix() has not been implemented.');
  }

  Future<bool> setSymbologyPrefix() {
    throw UnimplementedError('setSymbologyPrefix() has not been implemented.');
  }

  Future<bool> setDisableSymbologyPrefix() {
    throw UnimplementedError(
        'setDisableSymbologyPrefix() has not been implemented.');
  }

  Future<bool> setBarcodeEngineUserCommand(String command) {
    throw UnimplementedError(
        'setBarcodeEngineUserCommand() has not been implemented.');
  }

  Future<bool> setCodeID(int type, bool isBeepOn) {
    throw UnimplementedError('setCodeID() has not been implemented.');
  }

  Future<bool> setOCRType(int type, bool isBeepOn) {
    throw UnimplementedError('setOCRType() has not been implemented.');
  }

  Future<bool> setAndroidHIDEnable(int isOn) {
    throw UnimplementedError('setAndroidHIDEnable() has not been implemented.');
  }

  Future<bool> setiOSHIDEnable(int isOn) {
    throw UnimplementedError('setiOSHIDEnable() has not been implemented.');
  }

  Future<bool> setPresentationMode(bool isOn, bool isBeepOn) {
    throw UnimplementedError('setPresentationMode() has not been implemented.');
  }

  Future<bool> getCodeID() {
    throw UnimplementedError('getCodeID() has not been implemented.');
  }

  Future<bool> getOCR() {
    throw UnimplementedError('getOCR() has not been implemented.');
  }

  Future<bool> getHID() {
    throw UnimplementedError('getHID() has not been implemented.');
  }

  Future<bool> getSymbologies() {
    throw UnimplementedError('getSymbologies() has not been implemented.');
  }
  Future<bool> setSsiParamWithData(Uint8List symbolData,bool beepOn){
    throw UnimplementedError(
        'setSsiParamWithData() has not been implemented.');
  }
  Future<bool> setSsiParamWithDictionary(List<Map<String, String>> symbologies, bool beepOn) {
    throw UnimplementedError(
        'setSsiParamWithDictionary() has not been implemented.');
  }

  Future<bool> getPresentationMode() {
    throw UnimplementedError('getPresentationMode() has not been implemented.');
  }

  Future<bool> getSecurity() {
    throw UnimplementedError('getSecurity() has not been implemented.');
  }

  Future<bool> startScan(int numberOfTags, int readUntilInSec,
      int repeatCycle) {
    throw UnimplementedError('startScan() has not been implemented.');
  }

  Future<bool> stopRfidScan() {
    throw UnimplementedError('stopRfidScan() has not been implemented.');
  }

  Future<bool> startReadTagsAndRssiWithTagNum(int maxTags, int maxTime,
      int repeatCycle) {
    throw UnimplementedError(
        'startReadTagsAndRssiWithTagNum() has not been implemented.');
  }

  Future<bool> startReadTagAndTidWithTagNum(int maxTags, int maxTime,
      int repeatCycle) {
    throw UnimplementedError(
        'startReadTagAndTidWithTagNum() has not been implemented.');
  }

  Future<bool> startReadTagsRFM(int codeType, int maxTags, int maxTime,
      int repeatCycle) {
    throw UnimplementedError('startReadTagsRFM() has not been implemented.');
  }

  Future<bool> getSelectParameter() {
    throw UnimplementedError('getSelectParameter() has not been implemented.');
  }
  Future<bool> setSelectParameter(int target,int action,int memoryBank,int pointer,int length,int truncate,Uint8List mask){
    throw UnimplementedError('setSelectParameter() has not been implemented.');
  }
  Future<bool> getChannel() {
    throw UnimplementedError('getChannel() has not been implemented.');
  }

  Future<bool> setReadTime(int readTime, int idleTime) {
    throw UnimplementedError('setReadTime() has not been implemented.');
  }

  Future<bool> setChannel(int channel, int channelOffset) {
    throw UnimplementedError('setChannel() has not been implemented.');
  }

  Future<bool> getFhLbtParameter() {
    throw UnimplementedError('getFhLbtParameter() has not been implemented.');
  }

  Future<bool> setFhLbtParameter(int readTime, int idleTime,
      int carrierSenseTime, int targetRFPowerLevel, int frequencyHopping,
      int listenBeforeTalk, int continuousWave) {
    throw UnimplementedError('setFhLbtParameter() has not been implemented.');
  }

  Future<bool> getOutputPowerLevel() {
    throw UnimplementedError('getOutputPowerLevel() has not been implemented.');
  }

  Future<bool> setOutputPowerLevel(int powerLevel) {
    throw UnimplementedError('setOutputPowerLevel() has not been implemented.');
  }
  Future<bool> writeTagMemoryWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, Uint8List dataToWrite){
    throw UnimplementedError('writeTagMemoryWithAccessPassword() has not been implemented.');
  }
  Future<bool> killTagWithPassword(int accessPassword, Uint8List epc){
    throw UnimplementedError('killTagWithPassword() has not been implemented.');
  }
  Future<bool> lockTagMemoryWithAccessPassword(int accessPassword, Uint8List epc,int lockData){
    throw UnimplementedError('lockTagMemoryWithAccessPassword() has not been implemented.');
  }
  Future<bool> getFrequencyHoppingTable() {
    throw UnimplementedError('setOutputPowerLevel() has not been implemented.');
  }
  Future<bool> setFrequencyHoppingTableSize(int tableSize, Uint8List channels){
    throw UnimplementedError('setFrequencyHoppingTableSize() has not been implemented.');
  }
  Future<bool> getRssi() {
    throw UnimplementedError('getRssi() has not been implemented.');
  }

  Future<bool> getSession() {
    throw UnimplementedError('getSession() has not been implemented.');
  }

  Future<bool> setSession(int session) {
    throw UnimplementedError('setSession() has not been implemented.');
  }

  Future<bool> getAnticollision() {
    throw UnimplementedError('getAnticollision() has not been implemented.');
  }

  Future<bool> setAnticollision(int mode, int counter) {
    throw UnimplementedError('setAnticollision() has not been implemented.');
  }

  Future<bool> updateRegistry() {
    throw UnimplementedError('updateRegistry() has not been implemented.');
  }

  Future<bool> getRFIDModuleVersion() {
    throw UnimplementedError(
        'getRFIDModuleVersion() has not been implemented.');
  }

  Future<bool> setHoppingOnOff(bool isOn) {
    throw UnimplementedError('setHoppingOnOff() has not been implemented.');
  }
  Future<bool> writeTagMemoryWithEPC(Uint8List epc,String dataToWrite){
    throw UnimplementedError('writeTagMemoryWithEPC() has not been implemented.');
  }
  Future<bool> setRSSIThreshold(int threshold) {
    throw UnimplementedError('setRSSIThreshold() has not been implemented.');
  }

  Future<bool> getRSSIThreshold() {
    throw UnimplementedError('getRSSIThreshold() has not been implemented.');
  }

  Future<bool> getQueryParameter() {
    throw UnimplementedError('getQueryParameter() has not been implemented.');
  }
  Future<bool> readTagWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, int dataLength) {
    throw UnimplementedError('readTagWithAccessPassword() has not been implemented.');
  }
  Future<bool> setQueryParam(int divideRatio, int m, int trext, int selection,
      int session, int target, int qValue) {
    throw UnimplementedError('setQueryParam() has not been implemented.');
  }
  Future<bool> setRfCw(bool on){
    throw UnimplementedError('setRfCw() has not been implemented.');
  }
  Future<bool> getModulation(){
    throw UnimplementedError('getModulation() has not been implemented.');
  }
  Future<bool> setModulationBLF(int blf,int rxMod,int dr){
    throw UnimplementedError('setModulationBLF() has not been implemented.');
  }
  Future<bool> blockEraseTagMemoryWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, int dataLength) {
    throw UnimplementedError('blockEraseTagMemoryWithAccessPassword() has not been implemented.');
  }
  Future<bool> genericTransportWithAccessPassword(int accessPassword, Uint8List epc, int transmissionState, int rm, int size, Uint8List genericCommand) {
    throw UnimplementedError('genericTransportWithAccessPassword() has not been implemented.');
  }
  Future<bool> getTemperature(){
    throw UnimplementedError('getTemperature() has not been implemented.');
  }
  Future<bool> getRegistryItem(int registryItem){
    throw UnimplementedError('getRegistryItem() has not been implemented.');
  }
  Future<bool> setOptimumFrequencyHoppingTable(){
    throw UnimplementedError('setOptimumFrequencyHoppingTable() has not been implemented.');
  }
  Future<bool> setFrequencyHoppingMode(int mode){
    throw UnimplementedError('setFrequencyHoppingMode() has not been implemented.');
  }
  Future<bool> getFrequencyHoppingMode(){
    throw UnimplementedError('getFrequencyHoppingMode() has not been implemented.');
  }
  Future<bool> setSmartHoppingOnOff(bool isOn){
    throw UnimplementedError('setSmartHoppingOnOff() has not been implemented.');
  }
  Future<bool> getRegion(){
    throw UnimplementedError('getRegion() has not been implemented.');
  }
  Future<void> setReadRSSIMode(bool isReadRSSIMode){
    throw UnimplementedError('setReadRSSIMode() has not been implemented.');
  }
  Future<bool> getRfidModuleInformation(){
    throw UnimplementedError('getRfidModuleInformation() has not been implemented.');
  }
  Future<bool> getHoppingOnOff(){
    throw UnimplementedError('getHoppingOnOff() has not been implemented.');
  }
  Future<bool> getAutoOffTime(){
    throw UnimplementedError('getAutoOffTime() has not been implemented.');
  }
  Future<bool> setAutoOffTime(int time){
    throw UnimplementedError('setAutoOffTime() has not been implemented.');
  }
  Future<bool> getContinuousMode(){
    throw UnimplementedError('getContinuousMode() has not been implemented.');
  }
  Future<bool> setContinuousMode(bool isContinuousMode){
    throw UnimplementedError('setContinuousMode() has not been implemented.');
  }
  Future<bool> getQValue(){
    throw UnimplementedError('getQValue() has not been implemented.');
  }
  Future<bool> setQValue(int value){
    throw UnimplementedError('setQValue() has not been implemented.');
  }
  Future<bool> getSessionFlag(){
    throw UnimplementedError('getSessionFlag() has not been implemented.');
  }
  Future<bool> setSessionFlag(int sessionFlag){
    throw UnimplementedError('setSessionFlag() has not been implemented.');
  }
  Future<bool> getHidMode(){
    throw UnimplementedError('getHidMode() has not been implemented.');
  }
  Future<bool> setHidMode(bool hidMode){
    throw UnimplementedError('setHidMode() has not been implemented.');
  }
  Future<bool> getDutyRatio(){
    throw UnimplementedError('getDutyRatio() has not been implemented.');
  }
  Future<bool> setDutyRatio(int dutyRatio){
    throw UnimplementedError('setDutyRatio() has not been implemented.');
  }
  Future<bool> getDutyRatioBaseTime(){
    throw UnimplementedError('getDutyRatioBaseTime() has not been implemented.');
  }
  Future<bool> setDutyRatioBaseTime(int dutyRatioBaseTime){
    throw UnimplementedError('setDutyRatioBaseTime() has not been implemented.');
  }
  Future<bool> sendData(Uint8List sendData){
    throw UnimplementedError('sendData() has not been implemented.');
  }
  Future<bool> setInventoryTime(double inventoryTime){
    throw UnimplementedError('setInventoryTime() has not been implemented.');
  }
  Future<bool> startNFCScan(){
    throw UnimplementedError('startNFCScan() has not been implemented.');
  }
  Future<bool> stopNFCScan(){
    throw UnimplementedError('stopNFCScan() has not been implemented.');
  }
  Future<bool> readMultiBlockWithBlockIndex(int index, int count){
    throw UnimplementedError('readMultiBlockWithBlockIndex() has not been implemented.');
  }
  Future<bool> writeSingleBlockWithBlockIndex(int index, Uint8List writeData, Uint8List uid){
    throw UnimplementedError('writeSingleBlockWithBlockIndex() has not been implemented.');
  }
  Future<bool> writeBytesWithBlockIndex(int index, Uint8List writeData, Uint8List uid){
    throw UnimplementedError('writeBytesWithBlockIndex() has not been implemented.');
  }
  Future<bool> startLfScan(int numberOfTags, int readUntilInSec, int repeatCycle){
    throw UnimplementedError('startLfScan() has not been implemented.');
  }
  Future<bool> stopLfScan(){
    throw UnimplementedError('stopLfScan() has not been implemented.');
  }
  Future<bool> isShowPrintNSLog(){
    throw UnimplementedError('isShowPrintNSLog() has not been implemented.');
  }
  Future<String> bundleIdentifier(){
    throw UnimplementedError('bundleIdentifier() has not been implemented.');
  }
  Future<String> deviceName(){
    throw UnimplementedError('deviceName() has not been implemented.');
  }
  Future<String> deviceFirmware(){
    throw UnimplementedError('deviceFirmware() has not been implemented.');
  }
  Future<String> deviceHardware(){
    throw UnimplementedError('deviceHardware() has not been implemented.');
  }
  Future<String> deviceID(){
    throw UnimplementedError('deviceID() has not been implemented.');
  }
  Future<String> deviceManufacturer(){
    throw UnimplementedError('deviceManufacturer() has not been implemented.');
  }
  Future<String> deviceModelNumber(){
    throw UnimplementedError('deviceModelNumber() has not been implemented.');
  }
  Future<String> deviceSerialNumber(){
    throw UnimplementedError('deviceSerialNumber() has not been implemented.');
  }
  Future<String> deviceProtocol(){
    throw UnimplementedError('deviceProtocol() has not been implemented.');
  }
  Future<int> currentSelectDevice(){
    throw UnimplementedError('currentSelectDevice() has not been implemented.');
  }
  Future<bool> isPowerOn(){
    throw UnimplementedError('isPowerOn() has not been implemented.');
  }
  Future<int> supportMode(){
    throw UnimplementedError('supportMode() has not been implemented.');
  }
  Future<int> currentReaderMode(){
    throw UnimplementedError('currentReaderMode() has not been implemented.');
  }
  Future<int> receiveDataType(){
    throw UnimplementedError('receiveDataType() has not been implemented.');
  }
  Future<bool> dualSameTime(){
    throw UnimplementedError('dualSameTime() has not been implemented.');
  }
  Future<bool> isBeep(){
    throw UnimplementedError('isBeep() has not been implemented.');
  }
  Future<bool> isVibration(){
    throw UnimplementedError('isVibration() has not been implemented.');
  }
  Future<bool> isLED(){
    throw UnimplementedError('isLED() has not been implemented.');
  }
  Future<bool> isIllumination(){
    throw UnimplementedError('isIllumination() has not been implemented.');
  }
  Future<int> count(){
    throw UnimplementedError('count() has not been implemented.');
  }
  Future<int> scanTime(){
    throw UnimplementedError('scanTime() has not been implemented.');
  }
  Future<int> cycle(){
    throw UnimplementedError('cycle() has not been implemented.');
  }
  Future<bool> isTriggerModeDefault(){
    throw UnimplementedError('isTriggerModeDefault() has not been implemented.');
  }
  Future<bool> isReadRSSIMode(){
    throw UnimplementedError('isReadRSSIMode() has not been implemented.');
  }
  Future<bool> isEnginePowerAlwaysOn(){
    throw UnimplementedError('writeBytesWithBlockIndex() has not been implemented.');
  }
  Future<int> barcodeEngineType(){
    throw UnimplementedError('barcodeEngineType() has not been implemented.');
  }
  Future<int> carrierSenseTime(){
    throw UnimplementedError('carrierSenseTime() has not been implemented.');
  }
  Future<int> targetRFPowerLevel(){
    throw UnimplementedError('targetRFPowerLevel() has not been implemented.');
  }
  Future<bool> isSmartHopping(){
    throw UnimplementedError('isSmartHopping() has not been implemented.');
  }
  Future<double> rfidPower(){
    throw UnimplementedError('rfidPower() has not been implemented.');
  }
  Future<double> rfidPowerMax(){
    throw UnimplementedError('rfidPowerMax() has not been implemented.');
  }
  Future<double> rfidPowerMin(){
    throw UnimplementedError('rfidPowerMin() has not been implemented.');
  }
  Future<int> rfidOnTime(){
    throw UnimplementedError('rfidOnTime() has not been implemented.');
  }
  Future<int> rfidOffTime(){
    throw UnimplementedError('rfidOffTime() has not been implemented.');
  }
  Future<int> rfidChannel(){
    throw UnimplementedError('rfidChannel() has not been implemented.');
  }
  Future<int> rfidListenBeforeTalk(){
    throw UnimplementedError('rfidListenBeforeTalk() has not been implemented.');
  }
  Future<int> rfidFrequencyHopping(){
    throw UnimplementedError('rfidFrequencyHopping() has not been implemented.');
  }
  Future<int> rfidContinuousWave(){
    throw UnimplementedError('rfidContinuousWave() has not been implemented.');
  }
  Future<String> rfidModuleVersion(){
    throw UnimplementedError('rfidModuleVersion() has not been implemented.');
  }
  Future<bool> isSupportType(int supportType){
    throw UnimplementedError('isSupportType() has not been implemented.');
  }
  Future<List<int>> getSupportTypeArray(){
    throw UnimplementedError('getSupportTypeArray() has not been implemented.');
  }
  Future<bool> setConnectionType(int type){
    throw UnimplementedError('setConnectionType() has not been implemented.');
  }
  Future<int> getConnectionType(){
    throw UnimplementedError('getConnectionType() has not been implemented.');
  }
  Future<Map<String,String>> parseDataByProtocolType(Uint8List data,int type){
    throw UnimplementedError('parseDataByProtocolType() has not been implemented.');
  }
  Future<bool> getSleepBuzzer(){
    throw UnimplementedError('getSleepBuzzer() has not been implemented.');
  }
  Future<bool> setSleepBuzzer(bool sleepBuzzer){
    throw UnimplementedError('setSleepBuzzer() has not been implemented.');
  }
  Future<bool> getBarcodeTimeOut(){
    throw UnimplementedError('getBarcodeTimeOut() has not been implemented.');
  }
  Future<bool> setBarcodeTimeOut(int timeout){
    throw UnimplementedError('setBarcodeTimeOut() has not been implemented.');
  }
}