//
//  AsReaderSDK4Manager.h
//  asreader_sdk4
//
//  Created by ios on 2024/12/31.
//

#import <UIKit/UIKit.h>
#import <Flutter/Flutter.h>
#define PLUGGED_STATUS                         @"PLUGGED_STATUS"
#define CONNECTED_STATUS                       @"CONNECTED_STATUS"
#define TRIGGER_STATUS                         @"TRIGGER_STATUS"
#define POWER_ON_OFF                           @"POWER_ON_OFF"
#define RELEASED_TRIGGER_BUTTON                @"RELEASED_TRIGGER_BUTTON"
#define PUSHED_TRIGGER_BUTTON                  @"PUSHED_TRIGGER_BUTTON"
#define ON_ASREADER_TRIGGER_KEY_EVENT_STATUS   @"ON_ASREADER_TRIGGER_KEY_EVENT_STATUS"
#define RECEIVED_SCAN_DATA                     @"RECEIVED_SCAN_DATA"
#define RECEIVED_SCAN_DATA_AND_DATA_TYPE       @"RECEIVED_SCAN_DATA_AND_DATA_TYPE"
#define UNKNOWN_COMMAND_RECEIVED               @"UNKNOWN_COMMAND_RECEIVED"
#define ALL_DATA_RECEIVED                      @"ALL_DATA_RECEIVED"
#define BATTERY_RECEIVED                       @"BATTERY_RECEIVED"
#define STOP_READ_SCAN                         @"STOP_READ_SCAN"
#define STARTED_READ_SCAN                      @"STARTED_READ_SCAN"
#define ERROR_RECEIVED                         @"ERROR_RECEIVED"
#define RECEIVED_SLEEP_TIME_AND_ISACK          @"RECEIVED_SLEEP_TIME_AND_ISACK"
#define RECEIVED_SLEEP_TIME                    @"RECEIVED_SLEEP_TIME"
#define RECEIVED_BEEP                          @"RECEIVED_BEEP"
#define READER_INFO_RECEIVED                   @"READER_INFO_RECEIVED"
#define DID_SET_STOP_CONDITION                 @"DID_SET_STOP_CONDITION"
#define STOP_CONDITIONS_RECEIVED               @"STOP_CONDITIONS_RECEIVED"
#define RESPONSE_BOOT_LOADER_S0                @"RESPONSE_BOOT_LOADER_S0"
#define RECEIVED_BARCODE_DATA                  @"RECEIVED_BARCODE_DATA"
#define RECEIVED_FACTORY_RESET                 @"RECEIVED_FACTORY_RESET"
#define ACK_USER_COMMAND_RECEIVED              @"ACK_USER_COMMAND_RECEIVED"
#define RECEIVED_BYPASS_PAYLOAD                @"RECEIVED_BYPASS_PAYLOAD"
#define RECEIVED_CODE_ID                       @"RECEIVED_CODE_ID"
#define RECEIVED_OCR                           @"RECEIVED_OCR"
#define RECEIVED_HID                           @"RECEIVED_HID"
#define RECEIVED_PRESENTATION_MODE             @"RECEIVED_PRESENTATION_MODE"
#define RECEIVED_SLEEP_BEEP                    @"RECEIVED_SLEEP_BEEP"
#define RECEIVED_BARCODE_SET_SSI_SUCCESS       @"RECEIVED_BARCODE_SET_SSI_SUCCESS"
#define RECEIVED_SYMBOLOGIES                   @"RECEIVED_SYMBOLOGIES"
#define RECEIVED_GET_AUTO_LAUNCH               @"RECEIVED_GET_AUTO_LAUNCH"
#define RECEIVED_BARCODE_SECURITY              @"RECEIVED_BARCODE_SECURITY"
#define EPC_RECEIVED_AND_TID                   @"EPC_RECEIVED_AND_TID"
#define PC_EPC_RECEIVED                        @"PC_EPC_RECEIVED"
#define PC_EPC_RSSI_RECEIVED_AND_RSSI          @"PC_EPC_RSSI_RECEIVED_AND_RSSI"
#define PC_EPC_SENSOR_DATA_RECEIVED            @"PC_EPC_SENSOR_DATA_RECEIVED"
#define PC_EPC_SENSOR_DATA_RECEIVED_RSSI       @"PC_EPC_SENSOR_DATA_RECEIVED_RSSI"
#define DID_SET_OUTPUT_POWER_LEVEL             @"DID_SET_OUTPUT_POWER_LEVEL"
#define DID_SET_CHANNEL_PARAM_RECEIVED         @"DID_SET_CHANNEL_PARAM_RECEIVED"
#define DID_SET_ANTI_COLLISION                 @"DID_SET_ANTI_COLLISION"
#define DID_SET_SESSION                        @"DID_SET_SESSION"
#define DID_SET_BEEP                           @"DID_SET_BEEP"
#define CHANNEL_RECEIVED_AND_CHANNEL_OFFSET    @"CHANNEL_RECEIVED_AND_CHANNEL_OFFSET"
#define ANTICOL_PARAM_RECEIVED_AND_COUNTER     @"ANTICOL_PARAM_RECEIVED_AND_COUNTER"
#define MODULATION_PARAM_RECEIVED_RXMOD_DR     @"MODULATION_PARAM_RECEIVED_RXMOD_DR"
#define TX_POWER_LEVEL_RECEIVED_POWER          @"TX_POWER_LEVEL_RECEIVED_POWER"
#define REGION_RECEIVED                        @"REGION_RECEIVED"
#define SELECT_PARAM_RECEIVED                  @"SELECT_PARAM_RECEIVED"
#define QUERY_PARAM_RECEIVED                   @"QUERY_PARAM_RECEIVED"
#define ON_OFF_TIME_CHANGED                    @"ON_OFF_TIME_CHANGED"
#define FREQ_HP_TABLE_RECEIVED                 @"FREQ_HP_TABLE_RECEIVED"
#define FHLBT_RECEIVED                         @"FHLBT_RECEIVED"
#define HOPPING_TABLE_RECEIVED                 @"HOPPING_TABLE_RECEIVED"
#define DID_SET_FREQ_HP_TABLE                  @"DID_SET_FREQ_HP_TABLE"
#define DID_SET_FHLBT                          @"DID_SET_FHLBT"
#define DID_SET_OPTI_FREQ_HPTABLE              @"DID_SET_OPTI_FREQ_HPTABLE"
#define DID_SET_FHMODE_CHANGED                 @"DID_SET_FHMODE_CHANGED"
#define RESPONSE_GET_FH_MODE                   @"RESPONSE_GET_FH_MODE"
#define DID_SET_MODULATION                     @"DID_SET_MODULATION"
#define RFID_MODULE_VERSION_RECEIVED           @"RFID_MODULE_VERSION_RECEIVED"
#define RFID_ON_OFF_TIME_RECEIVED              @"RFID_ON_OFF_TIME_RECEIVED"
#define RSSI_THRESHOLD_RECEIVED                @"RSSI_THRESHOLD_RECEIVED"
#define WRITTEN_RECEIVED                       @"WRITTEN_RECEIVED"
#define SESSION_RECEIVED                       @"SESSION_RECEIVED"
#define TAG_MEMORY_RECEIVED                    @"TAG_MEMORY_RECEIVED"
#define KILL_RECEIVED                          @"KILL_RECEIVED"
#define LOCKED_RECEIVED                        @"LOCKED_RECEIVED"
#define REGISTERY_ITEM_RECEIVED                @"REGISTERY_ITEM_RECEIVED"
#define GENERIC_RECEIVED                       @"GENERIC_RECEIVED"
#define RESPONSE_REBOOT                        @"RESPONSE_REBOOT"
#define UPDATED_REGISTERY                      @"UPDATED_REGISTERY"
#define RFID_DATA_RECEIVED                     @"RFID_DATA_RECEIVED"
#define RESPONSE_SET_LEAKAGE                   @"RESPONSE_SET_LEAKAGE"
#define DID_GET_AUTO_OFF_TIME_RECEIVED         @"DID_GET_AUTO_OFF_TIME_RECEIVED"
#define DID_SET_AUTO_OFF_TIME                  @"DID_SET_AUTO_OFF_TIME"
#define DID_GET_CONTINUOUS_MODE_RECEIVED       @"DID_GET_CONTINUOUS_MODE_RECEIVED"
#define DID_SET_CONTINUOUS_MODE                @"DID_SET_CONTINUOUS_MODE"
#define DID_GET_Q_VALUE_RECEIVED               @"DID_GET_Q_VALUE_RECEIVED"
#define DID_SET_Q_VALUE                        @"DID_SET_Q_VALUE"
#define DID_GET_SESSION_FLAG_RECEIVED          @"DID_GET_SESSION_FLAG_RECEIVED"
#define DID_SET_SESSION_FLAG                   @"DID_SET_SESSION_FLAG"
#define DID_GET_HID_MODE_RECEIVED              @"DID_GET_HID_MODE_RECEIVED"
#define DID_SET_HID_MODE                       @"DID_SET_HID_MODE"
#define DID_GET_DUTY_RATIO_RECEIVED            @"DID_GET_DUTY_RATIO_RECEIVED"
#define DID_SET_DUTY_RATIO                     @"DID_SET_DUTY_RATIO"
#define DID_GET_DUTY_RATIO_BASE_TIME_RECEIVED  @"DID_GET_DUTY_RATIO_BASE_TIME_RECEIVED"
#define DID_SET_DUTY_RATIO_BASE_TIME           @"DID_SET_DUTY_RATIO_BASE_TIME"
#define NFC_READ_MULTI_BLOCK_RECEIVED          @"NFC_READ_MULTI_BLOCK_RECEIVED"
#define NFC_WRITE_SINGLE_BLOCK_STATUS_CODE     @"NFC_WRITE_SINGLE_BLOCK_STATUS_CODE"
#define NFC_WRITE_BYTES_STATUS_CODE            @"NFC_WRITE_BYTES_STATUS_CODE"
#define SCANING_BLE_DEVICE                     @"SCANING_BLE_DEVICE"
#define SCAN_BLE_STATUS                        @"SCAN_BLE_STATUS"
#define RECEIVED_SCAN_BARCODE_DATA             @"RECEIVED_SCAN_BARCODE_DATA"
#define DID_GET_SLEEP_BUZZER_RECEIVED          @"DID_GET_SLEEP_BUZZER_RECEIVED"
#define DID_SET_SLEEP_BUZZER                   @"DID_SET_SLEEP_BUZZER"
#define DID_GET_BARCODE_TIME_OUT_RECEIVED      @"DID_GET_BARCODE_TIME_OUT_RECEIVED"
#define DID_SET_BARCODE_TIME_OUT               @"DID_SET_BARCODE_TIME_OUT"

@interface AsReaderSDK4Manager : NSObject
@property (nonatomic, assign) BOOL isPlugged;
@property (nonatomic, assign) BOOL isConnected;
@property (nonatomic, strong) FlutterMethodChannel * currentChannel;
+ (AsReaderSDK4Manager *)sharedInstance;
- (NSString *)getSDKVersion;
- (NSString *)getFlutterSDKVersion;
- (void)showPrintNSLog:(BOOL)isShow;
- (void)setConnectionType:(int)type;
- (int)getConnectionType;
- (BOOL)getReaderInfo:(int)infoType;
- (int)getCurrentBattery;
- (BOOL)setBeep:(BOOL)isBeep
      vibration:(BOOL)isVibration
batteryGaugeLed:(BOOL)isbatteryGaugeLed
   barcodeAimer:(BOOL)isBarcodeAimer;
- (BOOL)setBeep:(BOOL)isBeep
      vibration:(BOOL)isVibration
batteryGaugeLed:(BOOL)isbatteryGaugeLed
   barcodeAimer:(BOOL)isBarcodeAimer
barcodePowerOnBeep:(BOOL)isBarcodePowerOnBeep;
- (int)setReaderPower:(BOOL)isOn
    beep:(BOOL)isBeep
    vibration:(BOOL)isVib
    batteryGaugeLed:(BOOL)isbatteryGaugeLed
    barcodeAimer:(BOOL)isBarcodeAimer
    barcodePowerOnBeep:(BOOL)isBarcodePowerOnBeep
                 mode:(int)nDeviceType;
- (void)setTagCount:(int)mtnu
        setScanTime:(int)mtime
           setCycle:(int)repeatCycle;
- (BOOL)setChargingControl:(BOOL)isOn;
- (void)setDelayDisconnectOnBackground:(NSTimeInterval)time;
- (NSTimeInterval) getDelayDisconnectOnBackground;
- (BOOL)isOpened;
- (BOOL)setStopTagNum:(int)maxTags
              maxTime:(int)maxTime
          repeatCycle:(int)repeatCycle;
- (BOOL)getStopCondition;
- (BOOL)setTriggerMode:(BOOL)isDefault;
- (BOOL)reset;
- (BOOL)getAutoLaunch;
- (BOOL)setAutoLaunch:(BOOL)enable bundleId:(NSString*) bundleId;
- (BOOL)setSleepBeep: (BOOL)isOn;
- (BOOL)setSleepTime: (int)time;
- (BOOL)getSleepTime;
- (BOOL)startBleScan;
- (void)stopBleScan;
- (void)disConnectBLE;
- (BOOL)connectBLE:(NSString *)deviceName;
- (int)getSleepTimeForBLEDevice;
- (int)setSleepTimeForBLEDevice:(int)min type:(int)type;
- (BOOL)startBarcodeScan:(uint8_t)numberOfTags readUntilInSec:(uint8_t)readUntilInSec;
- (BOOL)stopBarcodeScan;
- (BOOL)doFactoryReset;
- (BOOL)sendBarcodeSettingData:(NSData*)sendData;
- (BOOL)sendBarcodeHoneywellSettingWithData:(NSData*)sendData;
- (BOOL)setCustomPrefix:(NSString *)prefix;
- (BOOL)setDisableCustomPrefix;
- (BOOL)setCustomSuffix:(NSString *)suffix;
- (BOOL)setDisableCustomSuffix;
- (BOOL)setSymbologyPrefix;
- (BOOL)setDisableSymbologyPrefix;
- (BOOL)setBarcodeEngineUserCommand:(NSString *)command;
- (BOOL)setCodeID: (int)type isBeepOn:(BOOL)isBeepOn;
- (BOOL)setOCRType: (int)type isBeepOn:(BOOL)isBeepOn;
- (BOOL)setAndroidHIDEnable: (BOOL)isOn;
- (BOOL)setiOSHIDEnable: (BOOL)isOn;
- (BOOL)setPresentationMode: (BOOL)isOn isBeepOn:(BOOL)isBeepOn;
- (BOOL)getCodeID;
- (BOOL)getOCR;
- (BOOL)getHID;
- (BOOL)getSymbologies;
- (BOOL)setSsiParamWithData:(NSData *)symbolData beepOn:(BOOL)beepOn;
- (BOOL)setSsiParamWithDictionary:(NSMutableArray *)symbologies beepOn:(BOOL)beepOn;
- (BOOL)getPresentationMode;
- (BOOL)getSecurity;
- (BOOL)getSleepBuzzer;
- (BOOL)setSleepBuzzer:(BOOL)sleepBuzzer;
- (BOOL)getBarcodeTimeOut;
- (BOOL)setBarcodeTimeOut:(int)timeout;
- (BOOL)startScan:(int)numberOfTags
   readUntilInSec:(int)readUntilInSec
      repeatCycle:(int)repeatCycle;
- (BOOL)stopRfidScan;
- (BOOL)startReadTagsAndRssiWithTagNum:(int)maxTags
                               maxTime:(int)maxTime
                           repeatCycle:(int)repeatCycle;
- (BOOL)startReadTagAndTidWithTagNum:(int)maxTags
                             maxTime:(int)maxTime
                         repeatCycle:(int)repeatCycle;
- (BOOL)startReadTagsRFM:(int)codeType
                 maxTags:(int)maxTags
                 maxTime:(int)maxTime
             repeatCycle:(int)repeatCycle;
- (BOOL)getSelectParameter;
- (BOOL)setSelectParameter:(int)target
                    action:(int)action
                memoryBank:(int)memoryBank
                   pointer:(int)pointer
                    length:(int)length
                  truncate:(int)truncate
                      mask:(NSData *)mask;
- (BOOL)getChannel;
- (BOOL)setReadTime:(int)ReadTime
           idleTime:(int)IdleTime;
- (BOOL)setChannel:(int)channel
     channelOffset:(int)channelOffset;
- (BOOL)getFhLbtParameter;
- (BOOL)setFhLbtParameter:(int)ReadTime
                 idleTime:(int)IdleTime
         carrierSenseTime:(int)carrierSenseTime
       targetRFPowerLevel:(int)targetRFPowerLevel
         frequencyHopping:(int)frequencyHopping
         listenBeforeTalk:(int)listenBeforeTalk
           continuousWave:(int)continuousWave;
- (BOOL)getOutputPowerLevel;
- (BOOL)setOutputPowerLevel:(int)powerLevel;
- (BOOL)writeTagMemoryWithAccessPassword:(int)accessPassword
                                     epc:(NSData *)epc
                              memoryBank:(int)memoryBank
                            startAddress:(int)startAddress
                             dataToWrite:(NSData *)dataToWrite;
- (BOOL)killTagWithPassword:(int)password
                        epc:(NSData *)epc;
- (BOOL)lockTagMemoryWithAccessPassword:(int)accessPassword
                                    epc:(NSData *)epc
                               lockData:(int)lockData;
- (BOOL)getFrequencyHoppingTable;
- (BOOL)setFrequencyHoppingTableSize:(int)tableSize
                            channels:(NSData*)channels;
- (BOOL)getRssi;
- (BOOL)getSession;
- (BOOL)setSession:(int)session;
- (BOOL)getAnticollision;
- (BOOL)setAnticollision:(int)mode
                 Counter:(int)counter;
- (BOOL)updateRegistry;
- (BOOL)getRFIDModuleVersion;
- (BOOL)setHoppingOnOff:(BOOL)isOn;
- (BOOL)writeTagMemoryWithEPC:(NSData *)epc
             dataToWriteAscii:(NSString *)dataToWrite;
- (BOOL)setRSSIThreshold:(uint16_t)threshold;
- (BOOL)getRSSIThreshold;
- (BOOL)getQueryParameter;
- (BOOL)readTagWithAccessPassword:(int)accessPassword
                              epc:(NSData *)epc
                       memoryBank:(int)memoryBank
                     startAddress:(int)startAddress
                       dataLength:(int)dataLength;
- (BOOL)setQueryParam:(int)divideRatio
                    m:(int)m
                trext:(int)trext
            selection:(int)selection
              session:(int)session
               target:(int)target
               qValue:(int)qValue;
- (BOOL)setRfCw:(BOOL)on;
- (BOOL)getModulation;
- (BOOL)setModulationBLF:(int)blf rxMod:(int)rxMod dr:(int)dr;
- (BOOL)blockEraseTagMemoryWithAccessPassword:(int)accessPassword
                                          epc:(NSData *)epc
                                   memoryBank:(int)memoryBank
                                 startAddress:(int)startAddress
                                   dataLength:(int)dataLength;
- (BOOL)genericTransportWithAccessPassword:(int)accessPassword
                                       epc:(NSData *)epc
                         transmissionState:(int)transmissionState
                                        rm:(int)rm
                                      size:(int)size
                            genericCommand:(NSData *)genericCommand;
- (BOOL)getTemperature;
- (BOOL)getRegistryItem:(int)registryItem;
- (BOOL)setOptimumFrequencyHoppingTable;
- (BOOL)setFrequencyHoppingMode:(int)mode;
- (BOOL)getFrequencyHoppingMode;
- (BOOL)setSmartHoppingOnOff:(BOOL)isOn;
- (BOOL)getRegion;
- (void)setReadRSSIMode:(BOOL)isReadRSSIMode;
- (BOOL)getRfidModuleInformation;
- (BOOL)getHoppingOnOff;
- (BOOL)getAutoOffTime;
- (BOOL)setAutoOffTime:(int)time;
- (BOOL)getContinuousMode;
- (BOOL)setContinuousMode:(BOOL)isContinuousMode;
- (BOOL)getQValue;
- (BOOL)setQValue:(int)value;
- (BOOL)getSessionFlag;
- (BOOL)setSessionFlag:(int)sessionFlag;
- (BOOL)getHidMode;
- (BOOL)setHidMode:(BOOL)hidMode;
- (BOOL)getDutyRatio;
- (BOOL)setDutyRatio:(int)dutyRatio;
- (BOOL)getDutyRatioBaseTime;
- (BOOL)setDutyRatioBaseTime:(int)dutyRatioBaseTime;
- (BOOL)sendData:(NSData *)sendData;
- (BOOL)setInventoryTime:(float)inventoryTime;
- (BOOL)startNFCScan;
- (BOOL)stopNFCScan;
- (BOOL)readMultiBlockWithBlockIndex:(int)index
                               count:(int)count;
- (BOOL)writeSingleBlockWithBlockIndex:(int)index
                             writeData:(NSData *)writeData
                                   uid:(NSData *)uid;
- (BOOL)writeBytesWithBlockIndex:(int)index
                       writeData:(NSData *)writeData
                             uid:(NSData *)uid;
- (BOOL)startLfScan:(int)numberOfTags
   readUntilInSec:(int)readUntilInSec
        repeatCycle:(int)repeatCycle;
- (BOOL)stopLfScan;
- (BOOL)isShowPrintNSLog;
- (NSString *)bundleIdentifier;
- (NSString *)deviceName;
- (NSString *)deviceFirmware;
- (NSString *)deviceHardware;
- (NSString *)deviceID;
- (NSString *)deviceManufacturer;
- (NSString *)deviceModelNumber;
- (NSString *)deviceSerialNumber;
- (NSString *)deviceProtocol;
- (int)currentSelectDevice;
- (BOOL)isPowerOn;
- (int)supportMode;
- (int)currentReaderMode;
- (int)receiveDataType;
- (BOOL)dualSameTime;
- (BOOL)isBeep;
- (BOOL)isVibration;
- (BOOL)isLED;
- (BOOL)isIllumination;
- (int)count;
- (int)scanTime;
- (int)cycle;
- (BOOL)isTriggerModeDefault;
- (BOOL)isReadRSSIMode;
- (BOOL)isEnginePowerAlwaysOn;
- (int)barcodeEngineType;
- (int)carrierSenseTime;
- (int)targetRFPowerLevel;
- (BOOL)isSmartHopping;
- (float)rfidPower;
- (float)rfidPowerMax;
- (float)rfidPowerMin;
- (int)rfidOnTime;
- (int)rfidOffTime;
- (int)rfidChannel;
- (int)rfidListenBeforeTalk;
- (int)rfidFrequencyHopping;
- (int)rfidContinuousWave;
- (NSString*)rfidModuleVersion;
- (BOOL)isSupportType:(int)supportType;
- (NSArray *)getSupportTypeArray;
- (NSDictionary *)parseDataByProtocolType:(NSData *)data protocolType:(int)protocolType;
@end



