using Foundation;
using System.Runtime.InteropServices;

namespace AsReaderSDK4MAUIDemo.Platforms.iOS
{
    public partial class RainTagHelper : NSObject
    {
        public RainTagHelper(IntPtr handle) : base(handle)
        {
        }
        public static string getPC(NSData rawData)
        {
            byte[] ptr = rawData.ToArray();
            Marshal.Copy(rawData.Bytes, ptr, 0, Convert.ToInt32(rawData.Length));
            int startEPC = 0;
            string pc = "";
            string epc = "";
            int result = ptr[0] & 0x02;
            if (result != 0)
            {
                int result2 = ptr[2] & 0x01;
                if (result2 == 0x01)
                {
                    pc = "PC:" + ptr[0].ToString("X2") + ptr[1].ToString("X2") + ptr[2].ToString("X2") + ptr[3].ToString("X2") + ptr[4].ToString("X2") + ptr[5].ToString("X2");
                    startEPC = 6;
                }
                else
                {
                    pc = "PC:" + ptr[0].ToString("X2") + ptr[1].ToString("X2") + ptr[2].ToString("X2") + ptr[3].ToString("X2");
                    startEPC = 4;
                }
            }
            else
            {
                pc = "PC:" + ptr[0].ToString("X2") + ptr[1].ToString("X2");
                startEPC = 2;
            }
            string tag = "";
            for (int i = 0; i < (int)rawData.Length; i++) tag += (ptr[i] & 0xFF).ToString("X2");
            epc = tag.Substring(startEPC * 2).ToUpper();
            return pc;
        }

        public static string getEPC(NSData rawData)
        {
            byte[] ptr = rawData.ToArray();
            Marshal.Copy(rawData.Bytes, ptr, 0, Convert.ToInt32(rawData.Length));
            int startEPC = 0;
            string pc = "";
            string epc = "";

            int result = ptr[0] & 0x02;
            if (result != 0)
            {
                int result2 = ptr[2] & 0x01;
                if (result2 == 0x01)
                {
                    pc = "PC:" + ptr[0].ToString("X2") + ptr[1].ToString("X2") + ptr[2].ToString("X2") + ptr[3].ToString("X2") + ptr[4].ToString("X2") + ptr[5].ToString("X2");
                    startEPC = 6;
                }
                else
                {
                    pc = "PC:" + ptr[0].ToString("X2") + ptr[1].ToString("X2") + ptr[2].ToString("X2") + ptr[3].ToString("X2");
                    startEPC = 4;
                }
            }
            else
            {
                pc = "PC:" + ptr[0].ToString("X2") + ptr[1].ToString("X2");
                startEPC = 2;
            }

            string tag = "";
            for (int i = 0; i < (int)rawData.Length; i++) tag += (ptr[i] & 0xFF).ToString("X2");
            epc = tag.Substring(startEPC * 2).ToUpper();
            return epc;
        }
        public static string getPCEPCWithoutXpc(NSData rawData)
        {
            byte[] bytePtr = rawData.ToArray();
            Marshal.Copy(rawData.Bytes, bytePtr, 0, Convert.ToInt32(rawData.Length));
            int startEPC = 0;
            string pc = "";
            string epc = "";
            pc = "PC:" + bytePtr[0].ToString() + bytePtr[1].ToString();

            int result = bytePtr[0] & 0x02;
            if (result != 0)
            {
                int result2 = bytePtr[2] & 0x01;
                if (result2 == 0x01)
                {
                    startEPC = 6;
                }
                else
                {
                    startEPC = 4;
                }
            }
            else
            {
                startEPC = 2;
            }
            string tag = "";
            for (int i = 0; i < (int)rawData.Length; i++) tag += (bytePtr[i] & 0xFF).ToString("X2");
            try
            {
                epc = tag.Substring(startEPC * 2).ToUpper();
            }
            catch
            {
                epc = "Unknown";
            }
            return pc + epc;
        }
        public static bool checkSameTag1WithTag2(NSData compare1, NSData compare2)
        {
            String com1 = getPCEPCWithoutXpc(compare1);
            String com2 = getPCEPCWithoutXpc(compare2);

            if (com1 == com2)
            {
                return true;
            }
            return false;
        }
    }
}
